/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.bukkit.item.behavior;

import java.nio.file.Path;
import java.util.Map;
import net.momirealms.craftengine.bukkit.block.BukkitBlockManager;
import net.momirealms.craftengine.bukkit.plugin.reflection.minecraft.CoreReflections;
import net.momirealms.craftengine.bukkit.util.BlockStateUtils;
import net.momirealms.craftengine.bukkit.util.DirectionUtils;
import net.momirealms.craftengine.bukkit.util.InteractUtils;
import net.momirealms.craftengine.bukkit.util.LocationUtils;
import net.momirealms.craftengine.bukkit.world.BukkitBlockInWorld;
import net.momirealms.craftengine.core.block.ImmutableBlockState;
import net.momirealms.craftengine.core.entity.player.InteractionResult;
import net.momirealms.craftengine.core.item.behavior.ItemBehavior;
import net.momirealms.craftengine.core.item.behavior.ItemBehaviorFactory;
import net.momirealms.craftengine.core.item.context.UseOnContext;
import net.momirealms.craftengine.core.pack.Pack;
import net.momirealms.craftengine.core.plugin.CraftEngine;
import net.momirealms.craftengine.core.sound.SoundSource;
import net.momirealms.craftengine.core.util.Direction;
import net.momirealms.craftengine.core.util.Key;
import net.momirealms.craftengine.core.util.RandomUtils;
import net.momirealms.craftengine.core.world.BlockPos;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Player;

public class FlintAndSteelItemBehavior
extends ItemBehavior {
    public static final FlintAndSteelItemBehavior INSTANCE = new FlintAndSteelItemBehavior();
    public static final Factory FACTORY = new Factory();
    private static final Key FLINT_SOUND = Key.of("item.flintandsteel.use");

    @Override
    public InteractionResult useOnBlock(UseOnContext context) {
        boolean isClickedBlockBurnable;
        BlockPos clickedPos = context.getClickedPos();
        BukkitBlockInWorld clicked = (BukkitBlockInWorld)context.getLevel().getBlockAt(clickedPos);
        Block block = clicked.block();
        BlockPos firePos = clickedPos.relative(context.getClickedFace());
        Direction direction = context.getHorizontalDirection();
        try {
            if (!((Boolean)CoreReflections.method$BaseFireBlock$canBePlacedAt.invoke(null, context.getLevel().serverWorld(), LocationUtils.toBlockPos(firePos), DirectionUtils.toNMSDirection(direction))).booleanValue()) {
                return InteractionResult.PASS;
            }
        }
        catch (ReflectiveOperationException e) {
            CraftEngine.instance().logger().warn("Failed to call BaseFireBlock$canBePlacedAt", e);
            return InteractionResult.PASS;
        }
        BlockData clickedBlockData = block.getBlockData();
        Object clickedBlockState = BlockStateUtils.blockDataToBlockState(clickedBlockData);
        try {
            isClickedBlockBurnable = BlockStateUtils.isBurnable(clickedBlockState) || context.getClickedFace() == Direction.UP && (Boolean)CoreReflections.method$BlockStateBase$isFaceSturdy.invoke(clickedBlockState, context.getLevel().serverWorld(), LocationUtils.toBlockPos(clickedPos), CoreReflections.instance$Direction$UP, CoreReflections.instance$SupportType$FULL) != false;
        }
        catch (ReflectiveOperationException e) {
            CraftEngine.instance().logger().warn("Failed to call method$BlockStateBase$isFaceSturdy", e);
            return InteractionResult.PASS;
        }
        net.momirealms.craftengine.core.entity.player.Player player = context.getPlayer();
        if (isClickedBlockBurnable) {
            int stateId = BlockStateUtils.blockStateToId(clickedBlockState);
            if (BlockStateUtils.isVanillaBlock(stateId)) {
                return InteractionResult.PASS;
            }
            ImmutableBlockState immutableBlockState = BukkitBlockManager.instance().getImmutableBlockStateUnsafe(stateId);
            if (BlockStateUtils.isBurnable(immutableBlockState.vanillaBlockState().handle())) {
                return InteractionResult.PASS;
            }
            BlockData vanillaBlockState = BlockStateUtils.fromBlockData(immutableBlockState.vanillaBlockState().handle());
            if (direction == Direction.UP) {
                if (!InteractUtils.isInteractable((Player)player.platformPlayer(), vanillaBlockState, context.getHitResult(), context.getItem())) {
                    return InteractionResult.PASS;
                }
                if (!player.isSecondaryUseActive()) {
                    player.playSound(FLINT_SOUND, firePos, SoundSource.BLOCK, 1.0f, RandomUtils.generateRandomFloat(0.8f, 1.2f));
                }
            } else {
                boolean belowCanBurn;
                BlockPos belowFirePos = firePos.relative(Direction.DOWN);
                BukkitBlockInWorld belowFireBlock = (BukkitBlockInWorld)context.getLevel().getBlockAt(belowFirePos);
                try {
                    Block belowBlock = belowFireBlock.block();
                    belowCanBurn = BlockStateUtils.isBurnable(BlockStateUtils.blockDataToBlockState(belowBlock.getBlockData())) || (Boolean)CoreReflections.method$BlockStateBase$isFaceSturdy.invoke(BlockStateUtils.blockDataToBlockState(belowFireBlock.block().getBlockData()), context.getLevel().serverWorld(), LocationUtils.toBlockPos(belowFirePos), CoreReflections.instance$Direction$UP, CoreReflections.instance$SupportType$FULL) != false;
                }
                catch (ReflectiveOperationException e) {
                    CraftEngine.instance().logger().warn("Failed to call method$BlockStateBase$isFaceSturdy", e);
                    return InteractionResult.PASS;
                }
                if (InteractUtils.isInteractable((Player)player.platformPlayer(), vanillaBlockState, context.getHitResult(), context.getItem())) {
                    if (player.isSecondaryUseActive()) {
                        if (!belowCanBurn) {
                            player.playSound(FLINT_SOUND, firePos, SoundSource.BLOCK, 1.0f, RandomUtils.generateRandomFloat(0.8f, 1.2f));
                            player.swingHand(context.getHand());
                        }
                    } else {
                        player.playSound(FLINT_SOUND, firePos, SoundSource.BLOCK, 1.0f, RandomUtils.generateRandomFloat(0.8f, 1.2f));
                    }
                } else if (!belowCanBurn) {
                    player.playSound(FLINT_SOUND, firePos, SoundSource.BLOCK, 1.0f, RandomUtils.generateRandomFloat(0.8f, 1.2f));
                    player.swingHand(context.getHand());
                }
            }
        } else {
            Direction relativeDirection = direction.opposite();
            for (Direction dir : Direction.values()) {
                if (dir == relativeDirection) continue;
                BlockPos relPos = firePos.relative(dir);
                BukkitBlockInWorld nearByBlock = (BukkitBlockInWorld)context.getLevel().getBlockAt(relPos);
                BlockData nearbyBlockData = nearByBlock.block().getBlockData();
                Object nearbyBlockState = BlockStateUtils.blockDataToBlockState(nearbyBlockData);
                int stateID = BlockStateUtils.blockStateToId(nearbyBlockState);
                if (!BlockStateUtils.isVanillaBlock(stateID)) continue;
                if (BlockStateUtils.isBurnable(nearbyBlockState)) {
                    return InteractionResult.PASS;
                }
                try {
                    if (dir != Direction.DOWN || !((Boolean)CoreReflections.method$BlockStateBase$isFaceSturdy.invoke(nearbyBlockState, context.getLevel().serverWorld(), LocationUtils.toBlockPos(relPos), CoreReflections.instance$Direction$UP, CoreReflections.instance$SupportType$FULL)).booleanValue()) continue;
                    return InteractionResult.PASS;
                }
                catch (ReflectiveOperationException e) {
                    CraftEngine.instance().logger().warn("Failed to call method$BlockStateBase$isFaceSturdy", e);
                    return InteractionResult.PASS;
                }
            }
            player.playSound(FLINT_SOUND, firePos, SoundSource.BLOCK, 1.0f, RandomUtils.generateRandomFloat(0.8f, 1.2f));
            player.swingHand(context.getHand());
        }
        return InteractionResult.PASS;
    }

    public static class Factory
    implements ItemBehaviorFactory {
        @Override
        public ItemBehavior create(Pack pack, Path path, Key id, Map<String, Object> arguments) {
            return INSTANCE;
        }
    }
}

