/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.bukkit.item.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.Reader;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import net.momirealms.craftengine.bukkit.item.BukkitItemManager;
import net.momirealms.craftengine.bukkit.item.CloneableConstantItem;
import net.momirealms.craftengine.bukkit.item.recipe.BukkitRecipeConvertor;
import net.momirealms.craftengine.bukkit.item.recipe.CrafterEventListener;
import net.momirealms.craftengine.bukkit.item.recipe.RecipeEventListener;
import net.momirealms.craftengine.bukkit.nms.FastNMS;
import net.momirealms.craftengine.bukkit.plugin.BukkitCraftEngine;
import net.momirealms.craftengine.bukkit.plugin.reflection.bukkit.CraftBukkitReflections;
import net.momirealms.craftengine.bukkit.plugin.reflection.minecraft.CoreReflections;
import net.momirealms.craftengine.bukkit.plugin.reflection.minecraft.MRegistries;
import net.momirealms.craftengine.bukkit.plugin.reflection.minecraft.MRegistryOps;
import net.momirealms.craftengine.bukkit.util.KeyUtils;
import net.momirealms.craftengine.bukkit.util.MaterialUtils;
import net.momirealms.craftengine.bukkit.util.RecipeUtils;
import net.momirealms.craftengine.core.item.ItemBuildContext;
import net.momirealms.craftengine.core.item.recipe.AbstractRecipeManager;
import net.momirealms.craftengine.core.item.recipe.CookingRecipeCategory;
import net.momirealms.craftengine.core.item.recipe.CustomBlastingRecipe;
import net.momirealms.craftengine.core.item.recipe.CustomCampfireRecipe;
import net.momirealms.craftengine.core.item.recipe.CustomCookingRecipe;
import net.momirealms.craftengine.core.item.recipe.CustomRecipeResult;
import net.momirealms.craftengine.core.item.recipe.CustomShapedRecipe;
import net.momirealms.craftengine.core.item.recipe.CustomShapelessRecipe;
import net.momirealms.craftengine.core.item.recipe.CustomSmeltingRecipe;
import net.momirealms.craftengine.core.item.recipe.CustomSmithingTransformRecipe;
import net.momirealms.craftengine.core.item.recipe.CustomSmokingRecipe;
import net.momirealms.craftengine.core.item.recipe.CustomStoneCuttingRecipe;
import net.momirealms.craftengine.core.item.recipe.Ingredient;
import net.momirealms.craftengine.core.item.recipe.Recipe;
import net.momirealms.craftengine.core.item.recipe.RecipeTypes;
import net.momirealms.craftengine.core.item.recipe.vanilla.RecipeResult;
import net.momirealms.craftengine.core.item.recipe.vanilla.VanillaCookingRecipe;
import net.momirealms.craftengine.core.item.recipe.vanilla.VanillaRecipe;
import net.momirealms.craftengine.core.item.recipe.vanilla.VanillaShapedRecipe;
import net.momirealms.craftengine.core.item.recipe.vanilla.VanillaShapelessRecipe;
import net.momirealms.craftengine.core.item.recipe.vanilla.VanillaSmithingTransformRecipe;
import net.momirealms.craftengine.core.item.recipe.vanilla.VanillaStoneCuttingRecipe;
import net.momirealms.craftengine.core.plugin.CraftEngine;
import net.momirealms.craftengine.core.plugin.config.Config;
import net.momirealms.craftengine.core.registry.BuiltInRegistries;
import net.momirealms.craftengine.core.registry.Holder;
import net.momirealms.craftengine.core.util.HeptaFunction;
import net.momirealms.craftengine.core.util.Key;
import net.momirealms.craftengine.core.util.VersionHelper;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.inventory.BlastingRecipe;
import org.bukkit.inventory.CampfireRecipe;
import org.bukkit.inventory.FurnaceRecipe;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.RecipeChoice;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.ShapelessRecipe;
import org.bukkit.inventory.SmokingRecipe;
import org.bukkit.inventory.StonecuttingRecipe;
import org.bukkit.inventory.recipe.CookingBookCategory;
import org.bukkit.inventory.recipe.CraftingBookCategory;
import org.bukkit.plugin.Plugin;

public class BukkitRecipeManager
extends AbstractRecipeManager<ItemStack> {
    private static BukkitRecipeManager instance;
    private static final Map<Key, BukkitRecipeConvertor<? extends Recipe<ItemStack>>> MIXED_RECIPE_CONVERTORS;
    private static final List<Object> injectedIngredients;
    private static final IdentityHashMap<Recipe<ItemStack>, Object> CE_RECIPE_2_NMS_HOLDER;
    private static Object nmsRecipeManager;
    private final BukkitCraftEngine plugin;
    private final RecipeEventListener recipeEventListener;
    private final CrafterEventListener crafterEventListener;
    private Object stolenFeatureFlagSet;
    private final List<Runnable> delayedTasksOnMainThread = new ArrayList<Runnable>();

    private static void registerNMSSmithingRecipe(Object recipe) {
        try {
            CoreReflections.method$RecipeManager$addRecipe.invoke(BukkitRecipeManager.nmsRecipeManager(), recipe);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            CraftEngine.instance().logger().warn("Failed to register smithing recipe", e);
        }
    }

    private static void registerBukkitShapedRecipe(Object recipe) {
        try {
            Object craftRecipe = CraftBukkitReflections.method$CraftShapedRecipe$fromBukkitRecipe.invoke(null, recipe);
            CraftBukkitReflections.method$CraftRecipe$addToCraftingManager.invoke(craftRecipe, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            CraftEngine.instance().logger().warn("Failed to register shaped recipe", e);
        }
    }

    private static void registerBukkitShapelessRecipe(Object recipe) {
        try {
            Object craftRecipe = CraftBukkitReflections.method$CraftShapelessRecipe$fromBukkitRecipe.invoke(null, recipe);
            CraftBukkitReflections.method$CraftRecipe$addToCraftingManager.invoke(craftRecipe, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            CraftEngine.instance().logger().warn("Failed to register shapeless recipe", e);
        }
    }

    private static void registerBukkitSmeltingRecipe(Object recipe) {
        try {
            Object craftRecipe = CraftBukkitReflections.method$CraftFurnaceRecipe$fromBukkitRecipe.invoke(null, recipe);
            CraftBukkitReflections.method$CraftRecipe$addToCraftingManager.invoke(craftRecipe, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            CraftEngine.instance().logger().warn("Failed to register smelting recipe", e);
        }
    }

    private static void registerBukkitSmokingRecipe(Object recipe) {
        try {
            Object craftRecipe = CraftBukkitReflections.method$CraftSmokingRecipe$fromBukkitRecipe.invoke(null, recipe);
            CraftBukkitReflections.method$CraftRecipe$addToCraftingManager.invoke(craftRecipe, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            CraftEngine.instance().logger().warn("Failed to register smoking recipe", e);
        }
    }

    private static void registerBukkitBlastingRecipe(Object recipe) {
        try {
            Object craftRecipe = CraftBukkitReflections.method$CraftBlastingRecipe$fromBukkitRecipe.invoke(null, recipe);
            CraftBukkitReflections.method$CraftRecipe$addToCraftingManager.invoke(craftRecipe, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            CraftEngine.instance().logger().warn("Failed to register blasting recipe", e);
        }
    }

    private static void registerBukkitCampfireRecipe(Object recipe) {
        try {
            Object craftRecipe = CraftBukkitReflections.method$CraftCampfireRecipe$fromBukkitRecipe.invoke(null, recipe);
            CraftBukkitReflections.method$CraftRecipe$addToCraftingManager.invoke(craftRecipe, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            CraftEngine.instance().logger().warn("Failed to register campfire recipe", e);
        }
    }

    private static void registerBukkitStoneCuttingRecipe(Object recipe) {
        try {
            Object craftRecipe = CraftBukkitReflections.method$CraftStonecuttingRecipe$fromBukkitRecipe.invoke(null, recipe);
            CraftBukkitReflections.method$CraftRecipe$addToCraftingManager.invoke(craftRecipe, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            CraftEngine.instance().logger().warn("Failed to register stonecutting recipe", e);
        }
    }

    public BukkitRecipeManager(BukkitCraftEngine plugin) {
        instance = this;
        this.plugin = plugin;
        this.recipeEventListener = new RecipeEventListener(plugin, this, plugin.itemManager());
        this.crafterEventListener = VersionHelper.isOrAbove1_21() ? new CrafterEventListener(plugin, this, plugin.itemManager()) : null;
        try {
            nmsRecipeManager = CoreReflections.method$MinecraftServer$getRecipeManager.invoke(CoreReflections.method$MinecraftServer$getServer.invoke(null, new Object[0]), new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            plugin.logger().warn("Failed to get minecraft recipe manager", e);
        }
    }

    public Object nmsRecipeHolderByRecipe(Recipe<ItemStack> recipe) {
        if (this.isReloading) {
            return null;
        }
        return CE_RECIPE_2_NMS_HOLDER.get(recipe);
    }

    public static Object nmsRecipeManager() {
        return nmsRecipeManager;
    }

    public static BukkitRecipeManager instance() {
        return instance;
    }

    @Override
    public void delayedInit() {
        Bukkit.getPluginManager().registerEvents((Listener)this.recipeEventListener, (Plugin)this.plugin.javaPlugin());
        if (this.crafterEventListener != null) {
            Bukkit.getPluginManager().registerEvents((Listener)this.crafterEventListener, (Plugin)this.plugin.javaPlugin());
        }
    }

    @Override
    public void load() {
        if (!Config.enableRecipeSystem()) {
            return;
        }
        this.isReloading = true;
        if (VersionHelper.isOrAbove1_21_2()) {
            try {
                this.stolenFeatureFlagSet = CoreReflections.field$RecipeManager$featureflagset.get(nmsRecipeManager);
                CoreReflections.field$RecipeManager$featureflagset.set(nmsRecipeManager, null);
            }
            catch (ReflectiveOperationException e) {
                this.plugin.logger().warn("Failed to steal featureflagset", e);
            }
        }
    }

    @Override
    public void unload() {
        if (!Config.enableRecipeSystem()) {
            return;
        }
        super.unload();
        if (VersionHelper.isOrAbove1_21_2()) {
            this.plugin.scheduler().executeSync(() -> {
                try {
                    CoreReflections.method$RecipeManager$finalizeRecipeLoading.invoke(nmsRecipeManager, new Object[0]);
                }
                catch (ReflectiveOperationException e) {
                    this.plugin.logger().warn("Failed to unregister recipes", e);
                }
            });
        }
    }

    @Override
    public void delayedLoad() {
        if (!Config.enableRecipeSystem()) {
            return;
        }
        this.injectDataPackRecipes();
    }

    @Override
    public void disable() {
        this.unload();
        CE_RECIPE_2_NMS_HOLDER.clear();
        HandlerList.unregisterAll((Listener)this.recipeEventListener);
        if (this.crafterEventListener != null) {
            HandlerList.unregisterAll((Listener)this.crafterEventListener);
        }
    }

    @Override
    protected void unregisterPlatformRecipe(Key key) {
        this.unregisterNMSRecipe(new NamespacedKey(key.namespace(), key.value()));
    }

    @Override
    protected void registerPlatformRecipe(Key id, Recipe<ItemStack> recipe) {
        try {
            Runnable converted = this.findNMSRecipeConvertor(recipe).convert(id, recipe);
            if (converted != null) {
                this.delayedTasksOnMainThread.add(converted);
            }
        }
        catch (Exception e) {
            this.plugin.logger().warn("Failed to convert recipe " + String.valueOf(id), e);
        }
    }

    private <T extends Recipe<ItemStack>> BukkitRecipeConvertor<T> findNMSRecipeConvertor(T recipe) {
        return MIXED_RECIPE_CONVERTORS.get(recipe.type());
    }

    private void unregisterNMSRecipe(NamespacedKey key) {
        try {
            if (VersionHelper.isOrAbove1_21_2()) {
                Object recipeMap = CoreReflections.field$RecipeManager$recipes.get(nmsRecipeManager);
                CoreReflections.method$RecipeMap$removeRecipe.invoke(recipeMap, CraftBukkitReflections.method$CraftRecipe$toMinecraft.invoke(null, key));
            } else {
                Bukkit.removeRecipe((NamespacedKey)key);
            }
        }
        catch (ReflectiveOperationException e) {
            CraftEngine.instance().logger().warn("Failed to unregister nms recipes", e);
        }
    }

    private void injectDataPackRecipes() {
        try {
            Object fileToIdConverter = CoreReflections.method$FileToIdConverter$json.invoke(null, VersionHelper.isOrAbove1_21() ? "recipe" : "recipes");
            Object minecraftServer = CoreReflections.method$MinecraftServer$getServer.invoke(null, new Object[0]);
            Object packRepository = CoreReflections.method$MinecraftServer$getPackRepository.invoke(minecraftServer, new Object[0]);
            List selected = (List)CoreReflections.field$PackRepository$selected.get(packRepository);
            ArrayList<Object> packResources = new ArrayList<Object>();
            for (Object pack : selected) {
                packResources.add(CoreReflections.method$Pack$open.invoke(pack, new Object[0]));
            }
            boolean hasDisabledAny = !Config.disabledVanillaRecipes().isEmpty();
            try (AutoCloseable resourceManager = (AutoCloseable)CoreReflections.constructor$MultiPackResourceManager.newInstance(CoreReflections.instance$PackType$SERVER_DATA, packResources);){
                Map scannedResources = (Map)CoreReflections.method$FileToIdConverter$listMatchingResources.invoke(fileToIdConverter, resourceManager);
                for (Map.Entry entry : scannedResources.entrySet()) {
                    String type;
                    Key id = this.extractKeyFromResourceLocation(entry.getKey().toString());
                    if (Config.disableAllVanillaRecipes()) {
                        this.delayedTasksOnMainThread.add(() -> this.unregisterPlatformRecipe(id));
                        continue;
                    }
                    if (hasDisabledAny && Config.disabledVanillaRecipes().contains(id)) {
                        this.delayedTasksOnMainThread.add(() -> this.unregisterPlatformRecipe(id));
                        continue;
                    }
                    this.markAsDataPackRecipe(id);
                    Reader reader = (Reader)CoreReflections.method$Resource$openAsReader.invoke(entry.getValue(), new Object[0]);
                    JsonObject jsonObject = JsonParser.parseReader((Reader)reader).getAsJsonObject();
                    switch (type = jsonObject.get("type").getAsString()) {
                        case "minecraft:crafting_shaped": {
                            VanillaRecipe recipe = this.recipeReader.readShaped(jsonObject);
                            this.handleDataPackShapedRecipe(id, (VanillaShapedRecipe)recipe, this.delayedTasksOnMainThread::add);
                            break;
                        }
                        case "minecraft:crafting_shapeless": {
                            VanillaRecipe recipe = this.recipeReader.readShapeless(jsonObject);
                            this.handleDataPackShapelessRecipe(id, (VanillaShapelessRecipe)recipe, this.delayedTasksOnMainThread::add);
                            break;
                        }
                        case "minecraft:smelting": {
                            VanillaRecipe recipe = this.recipeReader.readSmelting(jsonObject);
                            this.handleDataPackCookingRecipe(id, (VanillaCookingRecipe)recipe, CustomSmeltingRecipe::new, this.delayedTasksOnMainThread::add);
                            break;
                        }
                        case "minecraft:blasting": {
                            VanillaRecipe recipe = this.recipeReader.readBlasting(jsonObject);
                            this.handleDataPackCookingRecipe(id, (VanillaCookingRecipe)recipe, CustomBlastingRecipe::new, this.delayedTasksOnMainThread::add);
                            break;
                        }
                        case "minecraft:smoking": {
                            VanillaRecipe recipe = this.recipeReader.readSmoking(jsonObject);
                            this.handleDataPackCookingRecipe(id, (VanillaCookingRecipe)recipe, CustomSmokingRecipe::new, this.delayedTasksOnMainThread::add);
                            break;
                        }
                        case "minecraft:campfire_cooking": {
                            VanillaRecipe recipe = this.recipeReader.readCampfire(jsonObject);
                            this.handleDataPackCookingRecipe(id, (VanillaCookingRecipe)recipe, CustomCampfireRecipe::new, this.delayedTasksOnMainThread::add);
                            break;
                        }
                        case "minecraft:smithing_transform": {
                            VanillaRecipe recipe = this.recipeReader.readSmithingTransform(jsonObject);
                            this.handleDataPackSmithingTransform(id, (VanillaSmithingTransformRecipe)recipe, this.delayedTasksOnMainThread::add);
                            break;
                        }
                        case "minecraft:stonecutting": {
                            VanillaRecipe recipe = this.recipeReader.readStoneCutting(jsonObject);
                            this.handleDataPackStoneCuttingRecipe(id, (VanillaStoneCuttingRecipe)recipe);
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            this.plugin.logger().warn("Failed to read data pack recipes", e);
        }
    }

    @Override
    public void runDelayedSyncTasks() {
        if (!Config.enableRecipeSystem()) {
            return;
        }
        try {
            for (Runnable runnable : this.delayedTasksOnMainThread) {
                runnable.run();
            }
            this.delayedTasksOnMainThread.clear();
            if (VersionHelper.isOrAbove1_21_2() && this.stolenFeatureFlagSet != null) {
                CoreReflections.field$RecipeManager$featureflagset.set(BukkitRecipeManager.nmsRecipeManager(), this.stolenFeatureFlagSet);
                this.stolenFeatureFlagSet = null;
            }
            if (VersionHelper.isOrAbove1_21_2()) {
                CoreReflections.method$RecipeManager$finalizeRecipeLoading.invoke(BukkitRecipeManager.nmsRecipeManager(), new Object[0]);
            }
            CoreReflections.method$DedicatedPlayerList$reloadRecipes.invoke(CraftBukkitReflections.field$CraftServer$playerList.get(Bukkit.getServer()), new Object[0]);
            if (VersionHelper.isOrAbove1_21_4()) {
                for (Object object : injectedIngredients) {
                    CoreReflections.field$Ingredient$itemStacks1_21_4.set(object, null);
                }
            } else if (VersionHelper.isOrAbove1_21_2()) {
                for (Object object : injectedIngredients) {
                    CoreReflections.field$Ingredient$itemStacks1_21_2.set(object, null);
                }
            }
            injectedIngredients.clear();
            CE_RECIPE_2_NMS_HOLDER.clear();
            for (Map.Entry entry : this.byId.entrySet()) {
                Optional<Object> nmsRecipe = BukkitRecipeManager.getOptionalNMSRecipe((Key)entry.getKey());
                nmsRecipe.ifPresent(o -> CE_RECIPE_2_NMS_HOLDER.put((Recipe)entry.getValue(), o));
            }
            this.isReloading = false;
        }
        catch (Exception e) {
            this.plugin.logger().warn("Failed to run delayed recipe tasks", e);
        }
    }

    private void handleDataPackStoneCuttingRecipe(Key id, VanillaStoneCuttingRecipe recipe) {
        ItemStack result = this.createDataPackResultStack(recipe.result());
        HashSet<Holder<Key>> holders = new HashSet<Holder<Key>>();
        for (String item : recipe.ingredient()) {
            if (item.charAt(0) == '#') {
                Key tag = Key.from(item.substring(1));
                holders.addAll(this.plugin.itemManager().tagToItems(tag));
                continue;
            }
            holders.add((Holder<Key>)BuiltInRegistries.OPTIMIZED_ITEM_ID.get(Key.from(item)).orElseThrow());
        }
        CustomStoneCuttingRecipe<ItemStack> ceRecipe = new CustomStoneCuttingRecipe<ItemStack>(id, recipe.group(), Ingredient.of(holders), new CustomRecipeResult<ItemStack>(new CloneableConstantItem(recipe.result().isCustom() ? Key.of("!internal:custom") : Key.of(recipe.result().id()), result), recipe.result().count()));
        this.registerInternalRecipe(id, ceRecipe);
    }

    private void handleDataPackShapelessRecipe(Key id, VanillaShapelessRecipe recipe, Consumer<Runnable> callback) {
        NamespacedKey key = new NamespacedKey(id.namespace(), id.value());
        ItemStack result = this.createDataPackResultStack(recipe.result());
        boolean hasCustomItemInTag = false;
        ArrayList ingredientList = new ArrayList();
        for (List<String> list : recipe.ingredients()) {
            HashSet<Holder<Key>> holders = new HashSet<Holder<Key>>();
            for (String item : list) {
                if (item.charAt(0) == '#') {
                    Key tag = Key.of(item.substring(1));
                    if (!hasCustomItemInTag && !this.plugin.itemManager().tagToCustomItems(tag).isEmpty()) {
                        hasCustomItemInTag = true;
                    }
                    holders.addAll(this.plugin.itemManager().tagToItems(tag));
                    continue;
                }
                holders.add((Holder<Key>)BuiltInRegistries.OPTIMIZED_ITEM_ID.get(Key.from(item)).orElseThrow());
            }
            ingredientList.add(Ingredient.of(holders));
        }
        CustomShapelessRecipe<ItemStack> ceRecipe = new CustomShapelessRecipe<ItemStack>(id, recipe.category(), recipe.group(), ingredientList, new CustomRecipeResult<ItemStack>(new CloneableConstantItem(recipe.result().isCustom() ? Key.of("!internal:custom") : Key.of(recipe.result().id()), result), recipe.result().count()));
        if (hasCustomItemInTag) {
            Runnable converted = this.findNMSRecipeConvertor(ceRecipe).convert(id, ceRecipe);
            callback.accept(() -> {
                this.unregisterNMSRecipe(key);
                converted.run();
            });
        }
        this.registerInternalRecipe(id, ceRecipe);
    }

    private void handleDataPackShapedRecipe(Key id, VanillaShapedRecipe recipe, Consumer<Runnable> callback) {
        NamespacedKey key = new NamespacedKey(id.namespace(), id.value());
        ItemStack result = this.createDataPackResultStack(recipe.result());
        boolean hasCustomItemInTag = false;
        HashMap ingredients = new HashMap();
        for (Map.Entry<Character, List<String>> entry : recipe.ingredients().entrySet()) {
            HashSet<Holder<Key>> holders = new HashSet<Holder<Key>>();
            for (String item : entry.getValue()) {
                if (item.charAt(0) == '#') {
                    Key tag = Key.from(item.substring(1));
                    if (!hasCustomItemInTag && !this.plugin.itemManager().tagToCustomItems(tag).isEmpty()) {
                        hasCustomItemInTag = true;
                    }
                    holders.addAll(this.plugin.itemManager().tagToItems(tag));
                    continue;
                }
                holders.add((Holder<Key>)BuiltInRegistries.OPTIMIZED_ITEM_ID.get(Key.from(item)).orElseThrow());
            }
            ingredients.put(entry.getKey(), Ingredient.of(holders));
        }
        CustomShapedRecipe<ItemStack> ceRecipe = new CustomShapedRecipe<ItemStack>(id, recipe.category(), recipe.group(), new CustomShapedRecipe.Pattern(recipe.pattern(), ingredients), new CustomRecipeResult<ItemStack>(new CloneableConstantItem(recipe.result().isCustom() ? Key.of("!internal:custom") : Key.of(recipe.result().id()), result), recipe.result().count()));
        if (hasCustomItemInTag) {
            Runnable converted = this.findNMSRecipeConvertor(ceRecipe).convert(id, ceRecipe);
            callback.accept(() -> {
                this.unregisterNMSRecipe(key);
                converted.run();
            });
        }
        this.registerInternalRecipe(id, ceRecipe);
    }

    private void handleDataPackCookingRecipe(Key id, VanillaCookingRecipe recipe, HeptaFunction<Key, CookingRecipeCategory, String, Ingredient<ItemStack>, Integer, Float, CustomRecipeResult<ItemStack>, CustomCookingRecipe<ItemStack>> constructor2, Consumer<Runnable> callback) {
        NamespacedKey key = new NamespacedKey(id.namespace(), id.value());
        ItemStack result = this.createDataPackResultStack(recipe.result());
        HashSet<Holder<Key>> holders = new HashSet<Holder<Key>>();
        boolean hasCustomItemInTag = this.readVanillaIngredients(false, recipe.ingredient(), holders::add);
        CustomCookingRecipe<ItemStack> ceRecipe = constructor2.apply(id, recipe.category(), recipe.group(), Ingredient.of(holders), recipe.cookingTime(), Float.valueOf(recipe.experience()), new CustomRecipeResult<ItemStack>(new CloneableConstantItem(recipe.result().isCustom() ? Key.of("!internal:custom") : Key.of(recipe.result().id()), result), recipe.result().count()));
        if (hasCustomItemInTag) {
            Runnable converted = this.findNMSRecipeConvertor(ceRecipe).convert(id, ceRecipe);
            callback.accept(() -> {
                this.unregisterNMSRecipe(key);
                converted.run();
            });
        }
        this.registerInternalRecipe(id, ceRecipe);
    }

    private void handleDataPackSmithingTransform(Key id, VanillaSmithingTransformRecipe recipe, Consumer<Runnable> callback) {
        NamespacedKey key = new NamespacedKey(id.namespace(), id.value());
        ItemStack result = this.createDataPackResultStack(recipe.result());
        HashSet<Holder<Key>> additionHolders = new HashSet<Holder<Key>>();
        boolean hasCustomItemInTag = this.readVanillaIngredients(false, recipe.addition(), additionHolders::add);
        HashSet<Holder<Key>> templateHolders = new HashSet<Holder<Key>>();
        hasCustomItemInTag = this.readVanillaIngredients(hasCustomItemInTag, recipe.template(), templateHolders::add);
        HashSet<Holder<Key>> baseHolders = new HashSet<Holder<Key>>();
        hasCustomItemInTag = this.readVanillaIngredients(hasCustomItemInTag, recipe.base(), baseHolders::add);
        CustomSmithingTransformRecipe<ItemStack> ceRecipe = new CustomSmithingTransformRecipe<ItemStack>(id, baseHolders.isEmpty() ? null : Ingredient.of(baseHolders), templateHolders.isEmpty() ? null : Ingredient.of(templateHolders), additionHolders.isEmpty() ? null : Ingredient.of(additionHolders), new CustomRecipeResult<ItemStack>(new CloneableConstantItem(recipe.result().isCustom() ? Key.of("!internal:custom") : Key.of(recipe.result().id()), result), recipe.result().count()), true, List.of());
        if (hasCustomItemInTag) {
            Runnable converted = this.findNMSRecipeConvertor(ceRecipe).convert(id, ceRecipe);
            callback.accept(() -> {
                this.unregisterNMSRecipe(key);
                converted.run();
            });
        }
        this.registerInternalRecipe(id, ceRecipe);
    }

    private boolean readVanillaIngredients(boolean hasCustomItemInTag, List<String> ingredients, Consumer<Holder<Key>> holderConsumer) {
        for (String item : ingredients) {
            if (item.charAt(0) == '#') {
                Key tag = Key.from(item.substring(1));
                if (!hasCustomItemInTag && !this.plugin.itemManager().tagToCustomItems(tag).isEmpty()) {
                    hasCustomItemInTag = true;
                }
                for (Holder<Key> holder : this.plugin.itemManager().tagToItems(tag)) {
                    holderConsumer.accept(holder);
                }
                continue;
            }
            holderConsumer.accept((Holder<Key>)BuiltInRegistries.OPTIMIZED_ITEM_ID.get(Key.from(item)).orElseThrow());
        }
        return hasCustomItemInTag;
    }

    private ItemStack createDataPackResultStack(RecipeResult result) {
        ItemStack itemStack;
        if (result.components() == null) {
            itemStack = new ItemStack(Objects.requireNonNull(MaterialUtils.getMaterial(result.id())));
            itemStack.setAmount(result.count());
        } else {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("id", result.id());
            jsonObject.addProperty("count", (Number)result.count());
            jsonObject.add("components", (JsonElement)result.components());
            Object nmsStack = CoreReflections.instance$ItemStack$CODEC.parse(MRegistryOps.JSON, (Object)jsonObject).resultOrPartial(itemId -> this.plugin.logger().severe("Tried to load invalid item: '" + itemId + "'")).orElse(null);
            if (nmsStack == null) {
                return new ItemStack(Material.STONE);
            }
            try {
                itemStack = FastNMS.INSTANCE.method$CraftItemStack$asCraftMirror(nmsStack);
            }
            catch (Exception e) {
                this.plugin.logger().warn("Failed to create ItemStack mirror", e);
                return new ItemStack(Material.STICK);
            }
        }
        return itemStack;
    }

    private Key extractKeyFromResourceLocation(String input) {
        int prefixEndIndex = input.indexOf(58);
        String prefix = input.substring(0, prefixEndIndex);
        int lastSlashIndex = input.lastIndexOf(47);
        int lastDotIndex = input.lastIndexOf(46);
        String fileName = input.substring(lastSlashIndex + 1, lastDotIndex);
        return Key.of(prefix, fileName);
    }

    private static RecipeChoice ingredientToBukkitRecipeChoice(Ingredient<ItemStack> ingredient) {
        HashSet<Material> materials = new HashSet<Material>();
        for (Holder<Key> holder : ingredient.items()) {
            materials.add(BukkitRecipeManager.getMaterialById(holder.value()));
        }
        return new RecipeChoice.MaterialChoice(new ArrayList(materials));
    }

    private static Material getMaterialById(Key key) {
        Material material = MaterialUtils.getMaterial(key);
        if (material != null) {
            return material;
        }
        Optional optionalItem = BukkitItemManager.instance().getCustomItem(key);
        return optionalItem.map(itemStackCustomItem -> MaterialUtils.getMaterial(itemStackCustomItem.material())).orElse(null);
    }

    private static List<Object> getIngredientLooks(List<Holder<Key>> holders) {
        ArrayList<Object> itemStacks = new ArrayList<Object>();
        for (Holder<Key> holder : holders) {
            ItemStack itemStack = (ItemStack)BukkitItemManager.instance().getBuildableItem(holder.value()).get().buildItemStack(ItemBuildContext.EMPTY, 1);
            Object nmsStack = FastNMS.INSTANCE.method$CraftItemStack$asNMSCopy(itemStack);
            itemStacks.add(nmsStack);
        }
        return itemStacks;
    }

    private static void injectShapedRecipe(Key id, CustomShapedRecipe<ItemStack> recipe) {
        try {
            List<Ingredient<ItemStack>> actualIngredients = recipe.parsedPattern().ingredients().stream().filter(Optional::isPresent).map(Optional::get).toList();
            Object shapedRecipe = BukkitRecipeManager.getOptionalNMSRecipe(id).get();
            if (VersionHelper.isOrAbove1_20_2()) {
                shapedRecipe = CoreReflections.field$RecipeHolder$recipe.get(shapedRecipe);
            }
            if (VersionHelper.isOrAbove1_21_2()) {
                CoreReflections.field$ShapedRecipe$placementInfo.set(shapedRecipe, null);
            }
            List<Object> ingredients = RecipeUtils.getIngredientsFromShapedRecipe(shapedRecipe);
            BukkitRecipeManager.injectIngredients(ingredients, actualIngredients);
        }
        catch (ReflectiveOperationException e) {
            CraftEngine.instance().logger().warn("Failed to inject shaped recipe", e);
        }
    }

    private static void injectShapelessRecipe(Key id, CustomShapelessRecipe<ItemStack> recipe) {
        try {
            List<Ingredient<ItemStack>> actualIngredients = recipe.ingredientsInUse();
            Object shapelessRecipe = BukkitRecipeManager.getOptionalNMSRecipe(id).get();
            if (VersionHelper.isOrAbove1_20_2()) {
                shapelessRecipe = CoreReflections.field$RecipeHolder$recipe.get(shapelessRecipe);
            }
            if (VersionHelper.isOrAbove1_21_2()) {
                CoreReflections.field$ShapelessRecipe$placementInfo.set(shapelessRecipe, null);
            }
            List ingredients = (List)CoreReflections.field$ShapelessRecipe$ingredients.get(shapelessRecipe);
            BukkitRecipeManager.injectIngredients(ingredients, actualIngredients);
        }
        catch (ReflectiveOperationException e) {
            CraftEngine.instance().logger().warn("Failed to inject shapeless recipe", e);
        }
    }

    private static void injectCookingRecipe(Key id, CustomCookingRecipe<ItemStack> recipe) {
        try {
            Ingredient<ItemStack> actualIngredient = recipe.ingredient();
            Object smeltingRecipe = BukkitRecipeManager.getOptionalNMSRecipe(id).get();
            if (VersionHelper.isOrAbove1_20_2()) {
                smeltingRecipe = CoreReflections.field$RecipeHolder$recipe.get(smeltingRecipe);
            }
            Object ingredient = VersionHelper.isOrAbove1_21_2() ? CoreReflections.field$SingleItemRecipe$input.get(smeltingRecipe) : CoreReflections.field$AbstractCookingRecipe$input.get(smeltingRecipe);
            BukkitRecipeManager.injectIngredients(List.of(ingredient), List.of(actualIngredient));
        }
        catch (ReflectiveOperationException e) {
            CraftEngine.instance().logger().warn("Failed to inject cooking recipe", e);
        }
    }

    private static Optional<Object> getOptionalNMSRecipe(Key id) throws ReflectiveOperationException {
        if (VersionHelper.isOrAbove1_21_2()) {
            Object resourceKey = FastNMS.INSTANCE.method$ResourceKey$create(MRegistries.RECIPE, KeyUtils.toResourceLocation(id));
            Optional optional = (Optional)CoreReflections.method$RecipeManager$byKey.invoke(nmsRecipeManager, resourceKey);
            return optional;
        }
        Object resourceLocation = KeyUtils.toResourceLocation(id);
        Optional optional = (Optional)CoreReflections.method$RecipeManager$byKey.invoke(nmsRecipeManager, resourceLocation);
        return optional;
    }

    private static void injectIngredients(List<Object> fakeIngredients, List<Ingredient<ItemStack>> actualIngredients) throws ReflectiveOperationException {
        if (fakeIngredients.size() != actualIngredients.size()) {
            throw new IllegalArgumentException("Ingredient count mismatch");
        }
        for (int i = 0; i < fakeIngredients.size(); ++i) {
            Object ingredient = fakeIngredients.get(i);
            Ingredient<ItemStack> actualIngredient = actualIngredients.get(i);
            List<Object> items = BukkitRecipeManager.getIngredientLooks(actualIngredient.items());
            if (VersionHelper.isOrAbove1_21_4()) {
                CoreReflections.field$Ingredient$itemStacks1_21_4.set(ingredient, new HashSet<Object>(items));
            } else if (VersionHelper.isOrAbove1_21_2()) {
                CoreReflections.field$Ingredient$itemStacks1_21_2.set(ingredient, items);
            } else {
                Object itemStackArray = Array.newInstance(CoreReflections.clazz$ItemStack, items.size());
                for (int j = 0; j < items.size(); ++j) {
                    Array.set(itemStackArray, j, items.get(j));
                }
                CoreReflections.field$Ingredient$itemStacks1_20_1.set(ingredient, itemStackArray);
            }
            injectedIngredients.add(ingredient);
        }
    }

    private static Object toMinecraftIngredient(Ingredient<ItemStack> ingredient) throws ReflectiveOperationException {
        if (ingredient == null) {
            return CraftBukkitReflections.method$CraftRecipe$toIngredient.invoke(null, null, true);
        }
        RecipeChoice choice = BukkitRecipeManager.ingredientToBukkitRecipeChoice(ingredient);
        return CraftBukkitReflections.method$CraftRecipe$toIngredient.invoke(null, choice, true);
    }

    private static Optional<Object> toOptionalMinecraftIngredient(Ingredient<ItemStack> ingredient) throws ReflectiveOperationException {
        if (ingredient == null) {
            return Optional.empty();
        }
        RecipeChoice choice = BukkitRecipeManager.ingredientToBukkitRecipeChoice(ingredient);
        Object mcIngredient = CraftBukkitReflections.method$CraftRecipe$toIngredient.invoke(null, choice, true);
        return Optional.of(mcIngredient);
    }

    private static Object toTransmuteResult(ItemStack item) throws InvocationTargetException, IllegalAccessException, InstantiationException {
        Object itemStack = FastNMS.INSTANCE.method$CraftItemStack$asNMSCopy(item);
        Object nmsItem = CoreReflections.method$ItemStack$getItem.invoke(itemStack, new Object[0]);
        return CoreReflections.constructor$TransmuteResult.newInstance(nmsItem);
    }

    private static Object createMinecraftSmithingTransformRecipe(CustomSmithingTransformRecipe<ItemStack> recipe) throws ReflectiveOperationException {
        if (VersionHelper.isOrAbove1_21_5()) {
            return CoreReflections.constructor$SmithingTransformRecipe.newInstance(BukkitRecipeManager.toOptionalMinecraftIngredient(recipe.template()), BukkitRecipeManager.toMinecraftIngredient(recipe.base()), BukkitRecipeManager.toOptionalMinecraftIngredient(recipe.addition()), BukkitRecipeManager.toTransmuteResult(recipe.result(ItemBuildContext.EMPTY)));
        }
        if (VersionHelper.isOrAbove1_21_2()) {
            return CoreReflections.constructor$SmithingTransformRecipe.newInstance(BukkitRecipeManager.toOptionalMinecraftIngredient(recipe.template()), BukkitRecipeManager.toOptionalMinecraftIngredient(recipe.base()), BukkitRecipeManager.toOptionalMinecraftIngredient(recipe.addition()), FastNMS.INSTANCE.method$CraftItemStack$asNMSCopy(recipe.result(ItemBuildContext.EMPTY)));
        }
        if (VersionHelper.isOrAbove1_20_2()) {
            return CoreReflections.constructor$SmithingTransformRecipe.newInstance(BukkitRecipeManager.toMinecraftIngredient(recipe.template()), BukkitRecipeManager.toMinecraftIngredient(recipe.base()), BukkitRecipeManager.toMinecraftIngredient(recipe.addition()), FastNMS.INSTANCE.method$CraftItemStack$asNMSCopy(recipe.result(ItemBuildContext.EMPTY)));
        }
        return CoreReflections.constructor$SmithingTransformRecipe.newInstance(KeyUtils.toResourceLocation(recipe.id()), BukkitRecipeManager.toMinecraftIngredient(recipe.template()), BukkitRecipeManager.toMinecraftIngredient(recipe.base()), BukkitRecipeManager.toMinecraftIngredient(recipe.addition()), FastNMS.INSTANCE.method$CraftItemStack$asNMSCopy(recipe.result(ItemBuildContext.EMPTY)));
    }

    static {
        MIXED_RECIPE_CONVERTORS = new HashMap<Key, BukkitRecipeConvertor<? extends Recipe<ItemStack>>>();
        injectedIngredients = new ArrayList<Object>();
        CE_RECIPE_2_NMS_HOLDER = new IdentityHashMap();
        MIXED_RECIPE_CONVERTORS.put(RecipeTypes.SMITHING_TRANSFORM, (id, recipe) -> {
            try {
                Object nmsRecipe = BukkitRecipeManager.createMinecraftSmithingTransformRecipe(recipe);
                if (VersionHelper.isOrAbove1_21_2()) {
                    nmsRecipe = CoreReflections.constructor$RecipeHolder.newInstance(CraftBukkitReflections.method$CraftRecipe$toMinecraft.invoke(null, new NamespacedKey(id.namespace(), id.value())), nmsRecipe);
                } else if (VersionHelper.isOrAbove1_20_2()) {
                    nmsRecipe = CoreReflections.constructor$RecipeHolder.newInstance(KeyUtils.toResourceLocation(id), nmsRecipe);
                } else {
                    Object finalNmsRecipe0 = nmsRecipe;
                    return () -> BukkitRecipeManager.registerNMSSmithingRecipe(finalNmsRecipe0);
                }
                Object finalNmsRecipe = nmsRecipe;
                return () -> BukkitRecipeManager.registerNMSSmithingRecipe(finalNmsRecipe);
            }
            catch (Exception e) {
                CraftEngine.instance().logger().warn("Failed to convert smithing transform recipe", e);
                return null;
            }
        });
        MIXED_RECIPE_CONVERTORS.put(RecipeTypes.SHAPED, (id, recipe) -> {
            ShapedRecipe shapedRecipe = new ShapedRecipe(new NamespacedKey(id.namespace(), id.value()), (ItemStack)recipe.result(ItemBuildContext.EMPTY));
            if (recipe.group() != null) {
                shapedRecipe.setGroup(Objects.requireNonNull(recipe.group()));
            }
            if (recipe.category() != null) {
                shapedRecipe.setCategory(CraftingBookCategory.valueOf((String)Objects.requireNonNull(recipe.category()).name()));
            }
            shapedRecipe.shape(recipe.pattern().pattern());
            for (Map.Entry entry : recipe.pattern().ingredients().entrySet()) {
                shapedRecipe.setIngredient(entry.getKey().charValue(), BukkitRecipeManager.ingredientToBukkitRecipeChoice(entry.getValue()));
            }
            return () -> {
                BukkitRecipeManager.registerBukkitShapedRecipe(shapedRecipe);
                BukkitRecipeManager.injectShapedRecipe(id, recipe);
            };
        });
        MIXED_RECIPE_CONVERTORS.put(RecipeTypes.SHAPELESS, (id, recipe) -> {
            ShapelessRecipe shapelessRecipe = new ShapelessRecipe(new NamespacedKey(id.namespace(), id.value()), (ItemStack)recipe.result(ItemBuildContext.EMPTY));
            if (recipe.group() != null) {
                shapelessRecipe.setGroup(Objects.requireNonNull(recipe.group()));
            }
            if (recipe.category() != null) {
                shapelessRecipe.setCategory(CraftingBookCategory.valueOf((String)Objects.requireNonNull(recipe.category()).name()));
            }
            for (Ingredient<ItemStack> ingredient : recipe.ingredientsInUse()) {
                shapelessRecipe.addIngredient(BukkitRecipeManager.ingredientToBukkitRecipeChoice(ingredient));
            }
            return () -> {
                BukkitRecipeManager.registerBukkitShapelessRecipe(shapelessRecipe);
                BukkitRecipeManager.injectShapelessRecipe(id, recipe);
            };
        });
        MIXED_RECIPE_CONVERTORS.put(RecipeTypes.SMELTING, (id, recipe) -> {
            FurnaceRecipe furnaceRecipe = new FurnaceRecipe(new NamespacedKey(id.namespace(), id.value()), (ItemStack)recipe.result(ItemBuildContext.EMPTY), BukkitRecipeManager.ingredientToBukkitRecipeChoice(recipe.ingredient()), recipe.experience(), recipe.cookingTime());
            if (recipe.group() != null) {
                furnaceRecipe.setGroup(Objects.requireNonNull(recipe.group()));
            }
            if (recipe.category() != null) {
                furnaceRecipe.setCategory(CookingBookCategory.valueOf((String)Objects.requireNonNull(recipe.category()).name()));
            }
            return () -> {
                BukkitRecipeManager.registerBukkitSmeltingRecipe(furnaceRecipe);
                BukkitRecipeManager.injectCookingRecipe(id, recipe);
            };
        });
        MIXED_RECIPE_CONVERTORS.put(RecipeTypes.SMOKING, (id, recipe) -> {
            SmokingRecipe smokingRecipe = new SmokingRecipe(new NamespacedKey(id.namespace(), id.value()), (ItemStack)recipe.result(ItemBuildContext.EMPTY), BukkitRecipeManager.ingredientToBukkitRecipeChoice(recipe.ingredient()), recipe.experience(), recipe.cookingTime());
            if (recipe.group() != null) {
                smokingRecipe.setGroup(Objects.requireNonNull(recipe.group()));
            }
            if (recipe.category() != null) {
                smokingRecipe.setCategory(CookingBookCategory.valueOf((String)Objects.requireNonNull(recipe.category()).name()));
            }
            return () -> {
                BukkitRecipeManager.registerBukkitSmokingRecipe(smokingRecipe);
                BukkitRecipeManager.injectCookingRecipe(id, recipe);
            };
        });
        MIXED_RECIPE_CONVERTORS.put(RecipeTypes.BLASTING, (id, recipe) -> {
            BlastingRecipe blastingRecipe = new BlastingRecipe(new NamespacedKey(id.namespace(), id.value()), (ItemStack)recipe.result(ItemBuildContext.EMPTY), BukkitRecipeManager.ingredientToBukkitRecipeChoice(recipe.ingredient()), recipe.experience(), recipe.cookingTime());
            if (recipe.group() != null) {
                blastingRecipe.setGroup(Objects.requireNonNull(recipe.group()));
            }
            if (recipe.category() != null) {
                blastingRecipe.setCategory(CookingBookCategory.valueOf((String)Objects.requireNonNull(recipe.category()).name()));
            }
            return () -> {
                BukkitRecipeManager.registerBukkitBlastingRecipe(blastingRecipe);
                BukkitRecipeManager.injectCookingRecipe(id, recipe);
            };
        });
        MIXED_RECIPE_CONVERTORS.put(RecipeTypes.CAMPFIRE_COOKING, (id, recipe) -> {
            CampfireRecipe campfireRecipe = new CampfireRecipe(new NamespacedKey(id.namespace(), id.value()), (ItemStack)recipe.result(ItemBuildContext.EMPTY), BukkitRecipeManager.ingredientToBukkitRecipeChoice(recipe.ingredient()), recipe.experience(), recipe.cookingTime());
            if (recipe.group() != null) {
                campfireRecipe.setGroup(Objects.requireNonNull(recipe.group()));
            }
            if (recipe.category() != null) {
                campfireRecipe.setCategory(CookingBookCategory.valueOf((String)Objects.requireNonNull(recipe.category()).name()));
            }
            return () -> {
                BukkitRecipeManager.registerBukkitCampfireRecipe(campfireRecipe);
                BukkitRecipeManager.injectCookingRecipe(id, recipe);
            };
        });
        MIXED_RECIPE_CONVERTORS.put(RecipeTypes.STONECUTTING, (id, recipe) -> {
            ArrayList<ItemStack> itemStacks = new ArrayList<ItemStack>();
            for (Holder<Key> item : recipe.ingredient().items()) {
                itemStacks.add(BukkitItemManager.instance().buildItemStack(item.value(), null));
            }
            StonecuttingRecipe stonecuttingRecipe = new StonecuttingRecipe(new NamespacedKey(id.namespace(), id.value()), (ItemStack)recipe.result(ItemBuildContext.EMPTY), (RecipeChoice)new RecipeChoice.ExactChoice(itemStacks));
            if (recipe.group() != null) {
                stonecuttingRecipe.setGroup(Objects.requireNonNull(recipe.group()));
            }
            return () -> BukkitRecipeManager.registerBukkitStoneCuttingRecipe(stonecuttingRecipe);
        });
    }
}

