/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.bukkit.item.recipe;

import java.util.ArrayList;
import java.util.Optional;
import net.momirealms.craftengine.bukkit.item.recipe.BukkitRecipeManager;
import net.momirealms.craftengine.bukkit.plugin.BukkitCraftEngine;
import net.momirealms.craftengine.bukkit.util.ItemUtils;
import net.momirealms.craftengine.core.item.Item;
import net.momirealms.craftengine.core.item.ItemBuildContext;
import net.momirealms.craftengine.core.item.ItemManager;
import net.momirealms.craftengine.core.item.recipe.OptimizedIDItem;
import net.momirealms.craftengine.core.item.recipe.Recipe;
import net.momirealms.craftengine.core.item.recipe.RecipeTypes;
import net.momirealms.craftengine.core.item.recipe.input.CraftingInput;
import net.momirealms.craftengine.core.plugin.config.Config;
import net.momirealms.craftengine.core.registry.BuiltInRegistries;
import net.momirealms.craftengine.core.registry.Holder;
import net.momirealms.craftengine.core.util.Key;
import org.bukkit.block.BlockState;
import org.bukkit.block.Crafter;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.CrafterCraftEvent;
import org.bukkit.inventory.CraftingRecipe;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class CrafterEventListener
implements Listener {
    private static final OptimizedIDItem<ItemStack> EMPTY = new OptimizedIDItem<Object>(null, null);
    private final ItemManager<ItemStack> itemManager;
    private final BukkitRecipeManager recipeManager;
    private final BukkitCraftEngine plugin;

    public CrafterEventListener(BukkitCraftEngine plugin, BukkitRecipeManager recipeManager, ItemManager<ItemStack> itemManager) {
        this.itemManager = itemManager;
        this.recipeManager = recipeManager;
        this.plugin = plugin;
    }

    @EventHandler
    public void onCrafting(CrafterCraftEvent event) {
        CraftingInput input;
        if (!Config.enableRecipeSystem()) {
            return;
        }
        CraftingRecipe recipe = event.getRecipe();
        BlockState blockState = event.getBlock().getState();
        if (!(blockState instanceof Crafter)) {
            return;
        }
        Crafter crafter = (Crafter)blockState;
        Key recipeId = Key.of(recipe.getKey().namespace(), recipe.getKey().value());
        boolean isCustom = this.recipeManager.isCustomRecipe(recipeId);
        if (!isCustom) {
            return;
        }
        Inventory inventory = crafter.getInventory();
        ItemStack[] ingredients = inventory.getStorageContents();
        ArrayList optimizedIDItems = new ArrayList();
        for (ItemStack itemStack : ingredients) {
            if (ItemUtils.isEmpty(itemStack)) {
                optimizedIDItems.add(EMPTY);
                continue;
            }
            Item<ItemStack> wrappedItem = this.itemManager.wrap(itemStack);
            Optional<Holder.Reference<Key>> idHolder = BuiltInRegistries.OPTIMIZED_ITEM_ID.get(wrappedItem.id());
            if (idHolder.isEmpty()) {
                event.setCancelled(true);
                return;
            }
            optimizedIDItems.add(new OptimizedIDItem<ItemStack>((Holder<Key>)idHolder.get(), itemStack));
        }
        if (ingredients.length == 9) {
            input = CraftingInput.of(3, 3, optimizedIDItems);
        } else if (ingredients.length == 4) {
            input = CraftingInput.of(2, 2, optimizedIDItems);
        } else {
            return;
        }
        Recipe ceRecipe = this.recipeManager.recipeByInput(RecipeTypes.SHAPELESS, input);
        if (ceRecipe != null) {
            event.setResult((ItemStack)ceRecipe.result(ItemBuildContext.EMPTY));
            return;
        }
        ceRecipe = this.recipeManager.recipeByInput(RecipeTypes.SHAPED, input);
        if (ceRecipe != null) {
            event.setResult((ItemStack)ceRecipe.result(ItemBuildContext.EMPTY));
            return;
        }
        event.setCancelled(true);
    }
}

