/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.bukkit.item.recipe;

import com.destroystokyo.paper.event.inventory.PrepareResultEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.momirealms.craftengine.bukkit.item.BukkitItemManager;
import net.momirealms.craftengine.bukkit.item.ComponentTypes;
import net.momirealms.craftengine.bukkit.item.recipe.BukkitRecipeManager;
import net.momirealms.craftengine.bukkit.nms.FastNMS;
import net.momirealms.craftengine.bukkit.plugin.BukkitCraftEngine;
import net.momirealms.craftengine.bukkit.plugin.injector.RecipeInjector;
import net.momirealms.craftengine.bukkit.plugin.reflection.bukkit.CraftBukkitReflections;
import net.momirealms.craftengine.bukkit.plugin.reflection.minecraft.CoreReflections;
import net.momirealms.craftengine.bukkit.plugin.reflection.minecraft.MRecipeTypes;
import net.momirealms.craftengine.bukkit.plugin.user.BukkitServerPlayer;
import net.momirealms.craftengine.bukkit.util.ComponentUtils;
import net.momirealms.craftengine.bukkit.util.ItemUtils;
import net.momirealms.craftengine.bukkit.util.LegacyInventoryUtils;
import net.momirealms.craftengine.core.item.CustomItem;
import net.momirealms.craftengine.core.item.Item;
import net.momirealms.craftengine.core.item.ItemBuildContext;
import net.momirealms.craftengine.core.item.ItemKeys;
import net.momirealms.craftengine.core.item.ItemManager;
import net.momirealms.craftengine.core.item.recipe.CustomCampfireRecipe;
import net.momirealms.craftengine.core.item.recipe.CustomSmithingTransformRecipe;
import net.momirealms.craftengine.core.item.recipe.OptimizedIDItem;
import net.momirealms.craftengine.core.item.recipe.Recipe;
import net.momirealms.craftengine.core.item.recipe.RecipeTypes;
import net.momirealms.craftengine.core.item.recipe.input.CraftingInput;
import net.momirealms.craftengine.core.item.recipe.input.SingleItemInput;
import net.momirealms.craftengine.core.item.recipe.input.SmithingInput;
import net.momirealms.craftengine.core.item.setting.AnvilRepairItem;
import net.momirealms.craftengine.core.plugin.config.Config;
import net.momirealms.craftengine.core.plugin.context.ContextHolder;
import net.momirealms.craftengine.core.registry.BuiltInRegistries;
import net.momirealms.craftengine.core.registry.Holder;
import net.momirealms.craftengine.core.util.AdventureHelper;
import net.momirealms.craftengine.core.util.Key;
import net.momirealms.craftengine.core.util.Pair;
import net.momirealms.craftengine.core.util.VersionHelper;
import net.momirealms.craftengine.libraries.adventure.text.Component;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Campfire;
import org.bukkit.block.Furnace;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockCookEvent;
import org.bukkit.event.block.BlockIgniteEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.block.CampfireStartEvent;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.CraftItemEvent;
import org.bukkit.event.inventory.FurnaceBurnEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.inventory.PrepareAnvilEvent;
import org.bukkit.event.inventory.PrepareItemCraftEvent;
import org.bukkit.event.inventory.PrepareSmithingEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.AnvilInventory;
import org.bukkit.inventory.CampfireRecipe;
import org.bukkit.inventory.CartographyInventory;
import org.bukkit.inventory.ComplexRecipe;
import org.bukkit.inventory.CraftingInventory;
import org.bukkit.inventory.CraftingRecipe;
import org.bukkit.inventory.FurnaceInventory;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.ShapelessRecipe;
import org.bukkit.inventory.SmithingInventory;
import org.bukkit.inventory.SmithingTransformRecipe;
import org.bukkit.inventory.view.AnvilView;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.Nullable;

public class RecipeEventListener
implements Listener {
    private static final OptimizedIDItem<ItemStack> EMPTY = new OptimizedIDItem<Object>(null, null);
    private final ItemManager<ItemStack> itemManager;
    private final BukkitRecipeManager recipeManager;
    private final BukkitCraftEngine plugin;

    public RecipeEventListener(BukkitCraftEngine plugin, BukkitRecipeManager recipeManager, ItemManager<ItemStack> itemManager) {
        this.itemManager = itemManager;
        this.recipeManager = recipeManager;
        this.plugin = plugin;
    }

    @EventHandler(ignoreCancelled=true)
    public void onClickInventoryWithFuel(InventoryClickEvent event) {
        Inventory inventory = event.getInventory();
        if (!(inventory instanceof FurnaceInventory)) {
            return;
        }
        FurnaceInventory furnaceInventory = (FurnaceInventory)inventory;
        ItemStack fuelStack = furnaceInventory.getFuel();
        Inventory clickedInventory = event.getClickedInventory();
        Player player = (Player)event.getWhoClicked();
        if (clickedInventory == player.getInventory()) {
            if (event.getClick() == ClickType.SHIFT_LEFT || event.getClick() == ClickType.SHIFT_RIGHT) {
                ItemStack item = event.getCurrentItem();
                if (ItemUtils.isEmpty(item)) {
                    return;
                }
                if (fuelStack == null || fuelStack.getType() == Material.AIR) {
                    Item<ItemStack> wrappedItem = BukkitItemManager.instance().wrap(item);
                    Optional<Holder.Reference<Key>> idHolder = BuiltInRegistries.OPTIMIZED_ITEM_ID.get(wrappedItem.id());
                    if (idHolder.isEmpty()) {
                        return;
                    }
                    SingleItemInput<ItemStack> input = new SingleItemInput<ItemStack>(new OptimizedIDItem<ItemStack>((Holder<Key>)idHolder.get(), item));
                    Key recipeType = furnaceInventory.getType() == InventoryType.FURNACE ? RecipeTypes.SMELTING : (furnaceInventory.getType() == InventoryType.BLAST_FURNACE ? RecipeTypes.BLASTING : RecipeTypes.SMOKING);
                    Recipe ceRecipe = this.recipeManager.recipeByInput(recipeType, input);
                    if (ceRecipe != null) {
                        return;
                    }
                    int fuelTime = this.itemManager.fuelTime(item);
                    if (fuelTime == 0) {
                        if (ItemUtils.isCustomItem(item) && item.getType().isFuel()) {
                            event.setCancelled(true);
                            ItemStack smelting = furnaceInventory.getSmelting();
                            if (ItemUtils.isEmpty(smelting)) {
                                furnaceInventory.setSmelting(item.clone());
                                item.setAmount(0);
                            } else if (smelting.isSimilar(item)) {
                                int maxStackSize = smelting.getMaxStackSize();
                                int canGiveMaxCount = item.getAmount();
                                if (maxStackSize > smelting.getAmount()) {
                                    if (canGiveMaxCount + smelting.getAmount() >= maxStackSize) {
                                        int givenCount = maxStackSize - smelting.getAmount();
                                        smelting.setAmount(maxStackSize);
                                        item.setAmount(item.getAmount() - givenCount);
                                    } else {
                                        smelting.setAmount(smelting.getAmount() + canGiveMaxCount);
                                        item.setAmount(0);
                                    }
                                }
                            }
                            player.updateInventory();
                        }
                        return;
                    }
                    event.setCancelled(true);
                    furnaceInventory.setFuel(item.clone());
                    item.setAmount(0);
                    player.updateInventory();
                } else if (fuelStack.isSimilar(item)) {
                    event.setCancelled(true);
                    int maxStackSize = fuelStack.getMaxStackSize();
                    int canGiveMaxCount = item.getAmount();
                    if (maxStackSize > fuelStack.getAmount()) {
                        if (canGiveMaxCount + fuelStack.getAmount() >= maxStackSize) {
                            int givenCount = maxStackSize - fuelStack.getAmount();
                            fuelStack.setAmount(maxStackSize);
                            item.setAmount(item.getAmount() - givenCount);
                        } else {
                            fuelStack.setAmount(fuelStack.getAmount() + canGiveMaxCount);
                            item.setAmount(0);
                        }
                        player.updateInventory();
                    }
                }
            }
        } else {
            int slot = event.getSlot();
            if (slot != 1) {
                return;
            }
            ClickType clickType = event.getClick();
            switch (clickType) {
                case SWAP_OFFHAND: 
                case NUMBER_KEY: {
                    int hotBarSlot = event.getHotbarButton();
                    ItemStack item = clickType == ClickType.SWAP_OFFHAND ? player.getInventory().getItemInOffHand() : player.getInventory().getItem(hotBarSlot);
                    if (item == null) {
                        return;
                    }
                    int fuelTime = this.plugin.itemManager().fuelTime(item);
                    if (fuelTime == 0) {
                        if (ItemUtils.isCustomItem(item) && item.getType().isFuel()) {
                            event.setCancelled(true);
                        }
                        return;
                    }
                    event.setCancelled(true);
                    if (fuelStack == null || fuelStack.getType() == Material.AIR) {
                        furnaceInventory.setFuel(item.clone());
                        item.setAmount(0);
                    } else {
                        if (clickType == ClickType.SWAP_OFFHAND) {
                            player.getInventory().setItemInOffHand(fuelStack);
                        } else {
                            player.getInventory().setItem(hotBarSlot, fuelStack);
                        }
                        furnaceInventory.setFuel(item.clone());
                    }
                    player.updateInventory();
                    break;
                }
                case LEFT: 
                case RIGHT: {
                    ItemStack itemOnCursor = event.getCursor();
                    if (ItemUtils.isEmpty(itemOnCursor)) {
                        return;
                    }
                    int fuelTime = this.plugin.itemManager().fuelTime(itemOnCursor);
                    if (fuelTime == 0) {
                        if (ItemUtils.isCustomItem(itemOnCursor) && itemOnCursor.getType().isFuel()) {
                            event.setCancelled(true);
                        }
                        return;
                    }
                    event.setCancelled(true);
                    if (fuelStack == null || fuelStack.getType() == Material.AIR) {
                        if (clickType == ClickType.LEFT) {
                            furnaceInventory.setFuel(itemOnCursor.clone());
                            itemOnCursor.setAmount(0);
                            player.updateInventory();
                            break;
                        }
                        ItemStack cloned = itemOnCursor.clone();
                        cloned.setAmount(1);
                        furnaceInventory.setFuel(cloned);
                        itemOnCursor.setAmount(itemOnCursor.getAmount() - 1);
                        player.updateInventory();
                        break;
                    }
                    boolean isSimilar = itemOnCursor.isSimilar(fuelStack);
                    if (clickType == ClickType.LEFT) {
                        if (isSimilar) {
                            int maxStackSize = fuelStack.getMaxStackSize();
                            int canGiveMaxCount = itemOnCursor.getAmount();
                            if (maxStackSize <= fuelStack.getAmount()) break;
                            if (canGiveMaxCount + fuelStack.getAmount() >= maxStackSize) {
                                int givenCount = maxStackSize - fuelStack.getAmount();
                                fuelStack.setAmount(maxStackSize);
                                itemOnCursor.setAmount(itemOnCursor.getAmount() - givenCount);
                            } else {
                                fuelStack.setAmount(fuelStack.getAmount() + canGiveMaxCount);
                                itemOnCursor.setAmount(0);
                            }
                            player.updateInventory();
                            break;
                        }
                        event.setCursor(fuelStack);
                        furnaceInventory.setFuel(itemOnCursor.clone());
                        player.updateInventory();
                        break;
                    }
                    if (isSimilar) {
                        int maxStackSize = fuelStack.getMaxStackSize();
                        if (maxStackSize <= fuelStack.getAmount()) break;
                        fuelStack.setAmount(fuelStack.getAmount() + 1);
                        itemOnCursor.setAmount(itemOnCursor.getAmount() - 1);
                        player.updateInventory();
                        break;
                    }
                    event.setCursor(fuelStack);
                    furnaceInventory.setFuel(itemOnCursor.clone());
                    player.updateInventory();
                }
            }
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGH)
    public void onFurnaceBurn(FurnaceBurnEvent event) {
        ItemStack fuel = event.getFuel();
        int fuelTime = this.itemManager.fuelTime(fuel);
        if (fuelTime != 0) {
            event.setBurnTime(fuelTime);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onFurnaceInventoryOpen(InventoryOpenEvent event) {
        if (!Config.enableRecipeSystem()) {
            return;
        }
        Inventory inventory = event.getInventory();
        if (!(inventory instanceof FurnaceInventory)) {
            return;
        }
        FurnaceInventory furnaceInventory = (FurnaceInventory)inventory;
        Furnace furnace = furnaceInventory.getHolder();
        try {
            Object blockEntity = CraftBukkitReflections.field$CraftBlockEntityState$tileEntity.get(furnace);
            RecipeInjector.injectCookingBlockEntity(blockEntity);
        }
        catch (Exception e) {
            this.plugin.logger().warn("Failed to inject cooking block entity", e);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onBlockIgnite(BlockIgniteEvent event) {
        BlockState blockState;
        if (!Config.enableRecipeSystem()) {
            return;
        }
        if (VersionHelper.isOrAbove1_21_2()) {
            return;
        }
        Block block = event.getBlock();
        Material material = block.getType();
        if (material == Material.CAMPFIRE && (blockState = block.getState()) instanceof Campfire) {
            Campfire campfire = (Campfire)blockState;
            try {
                Object blockEntity = CraftBukkitReflections.field$CraftBlockEntityState$tileEntity.get(campfire);
                RecipeInjector.injectCookingBlockEntity(blockEntity);
            }
            catch (Exception e) {
                this.plugin.logger().warn("Failed to inject cooking block entity", e);
            }
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onPlaceBlock(BlockPlaceEvent event) {
        BlockState e2;
        if (!Config.enableRecipeSystem()) {
            return;
        }
        Block block = event.getBlock();
        Material material = block.getType();
        if (material == Material.FURNACE || material == Material.BLAST_FURNACE || material == Material.SMOKER) {
            BlockState blockState = block.getState();
            if (blockState instanceof Furnace) {
                Furnace furnace = (Furnace)blockState;
                try {
                    Object blockEntity = CraftBukkitReflections.field$CraftBlockEntityState$tileEntity.get(furnace);
                    RecipeInjector.injectCookingBlockEntity(blockEntity);
                }
                catch (Exception e2) {
                    this.plugin.logger().warn("Failed to inject cooking block entity", e2);
                }
            }
        } else if (!VersionHelper.isOrAbove1_21_2() && material == Material.CAMPFIRE && (e2 = block.getState()) instanceof Campfire) {
            Campfire campfire = (Campfire)e2;
            try {
                Object blockEntity = CraftBukkitReflections.field$CraftBlockEntityState$tileEntity.get(campfire);
                RecipeInjector.injectCookingBlockEntity(blockEntity);
            }
            catch (Exception e3) {
                this.plugin.logger().warn("Failed to inject cooking block entity", e3);
            }
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onPutItemOnCampfire(PlayerInteractEvent event) {
        ItemStack itemStack;
        if (!Config.enableRecipeSystem()) {
            return;
        }
        if (!VersionHelper.isOrAbove1_21_2()) {
            return;
        }
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        Block clicked = event.getClickedBlock();
        if (clicked == null) {
            return;
        }
        Material type = clicked.getType();
        if (type != Material.CAMPFIRE && type != Material.SOUL_CAMPFIRE) {
            return;
        }
        BlockState blockState = clicked.getState();
        if (blockState instanceof Campfire) {
            Campfire campfire = (Campfire)blockState;
            try {
                Object blockEntity = CraftBukkitReflections.field$CraftBlockEntityState$tileEntity.get(campfire);
                RecipeInjector.injectCookingBlockEntity(blockEntity);
            }
            catch (Exception e) {
                this.plugin.logger().warn("Failed to inject cooking block entity", e);
            }
        }
        if (ItemUtils.isEmpty(itemStack = event.getItem())) {
            return;
        }
        try {
            Optional optionalMCRecipe = FastNMS.INSTANCE.method$RecipeManager$getRecipeFor(BukkitRecipeManager.nmsRecipeManager(), MRecipeTypes.CAMPFIRE_COOKING, CoreReflections.constructor$SingleRecipeInput.newInstance(FastNMS.INSTANCE.method$CraftItemStack$asNMSCopy(itemStack)), FastNMS.INSTANCE.field$CraftWorld$ServerLevel(event.getPlayer().getWorld()), null);
            if (optionalMCRecipe.isEmpty()) {
                return;
            }
            Item<ItemStack> wrappedItem = BukkitItemManager.instance().wrap(itemStack);
            Optional<Holder.Reference<Key>> idHolder = BuiltInRegistries.OPTIMIZED_ITEM_ID.get(wrappedItem.id());
            if (idHolder.isEmpty()) {
                return;
            }
            SingleItemInput<ItemStack> input = new SingleItemInput<ItemStack>(new OptimizedIDItem<ItemStack>((Holder<Key>)idHolder.get(), itemStack));
            CustomCampfireRecipe ceRecipe = (CustomCampfireRecipe)this.recipeManager.recipeByInput(RecipeTypes.CAMPFIRE_COOKING, input);
            if (ceRecipe == null) {
                event.setCancelled(true);
            }
        }
        catch (Exception e) {
            this.plugin.logger().warn("Failed to handle interact campfire", e);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onCampfireCook(CampfireStartEvent event) {
        if (!Config.enableRecipeSystem()) {
            return;
        }
        if (!VersionHelper.isOrAbove1_21_2()) {
            return;
        }
        CampfireRecipe recipe = event.getRecipe();
        Key recipeId = new Key(recipe.getKey().namespace(), recipe.getKey().value());
        boolean isCustom = this.recipeManager.isCustomRecipe(recipeId);
        if (!isCustom) {
            return;
        }
        ItemStack itemStack = event.getSource();
        Item<ItemStack> wrappedItem = BukkitItemManager.instance().wrap(itemStack);
        Optional<Holder.Reference<Key>> idHolder = BuiltInRegistries.OPTIMIZED_ITEM_ID.get(wrappedItem.id());
        if (idHolder.isEmpty()) {
            event.setTotalCookTime(Integer.MAX_VALUE);
            return;
        }
        SingleItemInput<ItemStack> input = new SingleItemInput<ItemStack>(new OptimizedIDItem<ItemStack>((Holder<Key>)idHolder.get(), itemStack));
        CustomCampfireRecipe ceRecipe = (CustomCampfireRecipe)this.recipeManager.recipeByInput(RecipeTypes.CAMPFIRE_COOKING, input);
        if (ceRecipe == null) {
            event.setTotalCookTime(Integer.MAX_VALUE);
            return;
        }
        event.setTotalCookTime(ceRecipe.cookingTime());
    }

    @EventHandler(ignoreCancelled=true)
    public void onCampfireCook(BlockCookEvent event) {
        if (!Config.enableRecipeSystem()) {
            return;
        }
        if (!VersionHelper.isOrAbove1_21_2()) {
            return;
        }
        Material type = event.getBlock().getType();
        if (type != Material.CAMPFIRE && type != Material.SOUL_CAMPFIRE) {
            return;
        }
        CampfireRecipe recipe = (CampfireRecipe)event.getRecipe();
        if (recipe == null) {
            return;
        }
        Key recipeId = new Key(recipe.getKey().namespace(), recipe.getKey().value());
        boolean isCustom = this.recipeManager.isCustomRecipe(recipeId);
        if (!isCustom) {
            return;
        }
        ItemStack itemStack = event.getSource();
        Item<ItemStack> wrappedItem = BukkitItemManager.instance().wrap(itemStack);
        Optional<Holder.Reference<Key>> idHolder = BuiltInRegistries.OPTIMIZED_ITEM_ID.get(wrappedItem.id());
        if (idHolder.isEmpty()) {
            event.setCancelled(true);
            return;
        }
        SingleItemInput<ItemStack> input = new SingleItemInput<ItemStack>(new OptimizedIDItem<ItemStack>((Holder<Key>)idHolder.get(), itemStack));
        CustomCampfireRecipe ceRecipe = (CustomCampfireRecipe)this.recipeManager.recipeByInput(RecipeTypes.CAMPFIRE_COOKING, input);
        if (ceRecipe == null) {
            event.setCancelled(true);
            return;
        }
        event.setResult((ItemStack)ceRecipe.result(ItemBuildContext.EMPTY));
    }

    @EventHandler
    public void onPrepareResult(PrepareResultEvent event) {
        CartographyInventory cartographyInventory;
        Inventory inventory = event.getInventory();
        if (inventory instanceof CartographyInventory && ItemUtils.hasCustomItem((cartographyInventory = (CartographyInventory)inventory).getStorageContents())) {
            event.setResult(new ItemStack(Material.AIR));
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOWEST)
    public void onAnvilCombineItems(PrepareAnvilEvent event) {
        AnvilInventory inventory = event.getInventory();
        ItemStack first = inventory.getFirstItem();
        ItemStack second = inventory.getSecondItem();
        if (first == null || second == null) {
            return;
        }
        Item<ItemStack> wrappedFirst = BukkitItemManager.instance().wrap(first);
        boolean firstCustom = wrappedFirst.isCustomItem();
        Item<ItemStack> wrappedSecond = BukkitItemManager.instance().wrap(second);
        boolean secondCustom = wrappedSecond.isCustomItem();
        if (!firstCustom && !secondCustom) {
            return;
        }
        if (wrappedSecond.vanillaId().equals(ItemKeys.ENCHANTED_BOOK)) {
            return;
        }
        if (!firstCustom || !secondCustom) {
            if (second.canRepair(first)) {
                return;
            }
            event.setResult(null);
            return;
        }
        if (!wrappedFirst.customId().equals(wrappedSecond.customId())) {
            event.setResult(null);
            return;
        }
        wrappedFirst.getCustomItem().ifPresent(it -> {
            if (!it.settings().canRepair()) {
                event.setResult(null);
            }
        });
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOW)
    public void onAnvilRepairItems(PrepareAnvilEvent event) {
        Player player;
        int maxRepairCost;
        String renameText;
        AnvilInventory inventory = event.getInventory();
        ItemStack first = inventory.getFirstItem();
        ItemStack second = inventory.getSecondItem();
        if (first == null || second == null) {
            return;
        }
        Item<ItemStack> wrappedSecond = BukkitItemManager.instance().wrap(second);
        Optional<CustomItem<ItemStack>> customItemOptional = this.plugin.itemManager().getCustomItem(wrappedSecond.id());
        if (customItemOptional.isEmpty()) {
            return;
        }
        CustomItem<ItemStack> customItem = customItemOptional.get();
        List<AnvilRepairItem> repairItems = customItem.settings().repairItems();
        if (repairItems.isEmpty()) {
            return;
        }
        Item<ItemStack> wrappedFirst = BukkitItemManager.instance().wrap(first.clone());
        int maxDamage = wrappedFirst.maxDamage();
        int damage = wrappedFirst.damage().orElse(0);
        if (damage == 0 || maxDamage == 0) {
            return;
        }
        Key firstId = wrappedFirst.id();
        Optional<CustomItem<ItemStack>> optionalCustomTool = wrappedFirst.getCustomItem();
        if (optionalCustomTool.isPresent() && !optionalCustomTool.get().settings().canRepair()) {
            return;
        }
        AnvilRepairItem repairItem = null;
        block6: for (AnvilRepairItem item : repairItems) {
            for (String target : item.targets()) {
                if (target.charAt(0) == '#') {
                    Key tag = Key.of(target.substring(1));
                    if (optionalCustomTool.isPresent() && optionalCustomTool.get().is(tag)) {
                        repairItem = item;
                        continue block6;
                    }
                    if (!wrappedFirst.is(tag)) continue;
                    repairItem = item;
                    continue block6;
                }
                if (!target.equals(firstId.toString())) continue;
                repairItem = item;
                continue block6;
            }
        }
        if (repairItem == null) {
            return;
        }
        boolean hasResult = true;
        int realDurabilityPerItem = (int)((double)repairItem.amount() + repairItem.percent() * (double)maxDamage);
        int consumeMaxAmount = damage / realDurabilityPerItem + 1;
        int actualConsumedAmount = Math.min(consumeMaxAmount, wrappedSecond.count());
        int actualRepairAmount = actualConsumedAmount * realDurabilityPerItem;
        int damageAfter = Math.max(damage - actualRepairAmount, 0);
        wrappedFirst.damage(damageAfter);
        if (VersionHelper.isOrAbove1_21_2()) {
            AnvilView anvilView = event.getView();
            renameText = anvilView.getRenameText();
            maxRepairCost = anvilView.getMaximumRepairCost();
        } else {
            renameText = LegacyInventoryUtils.getRenameText(inventory);
            maxRepairCost = LegacyInventoryUtils.getMaxRepairCost(inventory);
        }
        int repairCost = actualConsumedAmount;
        int repairPenalty = wrappedFirst.repairCost().orElse(0) + wrappedSecond.repairCost().orElse(0);
        if (renameText != null && !renameText.isBlank()) {
            try {
                if (!renameText.equals(CoreReflections.method$Component$getString.invoke(ComponentUtils.jsonToMinecraft(wrappedFirst.hoverNameJson().orElse(AdventureHelper.EMPTY_COMPONENT)), new Object[0]))) {
                    wrappedFirst.customNameJson(AdventureHelper.componentToJson((Component)Component.text((String)renameText)));
                    ++repairCost;
                } else if (repairCost == 0) {
                    hasResult = false;
                }
            }
            catch (ReflectiveOperationException e) {
                this.plugin.logger().warn("Failed to get hover name", e);
            }
        } else if (VersionHelper.isOrAbove1_20_5() && wrappedFirst.hasComponent(ComponentTypes.CUSTOM_NAME)) {
            ++repairCost;
            wrappedFirst.customNameJson(null);
        } else if (!VersionHelper.isOrAbove1_20_5() && wrappedFirst.hasTag("display", "Name")) {
            ++repairCost;
            wrappedFirst.customNameJson(null);
        }
        int finalCost = repairCost + repairPenalty;
        try {
            Object anvilMenu = VersionHelper.isOrAbove1_21() ? CraftBukkitReflections.field$CraftInventoryView$container.get(event.getView()) : CraftBukkitReflections.field$CraftInventoryAnvil$menu.get(inventory);
            CoreReflections.method$AbstractContainerMenu$broadcastFullState.invoke(anvilMenu, new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            this.plugin.logger().warn("Failed to broadcast changes", e);
        }
        if (VersionHelper.isOrAbove1_21()) {
            AnvilView anvilView = event.getView();
            anvilView.setRepairCost(finalCost);
            anvilView.setRepairItemCountCost(actualConsumedAmount);
        } else {
            LegacyInventoryUtils.setRepairCost(inventory, finalCost);
            LegacyInventoryUtils.setRepairCostAmount(inventory, actualConsumedAmount);
        }
        try {
            player = (Player)CraftBukkitReflections.method$InventoryView$getPlayer.invoke(VersionHelper.isOrAbove1_21() ? event.getView() : LegacyInventoryUtils.getView(event), new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            this.plugin.logger().warn("Failed to get inventory viewer", e);
            return;
        }
        if (finalCost >= maxRepairCost && !this.plugin.adapt(player).canInstabuild()) {
            hasResult = false;
        }
        if (hasResult) {
            int anotherPenalty;
            int afterPenalty = wrappedFirst.repairCost().orElse(0);
            if (afterPenalty < (anotherPenalty = wrappedSecond.repairCost().orElse(0).intValue())) {
                afterPenalty = anotherPenalty;
            }
            afterPenalty = RecipeEventListener.calculateIncreasedRepairCost(afterPenalty);
            wrappedFirst.repairCost(afterPenalty);
            event.setResult(wrappedFirst.getItem());
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.NORMAL)
    public void onAnvilRenameItem(PrepareAnvilEvent event) {
        AnvilInventory inventory = event.getInventory();
        ItemStack first = inventory.getFirstItem();
        if (ItemUtils.isEmpty(first)) {
            return;
        }
        if (event.getResult() == null) {
            return;
        }
        Item<ItemStack> wrappedFirst = BukkitItemManager.instance().wrap(first);
        wrappedFirst.getCustomItem().ifPresent(item -> {
            if (!item.settings().renameable()) {
                String renameText;
                if (VersionHelper.isOrAbove1_21_2()) {
                    AnvilView anvilView = event.getView();
                    renameText = anvilView.getRenameText();
                } else {
                    renameText = LegacyInventoryUtils.getRenameText(inventory);
                }
                if (renameText != null && !renameText.isBlank()) {
                    try {
                        if (!renameText.equals(CoreReflections.method$Component$getString.invoke(ComponentUtils.jsonToMinecraft(wrappedFirst.hoverNameJson().orElse(AdventureHelper.EMPTY_COMPONENT)), new Object[0]))) {
                            event.setResult(null);
                        }
                    }
                    catch (Exception e) {
                        this.plugin.logger().warn("Failed to get hover name", e);
                    }
                }
            }
        });
    }

    public static int calculateIncreasedRepairCost(int cost) {
        return (int)Math.min((long)cost * 2L + 1L, Integer.MAX_VALUE);
    }

    @EventHandler(ignoreCancelled=true)
    public void onSpecialRecipe(PrepareItemCraftEvent event) {
        block16: {
            org.bukkit.inventory.Recipe recipe = event.getRecipe();
            if (recipe == null) {
                return;
            }
            if (!(recipe instanceof ComplexRecipe)) {
                return;
            }
            ComplexRecipe complexRecipe = (ComplexRecipe)recipe;
            CraftingInventory inventory = event.getInventory();
            boolean hasCustomItem = ItemUtils.hasCustomItem(inventory.getMatrix());
            if (!hasCustomItem) {
                return;
            }
            if (!CraftBukkitReflections.clazz$CraftComplexRecipe.isInstance(complexRecipe)) {
                inventory.setResult(null);
                return;
            }
            try {
                Object mcRecipe = CraftBukkitReflections.field$CraftComplexRecipe$recipe.get(complexRecipe);
                if (CoreReflections.clazz$RepairItemRecipe.isInstance(mcRecipe)) {
                    Player player;
                    int totalMaxDamage;
                    ItemStack[] itemStacks = inventory.getMatrix();
                    Pair<ItemStack, ItemStack> onlyTwoItems = this.getTheOnlyTwoItem(itemStacks);
                    if (onlyTwoItems.left() == null || onlyTwoItems.right() == null) {
                        inventory.setResult(null);
                        return;
                    }
                    Item<ItemStack> left = this.plugin.itemManager().wrap(onlyTwoItems.left());
                    Item<ItemStack> right = this.plugin.itemManager().wrap(onlyTwoItems.right());
                    if (!left.id().equals(right.id())) {
                        inventory.setResult(null);
                        return;
                    }
                    int totalDamage = right.damage().orElse(0) + left.damage().orElse(0);
                    if (totalDamage >= (totalMaxDamage = left.maxDamage() + right.maxDamage())) {
                        inventory.setResult(null);
                        return;
                    }
                    try {
                        player = (Player)CraftBukkitReflections.method$InventoryView$getPlayer.invoke((Object)event.getView(), new Object[0]);
                    }
                    catch (ReflectiveOperationException e) {
                        this.plugin.logger().warn("Failed to get inventory viewer", e);
                        return;
                    }
                    Optional<CustomItem<ItemStack>> customItemOptional = this.plugin.itemManager().getCustomItem(left.id());
                    if (customItemOptional.isEmpty()) {
                        inventory.setResult(null);
                        return;
                    }
                    CustomItem<ItemStack> customItem = customItemOptional.get();
                    if (!customItem.settings().canRepair()) {
                        inventory.setResult(null);
                        return;
                    }
                    Item<ItemStack> newItem = customItem.buildItem(ItemBuildContext.of(this.plugin.adapt(player)));
                    int remainingDurability = totalMaxDamage - totalDamage;
                    int newItemDamage = Math.max(0, newItem.maxDamage() - remainingDurability);
                    newItem.damage(newItemDamage);
                    inventory.setResult(newItem.getItem());
                    break block16;
                }
                if (CoreReflections.clazz$ArmorDyeRecipe.isInstance(mcRecipe) || CoreReflections.clazz$FireworkStarFadeRecipe.isInstance(mcRecipe)) {
                    ItemStack[] itemStacks;
                    for (ItemStack itemStack : itemStacks = inventory.getMatrix()) {
                        Item<ItemStack> item;
                        Optional<CustomItem<ItemStack>> optionalCustomItem;
                        if (itemStack == null || !(optionalCustomItem = (item = this.plugin.itemManager().wrap(itemStack)).getCustomItem()).isPresent() || optionalCustomItem.get().settings().dyeable()) continue;
                        inventory.setResult(null);
                        return;
                    }
                    break block16;
                }
                inventory.setResult(null);
                return;
            }
            catch (Exception e) {
                this.plugin.logger().warn("Failed to handle minecraft custom recipe", e);
            }
        }
    }

    private Pair<ItemStack, ItemStack> getTheOnlyTwoItem(ItemStack[] matrix) {
        ItemStack first = null;
        ItemStack second = null;
        for (ItemStack itemStack : matrix) {
            if (itemStack == null) continue;
            if (first == null) {
                first = itemStack;
                continue;
            }
            if (second != null) continue;
            second = itemStack;
        }
        return new Pair<Object, Object>(first, second);
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
    public void onCraft(CraftItemEvent event) {
        org.bukkit.inventory.Recipe recipe = event.getRecipe();
        if (!(recipe instanceof ShapelessRecipe) && !(recipe instanceof ShapedRecipe)) {
            return;
        }
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        CraftingInventory inventory = event.getInventory();
        ItemStack result = inventory.getResult();
        if (result == null) {
            return;
        }
        ItemStack[] usedItems = inventory.getMatrix();
        ItemStack[] replacements = new ItemStack[usedItems.length];
        boolean hasReplacement = false;
        for (int i = 0; i < usedItems.length; ++i) {
            CustomItem<ItemStack> customItem;
            Key remainingItem;
            Optional<CustomItem<ItemStack>> optionalCustomItem;
            Item<ItemStack> wrapped;
            ItemStack usedItem = usedItems[i];
            if (ItemUtils.isEmpty(usedItem) || usedItem.getAmount() != 1 || (wrapped = BukkitItemManager.instance().wrap(usedItem)) == null || !(optionalCustomItem = wrapped.getCustomItem()).isPresent() || (remainingItem = (customItem = optionalCustomItem.get()).settings().craftRemainder()) == null) continue;
            replacements[i] = BukkitItemManager.instance().buildItemStack(remainingItem, this.plugin.adapt(player));
            hasReplacement = true;
        }
        if (!hasReplacement) {
            return;
        }
        Runnable delayedTask = () -> {
            for (int i = 0; i < replacements.length; ++i) {
                if (replacements[i] == null) continue;
                inventory.setItem(i + 1, replacements[i]);
            }
        };
        if (VersionHelper.isFolia()) {
            player.getScheduler().run((Plugin)this.plugin.javaPlugin(), t -> delayedTask.run(), () -> {});
        } else {
            this.plugin.scheduler().sync().runDelayed(delayedTask);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onCraftingRecipe(PrepareItemCraftEvent event) {
        Player player;
        CraftingInput input;
        if (!Config.enableRecipeSystem()) {
            return;
        }
        org.bukkit.inventory.Recipe recipe = event.getRecipe();
        if (recipe == null) {
            return;
        }
        boolean shapeless = event.getRecipe() instanceof ShapelessRecipe;
        boolean shaped = event.getRecipe() instanceof ShapedRecipe;
        if (!shaped && !shapeless) {
            return;
        }
        CraftingRecipe craftingRecipe = (CraftingRecipe)recipe;
        Key recipeId = Key.of(craftingRecipe.getKey().namespace(), craftingRecipe.getKey().value());
        boolean isCustom = this.recipeManager.isCustomRecipe(recipeId);
        if (!isCustom) {
            return;
        }
        CraftingInventory inventory = event.getInventory();
        ItemStack[] ingredients = inventory.getMatrix();
        ArrayList optimizedIDItems = new ArrayList();
        for (ItemStack itemStack : ingredients) {
            if (ItemUtils.isEmpty(itemStack)) {
                optimizedIDItems.add(EMPTY);
                continue;
            }
            Item<ItemStack> wrappedItem = this.itemManager.wrap(itemStack);
            Optional<Holder.Reference<Key>> idHolder = BuiltInRegistries.OPTIMIZED_ITEM_ID.get(wrappedItem.id());
            if (idHolder.isEmpty()) {
                inventory.setResult(null);
                return;
            }
            optimizedIDItems.add(new OptimizedIDItem<ItemStack>((Holder<Key>)idHolder.get(), itemStack));
        }
        if (ingredients.length == 9) {
            input = CraftingInput.of(3, 3, optimizedIDItems);
        } else if (ingredients.length == 4) {
            input = CraftingInput.of(2, 2, optimizedIDItems);
        } else {
            return;
        }
        try {
            player = (Player)CraftBukkitReflections.method$InventoryView$getPlayer.invoke((Object)event.getView(), new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            this.plugin.logger().warn("Failed to get inventory viewer", e);
            return;
        }
        BukkitServerPlayer serverPlayer = this.plugin.adapt(player);
        Key lastRecipe = serverPlayer.lastUsedRecipe();
        Recipe<Object> ceRecipe = this.recipeManager.recipeByInput(RecipeTypes.SHAPELESS, input, lastRecipe);
        if (ceRecipe != null) {
            inventory.setResult((ItemStack)ceRecipe.result(new ItemBuildContext(serverPlayer, ContextHolder.EMPTY)));
            serverPlayer.setLastUsedRecipe(ceRecipe.id());
            if (!ceRecipe.id().equals(recipeId)) {
                this.correctCraftingRecipeUsed(inventory, ceRecipe);
            }
            return;
        }
        ceRecipe = this.recipeManager.recipeByInput(RecipeTypes.SHAPED, input, lastRecipe);
        if (ceRecipe != null) {
            inventory.setResult((ItemStack)ceRecipe.result(new ItemBuildContext(serverPlayer, ContextHolder.EMPTY)));
            serverPlayer.setLastUsedRecipe(ceRecipe.id());
            if (!ceRecipe.id().equals(recipeId)) {
                this.correctCraftingRecipeUsed(inventory, ceRecipe);
            }
            return;
        }
        inventory.setResult(null);
    }

    private void correctCraftingRecipeUsed(CraftingInventory inventory, Recipe<ItemStack> recipe) {
        Object holderOrRecipe = this.recipeManager.nmsRecipeHolderByRecipe(recipe);
        if (holderOrRecipe == null) {
            return;
        }
        try {
            Object resultInventory = CraftBukkitReflections.field$CraftInventoryCrafting$resultInventory.get(inventory);
            CoreReflections.field$ResultContainer$recipeUsed.set(resultInventory, holderOrRecipe);
        }
        catch (ReflectiveOperationException e) {
            this.plugin.logger().warn("Failed to correct used recipe", e);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onSmithingTransform(PrepareSmithingEvent event) {
        Player player;
        if (!Config.enableRecipeSystem()) {
            return;
        }
        SmithingInventory inventory = event.getInventory();
        org.bukkit.inventory.Recipe recipe = inventory.getRecipe();
        if (!(recipe instanceof SmithingTransformRecipe)) {
            return;
        }
        SmithingTransformRecipe recipe2 = (SmithingTransformRecipe)recipe;
        Key recipeId = Key.of(recipe2.getKey().namespace(), recipe2.getKey().value());
        boolean isCustom = this.recipeManager.isCustomRecipe(recipeId);
        if (!isCustom) {
            return;
        }
        ItemStack base = inventory.getInputEquipment();
        ItemStack template = inventory.getInputTemplate();
        ItemStack addition = inventory.getInputMineral();
        SmithingInput<ItemStack> input = new SmithingInput<ItemStack>(this.getOptimizedIDItem(base), this.getOptimizedIDItem(template), this.getOptimizedIDItem(addition));
        Recipe<ItemStack> ceRecipe = this.recipeManager.recipeByInput(RecipeTypes.SMITHING_TRANSFORM, input);
        if (ceRecipe == null) {
            event.setResult(null);
            return;
        }
        try {
            player = (Player)CraftBukkitReflections.method$InventoryView$getPlayer.invoke((Object)event.getView(), new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            this.plugin.logger().warn("Failed to get inventory viewer", e);
            return;
        }
        CustomSmithingTransformRecipe transformRecipe = (CustomSmithingTransformRecipe)ceRecipe;
        ItemStack processed = transformRecipe.assemble(new ItemBuildContext(this.plugin.adapt(player), ContextHolder.EMPTY), this.itemManager.wrap(base));
        event.setResult(processed);
        if (!ceRecipe.id().equals(recipeId)) {
            this.correctSmithingRecipeUsed(inventory, ceRecipe);
        }
    }

    private void correctSmithingRecipeUsed(SmithingInventory inventory, Recipe<ItemStack> recipe) {
        Object holderOrRecipe = this.recipeManager.nmsRecipeHolderByRecipe(recipe);
        if (holderOrRecipe == null) {
            return;
        }
        try {
            Object resultInventory = CraftBukkitReflections.field$CraftResultInventory$resultInventory.get(inventory);
            CoreReflections.field$ResultContainer$recipeUsed.set(resultInventory, holderOrRecipe);
        }
        catch (ReflectiveOperationException e) {
            this.plugin.logger().warn("Failed to correct used recipe", e);
        }
    }

    private OptimizedIDItem<ItemStack> getOptimizedIDItem(@Nullable ItemStack itemStack) {
        if (ItemUtils.isEmpty(itemStack)) {
            return EMPTY;
        }
        Item<ItemStack> wrappedItem = this.itemManager.wrap(itemStack);
        Optional<Holder.Reference<Key>> idHolder = BuiltInRegistries.OPTIMIZED_ITEM_ID.get(wrappedItem.id());
        return idHolder.map(keyReference -> new OptimizedIDItem<ItemStack>((Holder<Key>)keyReference, itemStack)).orElse(EMPTY);
    }
}

