/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.bukkit.nms.v1_21_6;

import javax.annotation.Nullable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Interaction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.momirealms.craftengine.bukkit.nms.CollisionEntity;
import org.jetbrains.annotations.NotNull;

public class CollisionInteraction
extends Interaction
implements CollisionEntity {
    private final AABB aabb;
    private final boolean canProjectileHit;

    public CollisionInteraction(EntityType<? extends Interaction> type, Level world, double x, double y, double z, AABB aabb, boolean canProjectileHit, boolean blockBuilding) {
        super(type, world);
        this.aabb = aabb;
        this.canProjectileHit = canProjectileHit;
        this.setInvisible(true);
        this.setPos(new Vec3(x, y, z));
        this.setBoundingBox(aabb);
        this.setInvulnerable(true);
        this.setSilent(true);
        this.blocksBuilding = blockBuilding;
    }

    public boolean save(@NotNull ValueOutput output) {
        return super.saveAsPassenger(output, true, false, true);
    }

    @Override
    public void destroy() {
        super.remove(Entity.RemovalReason.DISCARDED);
    }

    @Override
    public int getId() {
        return super.getId();
    }

    public void tick() {
    }

    public void setPos(double x, double y, double z) {
        this.setPosRaw(x, y, z, true);
    }

    public boolean canBeHitByProjectile() {
        return this.canProjectileHit;
    }

    public boolean canCollideWith(@NotNull Entity other) {
        return true;
    }

    public boolean canCollideWithBukkit(@NotNull Entity entity) {
        return true;
    }

    public boolean canBeCollidedWith(@Nullable Entity entity) {
        return true;
    }
}

