/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.bukkit.plugin.command.feature;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import net.momirealms.craftengine.bukkit.nms.FastNMS;
import net.momirealms.craftengine.bukkit.plugin.command.BukkitCommandFeature;
import net.momirealms.craftengine.bukkit.plugin.reflection.minecraft.MRegistryOps;
import net.momirealms.craftengine.bukkit.util.ItemUtils;
import net.momirealms.craftengine.core.plugin.CraftEngine;
import net.momirealms.craftengine.core.plugin.command.CraftEngineCommandManager;
import net.momirealms.craftengine.core.util.AdventureHelper;
import net.momirealms.craftengine.libraries.cloud.Command;
import net.momirealms.craftengine.libraries.cloud.CommandManager;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class DebugItemDataCommand
extends BukkitCommandFeature<CommandSender> {
    public DebugItemDataCommand(CraftEngineCommandManager<CommandSender> commandManager, CraftEngine plugin) {
        super(commandManager, plugin);
    }

    @Override
    public Command.Builder<? extends CommandSender> assembleCommand(CommandManager<CommandSender> manager, Command.Builder<CommandSender> builder) {
        return builder.senderType(Player.class).handler(context -> {
            ItemStack itemInHand = ((Player)context.sender()).getInventory().getItemInMainHand();
            if (ItemUtils.isEmpty(itemInHand)) {
                return;
            }
            Map<String, Object> readableMap = DebugItemDataCommand.toMap(itemInHand);
            List<String> readableList = this.mapToList(readableMap);
            StringJoiner joiner = new StringJoiner("<newline><reset>");
            for (String text : readableList) {
                joiner.add(text);
            }
            this.plugin().senderFactory().wrap((Player)context.sender()).sendMessage(AdventureHelper.miniMessage().deserialize((Object)joiner.toString()));
        });
    }

    @Override
    public String getFeatureID() {
        return "debug_item_data";
    }

    private static Map<String, Object> toMap(ItemStack object) {
        Object tag = FastNMS.INSTANCE.method$itemStack$save(FastNMS.INSTANCE.field$CraftItemStack$handle(object), FastNMS.INSTANCE.constructor$CompoundTag());
        return (Map)MRegistryOps.NBT.convertTo(MRegistryOps.JAVA, tag);
    }

    private List<String> mapToList(Map<String, Object> readableDataMap) {
        ArrayList<String> list = new ArrayList<String>();
        this.mapToList(readableDataMap, list, 0, false);
        return list;
    }

    private void mapToList(Map<String, Object> map, List<String> readableList, int loopTimes, boolean isMapList) {
        boolean first = true;
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            Object nbt = entry.getValue();
            if (nbt instanceof List) {
                List list = (List)nbt;
                if (isMapList && first) {
                    first = false;
                    readableList.add("  ".repeat(loopTimes - 1) + "<#F5F5F5>- <gradient:#FFD700:#FFFACD><hover:show_text:'<yellow>List'>" + entry.getKey() + "</hover></gradient>:</#F5F5F5>");
                } else {
                    readableList.add("  ".repeat(loopTimes) + "<#F5F5F5><gradient:#FFD700:#FFFACD><hover:show_text:'<yellow>List'>" + entry.getKey() + "</hover></gradient>:</#F5F5F5>");
                }
                for (Object value : list) {
                    if (value instanceof Map) {
                        Map innerDataMap = (Map)value;
                        this.mapToList(innerDataMap, readableList, loopTimes + 2, true);
                        continue;
                    }
                    if (value instanceof String) {
                        String string = (String)value;
                        readableList.add("  ".repeat(loopTimes + 1) + "<#F5F5F5>- <hover:show_text:'<yellow>Copy'><click:suggest_command:'" + string.replace("'", "\\'") + "'>" + String.valueOf(value) + "</click></hover></#F5F5F5>");
                        continue;
                    }
                    readableList.add("  ".repeat(loopTimes + 1) + "<#F5F5F5>- <hover:show_text:'<yellow>Copy'><click:suggest_command:'" + String.valueOf(value) + "'>" + String.valueOf(value) + "</click></hover></#F5F5F5>");
                }
                continue;
            }
            if (nbt instanceof Map) {
                Map innerMap = (Map)nbt;
                if (isMapList && first) {
                    first = false;
                    readableList.add("  ".repeat(loopTimes - 1) + "<#F5F5F5>- <gradient:#FFD700:#FFFACD><hover:show_text:'<yellow>Map'>" + entry.getKey() + "</hover></gradient>:</#F5F5F5>");
                } else {
                    readableList.add("  ".repeat(loopTimes) + "<#F5F5F5><gradient:#FFD700:#FFFACD><hover:show_text:'<yellow>Map'>" + entry.getKey() + "</hover></gradient>:");
                }
                this.mapToList(innerMap, readableList, loopTimes + 1, false);
                continue;
            }
            String value = nbt.getClass().isArray() ? (nbt instanceof Object[] ? Arrays.deepToString((Object[])nbt) : (nbt instanceof int[] ? Arrays.toString((int[])nbt) : (nbt instanceof long[] ? Arrays.toString((long[])nbt) : (nbt instanceof double[] ? Arrays.toString((double[])nbt) : (nbt instanceof float[] ? Arrays.toString((float[])nbt) : (nbt instanceof boolean[] ? Arrays.toString((boolean[])nbt) : (nbt instanceof byte[] ? Arrays.toString((byte[])nbt) : (nbt instanceof char[] ? Arrays.toString((char[])nbt) : (nbt instanceof short[] ? Arrays.toString((short[])nbt) : "Unknown array type"))))))))) : nbt.toString();
            if (isMapList && first) {
                first = false;
                readableList.add("  ".repeat(loopTimes - 1) + "<#F5F5F5>- <gradient:#FFD700:#FFFACD><hover:show_text:'<yellow>" + nbt.getClass().getSimpleName() + "'>" + entry.getKey() + "</hover></gradient>: <#F5F5F5><hover:show_text:'<yellow>Copy'><click:suggest_command:'" + value.replace("'", "\\'") + "'>" + value + "</click></hover></#F5F5F5>");
                continue;
            }
            readableList.add("  ".repeat(loopTimes) + "<#F5F5F5><gradient:#FFD700:#FFFACD><hover:show_text:'<yellow>" + nbt.getClass().getSimpleName() + "'>" + entry.getKey() + "</hover></gradient>: <hover:show_text:'<yellow>Copy'><click:suggest_command:'" + value.replace("'", "\\'") + "'>" + value + "</click></hover></#F5F5F5>");
        }
    }
}

