/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.bukkit.plugin.command.feature;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.momirealms.craftengine.bukkit.block.BukkitBlockManager;
import net.momirealms.craftengine.bukkit.plugin.command.BukkitCommandFeature;
import net.momirealms.craftengine.core.block.ImmutableBlockState;
import net.momirealms.craftengine.core.plugin.CraftEngine;
import net.momirealms.craftengine.core.plugin.command.CraftEngineCommandManager;
import net.momirealms.craftengine.core.util.Key;
import net.momirealms.craftengine.libraries.adventure.text.Component;
import net.momirealms.craftengine.libraries.adventure.text.TextComponent;
import net.momirealms.craftengine.libraries.adventure.text.event.HoverEvent;
import net.momirealms.craftengine.libraries.adventure.text.event.HoverEventSource;
import net.momirealms.craftengine.libraries.adventure.text.format.NamedTextColor;
import net.momirealms.craftengine.libraries.adventure.text.format.TextColor;
import net.momirealms.craftengine.libraries.cloud.Command;
import net.momirealms.craftengine.libraries.cloud.CommandManager;
import net.momirealms.craftengine.libraries.cloud.context.CommandContext;
import net.momirealms.craftengine.libraries.cloud.context.CommandInput;
import net.momirealms.craftengine.libraries.cloud.parser.standard.StringParser;
import net.momirealms.craftengine.libraries.cloud.suggestion.Suggestion;
import net.momirealms.craftengine.libraries.cloud.suggestion.SuggestionProvider;
import org.bukkit.command.CommandSender;
import org.checkerframework.checker.nullness.qual.NonNull;

public class DebugRealStateUsageCommand
extends BukkitCommandFeature<CommandSender> {
    public DebugRealStateUsageCommand(CraftEngineCommandManager<CommandSender> commandManager, CraftEngine plugin) {
        super(commandManager, plugin);
    }

    @Override
    public Command.Builder<? extends CommandSender> assembleCommand(CommandManager<CommandSender> manager, Command.Builder<CommandSender> builder) {
        return builder.required("id", StringParser.stringComponent((StringParser.StringMode)StringParser.StringMode.GREEDY_FLAG_YIELDING).suggestionProvider((SuggestionProvider)new SuggestionProvider<Object>(){

            public @NonNull CompletableFuture<? extends @NonNull Iterable<? extends @NonNull Suggestion>> suggestionsFuture(@NonNull CommandContext<Object> context, @NonNull CommandInput input) {
                return CompletableFuture.completedFuture(DebugRealStateUsageCommand.this.plugin().blockManager().blockAppearanceArranger().keySet().stream().map(it -> Suggestion.suggestion((String)it.toString())).toList());
            }
        })).handler(context -> {
            String data = (String)context.get("id");
            BukkitBlockManager blockManager = this.plugin().blockManager();
            Key baseBlockId = Key.of(data);
            List<Integer> reals = blockManager.realBlockArranger().get(baseBlockId);
            if (reals == null) {
                return;
            }
            int i = 0;
            TextComponent block = Component.text((String)(String.valueOf(baseBlockId) + ": "));
            this.plugin().senderFactory().wrap((CommandSender)context.sender()).sendMessage((Component)block);
            ArrayList<Component> batch = new ArrayList<Component>(100);
            for (int real : reals) {
                ImmutableBlockState state = blockManager.getImmutableBlockStateUnsafe(real);
                if (state.isEmpty()) {
                    hover = Component.text((String)("craftengine:" + baseBlockId.value() + "_" + i)).color((TextColor)NamedTextColor.GREEN);
                    batch.add(((TextComponent)Component.text((String)"|").color((TextColor)NamedTextColor.GREEN)).hoverEvent((HoverEventSource)HoverEvent.showText((Component)hover)));
                } else {
                    hover = Component.text((String)("craftengine:" + baseBlockId.value() + "_" + i)).color((TextColor)NamedTextColor.RED);
                    hover = hover.append((Component)Component.newline()).append(Component.text((String)state.toString()).color((TextColor)NamedTextColor.GRAY));
                    batch.add(((TextComponent)Component.text((String)"|").color((TextColor)NamedTextColor.RED)).hoverEvent((HoverEventSource)HoverEvent.showText((Component)hover)));
                }
                ++i;
                if (batch.size() != 100) continue;
                this.plugin().senderFactory().wrap((CommandSender)context.sender()).sendMessage(Component.text((String)"").children(batch));
                batch.clear();
            }
            if (!batch.isEmpty()) {
                this.plugin().senderFactory().wrap((CommandSender)context.sender()).sendMessage(Component.text((String)"").children(batch));
                batch.clear();
            }
        });
    }

    @Override
    public String getFeatureID() {
        return "debug_real_state_usage";
    }
}

