/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.bukkit.plugin.command.feature;

import java.util.Collection;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.momirealms.craftengine.bukkit.item.BukkitItemManager;
import net.momirealms.craftengine.bukkit.plugin.command.BukkitCommandFeature;
import net.momirealms.craftengine.bukkit.util.PlayerUtils;
import net.momirealms.craftengine.core.plugin.CraftEngine;
import net.momirealms.craftengine.core.plugin.command.CraftEngineCommandManager;
import net.momirealms.craftengine.core.plugin.command.FlagKeys;
import net.momirealms.craftengine.core.plugin.locale.MessageConstants;
import net.momirealms.craftengine.core.util.Key;
import net.momirealms.craftengine.libraries.adventure.text.Component;
import net.momirealms.craftengine.libraries.cloud.Command;
import net.momirealms.craftengine.libraries.cloud.CommandManager;
import net.momirealms.craftengine.libraries.cloud.bukkit.data.MultiplePlayerSelector;
import net.momirealms.craftengine.libraries.cloud.bukkit.parser.NamespacedKeyParser;
import net.momirealms.craftengine.libraries.cloud.bukkit.parser.selector.MultiplePlayerSelectorParser;
import net.momirealms.craftengine.libraries.cloud.context.CommandContext;
import net.momirealms.craftengine.libraries.cloud.context.CommandInput;
import net.momirealms.craftengine.libraries.cloud.parser.standard.IntegerParser;
import net.momirealms.craftengine.libraries.cloud.suggestion.Suggestion;
import net.momirealms.craftengine.libraries.cloud.suggestion.SuggestionProvider;
import org.bukkit.NamespacedKey;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.checkerframework.checker.nullness.qual.NonNull;

public class GiveItemCommand
extends BukkitCommandFeature<CommandSender> {
    public GiveItemCommand(CraftEngineCommandManager<CommandSender> commandManager, CraftEngine plugin) {
        super(commandManager, plugin);
    }

    @Override
    public Command.Builder<? extends CommandSender> assembleCommand(CommandManager<CommandSender> manager, Command.Builder<CommandSender> builder) {
        return builder.flag(FlagKeys.SILENT_FLAG).flag(FlagKeys.TO_INVENTORY_FLAG).required("player", MultiplePlayerSelectorParser.multiplePlayerSelectorParser((boolean)true)).required("id", NamespacedKeyParser.namespacedKeyComponent().suggestionProvider((SuggestionProvider)new SuggestionProvider<Object>(){

            public @NonNull CompletableFuture<? extends @NonNull Iterable<? extends @NonNull Suggestion>> suggestionsFuture(@NonNull CommandContext<Object> context, @NonNull CommandInput input) {
                return CompletableFuture.completedFuture(GiveItemCommand.this.plugin().itemManager().cachedSuggestions());
            }
        })).optional("amount", IntegerParser.integerParser((int)1, (int)6400)).handler(context -> {
            MultiplePlayerSelector selector = (MultiplePlayerSelector)context.get("player");
            int amount = (Integer)context.getOrDefault("amount", (Object)1);
            boolean toInv = context.flags().hasFlag("to-inventory");
            NamespacedKey namespacedKey = (NamespacedKey)context.get("id");
            Key key = Key.of(namespacedKey.namespace(), namespacedKey.value());
            Optional optionalItem = BukkitItemManager.instance().getCustomItem(key);
            if (optionalItem.isEmpty()) {
                this.handleFeedback(context, MessageConstants.COMMAND_ITEM_GIVE_FAILURE_NOT_EXIST, new Component[]{Component.text((String)key.toString())});
                return;
            }
            Collection players = selector.values();
            for (Player player : players) {
                int perStackSize;
                ItemStack builtItem = (ItemStack)optionalItem.get().buildItemStack(this.plugin().adapt(player));
                if (builtItem == null) {
                    return;
                }
                int maxStack = builtItem.getMaxStackSize();
                for (int amountToGive = amount; amountToGive > 0; amountToGive -= perStackSize) {
                    perStackSize = Math.min(maxStack, amountToGive);
                    ItemStack more = builtItem.clone();
                    more.setAmount(perStackSize);
                    if (toInv) {
                        PlayerUtils.putItemsToInventory((Inventory)player.getInventory(), more, more.getAmount());
                        continue;
                    }
                    PlayerUtils.dropItem(player, more, false, true, false);
                }
            }
            if (players.size() == 1) {
                this.handleFeedback(context, MessageConstants.COMMAND_ITEM_GIVE_SUCCESS_SINGLE, new Component[]{Component.text((int)amount), Component.text((String)key.toString()), Component.text((String)((Player)players.iterator().next()).getName())});
            } else if (players.size() > 1) {
                this.handleFeedback(context, MessageConstants.COMMAND_ITEM_GIVE_SUCCESS_MULTIPLE, new Component[]{Component.text((int)amount), Component.text((String)key.toString()), Component.text((int)players.size())});
            }
        });
    }

    @Override
    public String getFeatureID() {
        return "give_item";
    }
}

