/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.bukkit.plugin.injector;

import com.google.common.collect.ImmutableList;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.concurrent.Callable;
import java.util.function.BiConsumer;
import net.momirealms.craftengine.bukkit.block.BukkitBlockShape;
import net.momirealms.craftengine.bukkit.nms.FastNMS;
import net.momirealms.craftengine.bukkit.plugin.injector.BlockStateGenerator;
import net.momirealms.craftengine.bukkit.plugin.reflection.minecraft.CoreReflections;
import net.momirealms.craftengine.bukkit.plugin.reflection.minecraft.MBlocks;
import net.momirealms.craftengine.bukkit.util.NoteBlockChainUpdateUtils;
import net.momirealms.craftengine.core.block.BlockBehavior;
import net.momirealms.craftengine.core.block.BlockKeys;
import net.momirealms.craftengine.core.block.BlockShape;
import net.momirealms.craftengine.core.block.DelegatingBlock;
import net.momirealms.craftengine.core.block.behavior.EmptyBlockBehavior;
import net.momirealms.craftengine.core.plugin.CraftEngine;
import net.momirealms.craftengine.core.plugin.config.Config;
import net.momirealms.craftengine.core.util.Key;
import net.momirealms.craftengine.core.util.ObjectHolder;
import net.momirealms.craftengine.core.util.VersionHelper;
import net.momirealms.craftengine.libraries.bytebuddy.ByteBuddy;
import net.momirealms.craftengine.libraries.bytebuddy.ClassFileVersion;
import net.momirealms.craftengine.libraries.bytebuddy.description.modifier.ModifierContributor;
import net.momirealms.craftengine.libraries.bytebuddy.description.modifier.Visibility;
import net.momirealms.craftengine.libraries.bytebuddy.dynamic.DynamicType;
import net.momirealms.craftengine.libraries.bytebuddy.dynamic.scaffold.subclass.ConstructorStrategy;
import net.momirealms.craftengine.libraries.bytebuddy.implementation.FieldAccessor;
import net.momirealms.craftengine.libraries.bytebuddy.implementation.Implementation;
import net.momirealms.craftengine.libraries.bytebuddy.implementation.MethodDelegation;
import net.momirealms.craftengine.libraries.bytebuddy.implementation.bind.annotation.AllArguments;
import net.momirealms.craftengine.libraries.bytebuddy.implementation.bind.annotation.RuntimeType;
import net.momirealms.craftengine.libraries.bytebuddy.implementation.bind.annotation.SuperCall;
import net.momirealms.craftengine.libraries.bytebuddy.implementation.bind.annotation.This;
import net.momirealms.craftengine.libraries.bytebuddy.matcher.ElementMatcher;
import net.momirealms.craftengine.libraries.bytebuddy.matcher.ElementMatchers;

public final class BlockGenerator {
    private static final BukkitBlockShape STONE_SHAPE = new BukkitBlockShape(MBlocks.STONE$defaultState, MBlocks.STONE$defaultState);
    private static MethodHandle constructor$CraftEngineBlock;
    private static Field field$CraftEngineBlock$behavior;
    private static Field field$CraftEngineBlock$shape;
    private static Field field$CraftEngineBlock$isNoteBlock;
    private static Field field$CraftEngineBlock$isTripwire;

    public static void init() throws ReflectiveOperationException {
        ByteBuddy byteBuddy = new ByteBuddy(ClassFileVersion.JAVA_V17);
        String packageWithName = BlockGenerator.class.getName();
        String generatedClassName = packageWithName.substring(0, packageWithName.lastIndexOf(46)) + ".CraftEngineBlock";
        DynamicType.Builder.MethodDefinition.ReceiverTypeDefinition builder = byteBuddy.subclass(CoreReflections.clazz$Block, (ConstructorStrategy)ConstructorStrategy.Default.IMITATE_SUPER_CLASS_OPENING).name(generatedClassName).defineField("behaviorHolder", ObjectHolder.class, new ModifierContributor.ForField[]{Visibility.PUBLIC}).defineField("shapeHolder", ObjectHolder.class, new ModifierContributor.ForField[]{Visibility.PUBLIC}).defineField("isClientSideNoteBlock", Boolean.TYPE, new ModifierContributor.ForField[]{Visibility.PUBLIC}).defineField("isClientSideTripwire", Boolean.TYPE, new ModifierContributor.ForField[]{Visibility.PUBLIC}).implement(new Type[]{DelegatingBlock.class}).implement(new Type[]{CoreReflections.clazz$Fallable}).implement(new Type[]{CoreReflections.clazz$BonemealableBlock}).implement(new Type[]{CoreReflections.clazz$SimpleWaterloggedBlock}).method((ElementMatcher)ElementMatchers.named((String)"behaviorDelegate")).intercept((Implementation)FieldAccessor.ofField((String)"behaviorHolder")).method((ElementMatcher)ElementMatchers.named((String)"shapeDelegate")).intercept((Implementation)FieldAccessor.ofField((String)"shapeHolder")).method((ElementMatcher)ElementMatchers.named((String)"isNoteBlock")).intercept((Implementation)FieldAccessor.ofField((String)"isClientSideNoteBlock")).method((ElementMatcher)ElementMatchers.named((String)"isTripwire")).intercept((Implementation)FieldAccessor.ofField((String)"isClientSideTripwire")).method((ElementMatcher)ElementMatchers.is((Method)CoreReflections.method$BlockBehaviour$getShape)).intercept((Implementation)MethodDelegation.to((Object)GetShapeInterceptor.INSTANCE)).method((ElementMatcher)ElementMatchers.is((Method)CoreReflections.method$BlockBehaviour$getCollisionShape)).intercept((Implementation)MethodDelegation.to((Object)GetCollisionShapeInterceptor.INSTANCE)).method((ElementMatcher)ElementMatchers.is((Method)CoreReflections.method$BlockBehaviour$getBlockSupportShape)).intercept((Implementation)MethodDelegation.to((Object)GetSupportShapeInterceptor.INSTANCE)).method((ElementMatcher)ElementMatchers.is((Method)CoreReflections.method$BlockBehaviour$isPathFindable)).intercept((Implementation)MethodDelegation.to((Object)IsPathFindableInterceptor.INSTANCE)).method((ElementMatcher)ElementMatchers.is((Method)CoreReflections.method$BlockBehaviour$mirror)).intercept((Implementation)MethodDelegation.to((Object)MirrorInterceptor.INSTANCE)).method((ElementMatcher)ElementMatchers.is((Method)CoreReflections.method$BlockBehaviour$rotate)).intercept((Implementation)MethodDelegation.to((Object)RotateInterceptor.INSTANCE)).method((ElementMatcher)ElementMatchers.is((Method)CoreReflections.method$BlockBehaviour$tick)).intercept((Implementation)MethodDelegation.to((Object)TickInterceptor.INSTANCE)).method((ElementMatcher)ElementMatchers.is((Method)CoreReflections.method$BonemealableBlock$isValidBonemealTarget)).intercept((Implementation)MethodDelegation.to((Object)IsValidBoneMealTargetInterceptor.INSTANCE)).method((ElementMatcher)ElementMatchers.is((Method)CoreReflections.method$BonemealableBlock$isBonemealSuccess)).intercept((Implementation)MethodDelegation.to((Object)IsBoneMealSuccessInterceptor.INSTANCE)).method((ElementMatcher)ElementMatchers.is((Method)CoreReflections.method$BonemealableBlock$performBonemeal)).intercept((Implementation)MethodDelegation.to((Object)PerformBoneMealInterceptor.INSTANCE)).method((ElementMatcher)ElementMatchers.is((Method)CoreReflections.method$BlockBehaviour$randomTick)).intercept((Implementation)MethodDelegation.to((Object)RandomTickInterceptor.INSTANCE)).method((ElementMatcher)ElementMatchers.takesArguments((int)5).and((ElementMatcher)ElementMatchers.takesArgument((int)0, CoreReflections.clazz$BlockState)).and((ElementMatcher)ElementMatchers.takesArgument((int)1, CoreReflections.clazz$Level)).and((ElementMatcher)ElementMatchers.takesArgument((int)2, CoreReflections.clazz$BlockPos)).and((ElementMatcher)ElementMatchers.takesArgument((int)3, CoreReflections.clazz$BlockState)).and((ElementMatcher)ElementMatchers.takesArgument((int)4, Boolean.TYPE)).and((ElementMatcher)ElementMatchers.named((String)"onPlace").or((ElementMatcher)ElementMatchers.named((String)"a")))).intercept((Implementation)MethodDelegation.to((Object)OnPlaceInterceptor.INSTANCE)).method((ElementMatcher)ElementMatchers.takesArguments((int)3).and((ElementMatcher)ElementMatchers.takesArgument((int)0, CoreReflections.clazz$Level)).and((ElementMatcher)ElementMatchers.takesArgument((int)1, CoreReflections.clazz$BlockPos)).and((ElementMatcher)ElementMatchers.takesArgument((int)2, CoreReflections.clazz$FallingBlockEntity))).intercept((Implementation)MethodDelegation.to((Object)OnBrokenAfterFallInterceptor.INSTANCE)).method((ElementMatcher)ElementMatchers.takesArguments((int)5).and((ElementMatcher)ElementMatchers.takesArgument((int)0, CoreReflections.clazz$Level)).and((ElementMatcher)ElementMatchers.takesArgument((int)1, CoreReflections.clazz$BlockPos)).and((ElementMatcher)ElementMatchers.takesArgument((int)2, CoreReflections.clazz$BlockState)).and((ElementMatcher)ElementMatchers.takesArgument((int)3, CoreReflections.clazz$BlockState)).and((ElementMatcher)ElementMatchers.takesArgument((int)4, CoreReflections.clazz$FallingBlockEntity))).intercept((Implementation)MethodDelegation.to((Object)OnLandInterceptor.INSTANCE)).method((ElementMatcher)ElementMatchers.takesArguments((int)3).and((ElementMatcher)ElementMatchers.takesArgument((int)0, CoreReflections.clazz$BlockState)).and((ElementMatcher)ElementMatchers.takesArgument((int)1, CoreReflections.clazz$LevelReader)).and((ElementMatcher)ElementMatchers.takesArgument((int)2, CoreReflections.clazz$BlockPos))).intercept((Implementation)MethodDelegation.to((Object)CanSurviveInterceptor.INSTANCE)).method((ElementMatcher)ElementMatchers.returns(CoreReflections.clazz$BlockState).and((ElementMatcher)ElementMatchers.takesArgument((int)0, CoreReflections.clazz$BlockState)).and((ElementMatcher)ElementMatchers.takesArgument((int)1, CoreReflections.clazz$LevelReader).or((ElementMatcher)ElementMatchers.takesArgument((int)1, CoreReflections.clazz$Direction))).and((ElementMatcher)ElementMatchers.named((String)"updateShape").or((ElementMatcher)ElementMatchers.named((String)"a")))).intercept((Implementation)MethodDelegation.to((Object)UpdateShapeInterceptor.INSTANCE)).method((ElementMatcher)ElementMatchers.returns(Void.TYPE).and((ElementMatcher)ElementMatchers.takesArgument((int)0, CoreReflections.clazz$BlockState)).and((ElementMatcher)ElementMatchers.takesArgument((int)1, CoreReflections.clazz$ServerLevel)).and((ElementMatcher)ElementMatchers.takesArgument((int)2, CoreReflections.clazz$BlockPos)).and((ElementMatcher)ElementMatchers.takesArgument((int)3, CoreReflections.clazz$Explosion)).and((ElementMatcher)ElementMatchers.takesArgument((int)4, BiConsumer.class))).intercept((Implementation)MethodDelegation.to((Object)OnExplosionHitInterceptor.INSTANCE)).method((ElementMatcher)ElementMatchers.is((Method)CoreReflections.method$BlockBehaviour$neighborChanged)).intercept((Implementation)MethodDelegation.to((Object)NeighborChangedInterceptor.INSTANCE)).method((ElementMatcher)ElementMatchers.is((Method)CoreReflections.method$SimpleWaterloggedBlock$pickupBlock)).intercept((Implementation)MethodDelegation.to((Object)PickUpBlockInterceptor.INSTANCE)).method((ElementMatcher)ElementMatchers.is((Method)CoreReflections.method$SimpleWaterloggedBlock$placeLiquid)).intercept((Implementation)MethodDelegation.to((Object)PlaceLiquidInterceptor.INSTANCE)).method((ElementMatcher)ElementMatchers.is((Method)CoreReflections.method$SimpleWaterloggedBlock$canPlaceLiquid)).intercept((Implementation)MethodDelegation.to((Object)CanPlaceLiquidInterceptor.INSTANCE)).method((ElementMatcher)ElementMatchers.is((Method)CoreReflections.method$BlockBehaviour$entityInside)).intercept((Implementation)MethodDelegation.to((Object)EntityInsideInterceptor.INSTANCE)).method((ElementMatcher)ElementMatchers.is((Method)CoreReflections.method$BlockBehaviour$getSignal)).intercept((Implementation)MethodDelegation.to((Object)GetSignalInterceptor.INSTANCE)).method((ElementMatcher)ElementMatchers.is((Method)CoreReflections.method$BlockBehaviour$getDirectSignal)).intercept((Implementation)MethodDelegation.to((Object)GetDirectSignalInterceptor.INSTANCE)).method((ElementMatcher)ElementMatchers.is((Method)CoreReflections.method$BlockBehaviour$isSignalSource)).intercept((Implementation)MethodDelegation.to((Object)IsSignalSourceInterceptor.INSTANCE));
        if (CoreReflections.method$BlockBehaviour$affectNeighborsAfterRemoval != null) {
            builder.method((ElementMatcher)ElementMatchers.is((Method)CoreReflections.method$BlockBehaviour$affectNeighborsAfterRemoval)).intercept((Implementation)MethodDelegation.to((Object)AffectNeighborsAfterRemovalInterceptor.INSTANCE));
        }
        Class clazz$CraftEngineBlock = builder.make().load(BlockGenerator.class.getClassLoader()).getLoaded();
        constructor$CraftEngineBlock = MethodHandles.publicLookup().in(clazz$CraftEngineBlock).findConstructor(clazz$CraftEngineBlock, MethodType.methodType(Void.TYPE, CoreReflections.clazz$BlockBehaviour$Properties)).asType(MethodType.methodType(CoreReflections.clazz$Block, CoreReflections.clazz$BlockBehaviour$Properties));
        field$CraftEngineBlock$behavior = clazz$CraftEngineBlock.getField("behaviorHolder");
        field$CraftEngineBlock$shape = clazz$CraftEngineBlock.getField("shapeHolder");
        field$CraftEngineBlock$isNoteBlock = clazz$CraftEngineBlock.getField("isClientSideNoteBlock");
        field$CraftEngineBlock$isTripwire = clazz$CraftEngineBlock.getField("isClientSideTripwire");
    }

    public static Object generateBlock(Key replacedBlock, Object ownerBlock, Object properties) throws Throwable {
        Object ownerProperties = CoreReflections.field$BlockBehaviour$properties.get(ownerBlock);
        CoreReflections.field$BlockBehaviour$Properties$hasCollision.set(properties, CoreReflections.field$BlockBehaviour$Properties$hasCollision.get(ownerProperties));
        ObjectHolder<EmptyBlockBehavior> behaviorHolder = new ObjectHolder<EmptyBlockBehavior>(EmptyBlockBehavior.INSTANCE);
        ObjectHolder<BukkitBlockShape> shapeHolder = new ObjectHolder<BukkitBlockShape>(STONE_SHAPE);
        Object newBlockInstance = constructor$CraftEngineBlock.invoke(properties);
        field$CraftEngineBlock$behavior.set(newBlockInstance, behaviorHolder);
        field$CraftEngineBlock$shape.set(newBlockInstance, shapeHolder);
        field$CraftEngineBlock$isNoteBlock.set(newBlockInstance, replacedBlock.equals(BlockKeys.NOTE_BLOCK));
        field$CraftEngineBlock$isTripwire.set(newBlockInstance, replacedBlock.equals(BlockKeys.TRIPWIRE));
        Object stateDefinitionBuilder = CoreReflections.constructor$StateDefinition$Builder.newInstance(newBlockInstance);
        Object[] objectArray = new Object[2];
        objectArray[0] = FastNMS.INSTANCE::method$Block$defaultState;
        objectArray[1] = BlockStateGenerator.instance$StateDefinition$Factory;
        Object stateDefinition = CoreReflections.method$StateDefinition$Builder$create.invoke(stateDefinitionBuilder, objectArray);
        CoreReflections.field$Block$StateDefinition.set(newBlockInstance, stateDefinition);
        CoreReflections.field$Block$defaultBlockState.set(newBlockInstance, ((ImmutableList)CoreReflections.field$StateDefinition$states.get(stateDefinition)).getFirst());
        return newBlockInstance;
    }

    public static class GetShapeInterceptor {
        public static final GetShapeInterceptor INSTANCE = new GetShapeInterceptor();

        @RuntimeType
        public Object intercept(@This Object thisObj, @AllArguments Object[] args, @SuperCall Callable<Object> superMethod) throws Exception {
            ObjectHolder<BlockShape> holder = ((DelegatingBlock)thisObj).shapeDelegate();
            try {
                return holder.value().getShape(thisObj, args);
            }
            catch (Exception e) {
                CraftEngine.instance().logger().severe("Failed to run getShape", e);
                return superMethod.call();
            }
        }
    }

    public static class GetCollisionShapeInterceptor {
        public static final GetCollisionShapeInterceptor INSTANCE = new GetCollisionShapeInterceptor();

        @RuntimeType
        public Object intercept(@This Object thisObj, @AllArguments Object[] args, @SuperCall Callable<Object> superMethod) throws Exception {
            ObjectHolder<BlockShape> holder = ((DelegatingBlock)thisObj).shapeDelegate();
            try {
                return holder.value().getCollisionShape(thisObj, args);
            }
            catch (Exception e) {
                CraftEngine.instance().logger().severe("Failed to run getCollisionShape", e);
                return superMethod.call();
            }
        }
    }

    public static class GetSupportShapeInterceptor {
        public static final GetSupportShapeInterceptor INSTANCE = new GetSupportShapeInterceptor();

        @RuntimeType
        public Object intercept(@This Object thisObj, @AllArguments Object[] args, @SuperCall Callable<Object> superMethod) throws Exception {
            ObjectHolder<BlockShape> holder = ((DelegatingBlock)thisObj).shapeDelegate();
            try {
                return holder.value().getSupportShape(thisObj, args);
            }
            catch (Exception e) {
                CraftEngine.instance().logger().severe("Failed to run getSupportShape", e);
                return superMethod.call();
            }
        }
    }

    public static class IsPathFindableInterceptor {
        public static final IsPathFindableInterceptor INSTANCE = new IsPathFindableInterceptor();

        @RuntimeType
        public Object intercept(@This Object thisObj, @AllArguments Object[] args, @SuperCall Callable<Object> superMethod) throws Exception {
            ObjectHolder<BlockBehavior> holder = ((DelegatingBlock)thisObj).behaviorDelegate();
            try {
                return holder.value().isPathFindable(thisObj, args, superMethod);
            }
            catch (Exception e) {
                CraftEngine.instance().logger().severe("Failed to run isPathFindable", e);
                return superMethod.call();
            }
        }
    }

    public static class MirrorInterceptor {
        public static final MirrorInterceptor INSTANCE = new MirrorInterceptor();

        @RuntimeType
        public Object intercept(@This Object thisObj, @AllArguments Object[] args, @SuperCall Callable<Object> superMethod) throws Exception {
            ObjectHolder<BlockBehavior> holder = ((DelegatingBlock)thisObj).behaviorDelegate();
            try {
                return holder.value().mirror(thisObj, args, superMethod);
            }
            catch (Exception e) {
                CraftEngine.instance().logger().severe("Failed to run mirror", e);
                return superMethod.call();
            }
        }
    }

    public static class RotateInterceptor {
        public static final RotateInterceptor INSTANCE = new RotateInterceptor();

        @RuntimeType
        public Object intercept(@This Object thisObj, @AllArguments Object[] args, @SuperCall Callable<Object> superMethod) throws Exception {
            ObjectHolder<BlockBehavior> holder = ((DelegatingBlock)thisObj).behaviorDelegate();
            try {
                return holder.value().rotate(thisObj, args, superMethod);
            }
            catch (Exception e) {
                CraftEngine.instance().logger().severe("Failed to run rotate", e);
                return superMethod.call();
            }
        }
    }

    public static class TickInterceptor {
        public static final TickInterceptor INSTANCE = new TickInterceptor();

        @RuntimeType
        public void intercept(@This Object thisObj, @AllArguments Object[] args, @SuperCall Callable<Object> superMethod) {
            ObjectHolder<BlockBehavior> holder = ((DelegatingBlock)thisObj).behaviorDelegate();
            try {
                holder.value().tick(thisObj, args, superMethod);
            }
            catch (Exception e) {
                CraftEngine.instance().logger().severe("Failed to run tick", e);
            }
        }
    }

    public static class IsValidBoneMealTargetInterceptor {
        public static final IsValidBoneMealTargetInterceptor INSTANCE = new IsValidBoneMealTargetInterceptor();

        @RuntimeType
        public boolean intercept(@This Object thisObj, @AllArguments Object[] args) {
            ObjectHolder<BlockBehavior> holder = ((DelegatingBlock)thisObj).behaviorDelegate();
            try {
                return holder.value().isValidBoneMealTarget(thisObj, args);
            }
            catch (Exception e) {
                CraftEngine.instance().logger().severe("Failed to run isValidBoneMealTarget", e);
                return true;
            }
        }
    }

    public static class IsBoneMealSuccessInterceptor {
        public static final IsBoneMealSuccessInterceptor INSTANCE = new IsBoneMealSuccessInterceptor();

        @RuntimeType
        public boolean intercept(@This Object thisObj, @AllArguments Object[] args) {
            ObjectHolder<BlockBehavior> holder = ((DelegatingBlock)thisObj).behaviorDelegate();
            try {
                return holder.value().isBoneMealSuccess(thisObj, args);
            }
            catch (Exception e) {
                CraftEngine.instance().logger().severe("Failed to run isBoneMealSuccess", e);
                return true;
            }
        }
    }

    public static class PerformBoneMealInterceptor {
        public static final PerformBoneMealInterceptor INSTANCE = new PerformBoneMealInterceptor();

        @RuntimeType
        public void intercept(@This Object thisObj, @AllArguments Object[] args) {
            ObjectHolder<BlockBehavior> holder = ((DelegatingBlock)thisObj).behaviorDelegate();
            try {
                holder.value().performBoneMeal(thisObj, args);
            }
            catch (Exception e) {
                CraftEngine.instance().logger().severe("Failed to run performBoneMeal", e);
            }
        }
    }

    public static class RandomTickInterceptor {
        public static final RandomTickInterceptor INSTANCE = new RandomTickInterceptor();

        @RuntimeType
        public void intercept(@This Object thisObj, @AllArguments Object[] args, @SuperCall Callable<Object> superMethod) {
            ObjectHolder<BlockBehavior> holder = ((DelegatingBlock)thisObj).behaviorDelegate();
            try {
                holder.value().randomTick(thisObj, args, superMethod);
            }
            catch (Exception e) {
                CraftEngine.instance().logger().severe("Failed to run randomTick", e);
            }
        }
    }

    public static class OnPlaceInterceptor {
        public static final OnPlaceInterceptor INSTANCE = new OnPlaceInterceptor();

        @RuntimeType
        public void intercept(@This Object thisObj, @AllArguments Object[] args, @SuperCall Callable<Object> superMethod) {
            ObjectHolder<BlockBehavior> holder = ((DelegatingBlock)thisObj).behaviorDelegate();
            try {
                holder.value().onPlace(thisObj, args, superMethod);
            }
            catch (Exception e) {
                CraftEngine.instance().logger().severe("Failed to run onPlace", e);
            }
        }
    }

    public static class OnBrokenAfterFallInterceptor {
        public static final OnBrokenAfterFallInterceptor INSTANCE = new OnBrokenAfterFallInterceptor();

        @RuntimeType
        public void intercept(@This Object thisObj, @AllArguments Object[] args) {
            ObjectHolder<BlockBehavior> holder = ((DelegatingBlock)thisObj).behaviorDelegate();
            try {
                holder.value().onBrokenAfterFall(thisObj, args);
            }
            catch (Exception e) {
                CraftEngine.instance().logger().severe("Failed to run onBrokenAfterFall", e);
            }
        }
    }

    public static class OnLandInterceptor {
        public static final OnLandInterceptor INSTANCE = new OnLandInterceptor();

        @RuntimeType
        public void intercept(@This Object thisObj, @AllArguments Object[] args) {
            ObjectHolder<BlockBehavior> holder = ((DelegatingBlock)thisObj).behaviorDelegate();
            try {
                holder.value().onLand(thisObj, args);
            }
            catch (Exception e) {
                CraftEngine.instance().logger().severe("Failed to run onLand", e);
            }
        }
    }

    public static class CanSurviveInterceptor {
        public static final CanSurviveInterceptor INSTANCE = new CanSurviveInterceptor();

        @RuntimeType
        public boolean intercept(@This Object thisObj, @AllArguments Object[] args, @SuperCall Callable<Object> superMethod) {
            ObjectHolder<BlockBehavior> holder = ((DelegatingBlock)thisObj).behaviorDelegate();
            try {
                return holder.value().canSurvive(thisObj, args, superMethod);
            }
            catch (Exception e) {
                CraftEngine.instance().logger().severe("Failed to run canSurvive", e);
                return true;
            }
        }
    }

    public static class UpdateShapeInterceptor {
        public static final UpdateShapeInterceptor INSTANCE = new UpdateShapeInterceptor();
        public static final int levelIndex = VersionHelper.isOrAbove1_21_2() ? 1 : 3;
        public static final int directionIndex = VersionHelper.isOrAbove1_21_2() ? 4 : 1;
        public static final int posIndex = VersionHelper.isOrAbove1_21_2() ? 3 : 4;

        @RuntimeType
        public Object intercept(@This Object thisObj, @AllArguments Object[] args, @SuperCall Callable<Object> superMethod) {
            ObjectHolder<BlockBehavior> holder = ((DelegatingBlock)thisObj).behaviorDelegate();
            DelegatingBlock indicator = (DelegatingBlock)thisObj;
            if (indicator.isNoteBlock()) {
                if (CoreReflections.clazz$ServerLevel.isInstance(args[levelIndex])) {
                    UpdateShapeInterceptor.startNoteBlockChain(args);
                }
            } else if (!indicator.isTripwire() || CoreReflections.clazz$ServerLevel.isInstance(args[posIndex])) {
                // empty if block
            }
            try {
                return holder.value().updateShape(thisObj, args, superMethod);
            }
            catch (Exception e) {
                CraftEngine.instance().logger().severe("Failed to run updateShape", e);
                return args[0];
            }
        }

        private static void startNoteBlockChain(Object[] args) {
            Object direction = args[directionIndex];
            Object serverLevel = args[levelIndex];
            Object blockPos = args[posIndex];
            if (direction == CoreReflections.instance$Direction$DOWN) {
                Object chunkSource = FastNMS.INSTANCE.method$ServerLevel$getChunkSource(serverLevel);
                FastNMS.INSTANCE.method$ServerChunkCache$blockChanged(chunkSource, blockPos);
                NoteBlockChainUpdateUtils.noteBlockChainUpdate(serverLevel, chunkSource, CoreReflections.instance$Direction$UP, blockPos, Config.maxNoteBlockChainUpdate());
            } else if (direction == CoreReflections.instance$Direction$UP) {
                Object chunkSource = FastNMS.INSTANCE.method$ServerLevel$getChunkSource(serverLevel);
                FastNMS.INSTANCE.method$ServerChunkCache$blockChanged(chunkSource, blockPos);
                NoteBlockChainUpdateUtils.noteBlockChainUpdate(serverLevel, chunkSource, CoreReflections.instance$Direction$DOWN, blockPos, Config.maxNoteBlockChainUpdate());
            }
        }
    }

    public static class OnExplosionHitInterceptor {
        public static final OnExplosionHitInterceptor INSTANCE = new OnExplosionHitInterceptor();

        @RuntimeType
        public void intercept(@This Object thisObj, @AllArguments Object[] args, @SuperCall Callable<Object> superMethod) {
            ObjectHolder<BlockBehavior> holder = ((DelegatingBlock)thisObj).behaviorDelegate();
            try {
                holder.value().onExplosionHit(thisObj, args, superMethod);
            }
            catch (Exception e) {
                CraftEngine.instance().logger().severe("Failed to run onExplosionHit", e);
            }
        }
    }

    public static class NeighborChangedInterceptor {
        public static final NeighborChangedInterceptor INSTANCE = new NeighborChangedInterceptor();

        @RuntimeType
        public void intercept(@This Object thisObj, @AllArguments Object[] args, @SuperCall Callable<Object> superMethod) {
            ObjectHolder<BlockBehavior> holder = ((DelegatingBlock)thisObj).behaviorDelegate();
            try {
                holder.value().neighborChanged(thisObj, args, superMethod);
            }
            catch (Exception e) {
                CraftEngine.instance().logger().severe("Failed to run neighborChanged", e);
            }
        }
    }

    public static class PickUpBlockInterceptor {
        public static final PickUpBlockInterceptor INSTANCE = new PickUpBlockInterceptor();

        @RuntimeType
        public Object intercept(@This Object thisObj, @AllArguments Object[] args, @SuperCall Callable<Object> superMethod) {
            ObjectHolder<BlockBehavior> holder = ((DelegatingBlock)thisObj).behaviorDelegate();
            try {
                return holder.value().pickupBlock(thisObj, args, () -> CoreReflections.instance$ItemStack$EMPTY);
            }
            catch (Exception e) {
                CraftEngine.instance().logger().severe("Failed to run pickupBlock", e);
                return CoreReflections.instance$ItemStack$EMPTY;
            }
        }
    }

    public static class PlaceLiquidInterceptor {
        public static final PlaceLiquidInterceptor INSTANCE = new PlaceLiquidInterceptor();

        @RuntimeType
        public boolean intercept(@This Object thisObj, @AllArguments Object[] args, @SuperCall Callable<Object> superMethod) throws Exception {
            ObjectHolder<BlockBehavior> holder = ((DelegatingBlock)thisObj).behaviorDelegate();
            try {
                return holder.value().placeLiquid(thisObj, args, superMethod);
            }
            catch (Exception e) {
                CraftEngine.instance().logger().severe("Failed to run placeLiquid", e);
                return false;
            }
        }
    }

    public static class CanPlaceLiquidInterceptor {
        public static final CanPlaceLiquidInterceptor INSTANCE = new CanPlaceLiquidInterceptor();

        @RuntimeType
        public boolean intercept(@This Object thisObj, @AllArguments Object[] args, @SuperCall Callable<Object> superMethod) {
            ObjectHolder<BlockBehavior> holder = ((DelegatingBlock)thisObj).behaviorDelegate();
            try {
                return holder.value().canPlaceLiquid(thisObj, args, superMethod);
            }
            catch (Exception e) {
                CraftEngine.instance().logger().severe("Failed to run canPlaceLiquid", e);
                return false;
            }
        }
    }

    public static class EntityInsideInterceptor {
        public static final EntityInsideInterceptor INSTANCE = new EntityInsideInterceptor();

        @RuntimeType
        public void intercept(@This Object thisObj, @AllArguments Object[] args, @SuperCall Callable<Object> superMethod) {
            ObjectHolder<BlockBehavior> holder = ((DelegatingBlock)thisObj).behaviorDelegate();
            try {
                holder.value().entityInside(thisObj, args, superMethod);
            }
            catch (Exception e) {
                CraftEngine.instance().logger().severe("Failed to run entityInside", e);
            }
        }
    }

    public static class GetSignalInterceptor {
        public static final GetSignalInterceptor INSTANCE = new GetSignalInterceptor();

        @RuntimeType
        public int intercept(@This Object thisObj, @AllArguments Object[] args, @SuperCall Callable<Object> superMethod) {
            ObjectHolder<BlockBehavior> holder = ((DelegatingBlock)thisObj).behaviorDelegate();
            try {
                return holder.value().getSignal(thisObj, args, superMethod);
            }
            catch (Exception e) {
                CraftEngine.instance().logger().severe("Failed to run getSignal", e);
                return 0;
            }
        }
    }

    public static class GetDirectSignalInterceptor {
        public static final GetDirectSignalInterceptor INSTANCE = new GetDirectSignalInterceptor();

        @RuntimeType
        public int intercept(@This Object thisObj, @AllArguments Object[] args, @SuperCall Callable<Object> superMethod) {
            ObjectHolder<BlockBehavior> holder = ((DelegatingBlock)thisObj).behaviorDelegate();
            try {
                return holder.value().getDirectSignal(thisObj, args, superMethod);
            }
            catch (Exception e) {
                CraftEngine.instance().logger().severe("Failed to run getDirectSignal", e);
                return 0;
            }
        }
    }

    public static class IsSignalSourceInterceptor {
        public static final IsSignalSourceInterceptor INSTANCE = new IsSignalSourceInterceptor();

        @RuntimeType
        public boolean intercept(@This Object thisObj, @AllArguments Object[] args, @SuperCall Callable<Object> superMethod) {
            ObjectHolder<BlockBehavior> holder = ((DelegatingBlock)thisObj).behaviorDelegate();
            try {
                return holder.value().isSignalSource(thisObj, args, superMethod);
            }
            catch (Exception e) {
                CraftEngine.instance().logger().severe("Failed to run isSignalSource", e);
                return false;
            }
        }
    }

    public static class AffectNeighborsAfterRemovalInterceptor {
        public static final AffectNeighborsAfterRemovalInterceptor INSTANCE = new AffectNeighborsAfterRemovalInterceptor();

        @RuntimeType
        public void intercept(@This Object thisObj, @AllArguments Object[] args, @SuperCall Callable<Object> superMethod) {
            ObjectHolder<BlockBehavior> holder = ((DelegatingBlock)thisObj).behaviorDelegate();
            try {
                holder.value().affectNeighborsAfterRemoval(thisObj, args, superMethod);
            }
            catch (Exception e) {
                CraftEngine.instance().logger().severe("Failed to run affectNeighborsAfterRemoval", e);
            }
        }
    }
}

