/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.bukkit.plugin.network;

import com.google.gson.JsonObject;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOutboundInvoker;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.MessageToMessageDecoder;
import io.netty.handler.codec.MessageToMessageEncoder;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import net.momirealms.craftengine.bukkit.nms.FastNMS;
import net.momirealms.craftengine.bukkit.plugin.BukkitCraftEngine;
import net.momirealms.craftengine.bukkit.plugin.network.CancelPacketException;
import net.momirealms.craftengine.bukkit.plugin.network.PacketConsumers;
import net.momirealms.craftengine.bukkit.plugin.network.PacketIds;
import net.momirealms.craftengine.bukkit.plugin.network.id.PacketIdFinder;
import net.momirealms.craftengine.bukkit.plugin.network.id.PacketIds1_20;
import net.momirealms.craftengine.bukkit.plugin.network.id.PacketIds1_20_5;
import net.momirealms.craftengine.bukkit.plugin.reflection.minecraft.CoreReflections;
import net.momirealms.craftengine.bukkit.plugin.reflection.minecraft.LibraryReflections;
import net.momirealms.craftengine.bukkit.plugin.reflection.minecraft.NetworkReflections;
import net.momirealms.craftengine.bukkit.plugin.user.BukkitServerPlayer;
import net.momirealms.craftengine.bukkit.util.KeyUtils;
import net.momirealms.craftengine.core.entity.player.Player;
import net.momirealms.craftengine.core.plugin.CraftEngine;
import net.momirealms.craftengine.core.plugin.context.CooldownData;
import net.momirealms.craftengine.core.plugin.network.ByteBufPacketEvent;
import net.momirealms.craftengine.core.plugin.network.ConnectionState;
import net.momirealms.craftengine.core.plugin.network.NMSPacketEvent;
import net.momirealms.craftengine.core.plugin.network.NetWorkUser;
import net.momirealms.craftengine.core.plugin.network.NetworkManager;
import net.momirealms.craftengine.core.util.ExceptionUtils;
import net.momirealms.craftengine.core.util.FriendlyByteBuf;
import net.momirealms.craftengine.core.util.GsonHelper;
import net.momirealms.craftengine.core.util.ListMonitor;
import net.momirealms.craftengine.core.util.TriConsumer;
import net.momirealms.craftengine.core.util.VersionHelper;
import org.bukkit.Bukkit;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.messaging.PluginMessageListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BukkitNetworkManager
implements NetworkManager,
Listener,
PluginMessageListener {
    private static BukkitNetworkManager instance;
    private static final Map<Class<?>, TriConsumer<NetWorkUser, NMSPacketEvent, Object>> NMS_PACKET_HANDLERS;
    private static BiConsumer<NetWorkUser, ByteBufPacketEvent>[] S2C_BYTE_BUFFER_PACKET_HANDLERS;
    private static BiConsumer<NetWorkUser, ByteBufPacketEvent>[] C2S_BYTE_BUFFER_PACKET_HANDLERS;
    private final BiConsumer<ChannelHandler, Object> packetConsumer;
    private final BiConsumer<ChannelHandler, List<Object>> packetsConsumer;
    private final BiConsumer<Channel, Object> immediatePacketConsumer;
    private final BiConsumer<Channel, List<Object>> immediatePacketsConsumer;
    private final BukkitCraftEngine plugin;
    private final Map<ChannelPipeline, BukkitServerPlayer> users = new ConcurrentHashMap<ChannelPipeline, BukkitServerPlayer>();
    private final Map<UUID, BukkitServerPlayer> onlineUsers = new ConcurrentHashMap<UUID, BukkitServerPlayer>();
    private final HashSet<Channel> injectedChannels = new HashSet();
    private BukkitServerPlayer[] onlineUserArray = new BukkitServerPlayer[0];
    private final PacketIds packetIds;
    private static final String CONNECTION_HANDLER_NAME = "craftengine_connection_handler";
    private static final String SERVER_CHANNEL_HANDLER_NAME = "craftengine_server_channel_handler";
    private static final String PLAYER_CHANNEL_HANDLER_NAME = "craftengine_player_channel_handler";
    private static final String PACKET_ENCODER = "craftengine_encoder";
    private static final String PACKET_DECODER = "craftengine_decoder";
    private static boolean hasModelEngine;
    private static boolean hasViaVersion;

    private static void registerNMSPacketConsumer(TriConsumer<NetWorkUser, NMSPacketEvent, Object> function, @Nullable Class<?> packet) {
        if (packet == null) {
            return;
        }
        NMS_PACKET_HANDLERS.put(packet, function);
    }

    private static void registerS2CByteBufPacketConsumer(BiConsumer<NetWorkUser, ByteBufPacketEvent> function, int id) {
        if (id == -1) {
            return;
        }
        if (id < 0 || id >= S2C_BYTE_BUFFER_PACKET_HANDLERS.length) {
            throw new IllegalArgumentException("Invalid packet id: " + id);
        }
        BukkitNetworkManager.S2C_BYTE_BUFFER_PACKET_HANDLERS[id] = function;
    }

    private static void registerC2SByteBufPacketConsumer(BiConsumer<NetWorkUser, ByteBufPacketEvent> function, int id) {
        if (id == -1) {
            return;
        }
        if (id < 0 || id >= C2S_BYTE_BUFFER_PACKET_HANDLERS.length) {
            throw new IllegalArgumentException("Invalid packet id: " + id);
        }
        BukkitNetworkManager.C2S_BYTE_BUFFER_PACKET_HANDLERS[id] = function;
    }

    public BukkitNetworkManager(BukkitCraftEngine plugin) {
        instance = this;
        S2C_BYTE_BUFFER_PACKET_HANDLERS = new BiConsumer[PacketIdFinder.maxS2CPacketId()];
        C2S_BYTE_BUFFER_PACKET_HANDLERS = new BiConsumer[PacketIdFinder.maxC2SPacketId()];
        Arrays.fill(S2C_BYTE_BUFFER_PACKET_HANDLERS, Handlers.DO_NOTHING);
        Arrays.fill(C2S_BYTE_BUFFER_PACKET_HANDLERS, Handlers.DO_NOTHING);
        hasModelEngine = Bukkit.getPluginManager().getPlugin("ModelEngine") != null;
        hasViaVersion = Bukkit.getPluginManager().getPlugin("ViaVersion") != null;
        this.plugin = plugin;
        this.packetIds = VersionHelper.isOrAbove1_20_5() ? new PacketIds1_20_5() : new PacketIds1_20();
        this.registerPacketHandlers();
        this.packetConsumer = FastNMS.INSTANCE::method$Connection$send;
        this.packetsConsumer = (connection, packets) -> {
            Object bundle = FastNMS.INSTANCE.constructor$ClientboundBundlePacket((List<Object>)packets);
            this.packetConsumer.accept((ChannelHandler)connection, bundle);
        };
        this.immediatePacketConsumer = ChannelOutboundInvoker::writeAndFlush;
        this.immediatePacketsConsumer = (channel, packets) -> {
            Object bundle = FastNMS.INSTANCE.constructor$ClientboundBundlePacket((List<Object>)packets);
            this.immediatePacketConsumer.accept((Channel)channel, bundle);
        };
        this.plugin.javaPlugin().getServer().getMessenger().registerIncomingPluginChannel((Plugin)this.plugin.javaPlugin(), "craftengine:payload", (PluginMessageListener)this);
        this.plugin.javaPlugin().getServer().getMessenger().registerOutgoingPluginChannel((Plugin)this.plugin.javaPlugin(), "craftengine:payload");
        this.plugin.javaPlugin().getServer().getMessenger().registerIncomingPluginChannel((Plugin)this.plugin.javaPlugin(), "vv:proxy_details", (PluginMessageListener)this);
        try {
            Object server = CoreReflections.method$MinecraftServer$getServer.invoke(null, new Object[0]);
            Object serverConnection = CoreReflections.field$MinecraftServer$connection.get(server);
            List channels = (List)CoreReflections.field$ServerConnectionListener$channels.get(serverConnection);
            ListMonitor<ChannelFuture> monitor = new ListMonitor<ChannelFuture>(channels, future -> {
                Channel channel = future.channel();
                this.injectServerChannel(channel);
                this.injectedChannels.add(channel);
            }, object -> {});
            CoreReflections.field$ServerConnectionListener$channels.set(serverConnection, monitor);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("Failed to init server connection", e);
        }
    }

    private void registerPacketHandlers() {
        BukkitNetworkManager.registerNMSPacketConsumer(PacketConsumers.PLAYER_INFO_UPDATE, NetworkReflections.clazz$ClientboundPlayerInfoUpdatePacket);
        BukkitNetworkManager.registerNMSPacketConsumer(PacketConsumers.PLAYER_ACTION, NetworkReflections.clazz$ServerboundPlayerActionPacket);
        BukkitNetworkManager.registerNMSPacketConsumer(PacketConsumers.SWING_HAND, NetworkReflections.clazz$ServerboundSwingPacket);
        BukkitNetworkManager.registerNMSPacketConsumer(PacketConsumers.HELLO_C2S, NetworkReflections.clazz$ServerboundHelloPacket);
        BukkitNetworkManager.registerNMSPacketConsumer(PacketConsumers.USE_ITEM_ON, NetworkReflections.clazz$ServerboundUseItemOnPacket);
        BukkitNetworkManager.registerNMSPacketConsumer(PacketConsumers.PICK_ITEM_FROM_BLOCK, NetworkReflections.clazz$ServerboundPickItemFromBlockPacket);
        BukkitNetworkManager.registerNMSPacketConsumer(PacketConsumers.SET_CREATIVE_SLOT, NetworkReflections.clazz$ServerboundSetCreativeModeSlotPacket);
        BukkitNetworkManager.registerNMSPacketConsumer(PacketConsumers.LOGIN, NetworkReflections.clazz$ClientboundLoginPacket);
        BukkitNetworkManager.registerNMSPacketConsumer(PacketConsumers.RESPAWN, NetworkReflections.clazz$ClientboundRespawnPacket);
        BukkitNetworkManager.registerNMSPacketConsumer(PacketConsumers.SYNC_ENTITY_POSITION, NetworkReflections.clazz$ClientboundEntityPositionSyncPacket);
        BukkitNetworkManager.registerNMSPacketConsumer(PacketConsumers.PICK_ITEM_FROM_ENTITY, NetworkReflections.clazz$ServerboundPickItemFromEntityPacket);
        BukkitNetworkManager.registerNMSPacketConsumer(PacketConsumers.RENAME_ITEM, NetworkReflections.clazz$ServerboundRenameItemPacket);
        BukkitNetworkManager.registerNMSPacketConsumer(PacketConsumers.SIGN_UPDATE, NetworkReflections.clazz$ServerboundSignUpdatePacket);
        BukkitNetworkManager.registerNMSPacketConsumer(PacketConsumers.EDIT_BOOK, NetworkReflections.clazz$ServerboundEditBookPacket);
        BukkitNetworkManager.registerNMSPacketConsumer(PacketConsumers.CUSTOM_PAYLOAD, NetworkReflections.clazz$ServerboundCustomPayloadPacket);
        BukkitNetworkManager.registerNMSPacketConsumer(PacketConsumers.RESOURCE_PACK_PUSH, NetworkReflections.clazz$ClientboundResourcePackPushPacket);
        BukkitNetworkManager.registerNMSPacketConsumer(PacketConsumers.HANDSHAKE_C2S, NetworkReflections.clazz$ClientIntentionPacket);
        BukkitNetworkManager.registerNMSPacketConsumer(PacketConsumers.LOGIN_ACKNOWLEDGED, NetworkReflections.clazz$ServerboundLoginAcknowledgedPacket);
        BukkitNetworkManager.registerNMSPacketConsumer(PacketConsumers.RESOURCE_PACK_RESPONSE, NetworkReflections.clazz$ServerboundResourcePackPacket);
        BukkitNetworkManager.registerNMSPacketConsumer(PacketConsumers.ENTITY_EVENT, NetworkReflections.clazz$ClientboundEntityEventPacket);
        BukkitNetworkManager.registerNMSPacketConsumer(PacketConsumers.MOVE_POS_AND_ROTATE_ENTITY, NetworkReflections.clazz$ClientboundMoveEntityPacket$PosRot);
        BukkitNetworkManager.registerNMSPacketConsumer(PacketConsumers.MOVE_POS_ENTITY, NetworkReflections.clazz$ClientboundMoveEntityPacket$Pos);
        BukkitNetworkManager.registerNMSPacketConsumer(PacketConsumers.ROTATE_HEAD, NetworkReflections.clazz$ClientboundRotateHeadPacket);
        BukkitNetworkManager.registerNMSPacketConsumer(PacketConsumers.SET_ENTITY_MOTION, NetworkReflections.clazz$ClientboundSetEntityMotionPacket);
        BukkitNetworkManager.registerS2CByteBufPacketConsumer(PacketConsumers.LEVEL_CHUNK_WITH_LIGHT, this.packetIds.clientboundLevelChunkWithLightPacket());
        BukkitNetworkManager.registerS2CByteBufPacketConsumer(PacketConsumers.SECTION_BLOCK_UPDATE, this.packetIds.clientboundSectionBlocksUpdatePacket());
        BukkitNetworkManager.registerS2CByteBufPacketConsumer(PacketConsumers.BLOCK_UPDATE, this.packetIds.clientboundBlockUpdatePacket());
        BukkitNetworkManager.registerS2CByteBufPacketConsumer(VersionHelper.isOrAbove1_21_4() ? PacketConsumers.LEVEL_PARTICLE_1_21_4 : (VersionHelper.isOrAbove1_20_5() ? PacketConsumers.LEVEL_PARTICLE_1_20_5 : PacketConsumers.LEVEL_PARTICLE_1_20), this.packetIds.clientboundLevelParticlesPacket());
        BukkitNetworkManager.registerS2CByteBufPacketConsumer(PacketConsumers.LEVEL_EVENT, this.packetIds.clientboundLevelEventPacket());
        BukkitNetworkManager.registerS2CByteBufPacketConsumer(VersionHelper.isOrAbove1_20_3() ? PacketConsumers.OPEN_SCREEN_1_20_3 : PacketConsumers.OPEN_SCREEN_1_20, this.packetIds.clientboundOpenScreenPacket());
        BukkitNetworkManager.registerS2CByteBufPacketConsumer(VersionHelper.isOrAbove1_20_3() ? PacketConsumers.SET_TITLE_TEXT_1_20_3 : PacketConsumers.SET_TITLE_TEXT_1_20, this.packetIds.clientboundSetTitleTextPacket());
        BukkitNetworkManager.registerS2CByteBufPacketConsumer(VersionHelper.isOrAbove1_20_3() ? PacketConsumers.SET_SUBTITLE_TEXT_1_20_3 : PacketConsumers.SET_SUBTITLE_TEXT_1_20, this.packetIds.clientboundSetSubtitleTextPacket());
        BukkitNetworkManager.registerS2CByteBufPacketConsumer(VersionHelper.isOrAbove1_20_3() ? PacketConsumers.SET_ACTIONBAR_TEXT_1_20_3 : PacketConsumers.SET_ACTIONBAR_TEXT_1_20, this.packetIds.clientboundSetActionBarTextPacket());
        BukkitNetworkManager.registerS2CByteBufPacketConsumer(VersionHelper.isOrAbove1_20_3() ? PacketConsumers.BOSS_EVENT_1_20_3 : PacketConsumers.BOSS_EVENT_1_20, this.packetIds.clientboundBossEventPacket());
        BukkitNetworkManager.registerS2CByteBufPacketConsumer(VersionHelper.isOrAbove1_20_3() ? PacketConsumers.SYSTEM_CHAT_1_20_3 : PacketConsumers.SYSTEM_CHAT_1_20, this.packetIds.clientboundSystemChatPacket());
        BukkitNetworkManager.registerS2CByteBufPacketConsumer(VersionHelper.isOrAbove1_20_3() ? PacketConsumers.TAB_LIST_1_20_3 : PacketConsumers.TAB_LIST_1_20, this.packetIds.clientboundTabListPacket());
        BukkitNetworkManager.registerS2CByteBufPacketConsumer(VersionHelper.isOrAbove1_20_3() ? PacketConsumers.TEAM_1_20_3 : PacketConsumers.TEAM_1_20, this.packetIds.clientboundSetPlayerTeamPacket());
        BukkitNetworkManager.registerS2CByteBufPacketConsumer(VersionHelper.isOrAbove1_20_3() ? PacketConsumers.SET_OBJECTIVE_1_20_3 : PacketConsumers.SET_OBJECTIVE_1_20, this.packetIds.clientboundSetObjectivePacket());
        BukkitNetworkManager.registerS2CByteBufPacketConsumer(PacketConsumers.SET_SCORE_1_20_3, VersionHelper.isOrAbove1_20_3() ? this.packetIds.clientboundSetScorePacket() : -1);
        BukkitNetworkManager.registerS2CByteBufPacketConsumer(PacketConsumers.REMOVE_ENTITY, this.packetIds.clientboundRemoveEntitiesPacket());
        BukkitNetworkManager.registerS2CByteBufPacketConsumer(PacketConsumers.ADD_ENTITY, this.packetIds.clientboundAddEntityPacket());
        BukkitNetworkManager.registerS2CByteBufPacketConsumer(PacketConsumers.SOUND, this.packetIds.clientboundSoundPacket());
        BukkitNetworkManager.registerS2CByteBufPacketConsumer(PacketConsumers.SET_ENTITY_DATA, this.packetIds.clientboundSetEntityDataPacket());
        BukkitNetworkManager.registerS2CByteBufPacketConsumer(PacketConsumers.CONTAINER_SET_CONTENT, this.packetIds.clientboundContainerSetContentPacket());
        BukkitNetworkManager.registerS2CByteBufPacketConsumer(PacketConsumers.CONTAINER_SET_SLOT, this.packetIds.clientboundContainerSetSlotPacket());
        BukkitNetworkManager.registerS2CByteBufPacketConsumer(PacketConsumers.SET_CURSOR_ITEM, this.packetIds.clientboundSetCursorItemPacket());
        BukkitNetworkManager.registerS2CByteBufPacketConsumer(PacketConsumers.SET_EQUIPMENT, this.packetIds.clientboundSetEquipmentPacket());
        BukkitNetworkManager.registerS2CByteBufPacketConsumer(PacketConsumers.SET_PLAYER_INVENTORY_1_21_2, this.packetIds.clientboundSetPlayerInventoryPacket());
        BukkitNetworkManager.registerC2SByteBufPacketConsumer(PacketConsumers.SET_CREATIVE_MODE_SLOT, this.packetIds.serverboundSetCreativeModeSlotPacket());
        BukkitNetworkManager.registerC2SByteBufPacketConsumer(PacketConsumers.CONTAINER_CLICK_1_20, this.packetIds.serverboundContainerClickPacket());
        BukkitNetworkManager.registerC2SByteBufPacketConsumer(PacketConsumers.INTERACT_ENTITY, this.packetIds.serverboundInteractPacket());
    }

    public static BukkitNetworkManager instance() {
        return instance;
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerJoin(PlayerJoinEvent event) {
        org.bukkit.entity.Player player = event.getPlayer();
        BukkitServerPlayer user = (BukkitServerPlayer)this.getUser(player);
        if (user != null) {
            user.setPlayer(player);
            this.onlineUsers.put(player.getUniqueId(), user);
            this.resetUserArray();
            if (VersionHelper.isFolia()) {
                player.getScheduler().runAtFixedRate((Plugin)this.plugin.javaPlugin(), t -> user.tick(), () -> this.plugin.debug(() -> "Player " + player.getName() + "'s entity scheduler is retired"), 1L, 1L);
            }
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerQuit(PlayerQuitEvent event) {
        org.bukkit.entity.Player player = event.getPlayer();
        BukkitServerPlayer serverPlayer = this.onlineUsers.remove(player.getUniqueId());
        if (serverPlayer != null) {
            this.resetUserArray();
            this.saveCooldown(player, serverPlayer.cooldown());
        }
    }

    private void saveCooldown(org.bukkit.entity.Player player, CooldownData cd) {
        if (cd != null && player != null) {
            try {
                byte[] data = CooldownData.toBytes(cd);
                player.getPersistentDataContainer().set(KeyUtils.toNamespacedKey(CooldownData.COOLDOWN_KEY), PersistentDataType.BYTE_ARRAY, (Object)data);
            }
            catch (IOException e) {
                player.getPersistentDataContainer().remove(KeyUtils.toNamespacedKey(CooldownData.COOLDOWN_KEY));
                this.plugin.logger().warn("Failed to save cooldown for player " + player.getName(), e);
            }
        }
    }

    private void resetUserArray() {
        this.onlineUserArray = this.onlineUsers.values().toArray(new BukkitServerPlayer[0]);
    }

    public BukkitServerPlayer[] onlineUsers() {
        return this.onlineUserArray;
    }

    public void onPluginMessageReceived(@NotNull String channel, @NotNull org.bukkit.entity.Player player, byte @NotNull [] message) {
        BukkitServerPlayer user;
        if (channel.equals("vv:proxy_details") && (user = this.plugin.adapt(player)) != null) {
            JsonObject payload = (JsonObject)GsonHelper.get().fromJson(new String(message), JsonObject.class);
            int version = payload.get("version").getAsInt();
            user.setProtocolVersion(version);
        }
    }

    @Override
    public void init() {
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin.javaPlugin());
    }

    @Override
    public void disable() {
        HandlerList.unregisterAll((Listener)this);
        for (Channel channel : this.injectedChannels) {
            this.uninjectServerChannel(channel);
        }
        for (org.bukkit.entity.Player player : Bukkit.getOnlinePlayers()) {
            this.handleDisconnection(this.getChannel(player));
        }
        this.injectedChannels.clear();
    }

    @Override
    public void setUser(Channel channel, NetWorkUser user) {
        ChannelPipeline pipeline = channel.pipeline();
        this.users.put(pipeline, (BukkitServerPlayer)user);
    }

    @Override
    public NetWorkUser getUser(Channel channel) {
        ChannelPipeline pipeline = channel.pipeline();
        return this.users.get(pipeline);
    }

    @Override
    public NetWorkUser removeUser(Channel channel) {
        ChannelPipeline pipeline = channel.pipeline();
        return this.users.remove(pipeline);
    }

    @Override
    public Channel getChannel(Player player) {
        return this.getChannel((org.bukkit.entity.Player)player.platformPlayer());
    }

    public NetWorkUser getUser(org.bukkit.entity.Player player) {
        return this.getUser(this.getChannel(player));
    }

    public NetWorkUser getOnlineUser(org.bukkit.entity.Player player) {
        return this.onlineUsers.get(player.getUniqueId());
    }

    public Channel getChannel(org.bukkit.entity.Player player) {
        return FastNMS.INSTANCE.field$Connection$channel(FastNMS.INSTANCE.field$ServerGamePacketListenerImpl$connection(FastNMS.INSTANCE.field$Player$connection(FastNMS.INSTANCE.method$CraftPlayer$getHandle(player))));
    }

    @Override
    public void sendPacket(@NotNull NetWorkUser player, Object packet, boolean immediately) {
        if (immediately) {
            this.immediatePacketConsumer.accept(player.nettyChannel(), packet);
        } else {
            this.packetConsumer.accept(player.connection(), packet);
        }
    }

    @Override
    public void sendPackets(@NotNull NetWorkUser player, List<Object> packet, boolean immediately) {
        if (immediately) {
            this.immediatePacketsConsumer.accept(player.nettyChannel(), packet);
        } else {
            this.packetsConsumer.accept(player.connection(), packet);
        }
    }

    public static boolean hasModelEngine() {
        return hasModelEngine;
    }

    public static boolean hasViaVersion() {
        return hasViaVersion;
    }

    public void simulatePacket(@NotNull NetWorkUser player, Object packet) {
        Channel channel = player.nettyChannel();
        if (channel.isOpen()) {
            List handlerNames = channel.pipeline().names();
            if (handlerNames.contains("via-encoder")) {
                channel.pipeline().context("via-decoder").fireChannelRead(packet);
            } else if (handlerNames.contains("ps_decoder_transformer")) {
                channel.pipeline().context("ps_decoder_transformer").fireChannelRead(packet);
            } else if (handlerNames.contains("decompress")) {
                channel.pipeline().context("decompress").fireChannelRead(packet);
            } else if (handlerNames.contains("decrypt")) {
                channel.pipeline().context("decrypt").fireChannelRead(packet);
            } else {
                channel.pipeline().context("splitter").fireChannelRead(packet);
            }
        } else {
            ((ByteBuf)packet).release();
        }
    }

    private void injectServerChannel(Channel serverChannel) {
        ChannelPipeline pipeline = serverChannel.pipeline();
        ChannelHandler connectionHandler = pipeline.get(CONNECTION_HANDLER_NAME);
        if (connectionHandler != null) {
            pipeline.remove(CONNECTION_HANDLER_NAME);
        }
        if (pipeline.get("SpigotNettyServerChannelHandler#0") != null) {
            pipeline.addAfter("SpigotNettyServerChannelHandler#0", CONNECTION_HANDLER_NAME, (ChannelHandler)new ServerChannelHandler());
        } else if (pipeline.get("floodgate-init") != null) {
            pipeline.addAfter("floodgate-init", CONNECTION_HANDLER_NAME, (ChannelHandler)new ServerChannelHandler());
        } else if (pipeline.get("MinecraftPipeline#0") != null) {
            pipeline.addAfter("MinecraftPipeline#0", CONNECTION_HANDLER_NAME, (ChannelHandler)new ServerChannelHandler());
        } else {
            pipeline.addFirst(CONNECTION_HANDLER_NAME, (ChannelHandler)new ServerChannelHandler());
        }
        for (org.bukkit.entity.Player player : Bukkit.getOnlinePlayers()) {
            Channel channel = this.getChannel(player);
            NetWorkUser user = this.getUser(player);
            if (user != null) continue;
            user = new BukkitServerPlayer(this.plugin, channel);
            ((BukkitServerPlayer)user).setPlayer(player);
            this.injectChannel(channel, ConnectionState.PLAY);
        }
    }

    private void uninjectServerChannel(Channel channel) {
        if (channel.pipeline().get(CONNECTION_HANDLER_NAME) != null) {
            channel.pipeline().remove(CONNECTION_HANDLER_NAME);
        }
    }

    public void handleDisconnection(Channel channel) {
        NetWorkUser user = this.removeUser(channel);
        if (user == null) {
            return;
        }
        if (channel.pipeline().get(PLAYER_CHANNEL_HANDLER_NAME) != null) {
            channel.pipeline().remove(PLAYER_CHANNEL_HANDLER_NAME);
        }
        if (channel.pipeline().get(PACKET_ENCODER) != null) {
            channel.pipeline().remove(PACKET_ENCODER);
        }
        if (channel.pipeline().get(PACKET_DECODER) != null) {
            channel.pipeline().remove(PACKET_DECODER);
        }
    }

    public void injectChannel(Channel channel, ConnectionState state) {
        if (BukkitNetworkManager.isFakeChannel(channel)) {
            return;
        }
        BukkitServerPlayer user = new BukkitServerPlayer(this.plugin, channel);
        if (channel.pipeline().get("splitter") == null) {
            channel.close();
            return;
        }
        ChannelPipeline pipeline = channel.pipeline();
        if (pipeline.get(PACKET_ENCODER) != null) {
            pipeline.remove(PACKET_ENCODER);
        }
        if (pipeline.get(PACKET_DECODER) != null) {
            pipeline.remove(PACKET_DECODER);
        }
        for (Map.Entry entry : pipeline.toMap().entrySet()) {
            if (!NetworkReflections.clazz$Connection.isAssignableFrom(((ChannelHandler)entry.getValue()).getClass())) continue;
            pipeline.addBefore((String)entry.getKey(), PLAYER_CHANNEL_HANDLER_NAME, (ChannelHandler)new PluginChannelHandler(user));
            break;
        }
        String decoderName = pipeline.names().contains("inbound_config") ? "inbound_config" : "decoder";
        pipeline.addBefore(decoderName, PACKET_DECODER, (ChannelHandler)new PluginChannelDecoder(user));
        String encoderName = pipeline.names().contains("outbound_config") ? "outbound_config" : "encoder";
        pipeline.addBefore(encoderName, PACKET_ENCODER, (ChannelHandler)new PluginChannelEncoder(user));
        channel.closeFuture().addListener((GenericFutureListener)((ChannelFutureListener)future -> this.handleDisconnection(user.nettyChannel())));
        this.setUser(channel, user);
    }

    public static boolean isFakeChannel(Object channel) {
        return channel.getClass().getSimpleName().equals("FakeChannel") || channel.getClass().getSimpleName().equals("SpoofedChannel");
    }

    private void onNMSPacketReceive(NetWorkUser user, NMSPacketEvent event, Object packet) {
        this.handleNMSPacket(user, event, packet);
    }

    private void onNMSPacketSend(NetWorkUser player, NMSPacketEvent event, Object packet) {
        if (NetworkReflections.clazz$ClientboundBundlePacket.isInstance(packet)) {
            Iterable<Object> packets = FastNMS.INSTANCE.method$ClientboundBundlePacket$subPackets(packet);
            for (Object p : packets) {
                this.onNMSPacketSend(player, event, p);
            }
        } else {
            this.handleNMSPacket(player, event, packet);
        }
    }

    protected void handleNMSPacket(NetWorkUser user, NMSPacketEvent event, Object packet) {
        Optional.ofNullable(NMS_PACKET_HANDLERS.get(packet.getClass())).ifPresent(function -> function.accept(user, event, packet));
    }

    protected void handleS2CByteBufPacket(NetWorkUser user, ByteBufPacketEvent event) {
        int packetID = event.packetID();
        Optional.ofNullable(S2C_BYTE_BUFFER_PACKET_HANDLERS[packetID]).ifPresent(function -> function.accept(user, event));
    }

    protected void handleC2SByteBufPacket(NetWorkUser user, ByteBufPacketEvent event) {
        int packetID = event.packetID();
        Optional.ofNullable(C2S_BYTE_BUFFER_PACKET_HANDLERS[packetID]).ifPresent(function -> function.accept(user, event));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compress(ChannelHandlerContext ctx, ByteBuf input) {
        ChannelHandler compressor = ctx.pipeline().get("compress");
        ByteBuf temp = ctx.alloc().buffer();
        try {
            if (compressor != null) {
                BukkitNetworkManager.callEncode(compressor, ctx, input, temp);
            }
        }
        finally {
            input.clear().writeBytes(temp);
            temp.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decompress(ChannelHandlerContext ctx, ByteBuf input, ByteBuf output) {
        ChannelHandler decompressor = ctx.pipeline().get("decompress");
        if (decompressor != null) {
            ByteBuf temp = (ByteBuf)BukkitNetworkManager.callDecode(decompressor, ctx, input).get(0);
            try {
                output.clear().writeBytes(temp);
            }
            finally {
                temp.release();
            }
        }
    }

    private static void callEncode(Object encoder, ChannelHandlerContext ctx, ByteBuf msg, ByteBuf output) {
        try {
            LibraryReflections.method$messageToByteEncoder$encode.invoke(encoder, ctx, msg, output);
        }
        catch (ReflectiveOperationException e) {
            CraftEngine.instance().logger().warn("Failed to call encode", e);
        }
    }

    public static List<Object> callDecode(Object decoder, Object ctx, Object input) {
        ArrayList<Object> output = new ArrayList<Object>();
        try {
            LibraryReflections.method$byteToMessageDecoder$decode.invoke(decoder, ctx, input, output);
        }
        catch (ReflectiveOperationException e) {
            CraftEngine.instance().logger().warn("Failed to call decode", e);
        }
        return output;
    }

    static {
        NMS_PACKET_HANDLERS = new HashMap();
    }

    @FunctionalInterface
    public static interface Handlers
    extends BiConsumer<NetWorkUser, ByteBufPacketEvent> {
        public static final Handlers DO_NOTHING = Handlers.doNothing();

        public static Handlers doNothing() {
            return (user, byteBufPacketEvent) -> {};
        }
    }

    public class ServerChannelHandler
    extends ChannelInboundHandlerAdapter {
        public void channelRead(@NotNull ChannelHandlerContext context, @NotNull Object c) throws Exception {
            Channel channel = (Channel)c;
            channel.pipeline().addLast(BukkitNetworkManager.SERVER_CHANNEL_HANDLER_NAME, (ChannelHandler)new PreChannelInitializer());
            super.channelRead(context, c);
        }
    }

    public class PluginChannelHandler
    extends ChannelDuplexHandler {
        private final NetWorkUser player;

        public PluginChannelHandler(NetWorkUser player) {
            this.player = player;
        }

        public void write(ChannelHandlerContext context, Object packet, ChannelPromise channelPromise) throws Exception {
            try {
                NMSPacketEvent event = new NMSPacketEvent(packet);
                BukkitNetworkManager.this.onNMSPacketSend(this.player, event, packet);
                if (event.isCancelled()) {
                    return;
                }
                if (event.isUsingNewPacket()) {
                    super.write(context, event.optionalNewPacket(), channelPromise);
                } else {
                    super.write(context, packet, channelPromise);
                }
            }
            catch (Throwable e) {
                BukkitNetworkManager.this.plugin.logger().severe("An error occurred when reading packets. Packet class: " + String.valueOf(packet.getClass()), e);
                super.write(context, packet, channelPromise);
            }
        }

        public void channelRead(@NotNull ChannelHandlerContext context, @NotNull Object packet) throws Exception {
            NMSPacketEvent event = new NMSPacketEvent(packet);
            BukkitNetworkManager.this.onNMSPacketReceive(this.player, event, packet);
            if (event.isCancelled()) {
                return;
            }
            if (event.isUsingNewPacket()) {
                super.channelRead(context, event.optionalNewPacket());
            } else {
                super.channelRead(context, packet);
            }
        }
    }

    public class PluginChannelDecoder
    extends MessageToMessageDecoder<ByteBuf> {
        private final NetWorkUser player;
        public boolean relocated = false;

        public PluginChannelDecoder(NetWorkUser player) {
            this.player = player;
        }

        public PluginChannelDecoder(PluginChannelDecoder decoder) {
            this.player = decoder.player;
            this.relocated = decoder.relocated;
        }

        protected void decode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, List<Object> list) {
            this.onByteBufReceive(byteBuf);
            if (byteBuf.isReadable()) {
                list.add(byteBuf.retain());
            }
        }

        private void onByteBufReceive(ByteBuf buffer) {
            if (this.player.decoderState() != ConnectionState.PLAY) {
                return;
            }
            int size = buffer.readableBytes();
            if (size != 0) {
                FriendlyByteBuf buf = new FriendlyByteBuf(buffer);
                int preProcessIndex = buf.readerIndex();
                int packetId = buf.readVarInt();
                int preIndex = buf.readerIndex();
                try {
                    ByteBufPacketEvent event = new ByteBufPacketEvent(packetId, buf, preIndex);
                    BukkitNetworkManager.this.handleC2SByteBufPacket(this.player, event);
                    if (event.isCancelled()) {
                        buf.clear();
                    } else if (!event.changed()) {
                        buf.readerIndex(preProcessIndex);
                    }
                }
                catch (Throwable e) {
                    CraftEngine.instance().logger().warn("An error occurred when reading packet " + packetId, e);
                    buf.readerIndex(preProcessIndex);
                }
            }
        }
    }

    public class PluginChannelEncoder
    extends MessageToMessageEncoder<ByteBuf> {
        private final NetWorkUser player;
        private boolean handledCompression = false;

        public PluginChannelEncoder(NetWorkUser player) {
            this.player = player;
        }

        public PluginChannelEncoder(PluginChannelEncoder encoder) {
            this.player = encoder.player;
            this.handledCompression = encoder.handledCompression;
        }

        protected void encode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, List<Object> list) {
            boolean needCompression = !this.handledCompression && this.handleCompression(channelHandlerContext, byteBuf);
            this.onByteBufSend(byteBuf);
            if (needCompression) {
                BukkitNetworkManager.this.compress(channelHandlerContext, byteBuf);
            }
            if (!byteBuf.isReadable()) {
                throw CancelPacketException.INSTANCE;
            }
            list.add(byteBuf.retain());
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            if (ExceptionUtils.hasException(cause, CancelPacketException.INSTANCE)) {
                return;
            }
            super.exceptionCaught(ctx, cause);
        }

        private boolean handleCompression(ChannelHandlerContext ctx, ByteBuf buffer) {
            if (this.handledCompression) {
                return false;
            }
            int compressIndex = ctx.pipeline().names().indexOf("compress");
            if (compressIndex == -1) {
                return false;
            }
            this.handledCompression = true;
            int encoderIndex = ctx.pipeline().names().indexOf(BukkitNetworkManager.PACKET_ENCODER);
            if (encoderIndex == -1) {
                return false;
            }
            if (compressIndex > encoderIndex) {
                BukkitNetworkManager.this.decompress(ctx, buffer, buffer);
                PluginChannelDecoder decoder = (PluginChannelDecoder)ctx.pipeline().get(BukkitNetworkManager.PACKET_DECODER);
                if (decoder != null) {
                    if (decoder.relocated) {
                        return true;
                    }
                    decoder.relocated = true;
                }
                PluginChannelEncoder encoder = (PluginChannelEncoder)ctx.pipeline().remove(BukkitNetworkManager.PACKET_ENCODER);
                String encoderName = ctx.pipeline().names().contains("outbound_config") ? "outbound_config" : "encoder";
                ctx.pipeline().addBefore(encoderName, BukkitNetworkManager.PACKET_ENCODER, (ChannelHandler)new PluginChannelEncoder(encoder));
                decoder = (PluginChannelDecoder)ctx.pipeline().remove(BukkitNetworkManager.PACKET_DECODER);
                String decoderName = ctx.pipeline().names().contains("inbound_config") ? "inbound_config" : "decoder";
                ctx.pipeline().addBefore(decoderName, BukkitNetworkManager.PACKET_DECODER, (ChannelHandler)new PluginChannelDecoder(decoder));
                return true;
            }
            return false;
        }

        private void onByteBufSend(ByteBuf buffer) {
            if (this.player.encoderState() != ConnectionState.PLAY) {
                return;
            }
            int size = buffer.readableBytes();
            if (size != 0) {
                FriendlyByteBuf buf = new FriendlyByteBuf(buffer);
                int preProcessIndex = buf.readerIndex();
                int packetId = buf.readVarInt();
                int preIndex = buf.readerIndex();
                try {
                    ByteBufPacketEvent event = new ByteBufPacketEvent(packetId, buf, preIndex);
                    BukkitNetworkManager.this.handleS2CByteBufPacket(this.player, event);
                    if (event.isCancelled()) {
                        buf.clear();
                    } else if (!event.changed()) {
                        buf.readerIndex(preProcessIndex);
                    }
                }
                catch (Throwable e) {
                    CraftEngine.instance().logger().warn("An error occurred when writing packet " + packetId, e);
                    buf.readerIndex(preProcessIndex);
                }
            }
        }
    }

    public class PreChannelInitializer
    extends ChannelInboundHandlerAdapter {
        private static final InternalLogger logger = InternalLoggerFactory.getInstance(ChannelInitializer.class);

        public void channelRegistered(ChannelHandlerContext context) {
            try {
                BukkitNetworkManager.this.injectChannel(context.channel(), ConnectionState.HANDSHAKING);
            }
            catch (Throwable t) {
                this.exceptionCaught(context, t);
            }
            finally {
                ChannelPipeline pipeline = context.pipeline();
                if (pipeline.context((ChannelHandler)this) != null) {
                    pipeline.remove((ChannelHandler)this);
                }
            }
            context.pipeline().fireChannelRegistered();
        }

        public void exceptionCaught(ChannelHandlerContext context, Throwable t) {
            logger.warn("Failed to inject channel: " + String.valueOf(context.channel()), t);
            context.close();
        }
    }
}

