/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.bukkit.plugin.network.payload;

import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.momirealms.craftengine.core.util.FriendlyByteBuf;

public class NetWorkDataTypes<T> {
    private static final Map<Integer, NetWorkDataTypes<?>> id2NetWorkDataTypes = new HashMap();
    public static final NetWorkDataTypes<Integer> CLIENT_CUSTOM_BLOCK = new NetWorkDataTypes<Integer>(0, FriendlyByteBuf::readInt, FriendlyByteBuf::writeInt);
    public static final NetWorkDataTypes<Boolean> CANCEL_BLOCK_UPDATE = new NetWorkDataTypes<Boolean>(1, FriendlyByteBuf::readBoolean, FriendlyByteBuf::writeBoolean);
    private final int id;
    private final Function<FriendlyByteBuf, T> decoder;
    private final BiConsumer<FriendlyByteBuf, T> encoder;

    private static void register(NetWorkDataTypes<?> type) {
        id2NetWorkDataTypes.put(type.id, type);
    }

    public NetWorkDataTypes(int id, Function<FriendlyByteBuf, T> decoder, BiConsumer<FriendlyByteBuf, T> encoder) {
        this.id = id;
        this.decoder = decoder;
        this.encoder = encoder;
    }

    public T decode(FriendlyByteBuf buf) {
        return this.decoder.apply(buf);
    }

    public void encode(FriendlyByteBuf buf, T data) {
        this.encoder.accept(buf, (FriendlyByteBuf)((Object)data));
    }

    public int id() {
        return this.id;
    }

    public void writeType(FriendlyByteBuf buf) {
        buf.writeVarInt(this.id);
    }

    public static NetWorkDataTypes<?> readType(FriendlyByteBuf buf) {
        int id = buf.readVarInt();
        return id2NetWorkDataTypes.get(id);
    }

    public <R> NetWorkDataTypes<R> as(Class<R> clazz) {
        return this;
    }

    static {
        NetWorkDataTypes.register(CLIENT_CUSTOM_BLOCK);
        NetWorkDataTypes.register(CANCEL_BLOCK_UPDATE);
    }
}

