/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.bukkit.plugin.user;

import com.google.common.collect.Lists;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.momirealms.craftengine.bukkit.api.CraftEngineBlocks;
import net.momirealms.craftengine.bukkit.item.BukkitItemManager;
import net.momirealms.craftengine.bukkit.nms.FastNMS;
import net.momirealms.craftengine.bukkit.plugin.BukkitCraftEngine;
import net.momirealms.craftengine.bukkit.plugin.gui.CraftEngineInventoryHolder;
import net.momirealms.craftengine.bukkit.plugin.network.payload.DiscardedPayload;
import net.momirealms.craftengine.bukkit.plugin.reflection.minecraft.CoreReflections;
import net.momirealms.craftengine.bukkit.plugin.reflection.minecraft.MAttributeHolders;
import net.momirealms.craftengine.bukkit.plugin.reflection.minecraft.MMobEffects;
import net.momirealms.craftengine.bukkit.plugin.reflection.minecraft.NetworkReflections;
import net.momirealms.craftengine.bukkit.util.AdventureModeUtils;
import net.momirealms.craftengine.bukkit.util.BlockStateUtils;
import net.momirealms.craftengine.bukkit.util.ComponentUtils;
import net.momirealms.craftengine.bukkit.util.DirectionUtils;
import net.momirealms.craftengine.bukkit.util.ItemTags;
import net.momirealms.craftengine.bukkit.util.KeyUtils;
import net.momirealms.craftengine.bukkit.util.LegacyAttributeUtils;
import net.momirealms.craftengine.bukkit.util.LegacyInventoryUtils;
import net.momirealms.craftengine.bukkit.util.LocationUtils;
import net.momirealms.craftengine.bukkit.util.MaterialUtils;
import net.momirealms.craftengine.bukkit.util.MobEffectUtils;
import net.momirealms.craftengine.bukkit.util.PlayerUtils;
import net.momirealms.craftengine.bukkit.util.SoundUtils;
import net.momirealms.craftengine.bukkit.world.BukkitWorld;
import net.momirealms.craftengine.core.block.BlockSettings;
import net.momirealms.craftengine.core.block.BlockStateWrapper;
import net.momirealms.craftengine.core.block.ImmutableBlockState;
import net.momirealms.craftengine.core.entity.player.GameMode;
import net.momirealms.craftengine.core.entity.player.InteractionHand;
import net.momirealms.craftengine.core.entity.player.Player;
import net.momirealms.craftengine.core.item.Item;
import net.momirealms.craftengine.core.plugin.CraftEngine;
import net.momirealms.craftengine.core.plugin.config.Config;
import net.momirealms.craftengine.core.plugin.context.CooldownData;
import net.momirealms.craftengine.core.plugin.network.ConnectionState;
import net.momirealms.craftengine.core.plugin.network.EntityPacketHandler;
import net.momirealms.craftengine.core.plugin.network.ProtocolVersion;
import net.momirealms.craftengine.core.sound.SoundSource;
import net.momirealms.craftengine.core.util.Direction;
import net.momirealms.craftengine.core.util.Key;
import net.momirealms.craftengine.core.util.VersionHelper;
import net.momirealms.craftengine.core.world.BlockPos;
import net.momirealms.craftengine.core.world.World;
import net.momirealms.craftengine.libraries.adventure.text.Component;
import org.bukkit.FluidCollisionMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Registry;
import org.bukkit.SoundCategory;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.util.RayTraceResult;
import org.jetbrains.annotations.Nullable;

public class BukkitServerPlayer
extends Player {
    private final BukkitCraftEngine plugin;
    private ProtocolVersion protocolVersion = ProtocolVersion.UNKNOWN;
    private final Channel channel;
    private ChannelHandler connection;
    private String name;
    private UUID uuid;
    private ConnectionState decoderState;
    private ConnectionState encoderState;
    private final Set<UUID> resourcePackUUID = Collections.synchronizedSet(new HashSet());
    private boolean sentResourcePack = !Config.sendPackOnJoin();
    private Reference<org.bukkit.entity.Player> playerRef;
    private Reference<Object> serverPlayerRef;
    private int sectionCount;
    private Key clientSideDimension;
    private int lastSuccessfulInteraction;
    private long lastAttributeSyncTime;
    private int lastSentState = -1;
    private int lastHitBlockTime;
    private BlockPos destroyPos;
    private Object destroyedState;
    private boolean isDestroyingBlock;
    private boolean isDestroyingCustomBlock;
    private boolean swingHandAck;
    private float miningProgress;
    private int resentSoundTick;
    private int resentSwingTick;
    private Key lastUsedRecipe = null;
    private boolean hasClientMod = false;
    private boolean clientSideCanBreak = true;
    private Location previousEyeLocation;
    private int lastSuccessfulBreak;
    private int gameTicks;
    private int lastUpdateInteractionRangeTick;
    private double cachedInteractionRange;
    private CooldownData cooldownData;
    private final Map<Integer, EntityPacketHandler> entityTypeView = new ConcurrentHashMap<Integer, EntityPacketHandler>();

    public BukkitServerPlayer(BukkitCraftEngine plugin, Channel channel) {
        this.channel = channel;
        this.plugin = plugin;
        for (String name : channel.pipeline().names()) {
            ChannelHandler handler = channel.pipeline().get(name);
            if (!NetworkReflections.clazz$Connection.isInstance(handler)) continue;
            this.connection = handler;
            break;
        }
    }

    public void setPlayer(org.bukkit.entity.Player player) {
        this.playerRef = new WeakReference<org.bukkit.entity.Player>(player);
        this.serverPlayerRef = new WeakReference<Object>(FastNMS.INSTANCE.method$CraftPlayer$getHandle(player));
        this.uuid = player.getUniqueId();
        this.name = player.getName();
        byte[] bytes = (byte[])player.getPersistentDataContainer().get(KeyUtils.toNamespacedKey(CooldownData.COOLDOWN_KEY), PersistentDataType.BYTE_ARRAY);
        try {
            this.cooldownData = CooldownData.fromBytes(bytes);
        }
        catch (IOException e) {
            this.cooldownData = new CooldownData();
            this.plugin.logger().warn("Failed to parse cooldown data", e);
        }
    }

    @Override
    public Channel nettyChannel() {
        return this.channel;
    }

    @Override
    public CraftEngine plugin() {
        return this.plugin;
    }

    @Override
    public boolean isMiningBlock() {
        return this.destroyPos != null;
    }

    public void setDestroyedState(Object destroyedState) {
        this.destroyedState = destroyedState;
    }

    public void setDestroyPos(BlockPos destroyPos) {
        this.destroyPos = destroyPos;
    }

    @Override
    public boolean shouldSyncAttribute() {
        long current = this.gameTicks();
        if (current - this.lastAttributeSyncTime > 100L) {
            this.lastAttributeSyncTime = current;
            return true;
        }
        return false;
    }

    @Override
    public boolean isSneaking() {
        return this.platformPlayer().isSneaking();
    }

    @Override
    public GameMode gameMode() {
        return switch (this.platformPlayer().getGameMode()) {
            default -> throw new MatchException(null, null);
            case org.bukkit.GameMode.CREATIVE -> GameMode.CREATIVE;
            case org.bukkit.GameMode.SPECTATOR -> GameMode.SPECTATOR;
            case org.bukkit.GameMode.ADVENTURE -> GameMode.ADVENTURE;
            case org.bukkit.GameMode.SURVIVAL -> GameMode.SURVIVAL;
        };
    }

    @Override
    public void setGameMode(GameMode gameMode) {
        this.platformPlayer().setGameMode(Objects.requireNonNull(org.bukkit.GameMode.getByValue((int)gameMode.id())));
    }

    @Override
    public boolean canBreak(BlockPos pos, @Nullable Object state) {
        return AdventureModeUtils.canBreak(this.platformPlayer().getInventory().getItemInMainHand(), new Location(this.platformPlayer().getWorld(), (double)pos.x(), (double)pos.y(), (double)pos.z()), state);
    }

    @Override
    public boolean canPlace(BlockPos pos, @Nullable Object state) {
        return AdventureModeUtils.canPlace(this.platformPlayer().getInventory().getItemInMainHand(), new Location(this.platformPlayer().getWorld(), (double)pos.x(), (double)pos.y(), (double)pos.z()), state);
    }

    @Override
    public void sendActionBar(Component text) {
        Object packet = FastNMS.INSTANCE.constructor$ClientboundActionBarPacket(ComponentUtils.adventureToMinecraft(text));
        this.sendPacket(packet, false);
    }

    @Override
    public void sendTitle(Component title, Component subtitle, int fadeIn, int stay, int fadeOut) {
        Object titlePacket = FastNMS.INSTANCE.constructor$ClientboundSetTitleTextPacket(ComponentUtils.adventureToMinecraft(title));
        Object subtitlePacket = FastNMS.INSTANCE.constructor$ClientboundSetSubtitleTextPacket(ComponentUtils.adventureToMinecraft(subtitle));
        Object timePacket = FastNMS.INSTANCE.constructor$ClientboundSetTitlesAnimationPacket(fadeIn, stay, fadeOut);
        this.sendPackets(List.of(titlePacket, subtitlePacket, timePacket), false);
    }

    @Override
    public void sendMessage(Component text, boolean overlay) {
        Object packet = FastNMS.INSTANCE.constructor$ClientboundSystemChatPacket(ComponentUtils.adventureToMinecraft(text), overlay);
        this.sendPacket(packet, false);
    }

    @Override
    public boolean updateLastSuccessfulInteractionTick(int tick) {
        if (this.lastSuccessfulInteraction != tick) {
            this.lastSuccessfulInteraction = tick;
            return true;
        }
        return false;
    }

    @Override
    public int lastSuccessfulInteractionTick() {
        return this.lastSuccessfulInteraction;
    }

    @Override
    public int gameTicks() {
        return this.gameTicks;
    }

    @Override
    public void swingHand(InteractionHand hand) {
        this.platformPlayer().swingHand(hand == InteractionHand.MAIN_HAND ? EquipmentSlot.HAND : EquipmentSlot.OFF_HAND);
    }

    @Override
    public boolean hasPermission(String permission) {
        return this.platformPlayer().hasPermission(permission);
    }

    @Override
    public boolean canInstabuild() {
        try {
            Object abilities = CoreReflections.field$Player$abilities.get(this.serverPlayer());
            return (Boolean)CoreReflections.field$Abilities$instabuild.get(abilities);
        }
        catch (ReflectiveOperationException e) {
            CraftEngine.instance().logger().warn("Failed to get canInstabuild for " + this.name(), e);
            return false;
        }
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        if (this.name != null) {
            return;
        }
        this.name = name;
    }

    @Override
    public UUID uuid() {
        return this.uuid;
    }

    @Override
    public void setUUID(UUID uuid) {
        if (this.uuid != null) {
            return;
        }
        this.uuid = uuid;
    }

    @Override
    public void playSound(Key sound, SoundSource source, float volume, float pitch) {
        this.platformPlayer().playSound((Entity)this.platformPlayer(), sound.toString(), SoundUtils.toBukkit(source), volume, pitch);
    }

    @Override
    public void playSound(Key sound, BlockPos blockPos, SoundSource source, float volume, float pitch) {
        this.platformPlayer().playSound(new Location(null, (double)blockPos.x() + 0.5, (double)blockPos.y() + 0.5, (double)blockPos.z() + 0.5), sound.toString(), SoundUtils.toBukkit(source), volume, pitch);
    }

    @Override
    public void giveItem(Item<?> item) {
        PlayerUtils.giveItem(this.platformPlayer(), (ItemStack)item.getItem(), item.count());
    }

    @Override
    public void closeInventory() {
        this.platformPlayer().closeInventory();
    }

    @Override
    public void sendPacket(Object packet, boolean immediately) {
        this.plugin.networkManager().sendPacket(this, packet, immediately);
    }

    @Override
    public void sendCustomPayload(Key channel, byte[] data) {
        try {
            Object channelKey = KeyUtils.toResourceLocation(channel);
            Object dataPayload = DiscardedPayload.useNewMethod ? NetworkReflections.constructor$DiscardedPayload.newInstance(channelKey, data) : NetworkReflections.constructor$DiscardedPayload.newInstance(channelKey, Unpooled.wrappedBuffer((byte[])data));
            Object responsePacket = NetworkReflections.constructor$ClientboundCustomPayloadPacket.newInstance(dataPayload);
            this.sendPacket(responsePacket, true);
        }
        catch (Exception e) {
            CraftEngine.instance().logger().warn("Failed to send custom payload to " + this.name(), e);
        }
    }

    @Override
    public void kick(Component message) {
        try {
            Object reason = ComponentUtils.adventureToMinecraft(message);
            Object kickPacket = NetworkReflections.constructor$ClientboundDisconnectPacket.newInstance(reason);
            this.sendPacket(kickPacket, true);
            this.nettyChannel().disconnect();
        }
        catch (Exception e) {
            CraftEngine.instance().logger().warn("Failed to kick " + this.name(), e);
        }
    }

    @Override
    public void sendPackets(List<Object> packet, boolean immediately) {
        this.plugin.networkManager().sendPackets(this, packet, immediately);
    }

    @Override
    public void simulatePacket(Object packet) {
        this.plugin.networkManager().simulatePacket(this, packet);
    }

    @Override
    public ConnectionState decoderState() {
        return this.decoderState;
    }

    @Override
    public ConnectionState encoderState() {
        return this.encoderState;
    }

    @Override
    public int clientSideSectionCount() {
        return this.sectionCount;
    }

    public void setClientSideSectionCount(int sectionCount) {
        this.sectionCount = sectionCount;
    }

    @Override
    public Key clientSideDimension() {
        return this.clientSideDimension;
    }

    public void setClientSideDimension(Key clientSideDimension) {
        this.clientSideDimension = clientSideDimension;
    }

    public void setConnectionState(ConnectionState connectionState) {
        this.encoderState = connectionState;
        this.decoderState = connectionState;
    }

    public void setDecoderState(ConnectionState decoderState) {
        this.decoderState = decoderState;
    }

    public void setEncoderState(ConnectionState encoderState) {
        this.encoderState = encoderState;
    }

    @Override
    public void tick() {
        if (this.serverPlayer() == null) {
            return;
        }
        if (VersionHelper.isFolia()) {
            try {
                Object serverPlayer = this.serverPlayer();
                Object gameMode = FastNMS.INSTANCE.field$ServerPlayer$gameMode(serverPlayer);
                this.gameTicks = (Integer)CoreReflections.field$ServerPlayerGameMode$gameTicks.get(gameMode);
            }
            catch (ReflectiveOperationException e) {
                CraftEngine.instance().logger().warn("Failed to get game tick for " + this.name(), e);
            }
        } else {
            this.gameTicks = FastNMS.INSTANCE.field$MinecraftServer$currentTick();
        }
        if (this.gameTicks % 30 == 0) {
            this.updateGUI();
        }
        if (this.isDestroyingBlock) {
            this.tickBlockDestroy();
        }
        if (Config.predictBreaking() && !this.isDestroyingCustomBlock && (this.gameTicks() + this.entityID()) % Config.predictBreakingInterval() == 0) {
            Location eyeLocation = this.platformPlayer().getEyeLocation();
            if (eyeLocation.equals((Object)this.previousEyeLocation)) {
                return;
            }
            this.previousEyeLocation = eyeLocation;
            this.predictNextBlockToMine();
        }
    }

    private void updateGUI() {
        Inventory top = !VersionHelper.isOrAbove1_21() ? LegacyInventoryUtils.getTopInventory(this.platformPlayer()) : this.platformPlayer().getOpenInventory().getTopInventory();
        InventoryHolder inventoryHolder = top.getHolder();
        if (inventoryHolder instanceof CraftEngineInventoryHolder) {
            CraftEngineInventoryHolder holder = (CraftEngineInventoryHolder)inventoryHolder;
            holder.gui().onTimer();
        }
    }

    @Override
    public float getDestroyProgress(Object blockState, BlockPos pos) {
        return FastNMS.INSTANCE.method$BlockStateBase$getDestroyProgress(blockState, this.serverPlayer(), FastNMS.INSTANCE.field$CraftWorld$ServerLevel(this.platformPlayer().getWorld()), LocationUtils.toBlockPos(pos));
    }

    private void predictNextBlockToMine() {
        double range = this.getCachedInteractionRange() + Config.extendedInteractionRange();
        RayTraceResult result = this.platformPlayer().rayTraceBlocks(range, FluidCollisionMode.NEVER);
        if (result == null) {
            if (!this.clientSideCanBreak) {
                this.setClientSideCanBreakBlock(true);
            }
            return;
        }
        Block hitBlock = result.getHitBlock();
        if (hitBlock == null) {
            if (!this.clientSideCanBreak) {
                this.setClientSideCanBreakBlock(true);
            }
            return;
        }
        ImmutableBlockState nextBlock = CraftEngineBlocks.getCustomBlockState(hitBlock);
        if (nextBlock == null) {
            if (!this.clientSideCanBreak) {
                this.setClientSideCanBreakBlock(true);
            }
        } else if (this.clientSideCanBreak) {
            this.setClientSideCanBreakBlock(false);
        }
    }

    public void startMiningBlock(BlockPos pos, Object state, @Nullable ImmutableBlockState immutableBlockState) {
        boolean custom;
        boolean bl = custom = immutableBlockState != null;
        if (custom && this.getDestroyProgress(state, pos) >= 1.0f) {
            BlockStateWrapper vanillaBlockState = immutableBlockState.vanillaBlockState();
            if (vanillaBlockState != null && this.getDestroyProgress(vanillaBlockState.handle(), pos) < 1.0f) {
                Object levelEventPacket = FastNMS.INSTANCE.constructor$ClientboundLevelEventPacket(2001, LocationUtils.toBlockPos(pos), BlockStateUtils.blockStateToId(state), false);
                this.sendPacket(levelEventPacket, false);
            }
            return;
        }
        if (!custom && !this.clientSideCanBreak && this.getDestroyProgress(state, pos) >= 1.0f) {
            Object levelEventPacket = FastNMS.INSTANCE.constructor$ClientboundLevelEventPacket(2001, LocationUtils.toBlockPos(pos), BlockStateUtils.blockStateToId(state), false);
            this.sendPacket(levelEventPacket, false);
        }
        this.setClientSideCanBreakBlock(!custom);
        this.setDestroyPos(pos);
        this.setDestroyedState(state);
        this.setIsDestroyingBlock(true, custom);
    }

    @Override
    public void setClientSideCanBreakBlock(boolean canBreak) {
        try {
            if (this.clientSideCanBreak == canBreak && !this.shouldSyncAttribute()) {
                return;
            }
            this.clientSideCanBreak = canBreak;
            if (canBreak) {
                if (VersionHelper.isOrAbove1_20_5()) {
                    Object serverPlayer = this.serverPlayer();
                    Object attributeInstance = CoreReflections.methodHandle$ServerPlayer$getAttributeMethod.invokeExact(serverPlayer, MAttributeHolders.BLOCK_BREAK_SPEED);
                    Object newPacket = NetworkReflections.methodHandle$ClientboundUpdateAttributesPacket0Constructor.invokeExact(this.entityID(), Lists.newArrayList((Object[])new Object[]{attributeInstance}));
                    this.sendPacket(newPacket, true);
                } else {
                    this.resetEffect(MMobEffects.MINING_FATIGUE);
                    this.resetEffect(MMobEffects.HASTE);
                }
            } else if (VersionHelper.isOrAbove1_20_5()) {
                Object attributeModifier = VersionHelper.isOrAbove1_21() ? CoreReflections.constructor$AttributeModifier.newInstance(KeyUtils.toResourceLocation("craftengine", "custom_hardness"), -9999.0, CoreReflections.instance$AttributeModifier$Operation$ADD_VALUE) : CoreReflections.constructor$AttributeModifier.newInstance(UUID.randomUUID(), "craftengine:custom_hardness", -9999.0, CoreReflections.instance$AttributeModifier$Operation$ADD_VALUE);
                Object attributeSnapshot = NetworkReflections.constructor$ClientboundUpdateAttributesPacket$AttributeSnapshot.newInstance(MAttributeHolders.BLOCK_BREAK_SPEED, 1.0, Lists.newArrayList((Object[])new Object[]{attributeModifier}));
                Object newPacket = NetworkReflections.constructor$ClientboundUpdateAttributesPacket1.newInstance(this.entityID(), Lists.newArrayList((Object[])new Object[]{attributeSnapshot}));
                this.sendPacket(newPacket, true);
            } else {
                Object fatiguePacket = MobEffectUtils.createPacket(MMobEffects.MINING_FATIGUE, this.entityID(), (byte)9, -1, false, false, false);
                Object hastePacket = MobEffectUtils.createPacket(MMobEffects.HASTE, this.entityID(), (byte)0, -1, false, false, false);
                this.sendPackets(List.of(fatiguePacket, hastePacket), true);
            }
        }
        catch (Throwable e) {
            this.plugin.logger().warn("Failed to set attribute for player " + this.platformPlayer().getName(), e);
        }
    }

    @Override
    public void stopMiningBlock() {
        this.setClientSideCanBreakBlock(true);
        this.setIsDestroyingBlock(false, false);
    }

    @Override
    public void preventMiningBlock() {
        this.setClientSideCanBreakBlock(false);
        this.setIsDestroyingBlock(false, false);
        this.abortMiningBlock();
    }

    @Override
    public void abortMiningBlock() {
        this.swingHandAck = false;
        this.miningProgress = 0.0f;
        BlockPos pos = this.destroyPos;
        if (pos != null && this.isDestroyingCustomBlock) {
            this.broadcastDestroyProgress(this.platformPlayer(), pos, LocationUtils.toBlockPos(pos), -1);
        }
    }

    private void resetEffect(Object mobEffect) throws ReflectiveOperationException {
        Object effectInstance = CoreReflections.method$ServerPlayer$getEffect.invoke(this.serverPlayer(), mobEffect);
        Object packet = effectInstance != null ? NetworkReflections.constructor$ClientboundUpdateMobEffectPacket.newInstance(this.entityID(), effectInstance) : NetworkReflections.constructor$ClientboundRemoveMobEffectPacket.newInstance(this.entityID(), mobEffect);
        this.sendPacket(packet, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tickBlockDestroy() {
        if (!this.swingHandAck) {
            return;
        }
        this.swingHandAck = false;
        int currentTick = this.gameTicks();
        if (currentTick - this.lastSuccessfulBreak <= 5) {
            return;
        }
        Object destroyedState = this.destroyedState;
        if (destroyedState == null) {
            return;
        }
        try {
            org.bukkit.entity.Player player = this.platformPlayer();
            double range = this.getCachedInteractionRange();
            RayTraceResult result = player.rayTraceBlocks(range, FluidCollisionMode.NEVER);
            if (result == null) {
                return;
            }
            Block hitBlock = result.getHitBlock();
            if (hitBlock == null) {
                return;
            }
            Location location = hitBlock.getLocation();
            BlockPos hitPos = new BlockPos(location.getBlockX(), location.getBlockY(), location.getBlockZ());
            if (!hitPos.equals(this.destroyPos)) {
                return;
            }
            Object blockPos = LocationUtils.toBlockPos(hitPos);
            Object serverPlayer = this.serverPlayer();
            if (currentTick - this.lastHitBlockTime > 3) {
                Object blockOwner = FastNMS.INSTANCE.method$BlockState$getBlock(destroyedState);
                Object soundType = CoreReflections.field$BlockBehaviour$soundType.get(blockOwner);
                Object soundEvent = CoreReflections.field$SoundType$hitSound.get(soundType);
                Object soundId = FastNMS.INSTANCE.field$SoundEvent$location(soundEvent);
                player.playSound(location, soundId.toString(), SoundCategory.BLOCKS, 0.5f, 0.5f);
                this.lastHitBlockTime = currentTick;
            }
            if (this.isDestroyingCustomBlock) {
                Object gameMode = FastNMS.INSTANCE.field$ServerPlayer$gameMode(serverPlayer);
                CoreReflections.field$ServerPlayerGameMode$isDestroyingBlock.set(gameMode, false);
                Item<ItemStack> item = this.getItemInHand(InteractionHand.MAIN_HAND);
                if (item != null) {
                    Material itemMaterial = item.getItem().getType();
                    if (this.canInstabuild() && (itemMaterial == Material.DEBUG_STICK || itemMaterial == Material.TRIDENT || VersionHelper.isOrAbove1_20_5() && itemMaterial == MaterialUtils.MACE || item.is(ItemTags.SWORDS))) {
                        return;
                    }
                }
                float progressToAdd = this.getDestroyProgress(destroyedState, hitPos);
                Optional<ImmutableBlockState> optionalCustomState = BlockStateUtils.getOptionalCustomBlockState(destroyedState);
                if (optionalCustomState.isPresent()) {
                    ImmutableBlockState customState = optionalCustomState.get();
                    BlockSettings blockSettings = customState.settings();
                    if (blockSettings.requireCorrectTool()) {
                        if (item != null) {
                            if (blockSettings.isCorrectTool(item.id())) {
                                if (!FastNMS.INSTANCE.method$ItemStack$isCorrectToolForDrops(item.getLiteralObject(), destroyedState)) {
                                    progressToAdd *= 3.3333333f;
                                }
                            } else if (!blockSettings.respectToolComponent() || !FastNMS.INSTANCE.method$ItemStack$isCorrectToolForDrops(item.getLiteralObject(), destroyedState)) {
                                progressToAdd = progressToAdd * 3.3333333f * blockSettings.incorrectToolSpeed();
                            }
                        } else {
                            progressToAdd = progressToAdd * 3.3333333f * blockSettings.incorrectToolSpeed();
                        }
                    }
                    this.miningProgress = progressToAdd + this.miningProgress;
                    int packetStage = (int)(this.miningProgress * 10.0f);
                    if (packetStage != this.lastSentState) {
                        this.lastSentState = packetStage;
                        this.broadcastDestroyProgress(player, hitPos, blockPos, packetStage);
                    }
                    if (this.miningProgress >= 1.0f) {
                        if (this.isAdventureMode() && Config.simplifyAdventureBreakCheck()) {
                            if (this.canBreak(hitPos, customState.vanillaBlockState().handle())) {
                                try {
                                    FastNMS.INSTANCE.field$Player$mayBuild(serverPlayer, true);
                                    CoreReflections.method$ServerPlayerGameMode$destroyBlock.invoke(gameMode, blockPos);
                                }
                                finally {
                                    FastNMS.INSTANCE.field$Player$mayBuild(serverPlayer, false);
                                }
                            }
                        } else {
                            CoreReflections.method$ServerPlayerGameMode$destroyBlock.invoke(gameMode, blockPos);
                        }
                        this.sendPacket(FastNMS.INSTANCE.constructor$ClientboundLevelEventPacket(2001, blockPos, customState.customBlockState().registryId(), false), false);
                        this.lastSuccessfulBreak = currentTick;
                        this.destroyPos = null;
                        this.setIsDestroyingBlock(false, false);
                    }
                }
            }
        }
        catch (Exception e) {
            this.plugin.logger().warn("Failed to tick destroy for player " + this.platformPlayer().getName(), e);
        }
    }

    @Override
    public void breakBlock(int x, int y, int z) {
        this.platformPlayer().breakBlock(new Location(this.platformPlayer().getWorld(), (double)x, (double)y, (double)z).getBlock());
    }

    private void broadcastDestroyProgress(org.bukkit.entity.Player player, BlockPos hitPos, Object blockPos, int stage) {
        Object packet = FastNMS.INSTANCE.constructor$ClientboundBlockDestructionPacket(Integer.MAX_VALUE - this.entityID(), blockPos, stage);
        for (org.bukkit.entity.Player other : player.getWorld().getPlayers()) {
            double d2;
            double d1;
            Location otherLocation = other.getLocation();
            double d0 = (double)hitPos.x() - otherLocation.getX();
            if (!(d0 * d0 + (d1 = (double)hitPos.y() - otherLocation.getY()) * d1 + (d2 = (double)hitPos.z() - otherLocation.getZ()) * d2 < 1024.0)) continue;
            FastNMS.INSTANCE.method$Connection$send(FastNMS.INSTANCE.field$ServerGamePacketListenerImpl$connection(FastNMS.INSTANCE.field$Player$connection(FastNMS.INSTANCE.method$CraftPlayer$getHandle(player))), packet);
        }
    }

    @Override
    public double getCachedInteractionRange() {
        if (this.lastUpdateInteractionRangeTick + 20 > this.gameTicks()) {
            return this.cachedInteractionRange;
        }
        this.cachedInteractionRange = FastNMS.INSTANCE.method$Player$getInteractionRange(this.serverPlayer());
        this.lastUpdateInteractionRangeTick = this.gameTicks();
        return this.cachedInteractionRange;
    }

    public void setIsDestroyingBlock(boolean is, boolean custom) {
        this.miningProgress = 0.0f;
        this.isDestroyingBlock = is;
        if (is) {
            this.swingHandAck = true;
            this.isDestroyingCustomBlock = custom;
        } else {
            this.swingHandAck = false;
            this.destroyedState = null;
            if (this.destroyPos != null) {
                if (this.isDestroyingCustomBlock) {
                    this.broadcastDestroyProgress(this.platformPlayer(), this.destroyPos, LocationUtils.toBlockPos(this.destroyPos), -1);
                }
                this.destroyPos = null;
            }
            this.isDestroyingCustomBlock = false;
        }
    }

    @Override
    public void onSwingHand() {
        this.swingHandAck = true;
    }

    @Override
    public int entityID() {
        return this.platformPlayer().getEntityId();
    }

    @Override
    public boolean isOnline() {
        org.bukkit.entity.Player player = this.platformPlayer();
        if (player == null) {
            return false;
        }
        return player.isOnline();
    }

    @Override
    public float yRot() {
        return this.platformPlayer().getPitch();
    }

    @Override
    public float xRot() {
        return this.platformPlayer().getYaw();
    }

    @Override
    public boolean isSecondaryUseActive() {
        return this.isSneaking();
    }

    @Override
    public Direction getDirection() {
        return DirectionUtils.toDirection(this.platformPlayer().getFacing());
    }

    @Nullable
    public Item<ItemStack> getItemInHand(InteractionHand hand) {
        PlayerInventory inventory = this.platformPlayer().getInventory();
        return BukkitItemManager.instance().wrap(hand == InteractionHand.MAIN_HAND ? inventory.getItemInMainHand() : inventory.getItemInOffHand());
    }

    @Override
    public World world() {
        return new BukkitWorld(this.platformPlayer().getWorld());
    }

    @Override
    public double x() {
        return this.platformPlayer().getX();
    }

    @Override
    public double y() {
        return this.platformPlayer().getY();
    }

    @Override
    public double z() {
        return this.platformPlayer().getZ();
    }

    @Override
    public Object serverPlayer() {
        if (this.serverPlayerRef == null) {
            return null;
        }
        return this.serverPlayerRef.get();
    }

    public org.bukkit.entity.Player platformPlayer() {
        if (this.playerRef == null) {
            return null;
        }
        return this.playerRef.get();
    }

    @Override
    public ChannelHandler connection() {
        if (this.connection == null) {
            Object serverPlayer = this.serverPlayer();
            if (serverPlayer != null) {
                this.connection = (ChannelHandler)FastNMS.INSTANCE.field$ServerGamePacketListenerImpl$connection(FastNMS.INSTANCE.field$Player$connection(serverPlayer));
            } else {
                throw new IllegalStateException("Cannot init or find connection instance for player " + this.name());
            }
        }
        return this.connection;
    }

    public org.bukkit.entity.Player literalObject() {
        return this.platformPlayer();
    }

    @Override
    public Map<Integer, EntityPacketHandler> entityPacketHandlers() {
        return this.entityTypeView;
    }

    public void setResendSound() {
        this.resentSoundTick = this.gameTicks();
    }

    public void setResendSwing() {
        this.resentSwingTick = this.gameTicks();
    }

    public boolean shouldResendSound() {
        return this.resentSoundTick == this.gameTicks();
    }

    public boolean shouldResendSwing() {
        return this.resentSwingTick == this.gameTicks();
    }

    public Key lastUsedRecipe() {
        return this.lastUsedRecipe;
    }

    public void setLastUsedRecipe(Key lastUsedRecipe) {
        this.lastUsedRecipe = lastUsedRecipe;
    }

    @Override
    public boolean clientModEnabled() {
        return this.hasClientMod;
    }

    @Override
    public void setClientModState(boolean enable) {
        this.hasClientMod = enable;
    }

    @Override
    public void addResourcePackUUID(UUID uuid) {
        if (VersionHelper.isOrAbove1_20_3()) {
            this.resourcePackUUID.add(uuid);
        }
    }

    @Override
    public ProtocolVersion protocolVersion() {
        return this.protocolVersion;
    }

    @Override
    public void setProtocolVersion(int protocolVersion) {
        this.protocolVersion = ProtocolVersion.getById(protocolVersion);
    }

    @Override
    public boolean sentResourcePack() {
        return this.sentResourcePack;
    }

    @Override
    public void setSentResourcePack(boolean sentResourcePack) {
        this.sentResourcePack = sentResourcePack;
    }

    @Override
    public void clearView() {
        this.entityTypeView.clear();
    }

    @Override
    public void unloadCurrentResourcePack() {
        if (!VersionHelper.isOrAbove1_20_3()) {
            return;
        }
        if (this.decoderState() == ConnectionState.PLAY && !this.resourcePackUUID.isEmpty()) {
            for (UUID u : this.resourcePackUUID) {
                this.sendPacket(FastNMS.INSTANCE.constructor$ClientboundResourcePackPopPacket(u), true);
            }
            this.resourcePackUUID.clear();
        }
    }

    @Override
    public void performCommand(String command) {
        this.platformPlayer().performCommand(command);
    }

    @Override
    public double luck() {
        if (VersionHelper.isOrAbove1_21_3()) {
            return Optional.ofNullable(this.platformPlayer().getAttribute(Attribute.LUCK)).map(AttributeInstance::getValue).orElse(1.0);
        }
        return LegacyAttributeUtils.getLuck(this.platformPlayer());
    }

    @Override
    public boolean isFlying() {
        return this.platformPlayer().isFlying();
    }

    @Override
    public int foodLevel() {
        return this.platformPlayer().getFoodLevel();
    }

    @Override
    public void setFoodLevel(int foodLevel) {
        this.platformPlayer().setFoodLevel(Math.min(Math.max(0, foodLevel), 20));
    }

    @Override
    public float saturation() {
        return this.platformPlayer().getSaturation();
    }

    @Override
    public void setSaturation(float saturation) {
        this.platformPlayer().setSaturation(saturation);
    }

    @Override
    public void addPotionEffect(Key potionEffectType, int duration, int amplifier, boolean ambient, boolean particles) {
        PotionEffectType type = (PotionEffectType)Registry.POTION_EFFECT_TYPE.get(KeyUtils.toNamespacedKey(potionEffectType));
        if (type == null) {
            return;
        }
        this.platformPlayer().addPotionEffect(new PotionEffect(type, duration, amplifier, ambient, particles));
    }

    @Override
    public void removePotionEffect(Key potionEffectType) {
        PotionEffectType type = (PotionEffectType)Registry.POTION_EFFECT_TYPE.get(KeyUtils.toNamespacedKey(potionEffectType));
        if (type == null) {
            return;
        }
        this.platformPlayer().removePotionEffect(type);
    }

    @Override
    public void clearPotionEffects() {
        this.platformPlayer().clearActivePotionEffects();
    }

    @Override
    public CooldownData cooldown() {
        return this.cooldownData;
    }
}

