/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.bukkit.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.momirealms.craftengine.bukkit.plugin.reflection.minecraft.CoreReflections;
import net.momirealms.craftengine.core.plugin.CraftEngine;
import net.momirealms.craftengine.core.util.VersionHelper;

public class RecipeUtils {
    private RecipeUtils() {
    }

    public static List<Object> getIngredientsFromShapedRecipe(Object recipe) {
        ArrayList<Object> ingredients = new ArrayList<Object>();
        try {
            if (VersionHelper.isOrAbove1_20_3()) {
                Object pattern = CoreReflections.field$1_20_3$ShapedRecipe$pattern.get(recipe);
                if (VersionHelper.isOrAbove1_21_2()) {
                    List optionals = (List)CoreReflections.field$ShapedRecipePattern$ingredients1_21_2.get(pattern);
                    for (Optional optional : optionals) {
                        optional.ifPresent(ingredients::add);
                    }
                } else {
                    List objectList = (List)CoreReflections.field$ShapedRecipePattern$ingredients1_20_3.get(pattern);
                    for (Object object : objectList) {
                        Object[] values = (Object[])CoreReflections.field$Ingredient$values.get(object);
                        if (values.length == 0) continue;
                        ingredients.add(object);
                    }
                }
            } else {
                List objectList = (List)CoreReflections.field$1_20_1$ShapedRecipe$recipeItems.get(recipe);
                for (Object object : objectList) {
                    Object[] values = (Object[])CoreReflections.field$Ingredient$values.get(object);
                    if (values.length == 0) continue;
                    ingredients.add(object);
                }
            }
        }
        catch (ReflectiveOperationException e) {
            CraftEngine.instance().logger().warn("Failed to get ingredients from shaped recipe", e);
        }
        return ingredients;
    }
}

