/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.bukkit.world;

import java.lang.ref.WeakReference;
import java.nio.file.Path;
import java.util.UUID;
import javax.annotation.Nullable;
import net.momirealms.craftengine.bukkit.nms.FastNMS;
import net.momirealms.craftengine.bukkit.util.EntityUtils;
import net.momirealms.craftengine.bukkit.util.ItemUtils;
import net.momirealms.craftengine.bukkit.util.LocationUtils;
import net.momirealms.craftengine.bukkit.util.ParticleUtils;
import net.momirealms.craftengine.bukkit.util.SoundUtils;
import net.momirealms.craftengine.bukkit.world.BukkitBlockInWorld;
import net.momirealms.craftengine.core.block.BlockStateWrapper;
import net.momirealms.craftengine.core.item.Item;
import net.momirealms.craftengine.core.plugin.context.Context;
import net.momirealms.craftengine.core.sound.SoundSource;
import net.momirealms.craftengine.core.util.Key;
import net.momirealms.craftengine.core.util.VersionHelper;
import net.momirealms.craftengine.core.world.BlockInWorld;
import net.momirealms.craftengine.core.world.BlockPos;
import net.momirealms.craftengine.core.world.Position;
import net.momirealms.craftengine.core.world.World;
import net.momirealms.craftengine.core.world.WorldHeight;
import net.momirealms.craftengine.core.world.particle.ParticleData;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.SoundCategory;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class BukkitWorld
implements World {
    private final WeakReference<org.bukkit.World> world;
    private WorldHeight worldHeight;

    public BukkitWorld(org.bukkit.World world) {
        this.world = new WeakReference<org.bukkit.World>(world);
    }

    public org.bukkit.World platformWorld() {
        return (org.bukkit.World)this.world.get();
    }

    @Override
    public Object serverWorld() {
        return FastNMS.INSTANCE.field$CraftWorld$ServerLevel(this.platformWorld());
    }

    @Override
    public WorldHeight worldHeight() {
        if (this.worldHeight == null) {
            this.worldHeight = WorldHeight.create(this.platformWorld().getMinHeight(), this.platformWorld().getMaxHeight() - this.platformWorld().getMinHeight());
        }
        return this.worldHeight;
    }

    @Override
    public BlockInWorld getBlockAt(int x, int y, int z) {
        return new BukkitBlockInWorld(this.platformWorld().getBlockAt(x, y, z));
    }

    @Override
    public String name() {
        return this.platformWorld().getName();
    }

    @Override
    public Path directory() {
        return this.platformWorld().getWorldFolder().toPath();
    }

    @Override
    public UUID uuid() {
        return this.platformWorld().getUID();
    }

    @Override
    public void dropItemNaturally(Position location, Item<?> item) {
        ItemStack itemStack = (ItemStack)item.getItem();
        if (ItemUtils.isEmpty(itemStack)) {
            return;
        }
        if (VersionHelper.isOrAbove1_21_2()) {
            this.platformWorld().dropItemNaturally(new Location(null, location.x(), location.y(), location.z()), (ItemStack)item.getItem());
        } else {
            this.platformWorld().dropItemNaturally(new Location(null, location.x() - 0.5, location.y() - 0.5, location.z() - 0.5), (ItemStack)item.getItem());
        }
    }

    @Override
    public void dropExp(Position location, int amount) {
        if (amount <= 0) {
            return;
        }
        EntityUtils.spawnEntity(this.platformWorld(), new Location(this.platformWorld(), location.x(), location.y(), location.z()), EntityType.EXPERIENCE_ORB, e -> {
            ExperienceOrb orb = (ExperienceOrb)e;
            orb.setExperience(amount);
        });
    }

    @Override
    public void playSound(Position location, Key sound, float volume, float pitch, SoundSource source) {
        this.platformWorld().playSound(new Location(null, location.x(), location.y(), location.z()), sound.toString(), SoundUtils.toBukkit(source), volume, pitch);
    }

    @Override
    public void playBlockSound(Position location, Key sound, float volume, float pitch) {
        this.platformWorld().playSound(new Location(null, location.x(), location.y(), location.z()), sound.toString(), SoundCategory.BLOCKS, volume, pitch);
    }

    @Override
    public void spawnParticle(Position location, Key particle, int count, double xOffset, double yOffset, double zOffset, double speed, @Nullable ParticleData extraData, @NotNull Context context) {
        Particle particleType = ParticleUtils.getParticle(particle);
        if (particleType == null) {
            return;
        }
        org.bukkit.World platformWorld = this.platformWorld();
        platformWorld.spawnParticle(particleType, location.x(), location.y(), location.z(), count, xOffset, yOffset, zOffset, speed, extraData == null ? null : ParticleUtils.toBukkitParticleData(extraData, context, platformWorld, location.x(), location.y(), location.z()));
    }

    @Override
    public long time() {
        return this.platformWorld().getTime();
    }

    @Override
    public void setBlockAt(int x, int y, int z, BlockStateWrapper blockState, int flags) {
        Object worldServer = this.serverWorld();
        Object blockPos = FastNMS.INSTANCE.constructor$BlockPos(x, y, z);
        FastNMS.INSTANCE.method$LevelWriter$setBlock(worldServer, blockPos, blockState.handle(), flags);
    }

    @Override
    public void levelEvent(int id, BlockPos pos, int data) {
        FastNMS.INSTANCE.method$Level$levelEvent(this.serverWorld(), id, LocationUtils.toBlockPos(pos), data);
    }
}

