/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.block;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.momirealms.craftengine.core.block.BlockSounds;
import net.momirealms.craftengine.core.block.PushReaction;
import net.momirealms.craftengine.core.plugin.locale.LocalizedResourceConfigException;
import net.momirealms.craftengine.core.util.Instrument;
import net.momirealms.craftengine.core.util.Key;
import net.momirealms.craftengine.core.util.MapColor;
import net.momirealms.craftengine.core.util.MiscUtils;
import net.momirealms.craftengine.core.util.ResourceConfigUtils;
import net.momirealms.craftengine.core.util.Tristate;
import org.jetbrains.annotations.Nullable;

public class BlockSettings {
    boolean isRandomlyTicking;
    boolean burnable;
    int burnChance;
    int fireSpreadChance;
    int blockLight = -1;
    boolean replaceable;
    float hardness = 2.0f;
    float resistance = 2.0f;
    Tristate canOcclude = Tristate.UNDEFINED;
    boolean fluidState;
    boolean requireCorrectTools;
    boolean respectToolComponent;
    Tristate isRedstoneConductor = Tristate.UNDEFINED;
    Tristate isSuffocating = Tristate.UNDEFINED;
    Tristate isViewBlocking = Tristate.UNDEFINED;
    Tristate useShapeForLightOcclusion = Tristate.UNDEFINED;
    Tristate propagatesSkylightDown = Tristate.UNDEFINED;
    MapColor mapColor = MapColor.CLEAR;
    PushReaction pushReaction = PushReaction.NORMAL;
    int luminance;
    Instrument instrument = Instrument.HARP;
    BlockSounds sounds = BlockSounds.EMPTY;
    @Nullable
    Key itemId;
    Set<Key> tags = Set.of();
    float incorrectToolSpeed = 0.3f;
    Set<Key> correctTools = Set.of();
    String name;
    String supportShapeBlockState;

    private BlockSettings() {
    }

    public static BlockSettings of() {
        return new BlockSettings();
    }

    public static BlockSettings fromMap(Map<String, Object> map) {
        if (map == null || map.isEmpty()) {
            return BlockSettings.of();
        }
        return BlockSettings.applyModifiers(BlockSettings.of(), map);
    }

    public static BlockSettings fromMap(Key id, Map<String, Object> map) {
        if (map == null || map.isEmpty()) {
            return BlockSettings.of().itemId(id);
        }
        return BlockSettings.applyModifiers(BlockSettings.of().itemId(id), map);
    }

    public static BlockSettings ofFullCopy(BlockSettings settings, Map<String, Object> map) {
        return BlockSettings.applyModifiers(BlockSettings.ofFullCopy(settings), map);
    }

    public static BlockSettings applyModifiers(BlockSettings settings, Map<String, Object> map) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            Modifier.Factory factory = Modifiers.FACTORIES.get(entry.getKey());
            if (factory != null) {
                factory.createModifier(entry.getValue()).apply(settings);
                continue;
            }
            throw new LocalizedResourceConfigException("warning.config.block.settings.unknown", entry.getKey());
        }
        return settings;
    }

    public static BlockSettings ofFullCopy(BlockSettings settings) {
        BlockSettings newSettings = BlockSettings.of();
        newSettings.canOcclude = settings.canOcclude;
        newSettings.hardness = settings.hardness;
        newSettings.resistance = settings.resistance;
        newSettings.isRandomlyTicking = settings.isRandomlyTicking;
        newSettings.burnable = settings.burnable;
        newSettings.replaceable = settings.replaceable;
        newSettings.mapColor = settings.mapColor;
        newSettings.pushReaction = settings.pushReaction;
        newSettings.luminance = settings.luminance;
        newSettings.instrument = settings.instrument;
        newSettings.sounds = settings.sounds;
        newSettings.itemId = settings.itemId;
        newSettings.tags = settings.tags;
        newSettings.burnChance = settings.burnChance;
        newSettings.requireCorrectTools = settings.requireCorrectTools;
        newSettings.respectToolComponent = settings.respectToolComponent;
        newSettings.fireSpreadChance = settings.fireSpreadChance;
        newSettings.isRedstoneConductor = settings.isRedstoneConductor;
        newSettings.isSuffocating = settings.isSuffocating;
        newSettings.isViewBlocking = settings.isViewBlocking;
        newSettings.correctTools = settings.correctTools;
        newSettings.fluidState = settings.fluidState;
        newSettings.blockLight = settings.blockLight;
        newSettings.name = settings.name;
        newSettings.incorrectToolSpeed = settings.incorrectToolSpeed;
        newSettings.supportShapeBlockState = settings.supportShapeBlockState;
        newSettings.propagatesSkylightDown = settings.propagatesSkylightDown;
        newSettings.useShapeForLightOcclusion = settings.useShapeForLightOcclusion;
        return newSettings;
    }

    public Set<Key> tags() {
        return this.tags;
    }

    public Key itemId() {
        return this.itemId;
    }

    public BlockSounds sounds() {
        return this.sounds;
    }

    public float resistance() {
        return this.resistance;
    }

    public boolean fluidState() {
        return this.fluidState;
    }

    public boolean isRandomlyTicking() {
        return this.isRandomlyTicking;
    }

    public boolean burnable() {
        return this.burnable;
    }

    public boolean replaceable() {
        return this.replaceable;
    }

    public float hardness() {
        return this.hardness;
    }

    public Tristate canOcclude() {
        return this.canOcclude;
    }

    public float incorrectToolSpeed() {
        return this.incorrectToolSpeed;
    }

    public boolean requireCorrectTool() {
        return this.requireCorrectTools || !this.correctTools.isEmpty();
    }

    public String name() {
        return this.name;
    }

    public MapColor mapColor() {
        return this.mapColor;
    }

    public PushReaction pushReaction() {
        return this.pushReaction;
    }

    public int luminance() {
        return this.luminance;
    }

    public Instrument instrument() {
        return this.instrument;
    }

    public int burnChance() {
        return this.burnChance;
    }

    public int fireSpreadChance() {
        return this.fireSpreadChance;
    }

    public Tristate isRedstoneConductor() {
        return this.isRedstoneConductor;
    }

    public Tristate isSuffocating() {
        return this.isSuffocating;
    }

    public Tristate isViewBlocking() {
        return this.isViewBlocking;
    }

    public int blockLight() {
        return this.blockLight;
    }

    public boolean isCorrectTool(Key key) {
        return this.correctTools.contains(key);
    }

    public boolean respectToolComponent() {
        return this.respectToolComponent;
    }

    public String supportShapeBlockState() {
        return this.supportShapeBlockState;
    }

    public Tristate propagatesSkylightDown() {
        return this.propagatesSkylightDown;
    }

    public Tristate useShapeForLightOcclusion() {
        return this.useShapeForLightOcclusion;
    }

    public BlockSettings correctTools(Set<Key> correctTools) {
        this.correctTools = correctTools;
        return this;
    }

    public BlockSettings burnChance(int burnChance) {
        this.burnChance = burnChance;
        return this;
    }

    public BlockSettings name(String name) {
        this.name = name;
        return this;
    }

    public BlockSettings fireSpreadChance(int fireSpreadChance) {
        this.fireSpreadChance = fireSpreadChance;
        return this;
    }

    public BlockSettings tags(Set<Key> tags) {
        this.tags = tags;
        return this;
    }

    public BlockSettings itemId(Key itemId) {
        this.itemId = itemId;
        return this;
    }

    public BlockSettings sounds(BlockSounds sounds) {
        this.sounds = sounds;
        return this;
    }

    public BlockSettings instrument(Instrument instrument) {
        this.instrument = instrument;
        return this;
    }

    public BlockSettings luminance(int luminance) {
        this.luminance = luminance;
        return this;
    }

    public BlockSettings pushReaction(PushReaction pushReaction) {
        this.pushReaction = pushReaction;
        return this;
    }

    public BlockSettings mapColor(MapColor mapColor) {
        this.mapColor = mapColor;
        return this;
    }

    public BlockSettings hardness(float hardness) {
        this.hardness = hardness;
        return this;
    }

    public BlockSettings resistance(float resistance) {
        this.resistance = resistance;
        return this;
    }

    public BlockSettings canOcclude(Tristate canOcclude) {
        this.canOcclude = canOcclude;
        return this;
    }

    public BlockSettings requireCorrectTool(boolean requireCorrectTool) {
        this.requireCorrectTools = requireCorrectTool;
        return this;
    }

    public BlockSettings respectToolComponent(boolean respectToolComponent) {
        this.respectToolComponent = respectToolComponent;
        return this;
    }

    public BlockSettings incorrectToolSpeed(float incorrectToolSpeed) {
        this.incorrectToolSpeed = incorrectToolSpeed;
        return this;
    }

    public BlockSettings isRandomlyTicking(boolean isRandomlyTicking) {
        this.isRandomlyTicking = isRandomlyTicking;
        return this;
    }

    public BlockSettings burnable(boolean burnable) {
        this.burnable = burnable;
        return this;
    }

    public BlockSettings propagatesSkylightDown(Tristate propagatesSkylightDown) {
        this.propagatesSkylightDown = propagatesSkylightDown;
        return this;
    }

    public BlockSettings blockLight(int intValue) {
        this.blockLight = intValue;
        return this;
    }

    public BlockSettings isRedstoneConductor(boolean isRedstoneConductor) {
        this.isRedstoneConductor = isRedstoneConductor ? Tristate.TRUE : Tristate.FALSE;
        return this;
    }

    public BlockSettings isSuffocating(boolean isSuffocating) {
        this.isSuffocating = isSuffocating ? Tristate.TRUE : Tristate.FALSE;
        return this;
    }

    public BlockSettings isViewBlocking(boolean isViewBlocking) {
        this.isViewBlocking = isViewBlocking ? Tristate.TRUE : Tristate.FALSE;
        return this;
    }

    public BlockSettings replaceable(boolean replaceable) {
        this.replaceable = replaceable;
        return this;
    }

    public BlockSettings fluidState(boolean state) {
        this.fluidState = state;
        return this;
    }

    public BlockSettings supportShapeBlockState(String supportShapeBlockState) {
        this.supportShapeBlockState = supportShapeBlockState;
        return this;
    }

    public BlockSettings useShapeForLightOcclusion(Tristate useShapeForLightOcclusion) {
        this.useShapeForLightOcclusion = useShapeForLightOcclusion;
        return this;
    }

    public static class Modifiers {
        private static final Map<String, Modifier.Factory> FACTORIES = new HashMap<String, Modifier.Factory>();

        private static void registerFactory(String id, Modifier.Factory factory) {
            FACTORIES.put(id, factory);
        }

        static {
            Modifiers.registerFactory("luminance", value -> {
                int intValue = ResourceConfigUtils.getAsInt(value, "luminance");
                return settings -> settings.luminance(intValue);
            });
            Modifiers.registerFactory("block-light", value -> {
                int intValue = ResourceConfigUtils.getAsInt(value, "block-light");
                return settings -> settings.blockLight(intValue);
            });
            Modifiers.registerFactory("hardness", value -> {
                float floatValue = ResourceConfigUtils.getAsFloat(value, "hardness");
                return settings -> settings.hardness(floatValue);
            });
            Modifiers.registerFactory("resistance", value -> {
                float floatValue = ResourceConfigUtils.getAsFloat(value, "resistance");
                return settings -> settings.resistance(floatValue);
            });
            Modifiers.registerFactory("is-randomly-ticking", value -> {
                boolean booleanValue = ResourceConfigUtils.getAsBoolean(value, "is-randomly-ticking");
                return settings -> settings.isRandomlyTicking(booleanValue);
            });
            Modifiers.registerFactory("propagate-skylight", value -> {
                boolean booleanValue = ResourceConfigUtils.getAsBoolean(value, "propagate-skylight");
                return settings -> settings.propagatesSkylightDown(booleanValue ? Tristate.TRUE : Tristate.FALSE);
            });
            Modifiers.registerFactory("push-reaction", value -> {
                PushReaction reaction = PushReaction.valueOf(value.toString().toUpperCase(Locale.ENGLISH));
                return settings -> settings.pushReaction(reaction);
            });
            Modifiers.registerFactory("map-color", value -> {
                int intValue = ResourceConfigUtils.getAsInt(value, "map-color");
                return settings -> settings.mapColor(MapColor.get(intValue));
            });
            Modifiers.registerFactory("burnable", value -> {
                boolean booleanValue = ResourceConfigUtils.getAsBoolean(value, "burnable");
                return settings -> settings.burnable(booleanValue);
            });
            Modifiers.registerFactory("instrument", value -> {
                Instrument instrument = Instrument.valueOf(value.toString().toUpperCase(Locale.ENGLISH));
                return settings -> settings.instrument(instrument);
            });
            Modifiers.registerFactory("item", value -> {
                Key item = Key.of(value.toString());
                return settings -> settings.itemId(item);
            });
            Modifiers.registerFactory("tags", value -> {
                List<String> tags = MiscUtils.getAsStringList(value);
                return settings -> settings.tags(tags.stream().map(Key::of).collect(Collectors.toSet()));
            });
            Modifiers.registerFactory("burn-chance", value -> {
                int intValue = ResourceConfigUtils.getAsInt(value, "burn-chance");
                return settings -> settings.burnChance(intValue);
            });
            Modifiers.registerFactory("fire-spread-chance", value -> {
                int intValue = ResourceConfigUtils.getAsInt(value, "fire-spread-chance");
                return settings -> settings.fireSpreadChance(intValue);
            });
            Modifiers.registerFactory("replaceable", value -> {
                boolean booleanValue = ResourceConfigUtils.getAsBoolean(value, "replaceable");
                return settings -> settings.replaceable(booleanValue);
            });
            Modifiers.registerFactory("is-redstone-conductor", value -> {
                boolean booleanValue = ResourceConfigUtils.getAsBoolean(value, "is-redstone-conductor");
                return settings -> settings.isRedstoneConductor(booleanValue);
            });
            Modifiers.registerFactory("is-suffocating", value -> {
                boolean booleanValue = ResourceConfigUtils.getAsBoolean(value, "is-suffocating");
                return settings -> settings.isSuffocating(booleanValue);
            });
            Modifiers.registerFactory("is-view-blocking", value -> {
                boolean booleanValue = ResourceConfigUtils.getAsBoolean(value, "is-view-blocking");
                return settings -> settings.isViewBlocking(booleanValue);
            });
            Modifiers.registerFactory("sounds", value -> {
                Map<String, Object> soundMap = MiscUtils.castToMap(value, false);
                return settings -> settings.sounds(BlockSounds.fromMap(soundMap));
            });
            Modifiers.registerFactory("fluid-state", value -> {
                String state = value.toString();
                return settings -> settings.fluidState(state.equals("water"));
            });
            Modifiers.registerFactory("can-occlude", value -> {
                boolean booleanValue = ResourceConfigUtils.getAsBoolean(value, "can-occlude");
                return settings -> settings.canOcclude(booleanValue ? Tristate.TRUE : Tristate.FALSE);
            });
            Modifiers.registerFactory("correct-tools", value -> {
                List<String> tools = MiscUtils.getAsStringList(value);
                return settings -> settings.correctTools(tools.stream().map(Key::of).collect(Collectors.toSet()));
            });
            Modifiers.registerFactory("require-correct-tools", value -> {
                boolean booleanValue = ResourceConfigUtils.getAsBoolean(value, "require-correct-tools");
                return settings -> settings.requireCorrectTool(booleanValue);
            });
            Modifiers.registerFactory("respect-tool-component", value -> {
                boolean booleanValue = ResourceConfigUtils.getAsBoolean(value, "respect-tool-component");
                return settings -> settings.respectToolComponent(booleanValue);
            });
            Modifiers.registerFactory("use-shape-for-light-occlusion", value -> {
                boolean booleanValue = ResourceConfigUtils.getAsBoolean(value, "use-shape-for-light-occlusion");
                return settings -> settings.useShapeForLightOcclusion(booleanValue ? Tristate.TRUE : Tristate.FALSE);
            });
            Modifiers.registerFactory("incorrect-tool-dig-speed", value -> {
                float floatValue = ResourceConfigUtils.getAsFloat(value, "incorrect-tool-dig-speed");
                return settings -> settings.incorrectToolSpeed(floatValue);
            });
            Modifiers.registerFactory("name", value -> {
                String name = value.toString();
                return settings -> settings.name(name);
            });
            Modifiers.registerFactory("support-shape", value -> {
                String shape = value.toString();
                return settings -> settings.supportShapeBlockState(shape);
            });
        }
    }

    @FunctionalInterface
    public static interface Modifier {
        public void apply(BlockSettings var1);

        @FunctionalInterface
        public static interface Factory {
            public Modifier createModifier(Object var1);
        }
    }
}

