/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.block;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.objects.Reference2ObjectArrayMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Stream;
import net.momirealms.craftengine.core.block.CustomBlock;
import net.momirealms.craftengine.core.block.ImmutableBlockState;
import net.momirealms.craftengine.core.block.properties.Property;
import net.momirealms.craftengine.core.registry.Holder;
import net.momirealms.craftengine.core.util.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BlockStateVariantProvider {
    private final ImmutableSortedMap<String, Property<?>> properties;
    private final ImmutableList<ImmutableBlockState> states;
    private final Holder<CustomBlock> owner;

    public BlockStateVariantProvider(Holder<CustomBlock> owner, Factory<Holder<CustomBlock>, ImmutableBlockState> factory, Map<String, Property<?>> propertiesMap) {
        this.owner = owner;
        this.properties = ImmutableSortedMap.copyOf(propertiesMap);
        ArrayList list = Lists.newArrayList();
        Stream<List<List<Object>>> stream = Stream.of(Collections.emptyList());
        LinkedHashMap map = Maps.newLinkedHashMap();
        for (Property property : this.properties.values()) {
            stream = stream.flatMap(entries -> {
                ArrayList streams = new ArrayList();
                for (Comparable value : property.possibleValues()) {
                    ArrayList<Pair<Property, Comparable>> newEntries = new ArrayList<Pair<Property, Comparable>>((Collection<Pair<Property, Comparable>>)entries);
                    newEntries.add(Pair.of(property, value));
                    streams.add(Stream.of(newEntries));
                }
                return streams.stream().flatMap(Function.identity());
            });
        }
        stream.forEach(entries -> {
            Reference2ObjectArrayMap reference2ObjectArrayMap = new Reference2ObjectArrayMap(entries.size());
            for (Pair entry : entries) {
                reference2ObjectArrayMap.put((Object)((Property)entry.left()), (Object)((Comparable)entry.right()));
            }
            ImmutableBlockState state = (ImmutableBlockState)factory.create(owner, reference2ObjectArrayMap);
            map.put(reference2ObjectArrayMap, state);
            list.add(state);
        });
        for (ImmutableBlockState state : list) {
            state.createWithMap(map);
        }
        this.states = ImmutableList.copyOf((Collection)list);
    }

    @NotNull
    public ImmutableBlockState getDefaultState() {
        ImmutableBlockState first = (ImmutableBlockState)this.states.getFirst();
        for (Property property : this.properties.values()) {
            first = ImmutableBlockState.with(first, property, property.defaultValue());
        }
        return first;
    }

    public ImmutableList<ImmutableBlockState> states() {
        return this.states;
    }

    public Holder<CustomBlock> owner() {
        return this.owner;
    }

    @Nullable
    public Property<?> getProperty(String name) {
        return (Property)this.properties.get((Object)name);
    }

    public static interface Factory<O, S> {
        public S create(O var1, Reference2ObjectArrayMap<Property<?>, Comparable<?>> var2);
    }
}

