/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.block;

import it.unimi.dsi.fastutil.objects.Reference2ObjectArrayMap;
import java.util.List;
import net.momirealms.craftengine.core.block.BlockBehavior;
import net.momirealms.craftengine.core.block.BlockSettings;
import net.momirealms.craftengine.core.block.BlockStateHolder;
import net.momirealms.craftengine.core.block.BlockStateWrapper;
import net.momirealms.craftengine.core.block.CustomBlock;
import net.momirealms.craftengine.core.block.EmptyBlock;
import net.momirealms.craftengine.core.block.properties.Property;
import net.momirealms.craftengine.core.entity.player.Player;
import net.momirealms.craftengine.core.item.Item;
import net.momirealms.craftengine.core.loot.LootTable;
import net.momirealms.craftengine.core.plugin.context.ContextHolder;
import net.momirealms.craftengine.core.plugin.context.parameter.DirectContextParameters;
import net.momirealms.craftengine.core.registry.Holder;
import net.momirealms.craftengine.core.world.World;
import net.momirealms.craftengine.libraries.nbt.CompoundTag;
import net.momirealms.craftengine.libraries.nbt.NBT;
import net.momirealms.craftengine.libraries.nbt.Tag;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ImmutableBlockState
extends BlockStateHolder {
    private CompoundTag tag;
    private BlockStateWrapper.CustomBlockState customBlockState;
    private BlockStateWrapper.VanillaBlockState vanillaBlockState;
    private BlockBehavior behavior;
    private Integer hashCode;
    private BlockSettings settings;

    ImmutableBlockState(Holder<CustomBlock> owner, Reference2ObjectArrayMap<Property<?>, Comparable<?>> propertyMap) {
        super(owner, propertyMap);
    }

    public BlockBehavior behavior() {
        return this.behavior;
    }

    public void setBehavior(BlockBehavior behavior) {
        this.behavior = behavior;
    }

    public BlockSettings settings() {
        return this.settings;
    }

    public void setSettings(BlockSettings settings) {
        this.settings = settings;
    }

    public boolean isEmpty() {
        return this == EmptyBlock.STATE;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ImmutableBlockState)) {
            return false;
        }
        ImmutableBlockState state = (ImmutableBlockState)o;
        return state.owner == this.owner && state.tag.equals(this.tag);
    }

    public int hashCode() {
        if (this.hashCode == null) {
            this.hashCode = this.getNbtToSave().hashCode();
        }
        return this.hashCode;
    }

    public BlockStateWrapper customBlockState() {
        return this.customBlockState;
    }

    public BlockStateWrapper vanillaBlockState() {
        return this.vanillaBlockState;
    }

    public void setCustomBlockState(@NotNull BlockStateWrapper.CustomBlockState customBlockState) {
        this.customBlockState = customBlockState;
    }

    public void setVanillaBlockState(@NotNull BlockStateWrapper.VanillaBlockState vanillaBlockState) {
        this.vanillaBlockState = vanillaBlockState;
    }

    public CompoundTag propertiesNbt() {
        CompoundTag properties = new CompoundTag();
        for (Property<?> property : this.getProperties()) {
            Object value = this.get(property);
            if (value != null) {
                properties.put(property.name(), ImmutableBlockState.pack(property, value));
                continue;
            }
            properties.put(property.name(), ImmutableBlockState.pack(property, property.defaultValue()));
        }
        return properties;
    }

    public static <T extends Comparable<T>> Tag pack(Property<T> property, Object value) {
        return property.pack((Comparable)value);
    }

    public CompoundTag getNbtToSave() {
        if (this.tag == null) {
            this.tag = this.toNbtToSave(this.propertiesNbt());
        }
        return this.tag;
    }

    public CompoundTag toNbtToSave(CompoundTag properties) {
        CompoundTag tag = new CompoundTag();
        tag.put("properties", properties);
        tag.put("id", NBT.createString(((CustomBlock)this.owner.value()).id().asString()));
        return tag;
    }

    public void setNbtToSave(CompoundTag tag) {
        this.tag = tag;
    }

    public static <T extends Comparable<T>> ImmutableBlockState with(ImmutableBlockState state, Property<T> property, Object value) {
        return state.with(property, (Comparable)value);
    }

    public List<Item<Object>> getDrops(@NotNull ContextHolder.Builder builder, @NotNull World world, @Nullable Player player) {
        CustomBlock block = (CustomBlock)this.owner.value();
        if (block == null) {
            return List.of();
        }
        LootTable<?> lootTable = block.lootTable();
        if (lootTable == null) {
            return List.of();
        }
        return lootTable.getRandomItems(builder.withParameter(DirectContextParameters.CUSTOM_BLOCK_STATE, this).build(), world, player);
    }
}

