/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.block.parser;

import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import net.momirealms.craftengine.core.block.CustomBlock;
import net.momirealms.craftengine.core.block.ImmutableBlockState;
import net.momirealms.craftengine.core.block.properties.Property;
import net.momirealms.craftengine.core.registry.BuiltInRegistries;
import net.momirealms.craftengine.core.registry.Holder;
import net.momirealms.craftengine.core.util.Key;
import net.momirealms.craftengine.core.util.StringReader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BlockStateParser {
    private static final char START = '[';
    private static final char EQUAL = '=';
    private static final char SEPARATOR = ',';
    private static final char END = ']';
    private final StringReader reader;
    private final int cursor;
    private final Set<String> suggestions = new HashSet<String>();
    private final Set<String> used = new HashSet<String>();
    private String input;
    private int replaceCursor;
    private Holder<CustomBlock> block;
    private Collection<Property<?>> properties;
    private Property<?> property;

    public BlockStateParser(String data, int cursor) {
        this.reader = StringReader.simple(data.toLowerCase());
        this.reader.setCursor(cursor);
        this.cursor = cursor;
        this.replaceCursor = cursor;
    }

    public static Set<String> fillSuggestions(@NotNull String data) {
        return BlockStateParser.fillSuggestions(data, 0);
    }

    public static Set<String> fillSuggestions(@NotNull String data, int cursor) {
        BlockStateParser parser = new BlockStateParser(data, cursor);
        parser.parse();
        return parser.suggestions;
    }

    private void parse() {
        this.readBlock();
        if (this.block == null) {
            this.suggestBlock();
            return;
        }
        this.readProperties();
        if (this.properties.isEmpty()) {
            return;
        }
        if (!this.reader.canRead()) {
            this.suggestStart();
        } else if (this.reader.peek() == '[') {
            this.reader.skip();
            this.suggestProperties();
        }
    }

    private void readBlock() {
        this.replaceCursor = this.reader.getCursor();
        this.input = this.reader.readUnquotedString();
        if (this.reader.canRead() && this.reader.peek() == ':') {
            this.reader.skip();
            this.input = this.input + ":" + this.reader.readUnquotedString();
        }
        BuiltInRegistries.BLOCK.get(Key.from(this.input)).ifPresent(block -> {
            this.block = block;
        });
    }

    private void suggestBlock() {
        String front = this.readPrefix();
        for (Key key : BuiltInRegistries.BLOCK.keySet()) {
            String id = key.toString();
            if (!id.contains(this.input)) continue;
            this.suggestions.add(front + id);
        }
        this.suggestions.remove(front + "craftengine:empty");
    }

    private void readProperties() {
        this.properties = this.block.value().properties();
    }

    private void suggestStart() {
        this.replaceCursor = this.reader.getCursor();
        this.suggestions.add(this.readPrefix() + "[");
    }

    private void suggestProperties() {
        this.reader.skipWhitespace();
        this.replaceCursor = this.reader.getCursor();
        this.suggestPropertyNameAndEnd();
        while (this.reader.canRead()) {
            if (this.used.isEmpty() && this.reader.peek() == ',') {
                return;
            }
            if (this.reader.peek() == ',') {
                this.reader.skip();
            }
            this.reader.skipWhitespace();
            if (this.reader.canRead() && this.reader.peek() == ']') {
                return;
            }
            this.replaceCursor = this.reader.getCursor();
            this.input = this.reader.readString();
            this.property = this.block.value().getProperty(this.input);
            if (this.property == null) {
                this.suggestPropertyName();
                return;
            }
            if (this.used.contains(this.property.name().toLowerCase())) {
                return;
            }
            this.used.add(this.input);
            this.reader.skipWhitespace();
            this.replaceCursor = this.reader.getCursor();
            this.suggestEqual();
            if (!this.reader.canRead() || this.reader.peek() != '=') {
                return;
            }
            this.reader.skip();
            this.reader.skipWhitespace();
            this.replaceCursor = this.reader.getCursor();
            this.input = this.reader.readString();
            if (this.property.possibleValues().stream().noneMatch(value -> value.toString().equalsIgnoreCase(this.input))) {
                this.suggestValue();
                return;
            }
            this.reader.skipWhitespace();
            this.replaceCursor = this.reader.getCursor();
            if (this.reader.canRead()) {
                if (this.used.size() == this.properties.size()) {
                    return;
                }
                if (this.reader.peek() == ',') continue;
                return;
            }
            if (this.used.size() >= this.properties.size()) continue;
            this.suggestSeparator();
        }
        this.suggestEnd();
    }

    private void suggestPropertyNameAndEnd() {
        if (!this.reader.getRemaining().isEmpty()) {
            return;
        }
        this.input = "";
        this.suggestEnd();
        this.suggestPropertyName();
    }

    private void suggestPropertyName() {
        if (!this.reader.getRemaining().isEmpty()) {
            return;
        }
        String front = this.readPrefix();
        for (Property<?> p : this.properties) {
            if (this.used.contains(p.name().toLowerCase()) || !p.name().toLowerCase().startsWith(this.input)) continue;
            this.suggestions.add(front + p.name() + "=");
        }
    }

    private void suggestEqual() {
        if (!this.reader.getRemaining().isEmpty()) {
            return;
        }
        this.suggestions.add(this.readPrefix() + "=");
    }

    private void suggestValue() {
        for (Object val : this.property.possibleValues()) {
            this.suggestions.add(this.readPrefix() + val.toString().toLowerCase());
        }
    }

    private void suggestSeparator() {
        this.suggestions.add(this.readPrefix() + ",");
    }

    private void suggestEnd() {
        this.suggestions.add(this.readPrefix() + "]");
    }

    private String readPrefix() {
        return this.reader.getString().substring(this.cursor, this.replaceCursor);
    }

    @Nullable
    public static ImmutableBlockState deserialize(@NotNull String data) {
        Optional<Holder.Reference<CustomBlock>> optional;
        StringReader reader = StringReader.simple(data);
        Object blockIdString = reader.readUnquotedString();
        if (reader.canRead() && reader.peek() == ':') {
            reader.skip();
            blockIdString = (String)blockIdString + ":" + reader.readUnquotedString();
        }
        if ((optional = BuiltInRegistries.BLOCK.get(Key.from((String)blockIdString))).isEmpty()) {
            return null;
        }
        Holder holder = optional.get();
        ImmutableBlockState defaultState = ((CustomBlock)holder.value()).defaultState();
        if (reader.canRead() && reader.peek() == '[') {
            reader.skip();
            while (reader.canRead()) {
                Optional<?> optionalValue;
                reader.skipWhitespace();
                if (reader.peek() == ']') break;
                String propertyName = reader.readUnquotedString();
                reader.skipWhitespace();
                if (!reader.canRead() || reader.peek() != '=') {
                    return null;
                }
                reader.skip();
                reader.skipWhitespace();
                String propertyValue = reader.readUnquotedString();
                Property<?> property = ((CustomBlock)holder.value()).getProperty(propertyName);
                if (property != null) {
                    optionalValue = property.optional(propertyValue);
                    if (optionalValue.isEmpty()) {
                        return null;
                    }
                } else {
                    return null;
                }
                defaultState = ImmutableBlockState.with(defaultState, property, optionalValue.get());
                reader.skipWhitespace();
                if (!reader.canRead() || reader.peek() != ',') continue;
                reader.skip();
            }
            reader.skipWhitespace();
            if (reader.canRead() && reader.peek() == ']') {
                reader.skip();
            } else {
                return null;
            }
        }
        return defaultState;
    }
}

