/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.block.properties;

import java.util.Map;
import net.momirealms.craftengine.core.block.properties.BooleanProperty;
import net.momirealms.craftengine.core.block.properties.EnumProperty;
import net.momirealms.craftengine.core.block.properties.IntegerProperty;
import net.momirealms.craftengine.core.block.properties.Property;
import net.momirealms.craftengine.core.block.properties.PropertyFactory;
import net.momirealms.craftengine.core.block.properties.StringProperty;
import net.momirealms.craftengine.core.block.state.properties.DoorHinge;
import net.momirealms.craftengine.core.block.state.properties.DoubleBlockHalf;
import net.momirealms.craftengine.core.block.state.properties.SingleBlockHalf;
import net.momirealms.craftengine.core.block.state.properties.SlabType;
import net.momirealms.craftengine.core.block.state.properties.StairsShape;
import net.momirealms.craftengine.core.plugin.locale.LocalizedResourceConfigException;
import net.momirealms.craftengine.core.registry.BuiltInRegistries;
import net.momirealms.craftengine.core.registry.Holder;
import net.momirealms.craftengine.core.registry.Registries;
import net.momirealms.craftengine.core.registry.WritableRegistry;
import net.momirealms.craftengine.core.util.Direction;
import net.momirealms.craftengine.core.util.HorizontalDirection;
import net.momirealms.craftengine.core.util.Key;
import net.momirealms.craftengine.core.util.ResourceConfigUtils;
import net.momirealms.craftengine.core.util.ResourceKey;

public class Properties {
    public static final Key BOOLEAN = Key.of("craftengine:boolean");
    public static final Key INT = Key.of("craftengine:int");
    public static final Key STRING = Key.of("craftengine:string");
    public static final Key AXIS = Key.of("craftengine:axis");
    public static final Key HORIZONTAL_DIRECTION = Key.of("craftengine:horizontal_direction");
    public static final Key DIRECTION = Key.of("craftengine:direction");
    public static final Key SINGLE_BLOCK_HALF = Key.of("craftengine:single_block_half");
    public static final Key DOUBLE_BLOCK_HALF = Key.of("craftengine:double_block_half");
    public static final Key HINGE = Key.of("craftengine:hinge");
    public static final Key STAIRS_SHAPE = Key.of("craftengine:stairs_shape");
    public static final Key SLAB_TYPE = Key.of("craftengine:slab_type");

    public static void register(Key key, PropertyFactory factory) {
        Holder.Reference<PropertyFactory> holder = ((WritableRegistry)BuiltInRegistries.PROPERTY_FACTORY).registerForHolder(new ResourceKey(Registries.PROPERTY_FACTORY.location(), key));
        holder.bindValue(factory);
    }

    public static Property<?> fromMap(String name, Map<String, Object> map) {
        String type = ResourceConfigUtils.requireNonEmptyStringOrThrow(map.get("type"), "warning.config.block.state.property.missing_type");
        Key key = Key.withDefaultNamespace(type, "craftengine");
        PropertyFactory factory = BuiltInRegistries.PROPERTY_FACTORY.getValue(key);
        if (factory == null) {
            throw new LocalizedResourceConfigException("warning.config.block.state.property.invalid_type", key.toString(), name);
        }
        return factory.create(name, map);
    }

    static {
        Properties.register(BOOLEAN, BooleanProperty.FACTORY);
        Properties.register(INT, IntegerProperty.FACTORY);
        Properties.register(STRING, StringProperty.FACTORY);
        Properties.register(AXIS, new EnumProperty.Factory<Direction.Axis>(Direction.Axis.class));
        Properties.register(DIRECTION, new EnumProperty.Factory<Direction>(Direction.class));
        Properties.register(Key.of("craftengine:6-direction"), new EnumProperty.Factory<Direction>(Direction.class));
        Properties.register(HORIZONTAL_DIRECTION, new EnumProperty.Factory<HorizontalDirection>(HorizontalDirection.class));
        Properties.register(Key.of("craftengine:4-direction"), new EnumProperty.Factory<HorizontalDirection>(HorizontalDirection.class));
        Properties.register(SINGLE_BLOCK_HALF, new EnumProperty.Factory<SingleBlockHalf>(SingleBlockHalf.class));
        Properties.register(DOUBLE_BLOCK_HALF, new EnumProperty.Factory<DoubleBlockHalf>(DoubleBlockHalf.class));
        Properties.register(HINGE, new EnumProperty.Factory<DoorHinge>(DoorHinge.class));
        Properties.register(STAIRS_SHAPE, new EnumProperty.Factory<StairsShape>(StairsShape.class));
        Properties.register(SLAB_TYPE, new EnumProperty.Factory<SlabType>(SlabType.class));
    }
}

