/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.entity.furniture;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import net.momirealms.craftengine.core.entity.Billboard;
import net.momirealms.craftengine.core.entity.ItemDisplayContext;
import net.momirealms.craftengine.core.entity.furniture.AlignmentRule;
import net.momirealms.craftengine.core.entity.furniture.AnchorType;
import net.momirealms.craftengine.core.entity.furniture.CustomFurniture;
import net.momirealms.craftengine.core.entity.furniture.FurnitureElement;
import net.momirealms.craftengine.core.entity.furniture.FurnitureManager;
import net.momirealms.craftengine.core.entity.furniture.FurnitureSettings;
import net.momirealms.craftengine.core.entity.furniture.HitBox;
import net.momirealms.craftengine.core.entity.furniture.HitBoxTypes;
import net.momirealms.craftengine.core.entity.furniture.RotationRule;
import net.momirealms.craftengine.core.loot.LootTable;
import net.momirealms.craftengine.core.pack.Pack;
import net.momirealms.craftengine.core.plugin.CraftEngine;
import net.momirealms.craftengine.core.plugin.config.ConfigParser;
import net.momirealms.craftengine.core.plugin.context.event.EventFunctions;
import net.momirealms.craftengine.core.plugin.locale.LocalizedResourceConfigException;
import net.momirealms.craftengine.core.util.Key;
import net.momirealms.craftengine.core.util.MiscUtils;
import net.momirealms.craftengine.core.util.ResourceConfigUtils;
import net.momirealms.craftengine.libraries.cloud.suggestion.Suggestion;
import org.joml.Vector3f;

public abstract class AbstractFurnitureManager
implements FurnitureManager {
    protected final Map<Key, CustomFurniture> byId = new HashMap<Key, CustomFurniture>();
    private final CraftEngine plugin;
    private final FurnitureParser furnitureParser;
    private final List<Suggestion> cachedSuggestions = new ArrayList<Suggestion>();

    public AbstractFurnitureManager(CraftEngine plugin) {
        this.plugin = plugin;
        this.furnitureParser = new FurnitureParser();
    }

    @Override
    public ConfigParser parser() {
        return this.furnitureParser;
    }

    @Override
    public void delayedLoad() {
        this.initSuggestions();
    }

    @Override
    public void initSuggestions() {
        this.cachedSuggestions.clear();
        for (Key key : this.byId.keySet()) {
            this.cachedSuggestions.add(Suggestion.suggestion((String)key.toString()));
        }
    }

    @Override
    public Collection<Suggestion> cachedSuggestions() {
        return Collections.unmodifiableCollection(this.cachedSuggestions);
    }

    @Override
    public Optional<CustomFurniture> furnitureById(Key id) {
        return Optional.ofNullable(this.byId.get(id));
    }

    @Override
    public void unload() {
        this.byId.clear();
    }

    protected abstract HitBox defaultHitBox();

    protected abstract FurnitureElement.Builder furnitureElementBuilder();

    protected abstract CustomFurniture.Builder furnitureBuilder();

    public class FurnitureParser
    implements ConfigParser {
        public static final String[] CONFIG_SECTION_NAME = new String[]{"furniture"};

        @Override
        public String[] sectionId() {
            return CONFIG_SECTION_NAME;
        }

        @Override
        public int loadingSequence() {
            return 60;
        }

        @Override
        public void parseSection(Pack pack, Path path, Key id, Map<String, Object> section) {
            if (AbstractFurnitureManager.this.byId.containsKey(id)) {
                throw new LocalizedResourceConfigException("warning.config.furniture.duplicate", new String[0]);
            }
            EnumMap<AnchorType, CustomFurniture.Placement> placements = new EnumMap<AnchorType, CustomFurniture.Placement>(AnchorType.class);
            Object placementObj = section.get("placement");
            if (placementObj == null && section.containsKey("material")) {
                AbstractFurnitureManager.this.plugin.itemManager().parser().parseSection(pack, path, id, section);
                return;
            }
            Map<String, Object> placementMap = MiscUtils.castToMap(ResourceConfigUtils.requireNonNullOrThrow(placementObj, "warning.config.furniture.missing_placement"), false);
            if (placementMap.isEmpty()) {
                throw new LocalizedResourceConfigException("warning.config.furniture.missing_placement", new String[0]);
            }
            for (Map.Entry<String, Object> entry : placementMap.entrySet()) {
                Map<String, Object> ruleSection;
                AnchorType anchorType = AnchorType.valueOf(entry.getKey().toUpperCase(Locale.ENGLISH));
                Map<String, Object> placementArguments = MiscUtils.castToMap(entry.getValue(), false);
                Optional<Vector3f> optionalLootSpawnOffset = Optional.ofNullable(placementArguments.get("loot-spawn-offset")).map(it -> MiscUtils.getAsVector3f(it, "loot-spawn-offset"));
                ArrayList<FurnitureElement> elements = new ArrayList<FurnitureElement>();
                List elementConfigs = placementArguments.getOrDefault("elements", List.of());
                for (Map element : elementConfigs) {
                    FurnitureElement furnitureElement = AbstractFurnitureManager.this.furnitureElementBuilder().item(Key.of(ResourceConfigUtils.requireNonEmptyStringOrThrow(element.get("item"), "warning.config.furniture.element.missing_item"))).applyDyedColor(ResourceConfigUtils.getAsBoolean(element.getOrDefault("apply-dyed-color", true), "apply-dyed-color")).billboard(ResourceConfigUtils.getOrDefault(element.get("billboard"), o -> Billboard.valueOf(o.toString().toUpperCase(Locale.ENGLISH)), Billboard.FIXED)).transform(ResourceConfigUtils.getOrDefault(element.get("transform"), o -> ItemDisplayContext.valueOf(o.toString().toUpperCase(Locale.ENGLISH)), ItemDisplayContext.NONE)).scale(MiscUtils.getAsVector3f(element.getOrDefault("scale", "1"), "scale")).position(MiscUtils.getAsVector3f(element.getOrDefault("position", "0"), "position")).translation(MiscUtils.getAsVector3f(element.getOrDefault("translation", "0"), "translation")).rotation(MiscUtils.getAsQuaternionf(element.getOrDefault("rotation", "0"), "rotation")).build();
                    elements.add(furnitureElement);
                }
                Optional<Object> externalModel = placementArguments.containsKey("model-engine") ? Optional.of(AbstractFurnitureManager.this.plugin.compatibilityManager().createModel("ModelEngine", placementArguments.get("model-engine").toString())) : (placementArguments.containsKey("better-model") ? Optional.of(AbstractFurnitureManager.this.plugin.compatibilityManager().createModel("BetterModel", placementArguments.get("better-model").toString())) : Optional.empty());
                List<HitBox> hitboxes = ResourceConfigUtils.parseConfigAsList(placementArguments.get("hitboxes"), HitBoxTypes::fromMap);
                if (hitboxes.isEmpty() && externalModel.isEmpty()) {
                    hitboxes = List.of(AbstractFurnitureManager.this.defaultHitBox());
                }
                if ((ruleSection = MiscUtils.castToMap(placementArguments.get("rules"), true)) != null) {
                    placements.put(anchorType, new CustomFurniture.Placement(anchorType, elements.toArray(new FurnitureElement[0]), hitboxes.toArray(new HitBox[0]), ResourceConfigUtils.getOrDefault(ruleSection.get("rotation"), o -> RotationRule.valueOf(o.toString().toUpperCase(Locale.ENGLISH)), RotationRule.ANY), ResourceConfigUtils.getOrDefault(ruleSection.get("alignment"), o -> AlignmentRule.valueOf(o.toString().toUpperCase(Locale.ENGLISH)), AlignmentRule.CENTER), externalModel, optionalLootSpawnOffset));
                    continue;
                }
                placements.put(anchorType, new CustomFurniture.Placement(anchorType, elements.toArray(new FurnitureElement[0]), hitboxes.toArray(new HitBox[0]), RotationRule.ANY, AlignmentRule.CENTER, externalModel, optionalLootSpawnOffset));
            }
            CustomFurniture furniture = AbstractFurnitureManager.this.furnitureBuilder().id(id).settings(FurnitureSettings.fromMap(MiscUtils.castToMap(section.get("settings"), true))).placement(placements).events(EventFunctions.parseEvents(ResourceConfigUtils.get(section, "events", "event"))).lootTable(LootTable.fromMap(MiscUtils.castToMap(section.get("loot"), true))).build();
            AbstractFurnitureManager.this.byId.put(id, furniture);
        }
    }
}

