/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.entity.furniture;

import java.util.Map;
import java.util.Optional;
import net.momirealms.craftengine.core.entity.furniture.HitBox;
import net.momirealms.craftengine.core.entity.furniture.HitBoxFactory;
import net.momirealms.craftengine.core.plugin.locale.LocalizedResourceConfigException;
import net.momirealms.craftengine.core.registry.BuiltInRegistries;
import net.momirealms.craftengine.core.registry.Holder;
import net.momirealms.craftengine.core.registry.Registries;
import net.momirealms.craftengine.core.registry.WritableRegistry;
import net.momirealms.craftengine.core.util.Key;
import net.momirealms.craftengine.core.util.ResourceKey;

public class HitBoxTypes {
    public static final Key INTERACTION = Key.of("minecraft:interaction");
    public static final Key SHULKER = Key.of("minecraft:shulker");
    public static final Key HAPPY_GHAST = Key.of("minecraft:happy_ghast");
    public static final Key CUSTOM = Key.of("minecraft:custom");

    public static void register(Key key, HitBoxFactory factory) {
        Holder.Reference<HitBoxFactory> holder = ((WritableRegistry)BuiltInRegistries.HITBOX_FACTORY).registerForHolder(new ResourceKey(Registries.HITBOX_FACTORY.location(), key));
        holder.bindValue(factory);
    }

    public static HitBox fromMap(Map<String, Object> arguments) {
        Key type = Optional.ofNullable(arguments.get("type")).map(String::valueOf).map(Key::of).orElse(INTERACTION);
        HitBoxFactory factory = BuiltInRegistries.HITBOX_FACTORY.getValue(type);
        if (factory == null) {
            throw new LocalizedResourceConfigException("warning.config.furniture.hitbox.invalid_type", type.toString());
        }
        return factory.create(arguments);
    }
}

