/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.font;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.function.Supplier;
import net.momirealms.craftengine.core.util.CharacterUtils;
import net.momirealms.craftengine.core.util.FormatUtils;
import net.momirealms.craftengine.libraries.adventure.key.Key;
import net.momirealms.craftengine.libraries.adventure.text.Component;

public class BitmapImage
implements Supplier<JsonObject> {
    private final net.momirealms.craftengine.core.util.Key id;
    private final net.momirealms.craftengine.core.util.Key font;
    private final int height;
    private final int ascent;
    private final String file;
    private final int[][] codepointGrid;

    public BitmapImage(net.momirealms.craftengine.core.util.Key id, net.momirealms.craftengine.core.util.Key font, int height, int ascent, String file, int[][] codepointGrid) {
        this.id = id;
        this.font = font;
        this.height = height;
        this.ascent = ascent;
        this.file = file;
        this.codepointGrid = codepointGrid;
    }

    public String miniMessageAt(int row, int col) {
        int codepoint = this.codepointGrid[row][col];
        return FormatUtils.miniMessageFont(new String(Character.toChars(codepoint)), this.font.toString());
    }

    public int height() {
        return this.height;
    }

    public int ascent() {
        return this.ascent;
    }

    public String file() {
        return this.file;
    }

    public net.momirealms.craftengine.core.util.Key font() {
        return this.font;
    }

    public net.momirealms.craftengine.core.util.Key id() {
        return this.id;
    }

    public int[][] codepointGrid() {
        return (int[][])this.codepointGrid.clone();
    }

    public int rows() {
        return this.codepointGrid.length;
    }

    public int columns() {
        return this.codepointGrid[0].length;
    }

    public int codepointAt(int row, int column) {
        if (!this.isValidCoordinate(row, column)) {
            throw new IndexOutOfBoundsException("Invalid index: (" + row + ", " + column + ") for image " + String.valueOf(this.id()));
        }
        return this.codepointGrid[row][column];
    }

    public Component componentAt(int row, int column) {
        int codepoint = this.codepointAt(row, column);
        return Component.text((String)new String(Character.toChars(codepoint))).font(Key.key((String)this.font().toString()));
    }

    public boolean isValidCoordinate(int row, int column) {
        return row >= 0 && row < this.codepointGrid.length && column >= 0 && column < this.codepointGrid[row].length;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        BitmapImage image = (BitmapImage)object;
        return this.id.equals(image.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    @Override
    public JsonObject get() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("type", "bitmap");
        jsonObject.addProperty("height", (Number)this.height);
        jsonObject.addProperty("ascent", (Number)this.ascent);
        jsonObject.addProperty("file", this.file);
        JsonArray charArray = new JsonArray();
        jsonObject.add("chars", (JsonElement)charArray);
        for (int[] codepoints : this.codepointGrid) {
            StringBuilder stringBuilder = new StringBuilder();
            for (int codepoint : codepoints) {
                stringBuilder.append(CharacterUtils.encodeCharsToUnicode(Character.toChars(codepoint)));
            }
            charArray.add(stringBuilder.toString());
        }
        return jsonObject;
    }
}

