/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.item;

import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.momirealms.craftengine.core.item.CustomItem;
import net.momirealms.craftengine.core.item.ItemSettings;
import net.momirealms.craftengine.core.item.behavior.ItemBehavior;
import net.momirealms.craftengine.core.item.modifier.ItemDataModifier;
import net.momirealms.craftengine.core.plugin.context.PlayerOptionalContext;
import net.momirealms.craftengine.core.plugin.context.event.EventTrigger;
import net.momirealms.craftengine.core.plugin.context.function.Function;
import net.momirealms.craftengine.core.registry.Holder;
import net.momirealms.craftengine.core.util.Key;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractCustomItem<I>
implements CustomItem<I> {
    protected final Holder<Key> id;
    protected final Key material;
    protected final Key clientBoundMaterial;
    protected final ItemDataModifier<I>[] modifiers;
    protected final Map<String, ItemDataModifier<I>> modifierMap;
    protected final ItemDataModifier<I>[] clientBoundModifiers;
    protected final Map<String, ItemDataModifier<I>> clientBoundModifierMap;
    protected final List<ItemBehavior> behaviors;
    protected final ItemSettings settings;
    protected final Map<EventTrigger, List<Function<PlayerOptionalContext>>> events;

    public AbstractCustomItem(Holder<Key> id, Key material, Key clientBoundMaterial, List<ItemBehavior> behaviors, List<ItemDataModifier<I>> modifiers, List<ItemDataModifier<I>> clientBoundModifiers, ItemSettings settings, Map<EventTrigger, List<Function<PlayerOptionalContext>>> events) {
        this.id = id;
        this.material = material;
        this.clientBoundMaterial = clientBoundMaterial;
        this.events = events;
        this.modifiers = modifiers.toArray(new ItemDataModifier[0]);
        this.clientBoundModifiers = clientBoundModifiers.toArray(new ItemDataModifier[0]);
        this.behaviors = List.copyOf(behaviors);
        this.settings = settings;
        ImmutableMap.Builder modifierMapBuilder = ImmutableMap.builder();
        for (ItemDataModifier<I> modifier : modifiers) {
            modifierMapBuilder.put((Object)modifier.name(), modifier);
        }
        this.modifierMap = modifierMapBuilder.build();
        ImmutableMap.Builder clientSideModifierMapBuilder = ImmutableMap.builder();
        this.clientBoundModifierMap = clientSideModifierMapBuilder.build();
    }

    @Override
    public void execute(PlayerOptionalContext context, EventTrigger trigger) {
        for (Function function : Optional.ofNullable(this.events.get((Object)trigger)).orElse(Collections.emptyList())) {
            function.run(context);
        }
    }

    @Override
    public Key id() {
        return this.id.value();
    }

    @Override
    public Holder<Key> idHolder() {
        return this.id;
    }

    @Override
    public Key material() {
        return this.material;
    }

    @Override
    public Key clientBoundMaterial() {
        return this.clientBoundMaterial;
    }

    @Override
    public ItemDataModifier<I>[] dataModifiers() {
        return this.modifiers;
    }

    @Override
    public Map<String, ItemDataModifier<I>> dataModifierMap() {
        return this.modifierMap;
    }

    @Override
    public boolean hasClientBoundDataModifier() {
        return this.clientBoundModifiers.length != 0;
    }

    @Override
    public ItemDataModifier<I>[] clientBoundDataModifiers() {
        return this.clientBoundModifiers;
    }

    @Override
    public Map<String, ItemDataModifier<I>> clientBoundDataModifierMap() {
        return this.clientBoundModifierMap;
    }

    @Override
    public ItemSettings settings() {
        return this.settings;
    }

    @Override
    @NotNull
    public List<ItemBehavior> behaviors() {
        return this.behaviors;
    }
}

