/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.item;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import net.momirealms.craftengine.core.item.CustomItem;
import net.momirealms.craftengine.core.item.ExternalItemProvider;
import net.momirealms.craftengine.core.item.ItemKeys;
import net.momirealms.craftengine.core.item.ItemManager;
import net.momirealms.craftengine.core.item.ItemSettings;
import net.momirealms.craftengine.core.item.behavior.ItemBehavior;
import net.momirealms.craftengine.core.item.behavior.ItemBehaviors;
import net.momirealms.craftengine.core.item.data.Enchantment;
import net.momirealms.craftengine.core.item.data.JukeboxPlayable;
import net.momirealms.craftengine.core.item.modifier.ArgumentModifier;
import net.momirealms.craftengine.core.item.modifier.ComponentModifier;
import net.momirealms.craftengine.core.item.modifier.CustomModelDataModifier;
import net.momirealms.craftengine.core.item.modifier.CustomNameModifier;
import net.momirealms.craftengine.core.item.modifier.DyedColorModifier;
import net.momirealms.craftengine.core.item.modifier.DynamicLoreModifier;
import net.momirealms.craftengine.core.item.modifier.EnchantmentModifier;
import net.momirealms.craftengine.core.item.modifier.EquippableModifier;
import net.momirealms.craftengine.core.item.modifier.ExternalModifier;
import net.momirealms.craftengine.core.item.modifier.FoodModifier;
import net.momirealms.craftengine.core.item.modifier.IdModifier;
import net.momirealms.craftengine.core.item.modifier.ItemDataModifier;
import net.momirealms.craftengine.core.item.modifier.ItemModelModifier;
import net.momirealms.craftengine.core.item.modifier.ItemNameModifier;
import net.momirealms.craftengine.core.item.modifier.JukeboxSongModifier;
import net.momirealms.craftengine.core.item.modifier.LoreModifier;
import net.momirealms.craftengine.core.item.modifier.RemoveComponentModifier;
import net.momirealms.craftengine.core.item.modifier.TagsModifier;
import net.momirealms.craftengine.core.item.modifier.TooltipStyleModifier;
import net.momirealms.craftengine.core.item.modifier.TrimModifier;
import net.momirealms.craftengine.core.item.modifier.UnbreakableModifier;
import net.momirealms.craftengine.core.item.setting.EquipmentData;
import net.momirealms.craftengine.core.item.setting.ItemEquipment;
import net.momirealms.craftengine.core.pack.Pack;
import net.momirealms.craftengine.core.pack.ResourceLocation;
import net.momirealms.craftengine.core.pack.misc.Equipment;
import net.momirealms.craftengine.core.pack.model.BaseItemModel;
import net.momirealms.craftengine.core.pack.model.ConditionItemModel;
import net.momirealms.craftengine.core.pack.model.ItemModel;
import net.momirealms.craftengine.core.pack.model.ItemModels;
import net.momirealms.craftengine.core.pack.model.LegacyItemModel;
import net.momirealms.craftengine.core.pack.model.LegacyModelPredicate;
import net.momirealms.craftengine.core.pack.model.LegacyOverridesModel;
import net.momirealms.craftengine.core.pack.model.ModernItemModel;
import net.momirealms.craftengine.core.pack.model.RangeDispatchItemModel;
import net.momirealms.craftengine.core.pack.model.SelectItemModel;
import net.momirealms.craftengine.core.pack.model.SpecialItemModel;
import net.momirealms.craftengine.core.pack.model.condition.ConditionProperty;
import net.momirealms.craftengine.core.pack.model.generation.AbstractModelGenerator;
import net.momirealms.craftengine.core.pack.model.generation.ModelGeneration;
import net.momirealms.craftengine.core.pack.model.rangedisptach.RangeDispatchProperty;
import net.momirealms.craftengine.core.pack.model.select.ChargeTypeSelectProperty;
import net.momirealms.craftengine.core.pack.model.select.SelectProperty;
import net.momirealms.craftengine.core.pack.model.select.TrimMaterialSelectProperty;
import net.momirealms.craftengine.core.plugin.CraftEngine;
import net.momirealms.craftengine.core.plugin.config.Config;
import net.momirealms.craftengine.core.plugin.config.ConfigParser;
import net.momirealms.craftengine.core.plugin.context.event.EventFunctions;
import net.momirealms.craftengine.core.plugin.context.text.TextProvider;
import net.momirealms.craftengine.core.plugin.context.text.TextProviders;
import net.momirealms.craftengine.core.plugin.locale.LocalizedResourceConfigException;
import net.momirealms.craftengine.core.plugin.locale.TranslationManager;
import net.momirealms.craftengine.core.registry.BuiltInRegistries;
import net.momirealms.craftengine.core.registry.Holder;
import net.momirealms.craftengine.core.registry.WritableRegistry;
import net.momirealms.craftengine.core.util.Key;
import net.momirealms.craftengine.core.util.MCUtils;
import net.momirealms.craftengine.core.util.MinecraftVersions;
import net.momirealms.craftengine.core.util.MiscUtils;
import net.momirealms.craftengine.core.util.ResourceConfigUtils;
import net.momirealms.craftengine.core.util.ResourceKey;
import net.momirealms.craftengine.core.util.TypeUtils;
import net.momirealms.craftengine.core.util.VersionHelper;
import net.momirealms.craftengine.libraries.cloud.suggestion.Suggestion;
import net.momirealms.craftengine.libraries.cloud.type.Either;
import org.joml.Vector3f;

public abstract class AbstractItemManager<I>
extends AbstractModelGenerator
implements ItemManager<I> {
    protected static final Map<Key, List<ItemBehavior>> VANILLA_ITEM_EXTRA_BEHAVIORS = new HashMap<Key, List<ItemBehavior>>();
    protected static final Set<Key> VANILLA_ITEMS = new HashSet<Key>(1024);
    protected static final Map<Key, List<Holder<Key>>> VANILLA_ITEM_TAGS = new HashMap<Key, List<Holder<Key>>>();
    private final ItemParser itemParser;
    protected final Map<String, ExternalItemProvider<I>> externalItemProviders = new HashMap<String, ExternalItemProvider<I>>();
    protected final Map<String, Function<Object, ItemDataModifier<I>>> dataFunctions = new HashMap<String, Function<Object, ItemDataModifier<I>>>();
    protected final Map<Key, CustomItem<I>> customItems = new HashMap<Key, CustomItem<I>>();
    protected final Map<Key, List<Holder<Key>>> customItemTags;
    protected final Map<Key, Map<Integer, Key>> cmdConflictChecker;
    protected final Map<Key, ModernItemModel> modernItemModels1_21_4;
    protected final Map<Key, TreeSet<LegacyOverridesModel>> modernItemModels1_21_2;
    protected final Map<Key, TreeSet<LegacyOverridesModel>> legacyOverrides;
    protected final Map<Key, TreeMap<Integer, ModernItemModel>> modernOverrides;
    protected final Map<Key, Equipment> equipmentsToGenerate;
    protected final List<Suggestion> cachedSuggestions = new ArrayList<Suggestion>();
    protected final List<Suggestion> cachedTotemSuggestions = new ArrayList<Suggestion>();

    protected AbstractItemManager(CraftEngine plugin) {
        super(plugin);
        this.itemParser = new ItemParser();
        this.registerFunctions();
        this.legacyOverrides = new HashMap<Key, TreeSet<LegacyOverridesModel>>();
        this.modernOverrides = new HashMap<Key, TreeMap<Integer, ModernItemModel>>();
        this.customItemTags = new HashMap<Key, List<Holder<Key>>>();
        this.cmdConflictChecker = new HashMap<Key, Map<Integer, Key>>();
        this.modernItemModels1_21_4 = new HashMap<Key, ModernItemModel>();
        this.modernItemModels1_21_2 = new HashMap<Key, TreeSet<LegacyOverridesModel>>();
        this.equipmentsToGenerate = new HashMap<Key, Equipment>();
    }

    @Override
    public void registerDataType(Function<Object, ItemDataModifier<I>> factory, String ... alias) {
        for (String a : alias) {
            this.dataFunctions.put(a, factory);
        }
    }

    protected static void registerVanillaItemExtraBehavior(ItemBehavior behavior, Key ... items) {
        for (Key key : items) {
            VANILLA_ITEM_EXTRA_BEHAVIORS.computeIfAbsent(key, k -> new ArrayList()).add(behavior);
        }
    }

    protected void applyDataFunctions(Map<String, Object> dataSection, Consumer<ItemDataModifier<I>> consumer) {
        if (dataSection != null) {
            for (Map.Entry<String, Object> dataEntry : dataSection.entrySet()) {
                Optional.ofNullable(this.dataFunctions.get(dataEntry.getKey())).ifPresent(function -> {
                    try {
                        consumer.accept((ItemDataModifier)function.apply(dataEntry.getValue()));
                    }
                    catch (IllegalArgumentException e) {
                        this.plugin.logger().warn("Invalid data format", e);
                    }
                });
            }
        }
    }

    @Override
    public ConfigParser parser() {
        return this.itemParser;
    }

    @Override
    public ExternalItemProvider<I> getExternalItemProvider(String name) {
        return this.externalItemProviders.get(name);
    }

    @Override
    public boolean registerExternalItemProvider(ExternalItemProvider<I> externalItemProvider) {
        if (this.externalItemProviders.containsKey(externalItemProvider.plugin())) {
            return false;
        }
        this.externalItemProviders.put(externalItemProvider.plugin(), externalItemProvider);
        return true;
    }

    @Override
    public void unload() {
        super.clearModelsToGenerate();
        this.customItems.clear();
        this.cachedSuggestions.clear();
        this.cachedTotemSuggestions.clear();
        this.legacyOverrides.clear();
        this.modernOverrides.clear();
        this.customItemTags.clear();
        this.equipmentsToGenerate.clear();
        this.cmdConflictChecker.clear();
        this.modernItemModels1_21_4.clear();
        this.modernItemModels1_21_2.clear();
    }

    @Override
    public Optional<CustomItem<I>> getCustomItem(Key key) {
        return Optional.ofNullable(this.customItems.get(key));
    }

    @Override
    public boolean addCustomItem(CustomItem<I> customItem) {
        Key id = customItem.id();
        if (this.customItems.containsKey(id)) {
            return false;
        }
        this.customItems.put(id, customItem);
        this.cachedSuggestions.add(Suggestion.suggestion((String)id.toString()));
        if (VersionHelper.isOrAbove1_21_2()) {
            this.cachedTotemSuggestions.add(Suggestion.suggestion((String)id.toString()));
        } else if (customItem.material().equals(ItemKeys.TOTEM_OF_UNDYING)) {
            this.cachedTotemSuggestions.add(Suggestion.suggestion((String)id.toString()));
        }
        Set<Key> tags = customItem.settings().tags();
        for (Key tag : tags) {
            this.customItemTags.computeIfAbsent(tag, k -> new ArrayList()).add(customItem.idHolder());
        }
        ItemEquipment equipment = customItem.settings().equipment();
        if (equipment != null) {
            EquipmentData data = equipment.data();
            Equipment equipmentJson = this.equipmentsToGenerate.computeIfAbsent(data.assetId(), k -> new Equipment());
            equipmentJson.addAll(equipment);
        }
        return true;
    }

    @Override
    public List<Holder<Key>> tagToItems(Key tag) {
        List<Holder<Key>> customItems;
        ArrayList<Holder<Key>> items = new ArrayList<Holder<Key>>();
        List<Holder<Key>> holders = VANILLA_ITEM_TAGS.get(tag);
        if (holders != null) {
            items.addAll(holders);
        }
        if ((customItems = this.customItemTags.get(tag)) != null) {
            items.addAll(customItems);
        }
        return items;
    }

    @Override
    public List<Holder<Key>> tagToVanillaItems(Key tag) {
        return Collections.unmodifiableList(VANILLA_ITEM_TAGS.getOrDefault(tag, List.of()));
    }

    @Override
    public List<Holder<Key>> tagToCustomItems(Key tag) {
        return Collections.unmodifiableList(this.customItemTags.getOrDefault(tag, List.of()));
    }

    @Override
    public Collection<Suggestion> cachedSuggestions() {
        return Collections.unmodifiableCollection(this.cachedSuggestions);
    }

    @Override
    public Collection<Suggestion> cachedTotemSuggestions() {
        return Collections.unmodifiableCollection(this.cachedTotemSuggestions);
    }

    @Override
    public Optional<List<ItemBehavior>> getItemBehavior(Key key) {
        Optional<CustomItem<I>> customItemOptional = this.getCustomItem(key);
        if (customItemOptional.isPresent()) {
            CustomItem<I> customItem = customItemOptional.get();
            Key vanillaMaterial = customItem.material();
            List<ItemBehavior> behavior = VANILLA_ITEM_EXTRA_BEHAVIORS.get(vanillaMaterial);
            if (behavior != null) {
                return Optional.of(Stream.concat(customItem.behaviors().stream(), behavior.stream()).toList());
            }
            return Optional.of(List.copyOf(customItem.behaviors()));
        }
        List<ItemBehavior> behavior = VANILLA_ITEM_EXTRA_BEHAVIORS.get(key);
        if (behavior != null) {
            return Optional.of(List.copyOf(behavior));
        }
        return Optional.empty();
    }

    @Override
    public Collection<Key> items() {
        return Collections.unmodifiableCollection(this.customItems.keySet());
    }

    @Override
    public Map<Key, ModernItemModel> modernItemModels1_21_4() {
        return Collections.unmodifiableMap(this.modernItemModels1_21_4);
    }

    @Override
    public Map<Key, TreeSet<LegacyOverridesModel>> modernItemModels1_21_2() {
        return Collections.unmodifiableMap(this.modernItemModels1_21_2);
    }

    @Override
    public Collection<Key> vanillaItems() {
        return Collections.unmodifiableCollection(VANILLA_ITEMS);
    }

    @Override
    public Map<Key, TreeSet<LegacyOverridesModel>> legacyItemOverrides() {
        return Collections.unmodifiableMap(this.legacyOverrides);
    }

    @Override
    public Map<Key, TreeMap<Integer, ModernItemModel>> modernItemOverrides() {
        return Collections.unmodifiableMap(this.modernOverrides);
    }

    @Override
    public Map<Key, Equipment> equipmentsToGenerate() {
        return Collections.unmodifiableMap(this.equipmentsToGenerate);
    }

    @Override
    public boolean isVanillaItem(Key item) {
        return VANILLA_ITEMS.contains(item);
    }

    protected abstract CustomItem.Builder<I> createPlatformItemBuilder(Holder<Key> var1, Key var2, Key var3);

    private void registerFunctions() {
        this.registerDataType((Object obj) -> {
            Map<String, Object> data = MiscUtils.castToMap(obj, false);
            String plugin = data.get("plugin").toString();
            String id = data.get("id").toString();
            ExternalItemProvider<I> provider = this.getExternalItemProvider(plugin);
            return new ExternalModifier<I>(id, Objects.requireNonNull(provider, "Item provider " + plugin + " not found"));
        }, new String[]{"external"});
        this.registerDataType((Object obj) -> {
            String name = obj.toString();
            return new CustomNameModifier((String)(Config.nonItalic() ? "<!i>" + name : name));
        }, new String[]{"custom-name"});
        this.registerDataType((Object obj) -> {
            String name = obj.toString();
            return new ItemNameModifier((String)(Config.nonItalic() ? "<!i>" + name : name));
        }, new String[]{"item-name", "display-name"});
        this.registerDataType((Object obj) -> {
            List<String> lore = MiscUtils.getAsStringList(obj).stream().map(it -> "<!i>" + it).toList();
            return new LoreModifier(lore);
        }, new String[]{"lore", "display-lore", "description"});
        this.registerDataType((Object obj) -> {
            LinkedHashMap<String, List<String>> dynamicLore = new LinkedHashMap<String, List<String>>();
            if (obj instanceof Map) {
                Map map = (Map)obj;
                for (Map.Entry entry : map.entrySet()) {
                    dynamicLore.put(entry.getKey().toString(), MiscUtils.getAsStringList(entry.getValue()));
                }
            }
            return new DynamicLoreModifier(dynamicLore);
        }, new String[]{"dynamic-lore"});
        this.registerDataType((Object obj) -> {
            if (obj instanceof Integer) {
                Integer integer = (Integer)obj;
                return new DyedColorModifier(integer);
            }
            Vector3f vector3f = MiscUtils.getAsVector3f(obj, "dyed-color");
            return new DyedColorModifier(0 | MCUtils.fastFloor(vector3f.x) << 16 | MCUtils.fastFloor(vector3f.y) << 8 | MCUtils.fastFloor(vector3f.z));
        }, new String[]{"dyed-color"});
        if (!VersionHelper.isOrAbove1_21_5()) {
            this.registerDataType((Object obj) -> {
                Map<String, Object> data = MiscUtils.castToMap(obj, false);
                return new TagsModifier(data);
            }, new String[]{"tags", "tag", "nbt"});
        }
        this.registerDataType((Object obj) -> {
            boolean value = TypeUtils.checkType(obj, Boolean.class);
            return new UnbreakableModifier(value);
        }, new String[]{"unbreakable"});
        this.registerDataType((Object obj) -> {
            int customModelData = ResourceConfigUtils.getAsInt(obj, "custom-model-data");
            return new CustomModelDataModifier(customModelData);
        }, new String[]{"custom-model-data"});
        this.registerDataType((Object obj) -> {
            Map<String, Object> data = MiscUtils.castToMap(obj, false);
            ArrayList<Enchantment> enchantments = new ArrayList<Enchantment>();
            for (Map.Entry<String, Object> e : data.entrySet()) {
                Object patt0$temp = e.getValue();
                if (!(patt0$temp instanceof Number)) continue;
                Number number = (Number)patt0$temp;
                enchantments.add(new Enchantment(Key.of(e.getKey()), number.intValue()));
            }
            return new EnchantmentModifier(enchantments);
        }, new String[]{"enchantment", "enchantments", "enchant"});
        this.registerDataType((Object obj) -> {
            Map<String, Object> data = MiscUtils.castToMap(obj, false);
            String material = data.get("material").toString().toLowerCase(Locale.ENGLISH);
            String pattern = data.get("pattern").toString().toLowerCase(Locale.ENGLISH);
            return new TrimModifier(material, pattern);
        }, new String[]{"trim"});
        this.registerDataType((Object obj) -> {
            Map<String, Object> data = MiscUtils.castToMap(obj, false);
            HashMap<String, TextProvider> arguments = new HashMap<String, TextProvider>();
            for (Map.Entry<String, Object> entry : data.entrySet()) {
                arguments.put(entry.getKey(), TextProviders.fromString(entry.getValue().toString()));
            }
            return new ArgumentModifier(arguments);
        }, new String[]{"args", "argument", "arguments"});
        if (VersionHelper.isOrAbove1_20_5()) {
            this.registerDataType((Object obj) -> {
                Map<String, Object> data = MiscUtils.castToMap(obj, false);
                return new ComponentModifier(data);
            }, new String[]{"components", "component"});
            this.registerDataType((Object obj) -> {
                List<String> data = MiscUtils.getAsStringList(obj);
                return new RemoveComponentModifier(data);
            }, new String[]{"remove-components", "remove-component"});
            this.registerDataType((Object obj) -> {
                Map<String, Object> data = MiscUtils.castToMap(obj, false);
                int nutrition = ResourceConfigUtils.getAsInt(data.get("nutrition"), "nutrition");
                float saturation = ResourceConfigUtils.getAsFloat(data.get("saturation"), "saturation");
                return new FoodModifier(nutrition, saturation, ResourceConfigUtils.getAsBoolean(data.getOrDefault("can-always-eat", false), "can-always-eat"));
            }, new String[]{"food"});
        }
        if (VersionHelper.isOrAbove1_21()) {
            this.registerDataType((Object obj) -> {
                String song = obj.toString();
                return new JukeboxSongModifier(new JukeboxPlayable(song, true));
            }, new String[]{"jukebox-playable"});
        }
        if (VersionHelper.isOrAbove1_21_2()) {
            this.registerDataType((Object obj) -> {
                String id = obj.toString();
                return new TooltipStyleModifier(Key.of(id));
            }, new String[]{"tooltip-style"});
            this.registerDataType((Object obj) -> {
                Map<String, Object> data = MiscUtils.castToMap(obj, false);
                return new EquippableModifier(EquipmentData.fromMap(data));
            }, new String[]{"equippable"});
            this.registerDataType((Object obj) -> {
                String id = obj.toString();
                return new ItemModelModifier(Key.of(id));
            }, new String[]{"item-model"});
        }
    }

    protected void processModelRecursively(ItemModel currentModel, Map<String, Object> accumulatedPredicates, Collection<LegacyOverridesModel> resultList, Key materialId, int customModelData) {
        if (currentModel instanceof ConditionItemModel) {
            ConditionItemModel conditionModel = (ConditionItemModel)currentModel;
            this.handleConditionModel(conditionModel, accumulatedPredicates, resultList, materialId, customModelData);
        } else if (currentModel instanceof RangeDispatchItemModel) {
            RangeDispatchItemModel rangeModel = (RangeDispatchItemModel)currentModel;
            this.handleRangeModel(rangeModel, accumulatedPredicates, resultList, materialId, customModelData);
        } else if (currentModel instanceof SelectItemModel) {
            SelectItemModel selectModel = (SelectItemModel)currentModel;
            this.handleSelectModel(selectModel, accumulatedPredicates, resultList, materialId, customModelData);
        } else if (currentModel instanceof BaseItemModel) {
            BaseItemModel baseModel = (BaseItemModel)currentModel;
            resultList.add(new LegacyOverridesModel(new LinkedHashMap<String, Object>(accumulatedPredicates), baseModel.path(), customModelData));
        } else if (currentModel instanceof SpecialItemModel) {
            SpecialItemModel specialModel = (SpecialItemModel)currentModel;
            resultList.add(new LegacyOverridesModel(new LinkedHashMap<String, Object>(accumulatedPredicates), specialModel.base(), customModelData));
        }
    }

    private void handleConditionModel(ConditionItemModel model, Map<String, Object> parentPredicates, Collection<LegacyOverridesModel> resultList, Key materialId, int customModelData) {
        ConditionProperty conditionProperty = model.property();
        if (conditionProperty instanceof LegacyModelPredicate) {
            LegacyModelPredicate predicate = (LegacyModelPredicate)((Object)conditionProperty);
            String predicateId = predicate.legacyPredicateId(materialId);
            Map<String, Object> truePredicates = this.mergePredicates(parentPredicates, predicateId, predicate.toLegacyValue(true));
            this.processModelRecursively(model.onTrue(), truePredicates, resultList, materialId, customModelData);
            Map<String, Object> falsePredicates = this.mergePredicates(parentPredicates, predicateId, predicate.toLegacyValue(false));
            this.processModelRecursively(model.onFalse(), falsePredicates, resultList, materialId, customModelData);
        }
    }

    private void handleRangeModel(RangeDispatchItemModel model, Map<String, Object> parentPredicates, Collection<LegacyOverridesModel> resultList, Key materialId, int customModelData) {
        RangeDispatchProperty rangeDispatchProperty = model.property();
        if (rangeDispatchProperty instanceof LegacyModelPredicate) {
            LegacyModelPredicate predicate = (LegacyModelPredicate)((Object)rangeDispatchProperty);
            String predicateId = predicate.legacyPredicateId(materialId);
            for (Map.Entry<Float, ItemModel> entry : model.entries().entrySet()) {
                Map<String, Object> merged = this.mergePredicates(parentPredicates, predicateId, predicate.toLegacyValue(entry.getKey()));
                this.processModelRecursively(entry.getValue(), merged, resultList, materialId, customModelData);
            }
            if (model.fallBack() != null) {
                Map<String, Object> merged = this.mergePredicates(parentPredicates, predicateId, predicate.toLegacyValue(Float.valueOf(0.0f)));
                this.processModelRecursively(model.fallBack(), merged, resultList, materialId, customModelData);
            }
        }
    }

    private void handleSelectModel(SelectItemModel model, Map<String, Object> parentPredicates, Collection<LegacyOverridesModel> resultList, Key materialId, int customModelData) {
        SelectProperty selectProperty = model.property();
        if (selectProperty instanceof LegacyModelPredicate) {
            LegacyModelPredicate predicate = (LegacyModelPredicate)((Object)selectProperty);
            String predicateId = predicate.legacyPredicateId(materialId);
            for (Map.Entry<Either<String, List<String>>, ItemModel> entry : model.whenMap().entrySet()) {
                List cases = (List)entry.getKey().fallbackOrMapPrimary(List::of);
                for (String caseValue : cases) {
                    TrimMaterialSelectProperty property;
                    Number legacyValue = predicate.toLegacyValue(caseValue);
                    if (predicate instanceof TrimMaterialSelectProperty && (property = (TrimMaterialSelectProperty)predicate).isArmor(materialId) && legacyValue.floatValue() > 1.0f) continue;
                    Map<String, Object> merged = this.mergePredicates(parentPredicates, predicateId, legacyValue);
                    if (predicate instanceof ChargeTypeSelectProperty && materialId.equals(ItemKeys.CROSSBOW)) {
                        merged = this.mergePredicates(merged, "charged", 1);
                    }
                    this.processModelRecursively(entry.getValue(), merged, resultList, materialId, customModelData);
                }
            }
            if (model.fallBack() != null) {
                TrimMaterialSelectProperty property;
                if (predicate instanceof ChargeTypeSelectProperty && materialId.equals(ItemKeys.CROSSBOW)) {
                    this.processModelRecursively(model.fallBack(), this.mergePredicates(parentPredicates, "charged", 0), resultList, materialId, customModelData);
                } else if (predicate instanceof TrimMaterialSelectProperty && (property = (TrimMaterialSelectProperty)predicate).isArmor(materialId)) {
                    this.processModelRecursively(model.fallBack(), this.mergePredicates(parentPredicates, "trim_type", Float.valueOf(0.0f)), resultList, materialId, customModelData);
                }
            }
        }
    }

    private Map<String, Object> mergePredicates(Map<String, Object> existing, String newKey, Number newValue) {
        LinkedHashMap<String, Object> merged = new LinkedHashMap<String, Object>(existing);
        if (newKey == null) {
            return merged;
        }
        merged.put(newKey, newValue);
        return merged;
    }

    public class ItemParser
    implements ConfigParser {
        public static final String[] CONFIG_SECTION_NAME = new String[]{"items", "item"};

        private boolean isModernFormatRequired() {
            return Config.packMaxVersion().isAtOrAbove(MinecraftVersions.V1_21_4);
        }

        private boolean needsLegacyCompatibility() {
            return Config.packMinVersion().isBelow(MinecraftVersions.V1_21_4);
        }

        @Override
        public String[] sectionId() {
            return CONFIG_SECTION_NAME;
        }

        @Override
        public int loadingSequence() {
            return 50;
        }

        @Override
        public void parseSection(Pack pack, Path path, Key id, Map<String, Object> section) {
            if (AbstractItemManager.this.customItems.containsKey(id)) {
                throw new LocalizedResourceConfigException("warning.config.item.duplicate", new String[0]);
            }
            Holder.Reference holder = BuiltInRegistries.OPTIMIZED_ITEM_ID.get(id).orElseGet(() -> ((WritableRegistry)BuiltInRegistries.OPTIMIZED_ITEM_ID).register(new ResourceKey(BuiltInRegistries.OPTIMIZED_ITEM_ID.key().location(), id), id));
            boolean isVanillaItem = AbstractItemManager.this.isVanillaItem(id);
            Key material = Key.from(isVanillaItem ? id.value() : ResourceConfigUtils.requireNonEmptyStringOrThrow(section.get("material"), "warning.config.item.missing_material").toLowerCase(Locale.ENGLISH));
            Key clientBoundMaterial = section.containsKey("client-bound-material") ? Key.from(section.get("client-bound-material").toString().toLowerCase(Locale.ENGLISH)) : material;
            int customModelData = ResourceConfigUtils.getAsInt(section.getOrDefault("custom-model-data", 0), "custom-model-data");
            if (customModelData < 0) {
                throw new LocalizedResourceConfigException("warning.config.item.invalid_custom_model_data", String.valueOf(customModelData));
            }
            if (customModelData > 0x1000000) {
                throw new LocalizedResourceConfigException("warning.config.item.bad_custom_model_data", String.valueOf(customModelData));
            }
            Key itemModelKey = null;
            CustomItem.Builder itemBuilder = AbstractItemManager.this.createPlatformItemBuilder(holder, material, clientBoundMaterial);
            boolean hasItemModelSection = section.containsKey("item-model");
            if (customModelData > 0) {
                itemBuilder.dataModifier(new CustomModelDataModifier(customModelData));
            } else if (!hasItemModelSection && section.containsKey("model") && VersionHelper.isOrAbove1_21_2()) {
                itemModelKey = Key.from(section.getOrDefault("item-model", id.toString()).toString());
                if (ResourceLocation.isValid(itemModelKey.toString())) {
                    itemBuilder.dataModifier(new ItemModelModifier(itemModelKey));
                } else {
                    itemModelKey = null;
                }
            }
            if (hasItemModelSection && VersionHelper.isOrAbove1_21_2()) {
                itemModelKey = Key.from(section.get("item-model").toString());
                itemBuilder.dataModifier(new ItemModelModifier(itemModelKey));
            }
            AbstractItemManager.this.applyDataFunctions(MiscUtils.castToMap(section.get("data"), true), itemBuilder::dataModifier);
            AbstractItemManager.this.applyDataFunctions(MiscUtils.castToMap(section.get("client-bound-data"), true), itemBuilder::clientBoundDataModifier);
            if (!isVanillaItem) {
                itemBuilder.dataModifier(new IdModifier(id));
            }
            CustomItem customItem = itemBuilder.behaviors(ItemBehaviors.fromObj(pack, path, id, ResourceConfigUtils.get(section, "behavior", "behaviors"))).settings(Optional.ofNullable(ResourceConfigUtils.get(section, "settings")).map(map -> ItemSettings.fromMap(MiscUtils.castToMap(map, true))).map(it -> isVanillaItem ? it.canPlaceRelatedVanillaBlock(true) : it).orElse(ItemSettings.of().canPlaceRelatedVanillaBlock(isVanillaItem))).events(EventFunctions.parseEvents(ResourceConfigUtils.get(section, "events", "event"))).build();
            AbstractItemManager.this.addCustomItem(customItem);
            if (section.containsKey("category")) {
                AbstractItemManager.this.plugin.itemBrowserManager().addExternalCategoryMember(id, MiscUtils.getAsStringList(section.get("category")).stream().map(Key::of).toList());
            }
            Map<String, Object> modelSection = MiscUtils.castToMap(section.get("model"), true);
            Map<String, Object> legacyModelSection = MiscUtils.castToMap(section.get("legacy-model"), true);
            if (modelSection == null && legacyModelSection == null) {
                return;
            }
            if (customModelData == 0 && itemModelKey == null) {
                throw new LocalizedResourceConfigException("warning.config.item.missing_model_id", new String[0]);
            }
            if (this.isModernFormatRequired() && modelSection == null) {
                throw new LocalizedResourceConfigException("warning.config.item.missing_model", new String[0]);
            }
            ItemModel modernModel = null;
            TreeSet<LegacyOverridesModel> legacyOverridesModels = null;
            if (this.isModernFormatRequired() || this.needsLegacyCompatibility() && legacyModelSection == null) {
                modernModel = ItemModels.fromMap(modelSection);
                for (ModelGeneration modelGeneration : modernModel.modelsToGenerate()) {
                    AbstractItemManager.this.prepareModelGeneration(modelGeneration);
                }
            }
            if (this.needsLegacyCompatibility()) {
                if (legacyModelSection != null) {
                    LegacyItemModel legacyItemModel = LegacyItemModel.fromMap(legacyModelSection, customModelData);
                    for (ModelGeneration generation : legacyItemModel.modelsToGenerate()) {
                        AbstractItemManager.this.prepareModelGeneration(generation);
                    }
                    legacyOverridesModels = new TreeSet<LegacyOverridesModel>(legacyItemModel.overrides());
                } else {
                    legacyOverridesModels = new TreeSet<LegacyOverridesModel>();
                    AbstractItemManager.this.processModelRecursively(modernModel, new LinkedHashMap<String, Object>(), legacyOverridesModels, clientBoundMaterial, customModelData);
                    if (legacyOverridesModels.isEmpty()) {
                        TranslationManager.instance().log("warning.config.item.legacy_model.cannot_convert", path.toString(), id.asString());
                    }
                }
            }
            if (customModelData != 0) {
                Map conflict = AbstractItemManager.this.cmdConflictChecker.computeIfAbsent(clientBoundMaterial, k -> new HashMap());
                if (conflict.containsKey(customModelData)) {
                    throw new LocalizedResourceConfigException("warning.config.item.custom_model_data_conflict", String.valueOf(customModelData), ((Key)conflict.get(customModelData)).toString());
                }
                conflict.put(customModelData, id);
                if (this.isModernFormatRequired() && modernModel != null) {
                    TreeMap treeMap = AbstractItemManager.this.modernOverrides.computeIfAbsent(clientBoundMaterial, k -> new TreeMap());
                    treeMap.put(customModelData, new ModernItemModel(modernModel, ResourceConfigUtils.getAsBoolean(section.getOrDefault("oversized-in-gui", true), "oversized-in-gui"), ResourceConfigUtils.getAsBoolean(section.getOrDefault("hand-animation-on-swap", true), "hand-animation-on-swap")));
                }
                if (this.needsLegacyCompatibility() && legacyOverridesModels != null && !legacyOverridesModels.isEmpty()) {
                    TreeSet treeSet = AbstractItemManager.this.legacyOverrides.computeIfAbsent(clientBoundMaterial, k -> new TreeSet());
                    treeSet.addAll(legacyOverridesModels);
                }
            }
            if (itemModelKey != null) {
                if (this.isModernFormatRequired() && modernModel != null) {
                    AbstractItemManager.this.modernItemModels1_21_4.put(itemModelKey, new ModernItemModel(modernModel, ResourceConfigUtils.getAsBoolean(section.getOrDefault("oversized-in-gui", true), "oversized-in-gui"), ResourceConfigUtils.getAsBoolean(section.getOrDefault("hand-animation-on-swap", true), "hand-animation-on-swap")));
                }
                if (Config.packMaxVersion().isAtOrAbove(MinecraftVersions.V1_21_2) && this.needsLegacyCompatibility() && legacyOverridesModels != null && !legacyOverridesModels.isEmpty()) {
                    TreeSet lom = AbstractItemManager.this.modernItemModels1_21_2.computeIfAbsent(itemModelKey, k -> new TreeSet());
                    lom.addAll(legacyOverridesModels);
                }
            }
        }
    }
}

