/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.item;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Function;
import net.momirealms.craftengine.core.entity.player.Player;
import net.momirealms.craftengine.core.item.BuildableItem;
import net.momirealms.craftengine.core.item.CustomItem;
import net.momirealms.craftengine.core.item.ExternalItemProvider;
import net.momirealms.craftengine.core.item.Item;
import net.momirealms.craftengine.core.item.NetworkItemHandler;
import net.momirealms.craftengine.core.item.behavior.ItemBehavior;
import net.momirealms.craftengine.core.item.modifier.ItemDataModifier;
import net.momirealms.craftengine.core.pack.misc.Equipment;
import net.momirealms.craftengine.core.pack.model.LegacyOverridesModel;
import net.momirealms.craftengine.core.pack.model.ModernItemModel;
import net.momirealms.craftengine.core.pack.model.generation.ModelGenerator;
import net.momirealms.craftengine.core.plugin.Manageable;
import net.momirealms.craftengine.core.plugin.config.ConfigParser;
import net.momirealms.craftengine.core.registry.Holder;
import net.momirealms.craftengine.core.util.Key;
import net.momirealms.craftengine.libraries.cloud.suggestion.Suggestion;
import org.jetbrains.annotations.Nullable;

public interface ItemManager<T>
extends Manageable,
ModelGenerator {
    public void registerDataType(Function<Object, ItemDataModifier<T>> var1, String ... var2);

    public ConfigParser parser();

    public Map<Key, TreeSet<LegacyOverridesModel>> legacyItemOverrides();

    public Map<Key, TreeMap<Integer, ModernItemModel>> modernItemOverrides();

    public Map<Key, Equipment> equipmentsToGenerate();

    public Map<Key, ModernItemModel> modernItemModels1_21_4();

    public Map<Key, TreeSet<LegacyOverridesModel>> modernItemModels1_21_2();

    public Collection<Key> vanillaItems();

    public T buildCustomItemStack(Key var1, @Nullable Player var2);

    public T buildItemStack(Key var1, @Nullable Player var2);

    public Item<T> createCustomWrappedItem(Key var1, @Nullable Player var2);

    public Item<T> createWrappedItem(Key var1, @Nullable Player var2);

    public Item<T> wrap(T var1);

    public Item<T> fromByteArray(byte[] var1);

    public Collection<Key> items();

    public Key itemId(T var1);

    public Key customItemId(T var1);

    public ExternalItemProvider<T> getExternalItemProvider(String var1);

    public boolean registerExternalItemProvider(ExternalItemProvider<T> var1);

    public Optional<CustomItem<T>> getCustomItem(Key var1);

    public Optional<List<ItemBehavior>> getItemBehavior(Key var1);

    public Optional<? extends BuildableItem<T>> getVanillaItem(Key var1);

    public NetworkItemHandler<T> networkItemHandler();

    default public Optional<? extends BuildableItem<T>> getBuildableItem(Key key) {
        Optional<CustomItem<T>> item = this.getCustomItem(key);
        if (item.isPresent()) {
            return item;
        }
        return this.getVanillaItem(key);
    }

    public boolean addCustomItem(CustomItem<T> var1);

    public List<Holder<Key>> tagToItems(Key var1);

    public List<Holder<Key>> tagToVanillaItems(Key var1);

    public List<Holder<Key>> tagToCustomItems(Key var1);

    public int fuelTime(T var1);

    public int fuelTime(Key var1);

    public Collection<Suggestion> cachedSuggestions();

    public Collection<Suggestion> cachedTotemSuggestions();

    public boolean isVanillaItem(Key var1);
}

