/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.item.modifier;

import java.util.List;
import net.momirealms.craftengine.core.item.ComponentKeys;
import net.momirealms.craftengine.core.item.Item;
import net.momirealms.craftengine.core.item.ItemBuildContext;
import net.momirealms.craftengine.core.item.ItemKeys;
import net.momirealms.craftengine.core.item.NetworkItemHandler;
import net.momirealms.craftengine.core.item.data.Enchantment;
import net.momirealms.craftengine.core.item.modifier.ItemDataModifier;
import net.momirealms.craftengine.core.util.VersionHelper;
import net.momirealms.craftengine.libraries.nbt.CompoundTag;
import net.momirealms.craftengine.libraries.nbt.Tag;

public class EnchantmentModifier<I>
implements ItemDataModifier<I> {
    private final List<Enchantment> enchantments;

    public EnchantmentModifier(List<Enchantment> enchantments) {
        this.enchantments = enchantments;
    }

    @Override
    public String name() {
        return "enchantment";
    }

    @Override
    public Item<I> apply(Item<I> item, ItemBuildContext context) {
        if (item.vanillaId().equals(ItemKeys.ENCHANTED_BOOK)) {
            item.setStoredEnchantments(this.enchantments);
        } else {
            item.setEnchantments(this.enchantments);
        }
        return item;
    }

    @Override
    public Item<I> prepareNetworkItem(Item<I> item, ItemBuildContext context, CompoundTag networkData) {
        if (item.vanillaId().equals(ItemKeys.ENCHANTED_BOOK)) {
            if (VersionHelper.isOrAbove1_20_5()) {
                Tag previous = item.getNBTComponent(ComponentKeys.STORED_ENCHANTMENTS);
                if (previous != null) {
                    networkData.put(ComponentKeys.STORED_ENCHANTMENTS.asString(), NetworkItemHandler.pack(NetworkItemHandler.Operation.ADD, previous));
                } else {
                    networkData.put(ComponentKeys.STORED_ENCHANTMENTS.asString(), NetworkItemHandler.pack(NetworkItemHandler.Operation.REMOVE));
                }
            } else {
                Tag previous = item.getNBTTag("StoredEnchantments");
                if (previous != null) {
                    networkData.put("StoredEnchantments", NetworkItemHandler.pack(NetworkItemHandler.Operation.ADD, previous));
                } else {
                    networkData.put("StoredEnchantments", NetworkItemHandler.pack(NetworkItemHandler.Operation.REMOVE));
                }
            }
        } else if (VersionHelper.isOrAbove1_20_5()) {
            Tag previous = item.getNBTComponent(ComponentKeys.ENCHANTMENTS);
            if (previous != null) {
                networkData.put(ComponentKeys.ENCHANTMENTS.asString(), NetworkItemHandler.pack(NetworkItemHandler.Operation.ADD, previous));
            } else {
                networkData.put(ComponentKeys.ENCHANTMENTS.asString(), NetworkItemHandler.pack(NetworkItemHandler.Operation.REMOVE));
            }
        } else {
            Tag previous = item.getNBTTag("Enchantments");
            if (previous != null) {
                networkData.put("Enchantments", NetworkItemHandler.pack(NetworkItemHandler.Operation.ADD, previous));
            } else {
                networkData.put("Enchantments", NetworkItemHandler.pack(NetworkItemHandler.Operation.REMOVE));
            }
        }
        return item;
    }
}

