/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.item.modifier;

import java.util.LinkedHashMap;
import java.util.Map;
import net.momirealms.craftengine.core.item.Item;
import net.momirealms.craftengine.core.item.ItemBuildContext;
import net.momirealms.craftengine.core.item.NetworkItemHandler;
import net.momirealms.craftengine.core.item.modifier.ItemDataModifier;
import net.momirealms.craftengine.core.util.MiscUtils;
import net.momirealms.craftengine.core.util.TypeUtils;
import net.momirealms.craftengine.libraries.nbt.CompoundTag;
import net.momirealms.craftengine.libraries.nbt.Tag;

public class TagsModifier<I>
implements ItemDataModifier<I> {
    private final Map<String, Object> arguments;

    public TagsModifier(Map<String, Object> arguments) {
        this.arguments = TagsModifier.mapToMap(arguments);
    }

    public Map<String, Object> arguments() {
        return this.arguments;
    }

    @Override
    public String name() {
        return "tags";
    }

    @Override
    public Item<I> apply(Item<I> item, ItemBuildContext context) {
        for (Map.Entry<String, Object> entry : this.arguments.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            item.setTag(value, key);
        }
        return item;
    }

    @Override
    public Item<I> prepareNetworkItem(Item<I> item, ItemBuildContext context, CompoundTag networkData) {
        for (Map.Entry<String, Object> entry : this.arguments.entrySet()) {
            Tag previous = item.getNBTTag(entry.getKey());
            if (previous != null) {
                networkData.put(entry.getKey(), NetworkItemHandler.pack(NetworkItemHandler.Operation.ADD, previous));
                continue;
            }
            networkData.put(entry.getKey(), NetworkItemHandler.pack(NetworkItemHandler.Operation.REMOVE));
        }
        return item;
    }

    private static Map<String, Object> mapToMap(Map<String, Object> source) {
        LinkedHashMap<String, Object> resultMap = new LinkedHashMap<String, Object>();
        TagsModifier.recursiveMapProcessing(source, resultMap);
        return resultMap;
    }

    private static void recursiveMapProcessing(Map<String, Object> sourceMap, Map<String, Object> targetMap) {
        for (Map.Entry<String, Object> entry : sourceMap.entrySet()) {
            TagsModifier.processMapEntry(entry.getKey(), entry.getValue(), targetMap);
        }
    }

    private static void processMapEntry(String key, Object value, Map<String, Object> targetMap) {
        if (value instanceof Map) {
            TagsModifier.handleNestedMap(key, MiscUtils.castToMap(value, false), targetMap);
        } else if (value instanceof String) {
            TagsModifier.handleStringValue(key, (String)value, targetMap);
        } else {
            targetMap.put(key, value);
        }
    }

    private static void handleNestedMap(String key, Map<String, Object> nestedSource, Map<String, Object> parentMap) {
        LinkedHashMap<String, Object> nestedTarget = new LinkedHashMap<String, Object>();
        parentMap.put(key, nestedTarget);
        TagsModifier.recursiveMapProcessing(nestedSource, nestedTarget);
    }

    private static void handleStringValue(String key, String value, Map<String, Object> targetMap) {
        ParsedValue parsed = TagsModifier.tryParseTypedValue(value);
        targetMap.put(key, parsed.success ? parsed.result : value);
    }

    private static ParsedValue tryParseTypedValue(String str) {
        if (str.length() < 3 || str.charAt(0) != '(') {
            return ParsedValue.FAILURE;
        }
        int closingBracketPos = str.indexOf(41, 1);
        if (closingBracketPos == -1 || closingBracketPos + 2 > str.length()) {
            return ParsedValue.FAILURE;
        }
        if (str.charAt(closingBracketPos + 1) != ' ') {
            return ParsedValue.FAILURE;
        }
        String typeMarker = str.substring(1, closingBracketPos);
        String content = str.substring(closingBracketPos + 2);
        return new ParsedValue(true, TypeUtils.castBasicTypes(content, typeMarker));
    }

    private record ParsedValue(boolean success, Object result) {
        static final ParsedValue FAILURE = new ParsedValue(false, null);
    }
}

