/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.item.recipe;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.momirealms.craftengine.core.item.recipe.Ingredient;
import net.momirealms.craftengine.core.item.recipe.Recipe;
import net.momirealms.craftengine.core.item.recipe.RecipeManager;
import net.momirealms.craftengine.core.item.recipe.RecipeTypes;
import net.momirealms.craftengine.core.item.recipe.input.RecipeInput;
import net.momirealms.craftengine.core.item.recipe.vanilla.VanillaRecipeReader;
import net.momirealms.craftengine.core.item.recipe.vanilla.reader.VanillaRecipeReader1_20;
import net.momirealms.craftengine.core.item.recipe.vanilla.reader.VanillaRecipeReader1_20_5;
import net.momirealms.craftengine.core.item.recipe.vanilla.reader.VanillaRecipeReader1_21_2;
import net.momirealms.craftengine.core.pack.Pack;
import net.momirealms.craftengine.core.plugin.CraftEngine;
import net.momirealms.craftengine.core.plugin.config.Config;
import net.momirealms.craftengine.core.plugin.config.ConfigParser;
import net.momirealms.craftengine.core.plugin.locale.LocalizedResourceConfigException;
import net.momirealms.craftengine.core.registry.Holder;
import net.momirealms.craftengine.core.util.Key;
import net.momirealms.craftengine.core.util.VersionHelper;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractRecipeManager<T>
implements RecipeManager<T> {
    protected final VanillaRecipeReader recipeReader;
    protected final Map<Key, List<Recipe<T>>> byType = new HashMap<Key, List<Recipe<T>>>();
    protected final Map<Key, Recipe<T>> byId = new HashMap<Key, Recipe<T>>();
    protected final Map<Key, List<Recipe<T>>> byResult = new HashMap<Key, List<Recipe<T>>>();
    protected final Map<Key, List<Recipe<T>>> byIngredient = new HashMap<Key, List<Recipe<T>>>();
    protected final Set<Key> dataPackRecipes = new HashSet<Key>();
    protected final Set<Key> customRecipes = new HashSet<Key>();
    protected final RecipeParser recipeParser;
    protected boolean isReloading;

    public AbstractRecipeManager() {
        this.recipeReader = this.initVanillaRecipeReader();
        this.recipeParser = new RecipeParser();
    }

    @Override
    public ConfigParser parser() {
        return this.recipeParser;
    }

    private VanillaRecipeReader initVanillaRecipeReader() {
        if (VersionHelper.isOrAbove1_21_2()) {
            return new VanillaRecipeReader1_21_2();
        }
        if (VersionHelper.isOrAbove1_20_5()) {
            return new VanillaRecipeReader1_20_5();
        }
        return new VanillaRecipeReader1_20();
    }

    @Override
    public void unload() {
        this.dataPackRecipes.clear();
        this.byType.clear();
        this.byId.clear();
        this.byResult.clear();
        this.byIngredient.clear();
        for (Key key : this.customRecipes) {
            this.unregisterPlatformRecipe(key);
        }
        this.customRecipes.clear();
    }

    protected void markAsDataPackRecipe(Key key) {
        this.dataPackRecipes.add(key);
    }

    protected void markAsCustomRecipe(Key key) {
        this.customRecipes.add(key);
    }

    @Override
    public boolean isDataPackRecipe(Key key) {
        if (this.isReloading) {
            return false;
        }
        return this.dataPackRecipes.contains(key);
    }

    @Override
    public boolean isCustomRecipe(Key key) {
        if (this.isReloading) {
            return false;
        }
        return this.byId.containsKey(key);
    }

    @Override
    public Optional<Recipe<T>> recipeById(Key key) {
        if (this.isReloading) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.byId.get(key));
    }

    @Override
    public List<Recipe<T>> recipesByType(Key type) {
        if (this.isReloading) {
            return List.of();
        }
        return this.byType.getOrDefault(type, List.of());
    }

    @Override
    public List<Recipe<T>> recipeByResult(Key result) {
        if (this.isReloading) {
            return List.of();
        }
        return this.byResult.getOrDefault(result, List.of());
    }

    @Override
    public List<Recipe<T>> recipeByIngredient(Key ingredient) {
        if (this.isReloading) {
            return List.of();
        }
        return this.byIngredient.getOrDefault(ingredient, List.of());
    }

    @Override
    @Nullable
    public Recipe<T> recipeByInput(Key type, RecipeInput input) {
        if (this.isReloading) {
            return null;
        }
        List<Recipe<T>> recipes = this.byType.get(type);
        if (recipes == null) {
            return null;
        }
        for (Recipe<T> recipe : recipes) {
            if (!recipe.matches(input)) continue;
            return recipe;
        }
        return null;
    }

    @Override
    @Nullable
    public Recipe<T> recipeByInput(Key type, RecipeInput input, Key lastRecipe) {
        Recipe<T> last;
        if (this.isReloading) {
            return null;
        }
        if (lastRecipe != null && (last = this.byId.get(lastRecipe)) != null && last.matches(input)) {
            return last;
        }
        return this.recipeByInput(type, input);
    }

    protected void registerInternalRecipe(Key id, Recipe<T> recipe) {
        this.byType.computeIfAbsent(recipe.type(), k -> new ArrayList()).add(recipe);
        this.byId.put(id, recipe);
        this.byResult.computeIfAbsent(recipe.result().item().id(), k -> new ArrayList()).add(recipe);
        HashSet<Key> usedKeys = new HashSet<Key>();
        for (Ingredient<T> ingredient : recipe.ingredientsInUse()) {
            for (Holder<Key> holder : ingredient.items()) {
                Key key = holder.value();
                if (!usedKeys.add(key)) continue;
                this.byIngredient.computeIfAbsent(key, k -> new ArrayList()).add(recipe);
            }
        }
    }

    protected abstract void unregisterPlatformRecipe(Key var1);

    protected abstract void registerPlatformRecipe(Key var1, Recipe<T> var2);

    public class RecipeParser
    implements ConfigParser {
        public static final String[] CONFIG_SECTION_NAME = new String[]{"recipes", "recipe"};

        @Override
        public int loadingSequence() {
            return 80;
        }

        @Override
        public String[] sectionId() {
            return CONFIG_SECTION_NAME;
        }

        @Override
        public void parseSection(Pack pack, Path path, Key id, Map<String, Object> section) {
            if (!Config.enableRecipeSystem()) {
                return;
            }
            if (AbstractRecipeManager.this.byId.containsKey(id)) {
                throw new LocalizedResourceConfigException("warning.config.recipe.duplicate", path, id, new String[0]);
            }
            Recipe recipe = RecipeTypes.fromMap(id, section);
            try {
                AbstractRecipeManager.this.markAsCustomRecipe(id);
                AbstractRecipeManager.this.registerInternalRecipe(id, recipe);
                AbstractRecipeManager.this.registerPlatformRecipe(id, recipe);
            }
            catch (Exception e) {
                CraftEngine.instance().logger().warn("Failed to register custom recipe " + String.valueOf(id), e);
            }
        }
    }
}

