/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.item.recipe;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.momirealms.craftengine.core.item.recipe.AbstractRecipeFactory;
import net.momirealms.craftengine.core.item.recipe.CraftingRecipeCategory;
import net.momirealms.craftengine.core.item.recipe.CustomCraftingTableRecipe;
import net.momirealms.craftengine.core.item.recipe.CustomRecipeResult;
import net.momirealms.craftengine.core.item.recipe.Ingredient;
import net.momirealms.craftengine.core.item.recipe.PlacementInfo;
import net.momirealms.craftengine.core.item.recipe.Recipe;
import net.momirealms.craftengine.core.item.recipe.RecipeTypes;
import net.momirealms.craftengine.core.item.recipe.input.CraftingInput;
import net.momirealms.craftengine.core.item.recipe.input.RecipeInput;
import net.momirealms.craftengine.core.plugin.CraftEngine;
import net.momirealms.craftengine.core.plugin.locale.LocalizedResourceConfigException;
import net.momirealms.craftengine.core.registry.BuiltInRegistries;
import net.momirealms.craftengine.core.registry.Holder;
import net.momirealms.craftengine.core.util.Key;
import net.momirealms.craftengine.core.util.MiscUtils;
import org.jetbrains.annotations.NotNull;

public class CustomShapelessRecipe<T>
extends CustomCraftingTableRecipe<T> {
    public static final Factory<?> FACTORY = new Factory();
    private final List<Ingredient<T>> ingredients;
    private final PlacementInfo<T> placementInfo;

    public CustomShapelessRecipe(Key id, CraftingRecipeCategory category, String group, List<Ingredient<T>> ingredients, CustomRecipeResult<T> result) {
        super(id, category, group, result);
        this.ingredients = ingredients;
        this.placementInfo = PlacementInfo.create(ingredients);
    }

    public PlacementInfo<T> placementInfo() {
        return this.placementInfo;
    }

    @Override
    public List<Ingredient<T>> ingredientsInUse() {
        return this.ingredients;
    }

    @Override
    public boolean matches(RecipeInput input) {
        return this.matches((CraftingInput)input);
    }

    private boolean matches(CraftingInput<T> input) {
        if (input.ingredientCount() != this.ingredients.size()) {
            return false;
        }
        if (input.size() == 1 && this.ingredients.size() == 1) {
            return this.ingredients.get(0).test(input.getItem(0));
        }
        return input.finder().canCraft(this);
    }

    @Override
    @NotNull
    public Key type() {
        return RecipeTypes.SHAPELESS;
    }

    public static class Factory<A>
    extends AbstractRecipeFactory<A> {
        @Override
        public Recipe<A> create(Key id, Map<String, Object> arguments) {
            String group = arguments.containsKey("group") ? arguments.get("group").toString() : null;
            ArrayList ingredients = new ArrayList();
            Object ingredientsObject = this.getIngredientOrThrow(arguments);
            if (ingredientsObject instanceof Map) {
                Map map = (Map)ingredientsObject;
                for (Map.Entry<String, Object> entry : MiscUtils.castToMap(map, false).entrySet()) {
                    List<String> items = MiscUtils.getAsStringList(entry.getValue());
                    HashSet<Holder<Key>> holders = new HashSet<Holder<Key>>();
                    for (String item : items) {
                        if (item.charAt(0) == '#') {
                            holders.addAll(CraftEngine.instance().itemManager().tagToItems(Key.of(item.substring(1))));
                            continue;
                        }
                        holders.add((Holder<Key>)BuiltInRegistries.OPTIMIZED_ITEM_ID.get(Key.of(item)).orElseThrow(() -> new LocalizedResourceConfigException("warning.config.recipe.invalid_item", item)));
                    }
                    ingredients.add(Ingredient.of(holders));
                }
            } else if (ingredientsObject instanceof List) {
                List list = (List)ingredientsObject;
                for (Object obj : list) {
                    if (obj instanceof List) {
                        List inner = (List)obj;
                        HashSet<Holder<Key>> holders = new HashSet<Holder<Key>>();
                        for (String item : MiscUtils.getAsStringList(inner)) {
                            if (item.charAt(0) == '#') {
                                holders.addAll(CraftEngine.instance().itemManager().tagToItems(Key.of(item.substring(1))));
                                continue;
                            }
                            holders.add((Holder<Key>)BuiltInRegistries.OPTIMIZED_ITEM_ID.get(Key.of(item)).orElseThrow(() -> new LocalizedResourceConfigException("warning.config.recipe.invalid_item", item)));
                        }
                        ingredients.add(Ingredient.of(holders));
                        continue;
                    }
                    String item = obj.toString();
                    HashSet<Holder<Key>> holders = new HashSet<Holder<Key>>();
                    if (item.charAt(0) == '#') {
                        holders.addAll(CraftEngine.instance().itemManager().tagToItems(Key.of(item.substring(1))));
                    } else {
                        holders.add((Holder)BuiltInRegistries.OPTIMIZED_ITEM_ID.get(Key.of(item)).orElseThrow(() -> new LocalizedResourceConfigException("warning.config.recipe.invalid_item", item)));
                    }
                    ingredients.add(Ingredient.of(holders));
                }
            } else {
                String item = ingredientsObject.toString();
                HashSet<Holder<Key>> holders = new HashSet<Holder<Key>>();
                if (item.charAt(0) == '#') {
                    holders.addAll(CraftEngine.instance().itemManager().tagToItems(Key.of(item.substring(1))));
                } else {
                    holders.add((Holder)BuiltInRegistries.OPTIMIZED_ITEM_ID.get(Key.of(item)).orElseThrow(() -> new LocalizedResourceConfigException("warning.config.recipe.invalid_item", item)));
                }
                ingredients.add(Ingredient.of(holders));
            }
            return new CustomShapelessRecipe(id, this.craftingRecipeCategory(arguments), group, ingredients, this.parseResult(arguments));
        }
    }
}

