/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.item.recipe;

import java.util.List;
import java.util.Map;
import java.util.Set;
import net.momirealms.craftengine.core.item.recipe.AbstractGroupedRecipe;
import net.momirealms.craftengine.core.item.recipe.AbstractRecipeFactory;
import net.momirealms.craftengine.core.item.recipe.CustomRecipeResult;
import net.momirealms.craftengine.core.item.recipe.Ingredient;
import net.momirealms.craftengine.core.item.recipe.Recipe;
import net.momirealms.craftengine.core.item.recipe.RecipeTypes;
import net.momirealms.craftengine.core.item.recipe.input.RecipeInput;
import net.momirealms.craftengine.core.item.recipe.input.SingleItemInput;
import net.momirealms.craftengine.core.registry.Holder;
import net.momirealms.craftengine.core.util.Key;
import org.jetbrains.annotations.NotNull;

public class CustomStoneCuttingRecipe<T>
extends AbstractGroupedRecipe<T> {
    public static final Factory<?> FACTORY = new Factory();
    protected final Ingredient<T> ingredient;

    public CustomStoneCuttingRecipe(Key id, String group, Ingredient<T> ingredient, CustomRecipeResult<T> result) {
        super(id, group, result);
        this.ingredient = ingredient;
    }

    @Override
    public boolean matches(RecipeInput input) {
        return this.ingredient.test(((SingleItemInput)input).input());
    }

    @Override
    public List<Ingredient<T>> ingredientsInUse() {
        return List.of(this.ingredient);
    }

    @Override
    @NotNull
    public Key type() {
        return RecipeTypes.STONECUTTING;
    }

    public Ingredient<T> ingredient() {
        return this.ingredient;
    }

    public static class Factory<A>
    extends AbstractRecipeFactory<A> {
        @Override
        public Recipe<A> create(Key id, Map<String, Object> arguments) {
            String group = arguments.containsKey("group") ? arguments.get("group").toString() : null;
            Set<Holder<Key>> holders = this.ingredientHolders(arguments);
            return new CustomStoneCuttingRecipe(id, group, Ingredient.of(holders), this.parseResult(arguments));
        }
    }
}

