/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.item.recipe.vanilla.reader;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.momirealms.craftengine.core.item.recipe.vanilla.RecipeResult;
import net.momirealms.craftengine.core.item.recipe.vanilla.VanillaBlastingRecipe;
import net.momirealms.craftengine.core.item.recipe.vanilla.VanillaCampfireRecipe;
import net.momirealms.craftengine.core.item.recipe.vanilla.VanillaShapedRecipe;
import net.momirealms.craftengine.core.item.recipe.vanilla.VanillaShapelessRecipe;
import net.momirealms.craftengine.core.item.recipe.vanilla.VanillaSmeltingRecipe;
import net.momirealms.craftengine.core.item.recipe.vanilla.VanillaSmithingTransformRecipe;
import net.momirealms.craftengine.core.item.recipe.vanilla.VanillaSmokingRecipe;
import net.momirealms.craftengine.core.item.recipe.vanilla.VanillaStoneCuttingRecipe;
import net.momirealms.craftengine.core.item.recipe.vanilla.reader.AbstractRecipeReader;
import org.jetbrains.annotations.NotNull;

public class VanillaRecipeReader1_20
extends AbstractRecipeReader {
    @Override
    public VanillaShapedRecipe readShaped(JsonObject json) {
        return new VanillaShapedRecipe(this.readCraftingCategory(json), this.readGroup(json), this.readShapedIngredientMap(json.getAsJsonObject("key")), this.readPattern(json), this.readCraftingResult(json.getAsJsonObject("result")));
    }

    @Override
    public VanillaShapelessRecipe readShapeless(JsonObject json) {
        return new VanillaShapelessRecipe(this.readCraftingCategory(json), this.readGroup(json), this.readShapelessIngredients(json.getAsJsonArray("ingredients")), this.readCraftingResult(json.getAsJsonObject("result")));
    }

    @Override
    public VanillaBlastingRecipe readBlasting(JsonObject json) {
        return new VanillaBlastingRecipe(this.readCookingCategory(json), this.readGroup(json), this.readCookingResult(json.get("result")), this.readSingleIngredient(json.get("ingredient")), this.readExperience(json), this.readCookingTime(json));
    }

    @Override
    public VanillaSmeltingRecipe readSmelting(JsonObject json) {
        return new VanillaSmeltingRecipe(this.readCookingCategory(json), this.readGroup(json), this.readCookingResult(json.get("result")), this.readSingleIngredient(json.get("ingredient")), this.readExperience(json), this.readCookingTime(json));
    }

    @Override
    public VanillaSmokingRecipe readSmoking(JsonObject json) {
        return new VanillaSmokingRecipe(this.readCookingCategory(json), this.readGroup(json), this.readCookingResult(json.get("result")), this.readSingleIngredient(json.get("ingredient")), this.readExperience(json), this.readCookingTime(json));
    }

    @Override
    public VanillaCampfireRecipe readCampfire(JsonObject json) {
        return new VanillaCampfireRecipe(this.readCookingCategory(json), this.readGroup(json), this.readCookingResult(json.get("result")), this.readSingleIngredient(json.get("ingredient")), this.readExperience(json), this.readCookingTime(json));
    }

    @Override
    public VanillaStoneCuttingRecipe readStoneCutting(JsonObject json) {
        return new VanillaStoneCuttingRecipe(this.readGroup(json), this.readStoneCuttingResult(json), this.readSingleIngredient(json.get("ingredient")));
    }

    @Override
    public VanillaSmithingTransformRecipe readSmithingTransform(JsonObject json) {
        return new VanillaSmithingTransformRecipe(this.readSingleIngredient(json.get("base")), this.readSingleIngredient(json.get("template")), this.readSingleIngredient(json.get("addition")), this.readSmithingResult(json.getAsJsonObject("result")));
    }

    protected List<String> readSingleIngredient(JsonElement json) {
        ArrayList<String> ingredients = new ArrayList<String>();
        if (json.isJsonObject()) {
            JsonObject argument = json.getAsJsonObject();
            if (argument.has("item")) {
                ingredients.add(argument.get("item").getAsString());
            } else if (argument.has("tag")) {
                ingredients.add("#" + argument.get("tag").getAsString());
            }
        } else if (json.isJsonArray()) {
            List<String> items = this.readIngredientList((JsonArray)json);
            ingredients.addAll(items);
        }
        return ingredients;
    }

    @NotNull
    protected RecipeResult readStoneCuttingResult(JsonObject json) {
        int count = json.has("count") ? json.get("count").getAsInt() : 1;
        String result = json.get("result").getAsString();
        return new RecipeResult(result, count, null);
    }

    @NotNull
    protected RecipeResult readCookingResult(JsonElement object) {
        return new RecipeResult(object.getAsString(), 1, null);
    }

    @NotNull
    protected RecipeResult readCraftingResult(JsonObject object) {
        String item = object.get("item").getAsString();
        int count = object.has("count") ? object.get("count").getAsInt() : 1;
        return new RecipeResult(item, count, null);
    }

    @NotNull
    protected RecipeResult readSmithingResult(JsonObject object) {
        String item = object.get("item").getAsString();
        return new RecipeResult(item, 1, null);
    }

    protected List<List<String>> readShapelessIngredients(JsonArray json) {
        ArrayList<List<String>> ingredients = new ArrayList<List<String>>();
        for (JsonElement element : json) {
            if (element.isJsonObject()) {
                JsonObject jsonObject = element.getAsJsonObject();
                if (jsonObject.has("item")) {
                    ingredients.add(List.of(jsonObject.get("item").getAsString()));
                    continue;
                }
                if (!jsonObject.has("tag")) continue;
                ingredients.add(List.of("#" + jsonObject.get("tag").getAsString()));
                continue;
            }
            if (!element.isJsonArray()) continue;
            List<String> ingredient = this.readIngredientList((JsonArray)element);
            ingredients.add(ingredient);
        }
        return ingredients;
    }

    protected Map<Character, List<String>> readShapedIngredientMap(JsonObject json) {
        HashMap<Character, List<String>> ingredients = new HashMap<Character, List<String>>();
        for (Map.Entry entry : json.entrySet()) {
            char c = ((String)entry.getKey()).charAt(0);
            if (((JsonElement)entry.getValue()).isJsonObject()) {
                JsonObject argument = ((JsonElement)entry.getValue()).getAsJsonObject();
                if (argument.has("item")) {
                    ingredients.put(Character.valueOf(c), List.of(argument.get("item").getAsString()));
                    continue;
                }
                if (!argument.has("tag")) continue;
                ingredients.put(Character.valueOf(c), List.of("#" + argument.get("tag").getAsString()));
                continue;
            }
            if (!((JsonElement)entry.getValue()).isJsonArray()) continue;
            List<String> items = this.readIngredientList((JsonArray)entry.getValue());
            ingredients.put(Character.valueOf(c), items);
        }
        return ingredients;
    }

    @NotNull
    protected List<String> readIngredientList(JsonArray array) {
        ArrayList<String> items = new ArrayList<String>();
        for (JsonElement element : array) {
            if (!element.isJsonObject()) continue;
            JsonObject argument = element.getAsJsonObject();
            if (argument.has("item")) {
                items.add(argument.get("item").getAsString());
                continue;
            }
            if (!argument.has("tag")) continue;
            items.add("#" + argument.get("tag").getAsString());
        }
        return items;
    }
}

