/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.loot;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.momirealms.craftengine.core.loot.LootContext;
import net.momirealms.craftengine.core.plugin.context.Condition;
import net.momirealms.craftengine.core.plugin.context.condition.AllOfCondition;
import net.momirealms.craftengine.core.plugin.context.condition.AnyOfCondition;
import net.momirealms.craftengine.core.plugin.context.condition.CommonConditions;
import net.momirealms.craftengine.core.plugin.context.condition.ConditionFactory;
import net.momirealms.craftengine.core.plugin.context.condition.DistanceCondition;
import net.momirealms.craftengine.core.plugin.context.condition.EnchantmentCondition;
import net.momirealms.craftengine.core.plugin.context.condition.ExpressionCondition;
import net.momirealms.craftengine.core.plugin.context.condition.FallingBlockCondition;
import net.momirealms.craftengine.core.plugin.context.condition.HandCondition;
import net.momirealms.craftengine.core.plugin.context.condition.InvertedCondition;
import net.momirealms.craftengine.core.plugin.context.condition.IsNullCondition;
import net.momirealms.craftengine.core.plugin.context.condition.MatchBlockPropertyCondition;
import net.momirealms.craftengine.core.plugin.context.condition.MatchItemCondition;
import net.momirealms.craftengine.core.plugin.context.condition.PermissionCondition;
import net.momirealms.craftengine.core.plugin.context.condition.RandomCondition;
import net.momirealms.craftengine.core.plugin.context.condition.StringContainsCondition;
import net.momirealms.craftengine.core.plugin.context.condition.StringEqualsCondition;
import net.momirealms.craftengine.core.plugin.context.condition.StringRegexCondition;
import net.momirealms.craftengine.core.plugin.context.condition.SurvivesExplosionCondition;
import net.momirealms.craftengine.core.plugin.context.condition.TableBonusCondition;
import net.momirealms.craftengine.core.plugin.locale.LocalizedResourceConfigException;
import net.momirealms.craftengine.core.registry.BuiltInRegistries;
import net.momirealms.craftengine.core.registry.Holder;
import net.momirealms.craftengine.core.registry.Registries;
import net.momirealms.craftengine.core.registry.WritableRegistry;
import net.momirealms.craftengine.core.util.Key;
import net.momirealms.craftengine.core.util.ResourceConfigUtils;
import net.momirealms.craftengine.core.util.ResourceKey;

public class LootConditions {
    public static void register(Key key, ConditionFactory<LootContext> factory) {
        Holder.Reference<ConditionFactory<LootContext>> holder = ((WritableRegistry)BuiltInRegistries.LOOT_CONDITION_FACTORY).registerForHolder(new ResourceKey(Registries.LOOT_CONDITION_FACTORY.location(), key));
        holder.bindValue(factory);
    }

    public static <T> Predicate<T> andConditions(List<? extends Predicate<T>> predicates) {
        List list = List.copyOf(predicates);
        return switch (list.size()) {
            case 0 -> ctx -> true;
            case 1 -> list.get(0);
            case 2 -> list.get(0).and(list.get(1));
            default -> ctx -> {
                for (Predicate predicate : list) {
                    if (predicate.test(ctx)) continue;
                    return false;
                }
                return true;
            };
        };
    }

    public static <T> Predicate<T> orConditions(List<? extends Predicate<T>> predicates) {
        List list = List.copyOf(predicates);
        return switch (list.size()) {
            case 0 -> ctx -> false;
            case 1 -> list.get(0);
            case 2 -> list.get(0).or(list.get(1));
            default -> ctx -> {
                for (Predicate predicate : list) {
                    if (!predicate.test(ctx)) continue;
                    return true;
                }
                return false;
            };
        };
    }

    public static List<Condition<LootContext>> fromMapList(List<Map<String, Object>> mapList) {
        if (mapList == null || mapList.isEmpty()) {
            return List.of();
        }
        ArrayList<Condition<LootContext>> functions = new ArrayList<Condition<LootContext>>();
        for (Map<String, Object> map : mapList) {
            functions.add(LootConditions.fromMap(map));
        }
        return functions;
    }

    public static Condition<LootContext> fromMap(Map<String, Object> map) {
        String type = ResourceConfigUtils.requireNonEmptyStringOrThrow(map.get("type"), "warning.config.loot_table.condition.missing_type");
        Key key = Key.withDefaultNamespace(type, "craftengine");
        if (key.value().charAt(0) == '!') {
            ConditionFactory<LootContext> factory = BuiltInRegistries.LOOT_CONDITION_FACTORY.getValue(new Key(key.namespace(), key.value().substring(1)));
            if (factory == null) {
                throw new LocalizedResourceConfigException("warning.config.loot_table.condition.invalid_type", type);
            }
            return new InvertedCondition<LootContext>(factory.create(map));
        }
        ConditionFactory<LootContext> factory = BuiltInRegistries.LOOT_CONDITION_FACTORY.getValue(key);
        if (factory == null) {
            throw new LocalizedResourceConfigException("warning.config.loot_table.condition.invalid_type", type);
        }
        return factory.create(map);
    }

    static {
        LootConditions.register(CommonConditions.MATCH_ITEM, new MatchItemCondition.FactoryImpl<LootContext>());
        LootConditions.register(CommonConditions.MATCH_BLOCK_PROPERTY, new MatchBlockPropertyCondition.FactoryImpl<LootContext>());
        LootConditions.register(CommonConditions.TABLE_BONUS, new TableBonusCondition.FactoryImpl<LootContext>());
        LootConditions.register(CommonConditions.SURVIVES_EXPLOSION, new SurvivesExplosionCondition.FactoryImpl<LootContext>());
        LootConditions.register(CommonConditions.ANY_OF, new AnyOfCondition.FactoryImpl<LootContext>(LootConditions::fromMap));
        LootConditions.register(CommonConditions.ALL_OF, new AllOfCondition.FactoryImpl<LootContext>(LootConditions::fromMap));
        LootConditions.register(CommonConditions.ENCHANTMENT, new EnchantmentCondition.FactoryImpl<LootContext>());
        LootConditions.register(CommonConditions.INVERTED, new InvertedCondition.FactoryImpl<LootContext>(LootConditions::fromMap));
        LootConditions.register(CommonConditions.FALLING_BLOCK, new FallingBlockCondition.FactoryImpl<LootContext>());
        LootConditions.register(CommonConditions.RANDOM, new RandomCondition.FactoryImpl<LootContext>());
        LootConditions.register(CommonConditions.DISTANCE, new DistanceCondition.FactoryImpl<LootContext>());
        LootConditions.register(CommonConditions.PERMISSION, new PermissionCondition.FactoryImpl<LootContext>());
        LootConditions.register(CommonConditions.EQUALS, new StringEqualsCondition.FactoryImpl<LootContext>());
        LootConditions.register(CommonConditions.STRING_REGEX, new StringRegexCondition.FactoryImpl<LootContext>());
        LootConditions.register(CommonConditions.STRING_EQUALS, new StringEqualsCondition.FactoryImpl<LootContext>());
        LootConditions.register(CommonConditions.STRING_CONTAINS, new StringContainsCondition.FactoryImpl<LootContext>());
        LootConditions.register(CommonConditions.EXPRESSION, new ExpressionCondition.FactoryImpl<LootContext>());
        LootConditions.register(CommonConditions.IS_NULL, new IsNullCondition.FactoryImpl<LootContext>());
        LootConditions.register(CommonConditions.HAND, new HandCondition.FactoryImpl<LootContext>());
    }
}

