/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.loot.entry;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.momirealms.craftengine.core.loot.entry.AlternativesLootEntryContainer;
import net.momirealms.craftengine.core.loot.entry.ExpLootEntryContainer;
import net.momirealms.craftengine.core.loot.entry.FurnitureItemLootEntryContainer;
import net.momirealms.craftengine.core.loot.entry.LootEntryContainer;
import net.momirealms.craftengine.core.loot.entry.LootEntryContainerFactory;
import net.momirealms.craftengine.core.loot.entry.SingleItemLootEntryContainer;
import net.momirealms.craftengine.core.plugin.locale.LocalizedResourceConfigException;
import net.momirealms.craftengine.core.registry.BuiltInRegistries;
import net.momirealms.craftengine.core.registry.Holder;
import net.momirealms.craftengine.core.registry.Registries;
import net.momirealms.craftengine.core.registry.WritableRegistry;
import net.momirealms.craftengine.core.util.Key;
import net.momirealms.craftengine.core.util.ResourceConfigUtils;
import net.momirealms.craftengine.core.util.ResourceKey;

public class LootEntryContainers {
    public static final Key ALTERNATIVES = Key.from("craftengine:alternatives");
    public static final Key ITEM = Key.from("craftengine:item");
    public static final Key FURNITURE_ITEM = Key.from("craftengine:furniture_item");
    public static final Key EXP = Key.from("craftengine:exp");

    public static <T> void register(Key key, LootEntryContainerFactory<T> factory) {
        Holder.Reference<LootEntryContainerFactory<T>> holder = ((WritableRegistry)BuiltInRegistries.LOOT_ENTRY_CONTAINER_FACTORY).registerForHolder(new ResourceKey(Registries.LOOT_ENTRY_CONTAINER_FACTORY.location(), key));
        holder.bindValue(factory);
    }

    public static <T> List<LootEntryContainer<T>> fromMapList(List<Map<String, Object>> mapList) {
        if (mapList == null || mapList.isEmpty()) {
            return List.of();
        }
        ArrayList<LootEntryContainer<T>> functions = new ArrayList<LootEntryContainer<T>>();
        for (Map<String, Object> map : mapList) {
            functions.add(LootEntryContainers.fromMap(map));
        }
        return functions;
    }

    public static <T> LootEntryContainer<T> fromMap(Map<String, Object> map) {
        String type = ResourceConfigUtils.requireNonEmptyStringOrThrow(map.get("type"), "warning.config.loot_table.entry.missing_type");
        Key key = Key.withDefaultNamespace(type, "craftengine");
        LootEntryContainerFactory<?> factory = BuiltInRegistries.LOOT_ENTRY_CONTAINER_FACTORY.getValue(key);
        if (factory == null) {
            throw new LocalizedResourceConfigException("warning.config.loot_table.entry.invalid_type", type);
        }
        return factory.create(map);
    }

    static {
        LootEntryContainers.register(ALTERNATIVES, AlternativesLootEntryContainer.FACTORY);
        LootEntryContainers.register(ITEM, SingleItemLootEntryContainer.FACTORY);
        LootEntryContainers.register(EXP, ExpLootEntryContainer.FACTORY);
        LootEntryContainers.register(FURNITURE_ITEM, FurnitureItemLootEntryContainer.FACTORY);
    }
}

