/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.loot.function;

import java.util.List;
import java.util.function.Predicate;
import net.momirealms.craftengine.core.item.Item;
import net.momirealms.craftengine.core.loot.LootContext;
import net.momirealms.craftengine.core.loot.function.LootFunction;
import net.momirealms.craftengine.core.plugin.context.Condition;
import net.momirealms.craftengine.core.util.MCUtils;

public abstract class AbstractLootConditionalFunction<T>
implements LootFunction<T> {
    protected final List<Condition<LootContext>> predicates;
    private final Predicate<LootContext> compositePredicates;

    public AbstractLootConditionalFunction(List<Condition<LootContext>> predicates) {
        this.predicates = predicates;
        this.compositePredicates = MCUtils.allOf(predicates);
    }

    @Override
    public Item<T> apply(Item<T> item, LootContext lootContext) {
        return this.compositePredicates.test(lootContext) ? this.applyInternal(item, lootContext) : item;
    }

    protected abstract Item<T> applyInternal(Item<T> var1, LootContext var2);
}

