/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.pack.host;

import java.util.Map;
import net.momirealms.craftengine.core.pack.host.ResourcePackHost;
import net.momirealms.craftengine.core.pack.host.ResourcePackHostFactory;
import net.momirealms.craftengine.core.pack.host.impl.AlistHost;
import net.momirealms.craftengine.core.pack.host.impl.DropboxHost;
import net.momirealms.craftengine.core.pack.host.impl.ExternalHost;
import net.momirealms.craftengine.core.pack.host.impl.GitLabHost;
import net.momirealms.craftengine.core.pack.host.impl.LobFileHost;
import net.momirealms.craftengine.core.pack.host.impl.NoneHost;
import net.momirealms.craftengine.core.pack.host.impl.OneDriveHost;
import net.momirealms.craftengine.core.pack.host.impl.S3HostFactory;
import net.momirealms.craftengine.core.pack.host.impl.SelfHost;
import net.momirealms.craftengine.core.plugin.locale.LocalizedException;
import net.momirealms.craftengine.core.registry.BuiltInRegistries;
import net.momirealms.craftengine.core.registry.Holder;
import net.momirealms.craftengine.core.registry.Registries;
import net.momirealms.craftengine.core.registry.WritableRegistry;
import net.momirealms.craftengine.core.util.Key;
import net.momirealms.craftengine.core.util.ResourceKey;

public class ResourcePackHosts {
    public static final Key NONE = Key.of("craftengine:none");
    public static final Key SELF = Key.of("craftengine:self");
    public static final Key EXTERNAL = Key.of("craftengine:external");
    public static final Key LOBFILE = Key.of("craftengine:lobfile");
    public static final Key S3 = Key.of("craftengine:s3");
    public static final Key ALIST = Key.of("craftengine:alist");
    public static final Key DROPBOX = Key.of("craftengine:dropbox");
    public static final Key ONEDRIVE = Key.of("craftengine:onedrive");
    public static final Key GITLAB = Key.of("craftengine:gitlab");

    public static void register(Key key, ResourcePackHostFactory factory) {
        Holder.Reference<ResourcePackHostFactory> holder = ((WritableRegistry)BuiltInRegistries.RESOURCE_PACK_HOST_FACTORY).registerForHolder(new ResourceKey(Registries.RESOURCE_PACK_HOST_FACTORY.location(), key));
        holder.bindValue(factory);
    }

    public static ResourcePackHost fromMap(Map<String, Object> map) {
        String type = (String)map.get("type");
        if (type == null) {
            throw new LocalizedException("warning.config.host.missing_type", new String[0]);
        }
        Key key = Key.withDefaultNamespace(type, "craftengine");
        ResourcePackHostFactory factory = BuiltInRegistries.RESOURCE_PACK_HOST_FACTORY.getValue(key);
        if (factory == null) {
            throw new LocalizedException("warning.config.host.invalid_type", type);
        }
        return factory.create(map);
    }

    static {
        ResourcePackHosts.register(NONE, NoneHost.FACTORY);
        ResourcePackHosts.register(SELF, SelfHost.FACTORY);
        ResourcePackHosts.register(EXTERNAL, ExternalHost.FACTORY);
        ResourcePackHosts.register(LOBFILE, LobFileHost.FACTORY);
        ResourcePackHosts.register(S3, S3HostFactory.INSTANCE);
        ResourcePackHosts.register(ALIST, AlistHost.FACTORY);
        ResourcePackHosts.register(DROPBOX, DropboxHost.FACTORY);
        ResourcePackHosts.register(ONEDRIVE, OneDriveHost.FACTORY);
        ResourcePackHosts.register(GITLAB, GitLabHost.FACTORY);
    }
}

