/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.pack.host.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.ProxySelector;
import java.net.URI;
import java.net.URLEncoder;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.time.Duration;
import java.util.Date;
import java.util.HashMap;
import java.util.HexFormat;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.momirealms.craftengine.core.pack.host.ResourcePackDownloadData;
import net.momirealms.craftengine.core.pack.host.ResourcePackHost;
import net.momirealms.craftengine.core.pack.host.ResourcePackHostFactory;
import net.momirealms.craftengine.core.pack.host.ResourcePackHosts;
import net.momirealms.craftengine.core.plugin.CraftEngine;
import net.momirealms.craftengine.core.plugin.locale.LocalizedException;
import net.momirealms.craftengine.core.util.GsonHelper;
import net.momirealms.craftengine.core.util.HashUtils;
import net.momirealms.craftengine.core.util.Key;
import net.momirealms.craftengine.core.util.MiscUtils;
import net.momirealms.craftengine.core.util.Pair;
import net.momirealms.craftengine.core.util.ResourceConfigUtils;
import org.jetbrains.annotations.Nullable;

public class AlistHost
implements ResourcePackHost {
    public static final Factory FACTORY = new Factory();
    private final String apiUrl;
    private final String userName;
    private final String password;
    private final String filePassword;
    private final String otpCode;
    private final Duration jwtTokenExpiration;
    private final String uploadPath;
    private final boolean disableUpload;
    private final ProxySelector proxy;
    private Pair<String, Date> jwtToken;
    private String cachedSha1;

    public AlistHost(String apiUrl, String userName, String password, String filePassword, String otpCode, Duration jwtTokenExpiration, String uploadPath, boolean disableUpload, ProxySelector proxy) {
        this.apiUrl = apiUrl;
        this.userName = userName;
        this.password = password;
        this.filePassword = filePassword;
        this.otpCode = otpCode;
        this.jwtTokenExpiration = jwtTokenExpiration;
        this.uploadPath = uploadPath;
        this.disableUpload = disableUpload;
        this.proxy = proxy;
        this.readCacheFromDisk();
    }

    @Override
    public boolean canUpload() {
        return true;
    }

    @Override
    public Key type() {
        return ResourcePackHosts.ALIST;
    }

    private void readCacheFromDisk() {
        Path cachePath = CraftEngine.instance().dataFolderPath().resolve("alist.cache");
        if (!Files.exists(cachePath, new LinkOption[0])) {
            return;
        }
        try (InputStream is = Files.newInputStream(cachePath, new OpenOption[0]);){
            Map cache = (Map)GsonHelper.get().fromJson((Reader)new InputStreamReader(is), new TypeToken<Map<String, String>>(this){}.getType());
            this.cachedSha1 = (String)cache.get("sha1");
            CraftEngine.instance().logger().info("[Alist] Loaded cached resource pack metadata");
        }
        catch (Exception e) {
            CraftEngine.instance().logger().warn("[Alist] Failed to load cache " + String.valueOf(cachePath), e);
        }
    }

    private void saveCacheToDisk() {
        HashMap<String, String> cache = new HashMap<String, String>();
        cache.put("sha1", this.cachedSha1 != null ? this.cachedSha1 : "");
        Path cachePath = CraftEngine.instance().dataFolderPath().resolve("alist.cache");
        try {
            Files.writeString(cachePath, (CharSequence)GsonHelper.get().toJson(cache), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        }
        catch (IOException e) {
            CraftEngine.instance().logger().warn("[Alist] Failed to persist cache to disk: " + e.getMessage());
        }
    }

    @Override
    public CompletableFuture<List<ResourcePackDownloadData>> requestResourcePackDownloadLink(UUID player) {
        CompletableFuture<List<ResourcePackDownloadData>> future = new CompletableFuture<List<ResourcePackDownloadData>>();
        CraftEngine.instance().scheduler().executeAsync(() -> {
            try (HttpClient client = HttpClient.newBuilder().proxy(this.proxy).build();){
                HttpRequest request = HttpRequest.newBuilder().uri(URI.create(this.apiUrl + "/api/fs/get")).header("Authorization", this.getOrRefreshJwtToken()).header("Content-Type", "application/json").POST(this.getRequestResourcePackDownloadLinkPost()).build();
                ((CompletableFuture)client.sendAsync(request, HttpResponse.BodyHandlers.ofString()).thenAccept(response -> this.handleResourcePackDownloadLinkResponse((HttpResponse<String>)response, future))).exceptionally(ex -> {
                    CraftEngine.instance().logger().severe("[Alist] Failed to retrieve resource pack download URL", (Throwable)ex);
                    future.completeExceptionally((Throwable)ex);
                    return null;
                });
            }
        });
        return future;
    }

    @Override
    public CompletableFuture<Void> upload(Path resourcePackPath) {
        if (this.disableUpload) {
            this.cachedSha1 = "";
            this.saveCacheToDisk();
            return CompletableFuture.completedFuture(null);
        }
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        CraftEngine.instance().scheduler().executeAsync(() -> {
            try (HttpClient client = HttpClient.newBuilder().proxy(this.proxy).build();){
                HttpRequest request = HttpRequest.newBuilder().uri(URI.create(this.apiUrl + "/api/fs/put")).header("Authorization", this.getOrRefreshJwtToken()).header("File-Path", URLEncoder.encode(this.uploadPath, StandardCharsets.UTF_8).replace("/", "%2F")).header("overwrite", "true").header("password", this.filePassword).header("Content-Type", "application/x-zip-compressed").PUT(HttpRequest.BodyPublishers.ofFile(resourcePackPath)).build();
                long requestStart = System.currentTimeMillis();
                CraftEngine.instance().logger().info("[Alist] Initiating resource pack upload...");
                ((CompletableFuture)client.sendAsync(request, HttpResponse.BodyHandlers.ofString()).thenAccept(response -> {
                    long uploadTime = System.currentTimeMillis() - requestStart;
                    if (response.statusCode() == 200) {
                        this.cachedSha1 = HashUtils.calculateLocalFileSha1(resourcePackPath);
                        this.saveCacheToDisk();
                        CraftEngine.instance().logger().info("[Alist] Successfully uploaded resource pack in " + uploadTime + " ms");
                        future.complete(null);
                    } else {
                        future.completeExceptionally(new RuntimeException("Upload failed with status code: " + response.statusCode()));
                    }
                })).exceptionally(ex -> {
                    long uploadTime = System.currentTimeMillis() - requestStart;
                    CraftEngine.instance().logger().severe("[Alist] Resource pack upload failed after " + uploadTime + " ms", (Throwable)ex);
                    future.completeExceptionally((Throwable)ex);
                    return null;
                });
            }
            catch (IOException e) {
                CraftEngine.instance().logger().warn("[Alist] Failed to upload resource pack: " + e.getMessage());
                future.completeExceptionally(e);
            }
        });
        return future;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private String getOrRefreshJwtToken() {
        if (this.jwtToken != null) {
            if (!this.jwtToken.right().before(new Date())) return this.jwtToken.left();
        }
        try (HttpClient client = HttpClient.newBuilder().proxy(this.proxy).build();){
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create(this.apiUrl + "/api/auth/login")).header("Content-Type", "application/json").POST(this.getLoginPost()).build();
            HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
            if (response.statusCode() != 200) {
                CraftEngine.instance().logger().warn("[Alist] Authentication failed (HTTP " + response.statusCode() + "): " + response.body());
                String string = null;
                return string;
            }
            JsonObject jsonData = GsonHelper.parseJsonToJsonObject(response.body());
            JsonElement code = jsonData.get("code");
            if (code.isJsonPrimitive() && code.getAsJsonPrimitive().isNumber() && code.getAsJsonPrimitive().getAsInt() == 200) {
                JsonElement data = jsonData.get("data");
                if (data.isJsonObject()) {
                    JsonObject jsonObj = data.getAsJsonObject();
                    this.jwtToken = Pair.of(jsonObj.getAsJsonPrimitive("token").getAsString(), new Date(System.currentTimeMillis() + this.jwtTokenExpiration.toMillis()));
                    String string = this.jwtToken.left();
                    return string;
                }
                CraftEngine.instance().logger().warn("[Alist] Invalid JWT response format: " + response.body());
                String string = null;
                return string;
            }
            CraftEngine.instance().logger().warn("[Alist] Authentication rejected: " + response.body());
            String string = null;
            return string;
        }
        catch (IOException | InterruptedException e) {
            CraftEngine.instance().logger().warn("[Alist] JWT token acquisition failed", e);
            return null;
        }
    }

    private HttpRequest.BodyPublisher getLoginPost() {
        String body = "{\"username\":\"" + this.userName + "\",\"password\":\"" + this.password + "\"";
        if (this.otpCode != null && !this.otpCode.isEmpty()) {
            body = body + ",\"otp_code\":\"" + this.otpCode + "\"";
        }
        body = body + "}";
        return HttpRequest.BodyPublishers.ofString(body);
    }

    private HttpRequest.BodyPublisher getRequestResourcePackDownloadLinkPost() {
        String body = "{\"path\":\"" + this.uploadPath + "\",\"password\":\"" + this.filePassword + "\"}";
        return HttpRequest.BodyPublishers.ofString(body);
    }

    private void handleResourcePackDownloadLinkResponse(HttpResponse<String> response, CompletableFuture<List<ResourcePackDownloadData>> future) {
        JsonObject dataObj;
        boolean isDir;
        JsonElement data;
        JsonObject json;
        JsonElement code;
        if (response.statusCode() == 200 && (code = (json = GsonHelper.parseJsonToJsonObject(response.body())).get("code")).isJsonPrimitive() && code.getAsJsonPrimitive().isNumber() && code.getAsJsonPrimitive().getAsInt() == 200 && (data = json.get("data")).isJsonObject() && !(isDir = (dataObj = data.getAsJsonObject()).getAsJsonPrimitive("is_dir").getAsBoolean())) {
            String url = dataObj.getAsJsonPrimitive("raw_url").getAsString();
            if ((this.cachedSha1 == null || this.cachedSha1.isEmpty()) && this.disableUpload) {
                try (HttpClient client = HttpClient.newBuilder().proxy(this.proxy).build();){
                    HttpRequest request = HttpRequest.newBuilder().uri(URI.create(url)).GET().build();
                    HttpResponse<InputStream> responseHash = client.send(request, HttpResponse.BodyHandlers.ofInputStream());
                    try (InputStream inputStream = responseHash.body();){
                        int len;
                        MessageDigest md = MessageDigest.getInstance("SHA-1");
                        byte[] buffer = new byte[8192];
                        while ((len = inputStream.read(buffer)) != -1) {
                            md.update(buffer, 0, len);
                        }
                        byte[] digest = md.digest();
                        this.cachedSha1 = HexFormat.of().formatHex(digest);
                        this.saveCacheToDisk();
                    }
                    catch (NoSuchAlgorithmException e) {
                        future.completeExceptionally(new RuntimeException("Failed to calculate SHA-1 hash algorithm", e));
                        if (client != null) {
                            client.close();
                        }
                        return;
                    }
                }
                catch (IOException | InterruptedException e) {
                    future.completeExceptionally(new RuntimeException("Failed to retrieve remote resource pack for hashing", e));
                    return;
                }
            }
            UUID uuid = UUID.nameUUIDFromBytes(Objects.requireNonNull(this.cachedSha1).getBytes(StandardCharsets.UTF_8));
            future.complete(List.of(new ResourcePackDownloadData(url, uuid, this.cachedSha1)));
            return;
        }
        future.completeExceptionally(new RuntimeException("Failed to obtain resource pack download URL (HTTP " + response.statusCode() + "): " + response.body()));
    }

    public static class Factory
    implements ResourcePackHostFactory {
        @Override
        public ResourcePackHost create(Map<String, Object> arguments) {
            String password;
            String userName;
            boolean useEnv = ResourceConfigUtils.getAsBoolean(arguments.getOrDefault("use-environment-variables", false), "use-environment-variables");
            String apiUrl = ResourceConfigUtils.requireNonEmptyStringOrThrow(arguments.get("api-url"), () -> new LocalizedException("warning.config.host.alist.missing_api_url", new String[0]));
            String string = userName = useEnv ? System.getenv("CE_ALIST_USERNAME") : (String)Optional.ofNullable(arguments.get("username")).map(String::valueOf).orElse(null);
            if (userName == null || userName.isEmpty()) {
                throw new LocalizedException("warning.config.host.alist.missing_username", new String[0]);
            }
            String string2 = password = useEnv ? System.getenv("CE_ALIST_PASSWORD") : (String)Optional.ofNullable(arguments.get("password")).map(String::valueOf).orElse(null);
            if (password == null || password.isEmpty()) {
                throw new LocalizedException("warning.config.host.alist.missing_password", new String[0]);
            }
            String filePassword = useEnv ? System.getenv("CE_ALIST_FILE_PASSWORD") : arguments.getOrDefault("file-password", "").toString();
            String otpCode = Optional.ofNullable(arguments.get("otp-code")).map(String::valueOf).orElse(null);
            Duration jwtTokenExpiration = Duration.ofHours(((Integer)arguments.getOrDefault("jwt-token-expiration", 48)).intValue());
            String uploadPath = ResourceConfigUtils.requireNonEmptyStringOrThrow(arguments.get("upload-path"), () -> new LocalizedException("warning.config.host.alist.missing_upload_path", new String[0]));
            boolean disableUpload = ResourceConfigUtils.getAsBoolean(arguments.getOrDefault("disable-upload", false), "disable-upload");
            ProxySelector proxy = this.getProxySelector(MiscUtils.castToMap(arguments.get("proxy"), true));
            return new AlistHost(apiUrl, userName, password, filePassword, otpCode, jwtTokenExpiration, uploadPath, disableUpload, proxy);
        }
    }
}

