/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.pack.host.impl;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.io.InputStream;
import java.net.ProxySelector;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.locks.ReentrantLock;
import net.momirealms.craftengine.core.pack.host.ResourcePackDownloadData;
import net.momirealms.craftengine.core.pack.host.ResourcePackHost;
import net.momirealms.craftengine.core.pack.host.ResourcePackHostFactory;
import net.momirealms.craftengine.core.pack.host.ResourcePackHosts;
import net.momirealms.craftengine.core.plugin.CraftEngine;
import net.momirealms.craftengine.core.plugin.locale.LocalizedException;
import net.momirealms.craftengine.core.util.GsonHelper;
import net.momirealms.craftengine.core.util.HashUtils;
import net.momirealms.craftengine.core.util.Key;
import net.momirealms.craftengine.core.util.MiscUtils;
import net.momirealms.craftengine.core.util.ResourceConfigUtils;

public class DropboxHost
implements ResourcePackHost {
    public static final Factory FACTORY = new Factory();
    private final String appKey;
    private final String appSecret;
    private final String uploadPath;
    private final ProxySelector proxy;
    private final ReentrantLock tokenLock = new ReentrantLock();
    private volatile String accessToken;
    private volatile String refreshToken;
    private volatile long expiresAt;
    private String url;
    private String sha1;

    public DropboxHost(String appKey, String appSecret, String refreshToken, String uploadPath, ProxySelector proxy) {
        this.appKey = appKey;
        this.appSecret = appSecret;
        this.refreshToken = refreshToken;
        this.uploadPath = uploadPath;
        this.proxy = proxy;
        this.readCacheFromDisk();
    }

    public void readCacheFromDisk() {
        Path cachePath = CraftEngine.instance().dataFolderPath().resolve("dropbox.cache");
        if (!Files.exists(cachePath, new LinkOption[0])) {
            return;
        }
        try (InputStream is = Files.newInputStream(cachePath, new OpenOption[0]);){
            JsonObject cache = GsonHelper.parseJsonToJsonObject(new String(is.readAllBytes(), StandardCharsets.UTF_8));
            this.url = this.getString(cache, "url");
            this.sha1 = this.getString(cache, "sha1");
            this.refreshToken = this.getString(cache, "refresh_token");
            this.accessToken = this.getString(cache, "access_token");
            this.expiresAt = this.getLong(cache, "expires_at");
            CraftEngine.instance().logger().info("[Dropbox] Loaded cached resource pack info");
        }
        catch (Exception e) {
            CraftEngine.instance().logger().warn("[Dropbox] Failed to load cache " + String.valueOf(cachePath), e);
        }
    }

    public void saveCacheToDisk() {
        JsonObject cache = new JsonObject();
        cache.addProperty("url", this.url);
        cache.addProperty("sha1", this.sha1);
        cache.addProperty("refresh_token", this.refreshToken);
        cache.addProperty("access_token", this.accessToken);
        cache.addProperty("expires_at", (Number)this.expiresAt);
        Path cachePath = CraftEngine.instance().dataFolderPath().resolve("dropbox.cache");
        try {
            Files.writeString(cachePath, (CharSequence)GsonHelper.get().toJson((JsonElement)cache), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        }
        catch (IOException e) {
            CraftEngine.instance().logger().warn("[Dropbox] Failed to save cache", e);
        }
    }

    @Override
    public boolean canUpload() {
        return true;
    }

    @Override
    public Key type() {
        return ResourcePackHosts.DROPBOX;
    }

    @Override
    public CompletableFuture<List<ResourcePackDownloadData>> requestResourcePackDownloadLink(UUID player) {
        return CompletableFuture.completedFuture(Collections.singletonList(ResourcePackDownloadData.of(this.url, UUID.nameUUIDFromBytes(this.sha1.getBytes(StandardCharsets.UTF_8)), this.sha1)));
    }

    @Override
    public CompletableFuture<Void> upload(Path resourcePackPath) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        CraftEngine.instance().scheduler().executeAsync(() -> {
            try {
                String validToken = this.getOrRefreshToken();
                this.sha1 = HashUtils.calculateLocalFileSha1(resourcePackPath);
                try (HttpClient client = HttpClient.newBuilder().proxy(this.proxy).build();){
                    JsonObject apiArg = new JsonObject();
                    apiArg.addProperty("path", this.uploadPath);
                    apiArg.addProperty("mode", "overwrite");
                    HttpRequest request = HttpRequest.newBuilder().uri(URI.create("https://content.dropboxapi.com/2/files/upload")).header("Authorization", "Bearer " + validToken).header("Content-Type", "application/octet-stream").header("Dropbox-API-Arg", apiArg.toString()).POST(HttpRequest.BodyPublishers.ofFile(resourcePackPath)).build();
                    long startTime = System.currentTimeMillis();
                    CraftEngine.instance().logger().info("[Dropbox] Starting upload...");
                    ((CompletableFuture)client.sendAsync(request, HttpResponse.BodyHandlers.ofString()).thenAccept(response -> {
                        long elapsed = System.currentTimeMillis() - startTime;
                        if (response.statusCode() == 200) {
                            CraftEngine.instance().logger().info("[Dropbox] Upload completed in " + elapsed + "ms");
                            this.url = this.getDownloadUrl(validToken);
                            this.saveCacheToDisk();
                            future.complete(null);
                        } else {
                            CraftEngine.instance().logger().warn("[Dropbox] Upload failed (HTTP " + response.statusCode() + "): " + (String)response.body());
                            future.completeExceptionally(new RuntimeException((String)response.body()));
                        }
                    })).exceptionally(ex -> {
                        CraftEngine.instance().logger().warn("[Dropbox] Upload error", (Throwable)ex);
                        future.completeExceptionally((Throwable)ex);
                        return null;
                    });
                }
            }
            catch (Exception e) {
                future.completeExceptionally(e);
            }
        });
        return future;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getDownloadUrl(String accessToken) {
        try (HttpClient client = HttpClient.newBuilder().proxy(this.proxy).build();){
            JsonObject requestBody = new JsonObject();
            requestBody.addProperty("path", this.uploadPath);
            requestBody.add("settings", (JsonElement)new JsonObject());
            requestBody.getAsJsonObject("settings").addProperty("requested_visibility", "public");
            HttpRequest createLinkRequest = HttpRequest.newBuilder().uri(URI.create("https://api.dropboxapi.com/2/sharing/create_shared_link_with_settings")).header("Authorization", "Bearer " + accessToken).header("Content-Type", "application/json").POST(HttpRequest.BodyPublishers.ofString(requestBody.toString())).build();
            HttpResponse<String> response = client.send(createLinkRequest, HttpResponse.BodyHandlers.ofString());
            if (response.statusCode() == 409) {
                JsonObject listRequest = new JsonObject();
                listRequest.addProperty("path", this.uploadPath);
                HttpRequest listLinksRequest = HttpRequest.newBuilder().uri(URI.create("https://api.dropboxapi.com/2/sharing/list_shared_links")).header("Authorization", "Bearer " + accessToken).header("Content-Type", "application/json").POST(HttpRequest.BodyPublishers.ofString(listRequest.toString())).build();
                HttpResponse<String> listResponse = client.send(listLinksRequest, HttpResponse.BodyHandlers.ofString());
                JsonObject listData = GsonHelper.parseJsonToJsonObject(listResponse.body());
                JsonArray links = listData.getAsJsonArray("links");
                if (!links.isEmpty()) {
                    String string = links.get(0).getAsJsonObject().get("url").getAsString().replace("dl=0", "dl=1");
                    return string;
                }
            }
            JsonObject responseData = GsonHelper.parseJsonToJsonObject(response.body());
            String string = responseData.get("url").getAsString().replace("dl=0", "dl=1");
            return string;
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException("Failed to get download URL", e);
        }
    }

    private String getString(JsonObject json, String key) {
        return json.has(key) ? json.get(key).getAsString() : null;
    }

    private long getLong(JsonObject json, String key) {
        return json.has(key) ? json.get(key).getAsLong() : 0L;
    }

    private String getOrRefreshToken() {
        if (System.currentTimeMillis() < this.expiresAt - 30000L && this.accessToken != null) {
            return this.accessToken;
        }
        this.tokenLock.lock();
        try {
            if (System.currentTimeMillis() < this.expiresAt - 30000L && this.accessToken != null) {
                String string = this.accessToken;
                return string;
            }
            String credentials = this.appKey + ":" + this.appSecret;
            String authHeader = "Basic " + Base64.getEncoder().encodeToString(credentials.getBytes());
            HttpClient client = HttpClient.newBuilder().proxy(this.proxy).build();
            try {
                HttpRequest request = HttpRequest.newBuilder().uri(URI.create("https://api.dropboxapi.com/oauth2/token")).header("Content-Type", "application/x-www-form-urlencoded").header("Authorization", authHeader).POST(HttpRequest.BodyPublishers.ofString("grant_type=refresh_token&refresh_token=" + this.refreshToken)).build();
                HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
                if (response.statusCode() != 200) {
                    throw new RuntimeException("Refresh failed: " + response.body());
                }
                JsonObject tokenData = GsonHelper.parseJsonToJsonObject(response.body());
                this.accessToken = tokenData.get("access_token").getAsString();
                this.expiresAt = System.currentTimeMillis() + tokenData.get("expires_in").getAsLong() * 1000L;
                if (tokenData.has("refresh_token")) {
                    this.refreshToken = tokenData.get("refresh_token").getAsString();
                }
                this.saveCacheToDisk();
                String string = this.accessToken;
                if (client != null) {
                    client.close();
                }
                return string;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | InterruptedException e) {
                    throw new RuntimeException("Token refresh failed", e);
                }
            }
        }
        finally {
            this.tokenLock.unlock();
        }
    }

    public static class Factory
    implements ResourcePackHostFactory {
        @Override
        public ResourcePackHost create(Map<String, Object> arguments) {
            String refreshToken;
            String appSecret;
            String appKey;
            boolean useEnv = ResourceConfigUtils.getAsBoolean(arguments.getOrDefault("use-environment-variables", false), "use-environment-variables");
            String string = appKey = useEnv ? System.getenv("CE_DROPBOX_APP_KEY") : (String)Optional.ofNullable(arguments.get("app-key")).map(String::valueOf).orElse(null);
            if (appKey == null || appKey.isEmpty()) {
                throw new LocalizedException("warning.config.host.dropbox.missing_app_key", new String[0]);
            }
            String string2 = appSecret = useEnv ? System.getenv("CE_DROPBOX_APP_SECRET") : (String)Optional.ofNullable(arguments.get("app-secret")).map(String::valueOf).orElse(null);
            if (appSecret == null || appSecret.isEmpty()) {
                throw new LocalizedException("warning.config.host.dropbox.missing_app_secret", new String[0]);
            }
            String string3 = refreshToken = useEnv ? System.getenv("CE_DROPBOX_REFRESH_TOKEN") : (String)Optional.ofNullable(arguments.get("refresh-token")).map(String::valueOf).orElse(null);
            if (refreshToken == null || refreshToken.isEmpty()) {
                throw new LocalizedException("warning.config.host.dropbox.missing_refresh_token", new String[0]);
            }
            String uploadPath = ResourceConfigUtils.requireNonEmptyStringOrThrow(arguments.get("upload-path"), () -> new LocalizedException("warning.config.host.dropbox.missing_upload_path", new String[0]));
            ProxySelector proxy = this.getProxySelector(MiscUtils.castToMap(arguments.get("proxy"), true));
            return new DropboxHost(appKey, appSecret, refreshToken, "/" + uploadPath, proxy);
        }
    }
}

