/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.pack.host.impl;

import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.ProxySelector;
import java.net.URI;
import java.net.URLEncoder;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.momirealms.craftengine.core.pack.host.ResourcePackDownloadData;
import net.momirealms.craftengine.core.pack.host.ResourcePackHost;
import net.momirealms.craftengine.core.pack.host.ResourcePackHostFactory;
import net.momirealms.craftengine.core.pack.host.ResourcePackHosts;
import net.momirealms.craftengine.core.plugin.CraftEngine;
import net.momirealms.craftengine.core.plugin.locale.LocalizedException;
import net.momirealms.craftengine.core.util.GsonHelper;
import net.momirealms.craftengine.core.util.HashUtils;
import net.momirealms.craftengine.core.util.Key;
import net.momirealms.craftengine.core.util.MiscUtils;
import net.momirealms.craftengine.core.util.ResourceConfigUtils;

public class GitLabHost
implements ResourcePackHost {
    public static final Factory FACTORY = new Factory();
    private final String gitlabUrl;
    private final String accessToken;
    private final String projectId;
    private final ProxySelector proxy;
    private String url;
    private String sha1;
    private UUID uuid;

    public GitLabHost(String gitlabUrl, String accessToken, String projectId, ProxySelector proxy) {
        this.gitlabUrl = gitlabUrl;
        this.accessToken = accessToken;
        this.projectId = projectId;
        this.proxy = proxy;
        this.readCacheFromDisk();
    }

    public void readCacheFromDisk() {
        Path cachePath = CraftEngine.instance().dataFolderPath().resolve("gitlab.cache");
        if (!Files.exists(cachePath, new LinkOption[0])) {
            return;
        }
        try (InputStream is = Files.newInputStream(cachePath, new OpenOption[0]);){
            Map cache = (Map)GsonHelper.get().fromJson((Reader)new InputStreamReader(is), new TypeToken<Map<String, String>>(this){}.getType());
            this.url = (String)cache.get("url");
            this.sha1 = (String)cache.get("sha1");
            String uuidString = (String)cache.get("uuid");
            if (uuidString != null && !uuidString.isEmpty()) {
                this.uuid = UUID.fromString(uuidString);
            }
            CraftEngine.instance().logger().info("[GitLab] Loaded cached resource pack info");
        }
        catch (Exception e) {
            CraftEngine.instance().logger().warn("[GitLab] Failed to read cache file: " + String.valueOf(cachePath), e);
        }
    }

    public void saveCacheToDisk() {
        HashMap<String, String> cache = new HashMap<String, String>();
        cache.put("url", this.url);
        cache.put("sha1", this.sha1);
        cache.put("uuid", this.uuid != null ? this.uuid.toString() : "");
        Path cachePath = CraftEngine.instance().dataFolderPath().resolve("gitlab.cache");
        try {
            Files.writeString(cachePath, (CharSequence)GsonHelper.get().toJson(cache), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        }
        catch (IOException e) {
            CraftEngine.instance().logger().warn("[GitLab] Failed to save cache: " + e.getMessage());
        }
    }

    @Override
    public boolean canUpload() {
        return true;
    }

    @Override
    public Key type() {
        return ResourcePackHosts.GITLAB;
    }

    @Override
    public CompletableFuture<List<ResourcePackDownloadData>> requestResourcePackDownloadLink(UUID player) {
        if (this.url == null) {
            return CompletableFuture.completedFuture(Collections.emptyList());
        }
        return CompletableFuture.completedFuture(List.of(ResourcePackDownloadData.of(this.url, this.uuid, this.sha1)));
    }

    @Override
    public CompletableFuture<Void> upload(Path resourcePackPath) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        CraftEngine.instance().scheduler().executeAsync(() -> {
            this.sha1 = HashUtils.calculateLocalFileSha1(resourcePackPath);
            this.uuid = UUID.nameUUIDFromBytes(this.sha1.getBytes(StandardCharsets.UTF_8));
            try (HttpClient client = HttpClient.newBuilder().proxy(this.proxy).build();){
                String boundary = UUID.randomUUID().toString();
                HttpRequest request = HttpRequest.newBuilder().uri(URI.create(this.gitlabUrl + "/api/v4/projects/" + this.projectId + "/uploads")).header("PRIVATE-TOKEN", this.accessToken).header("Content-Type", "multipart/form-data; boundary=" + boundary).POST(this.buildMultipartBody(resourcePackPath, boundary)).build();
                long uploadStart = System.currentTimeMillis();
                CraftEngine.instance().logger().info("[GitLab] Initiating resource pack upload...");
                ((CompletableFuture)client.sendAsync(request, HttpResponse.BodyHandlers.ofString()).thenAccept(response -> {
                    Map<String, Object> json;
                    long uploadTime = System.currentTimeMillis() - uploadStart;
                    CraftEngine.instance().logger().info("[GitLab] Upload request completed in " + uploadTime + "ms");
                    if ((response.statusCode() == 200 || response.statusCode() == 201) && (json = GsonHelper.parseJsonToMap((String)response.body())).containsKey("full_path")) {
                        this.url = this.gitlabUrl + String.valueOf(json.get("full_path"));
                        future.complete(null);
                        this.saveCacheToDisk();
                        return;
                    }
                    CraftEngine.instance().logger().warn("[GitLab] Upload failed: " + (String)response.body());
                    future.completeExceptionally(new RuntimeException("Upload failed: " + (String)response.body()));
                })).exceptionally(ex -> {
                    CraftEngine.instance().logger().warn("[GitLab] Upload error: " + ex.getMessage());
                    future.completeExceptionally((Throwable)ex);
                    return null;
                });
            }
            catch (IOException e) {
                CraftEngine.instance().logger().warn("[GitLab] Failed to upload resource pack: " + e.getMessage());
            }
        });
        return future;
    }

    private HttpRequest.BodyPublisher buildMultipartBody(Path filePath, String boundary) throws IOException {
        ArrayList<byte[]> parts = new ArrayList<byte[]>();
        String filePartHeader = "--" + boundary + "\r\nContent-Disposition: form-data; name=\"file\"; filename=\"" + String.valueOf(filePath.getFileName()) + "\"\r\nContent-Type: application/octet-stream\r\n\r\n";
        parts.add(filePartHeader.getBytes());
        parts.add(Files.readAllBytes(filePath));
        parts.add("\r\n".getBytes());
        String endBoundary = "--" + boundary + "--\r\n";
        parts.add(endBoundary.getBytes());
        return HttpRequest.BodyPublishers.ofByteArrays(parts);
    }

    public static class Factory
    implements ResourcePackHostFactory {
        @Override
        public ResourcePackHost create(Map<String, Object> arguments) {
            String accessToken;
            boolean useEnv = ResourceConfigUtils.getAsBoolean(arguments.getOrDefault("use-environment-variables", false), "use-environment-variables");
            String gitlabUrl = Optional.ofNullable(arguments.get("gitlab-url")).map(String::valueOf).orElse(null);
            if (gitlabUrl == null || gitlabUrl.isEmpty()) {
                throw new LocalizedException("warning.config.host.gitlab.missing_url", new String[0]);
            }
            if (gitlabUrl.endsWith("/")) {
                gitlabUrl = gitlabUrl.substring(0, gitlabUrl.length() - 1);
            }
            String string = accessToken = useEnv ? System.getenv("CE_GITLAB_ACCESS_TOKEN") : (String)Optional.ofNullable(arguments.get("access-token")).map(String::valueOf).orElse(null);
            if (accessToken == null || accessToken.isEmpty()) {
                throw new LocalizedException("warning.config.host.gitlab.missing_token", new String[0]);
            }
            String projectId = Optional.ofNullable(arguments.get("project-id")).map(String::valueOf).orElse(null);
            if (projectId == null || projectId.isEmpty()) {
                throw new LocalizedException("warning.config.host.gitlab.missing_project", new String[0]);
            }
            projectId = URLEncoder.encode(projectId, StandardCharsets.UTF_8).replace("/", "%2F");
            ProxySelector proxy = this.getProxySelector(MiscUtils.castToMap(arguments.get("proxy"), true));
            return new GitLabHost(gitlabUrl, accessToken, projectId, proxy);
        }
    }
}

