/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.pack.model.condition;

import com.google.gson.JsonObject;
import java.util.Map;
import net.momirealms.craftengine.core.pack.model.condition.BrokenConditionProperty;
import net.momirealms.craftengine.core.pack.model.condition.ComponentConditionProperty;
import net.momirealms.craftengine.core.pack.model.condition.ConditionProperty;
import net.momirealms.craftengine.core.pack.model.condition.ConditionPropertyFactory;
import net.momirealms.craftengine.core.pack.model.condition.ConditionPropertyReader;
import net.momirealms.craftengine.core.pack.model.condition.CustomModelDataConditionProperty;
import net.momirealms.craftengine.core.pack.model.condition.DamagedConditionProperty;
import net.momirealms.craftengine.core.pack.model.condition.HasComponentConditionProperty;
import net.momirealms.craftengine.core.pack.model.condition.KeyBindDownConditionProperty;
import net.momirealms.craftengine.core.pack.model.condition.RodCastConditionProperty;
import net.momirealms.craftengine.core.pack.model.condition.SimpleConditionProperty;
import net.momirealms.craftengine.core.pack.model.condition.UsingItemConditionProperty;
import net.momirealms.craftengine.core.plugin.locale.LocalizedResourceConfigException;
import net.momirealms.craftengine.core.registry.BuiltInRegistries;
import net.momirealms.craftengine.core.registry.Holder;
import net.momirealms.craftengine.core.registry.Registries;
import net.momirealms.craftengine.core.registry.WritableRegistry;
import net.momirealms.craftengine.core.util.Key;
import net.momirealms.craftengine.core.util.ResourceConfigUtils;
import net.momirealms.craftengine.core.util.ResourceKey;

public class ConditionProperties {
    public static final Key BROKEN = Key.of("minecraft:broken");
    public static final Key BUNDLE_HAS_SELECTED_ITEM = Key.of("minecraft:bundle/has_selected_item");
    public static final Key CARRIED = Key.of("minecraft:carried");
    public static final Key CUSTOM_MODEL_DATA = Key.of("minecraft:custom_model_data");
    public static final Key DAMAGED = Key.of("minecraft:damaged");
    public static final Key EXTENDED_VIEW = Key.of("minecraft:extended_view");
    public static final Key FISHING_ROD_CAST = Key.of("minecraft:fishing_rod/cast");
    public static final Key HAS_COMPONENT = Key.of("minecraft:has_component");
    public static final Key KEYBIND_DOWN = Key.of("minecraft:keybind_down");
    public static final Key COMPONENT = Key.of("minecraft:component");
    public static final Key SELECTED = Key.of("minecraft:selected");
    public static final Key USING_ITEM = Key.of("minecraft:using_item");
    public static final Key VIEW_ENTITY = Key.of("minecraft:view_entity");

    public static void registerFactory(Key key, ConditionPropertyFactory factory) {
        Holder.Reference<ConditionPropertyFactory> holder = ((WritableRegistry)BuiltInRegistries.CONDITION_PROPERTY_FACTORY).registerForHolder(new ResourceKey(Registries.CONDITION_PROPERTY_FACTORY.location(), key));
        holder.bindValue(factory);
    }

    public static void registerReader(Key key, ConditionPropertyReader reader) {
        Holder.Reference<ConditionPropertyReader> holder = ((WritableRegistry)BuiltInRegistries.CONDITION_PROPERTY_READER).registerForHolder(new ResourceKey(Registries.CONDITION_PROPERTY_READER.location(), key));
        holder.bindValue(reader);
    }

    public static ConditionProperty fromMap(Map<String, Object> map) {
        String type = ResourceConfigUtils.requireNonEmptyStringOrThrow(map.get("property"), "warning.config.item.model.condition.missing_property");
        Key key = Key.withDefaultNamespace(type, "minecraft");
        ConditionPropertyFactory factory = BuiltInRegistries.CONDITION_PROPERTY_FACTORY.getValue(key);
        if (factory == null) {
            throw new LocalizedResourceConfigException("warning.config.item.model.condition.invalid_property", type);
        }
        return factory.create(map);
    }

    public static ConditionProperty fromJson(JsonObject json) {
        String type = json.get("property").getAsString();
        Key key = Key.withDefaultNamespace(type, "minecraft");
        ConditionPropertyReader reader = BuiltInRegistries.CONDITION_PROPERTY_READER.getValue(key);
        if (reader == null) {
            throw new IllegalArgumentException("Invalid condition property type: " + String.valueOf(key));
        }
        return reader.read(json);
    }

    static {
        ConditionProperties.registerFactory(BROKEN, BrokenConditionProperty.FACTORY);
        ConditionProperties.registerReader(BROKEN, BrokenConditionProperty.READER);
        ConditionProperties.registerFactory(BUNDLE_HAS_SELECTED_ITEM, SimpleConditionProperty.FACTORY);
        ConditionProperties.registerReader(BUNDLE_HAS_SELECTED_ITEM, SimpleConditionProperty.READER);
        ConditionProperties.registerFactory(CARRIED, SimpleConditionProperty.FACTORY);
        ConditionProperties.registerReader(CARRIED, SimpleConditionProperty.READER);
        ConditionProperties.registerFactory(DAMAGED, DamagedConditionProperty.FACTORY);
        ConditionProperties.registerReader(DAMAGED, DamagedConditionProperty.READER);
        ConditionProperties.registerFactory(EXTENDED_VIEW, SimpleConditionProperty.FACTORY);
        ConditionProperties.registerReader(EXTENDED_VIEW, SimpleConditionProperty.READER);
        ConditionProperties.registerFactory(FISHING_ROD_CAST, RodCastConditionProperty.FACTORY);
        ConditionProperties.registerReader(FISHING_ROD_CAST, RodCastConditionProperty.READER);
        ConditionProperties.registerFactory(SELECTED, SimpleConditionProperty.FACTORY);
        ConditionProperties.registerReader(SELECTED, SimpleConditionProperty.READER);
        ConditionProperties.registerFactory(USING_ITEM, UsingItemConditionProperty.FACTORY);
        ConditionProperties.registerReader(USING_ITEM, UsingItemConditionProperty.READER);
        ConditionProperties.registerFactory(VIEW_ENTITY, SimpleConditionProperty.FACTORY);
        ConditionProperties.registerReader(VIEW_ENTITY, SimpleConditionProperty.READER);
        ConditionProperties.registerFactory(CUSTOM_MODEL_DATA, CustomModelDataConditionProperty.FACTORY);
        ConditionProperties.registerReader(CUSTOM_MODEL_DATA, CustomModelDataConditionProperty.READER);
        ConditionProperties.registerFactory(HAS_COMPONENT, HasComponentConditionProperty.FACTORY);
        ConditionProperties.registerReader(HAS_COMPONENT, HasComponentConditionProperty.READER);
        ConditionProperties.registerFactory(KEYBIND_DOWN, KeyBindDownConditionProperty.FACTORY);
        ConditionProperties.registerReader(KEYBIND_DOWN, KeyBindDownConditionProperty.READER);
        ConditionProperties.registerFactory(COMPONENT, ComponentConditionProperty.FACTORY);
        ConditionProperties.registerReader(COMPONENT, ComponentConditionProperty.READER);
    }
}

