/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.pack.model.rangedisptach;

import com.google.gson.JsonObject;
import java.util.Map;
import net.momirealms.craftengine.core.pack.model.LegacyModelPredicate;
import net.momirealms.craftengine.core.pack.model.rangedisptach.RangeDispatchProperties;
import net.momirealms.craftengine.core.pack.model.rangedisptach.RangeDispatchProperty;
import net.momirealms.craftengine.core.pack.model.rangedisptach.RangeDispatchPropertyFactory;
import net.momirealms.craftengine.core.pack.model.rangedisptach.RangeDispatchPropertyReader;
import net.momirealms.craftengine.core.util.Key;
import net.momirealms.craftengine.core.util.ResourceConfigUtils;

public class DamageRangeDispatchProperty
implements RangeDispatchProperty,
LegacyModelPredicate<Float> {
    public static final Factory FACTORY = new Factory();
    public static final Reader READER = new Reader();
    private final boolean normalize;

    public DamageRangeDispatchProperty(boolean normalize) {
        this.normalize = normalize;
    }

    @Override
    public Key type() {
        return RangeDispatchProperties.DAMAGE;
    }

    @Override
    public void accept(JsonObject jsonObject) {
        jsonObject.addProperty("property", this.type().toString());
        if (!this.normalize) {
            jsonObject.addProperty("normalize", Boolean.valueOf(false));
        }
    }

    @Override
    public String legacyPredicateId(Key material) {
        if (this.normalize) {
            return "damage";
        }
        throw new RuntimeException("Enable 'normalize' option if you want to use 'damage' on 1.21.3 and below");
    }

    @Override
    public Number toLegacyValue(Float value) {
        if (this.normalize) {
            return value;
        }
        throw new RuntimeException("Enable 'normalize' option if you want to use 'damage' on 1.21.3 and below");
    }

    public static class Factory
    implements RangeDispatchPropertyFactory {
        @Override
        public RangeDispatchProperty create(Map<String, Object> arguments) {
            boolean normalize = ResourceConfigUtils.getAsBoolean(arguments.getOrDefault("normalize", true), "normalize");
            return new DamageRangeDispatchProperty(normalize);
        }
    }

    public static class Reader
    implements RangeDispatchPropertyReader {
        @Override
        public RangeDispatchProperty read(JsonObject json) {
            boolean normalize = !json.has("normalize") || json.get("normalize").getAsBoolean();
            return new DamageRangeDispatchProperty(normalize);
        }
    }
}

