/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.pack.model.rangedisptach;

import com.google.gson.JsonObject;
import java.util.Map;
import net.momirealms.craftengine.core.pack.model.rangedisptach.CompassRangeDispatchProperty;
import net.momirealms.craftengine.core.pack.model.rangedisptach.CrossBowPullingRangeDispatchProperty;
import net.momirealms.craftengine.core.pack.model.rangedisptach.CustomModelDataRangeDispatchProperty;
import net.momirealms.craftengine.core.pack.model.rangedisptach.DamageRangeDispatchProperty;
import net.momirealms.craftengine.core.pack.model.rangedisptach.NormalizeRangeDispatchProperty;
import net.momirealms.craftengine.core.pack.model.rangedisptach.RangeDispatchProperty;
import net.momirealms.craftengine.core.pack.model.rangedisptach.RangeDispatchPropertyFactory;
import net.momirealms.craftengine.core.pack.model.rangedisptach.RangeDispatchPropertyReader;
import net.momirealms.craftengine.core.pack.model.rangedisptach.SimpleRangeDispatchProperty;
import net.momirealms.craftengine.core.pack.model.rangedisptach.TimeRangeDispatchProperty;
import net.momirealms.craftengine.core.pack.model.rangedisptach.UseCycleRangeDispatchProperty;
import net.momirealms.craftengine.core.pack.model.rangedisptach.UseDurationRangeDispatchProperty;
import net.momirealms.craftengine.core.plugin.locale.LocalizedResourceConfigException;
import net.momirealms.craftengine.core.registry.BuiltInRegistries;
import net.momirealms.craftengine.core.registry.Holder;
import net.momirealms.craftengine.core.registry.Registries;
import net.momirealms.craftengine.core.registry.WritableRegistry;
import net.momirealms.craftengine.core.util.Key;
import net.momirealms.craftengine.core.util.ResourceConfigUtils;
import net.momirealms.craftengine.core.util.ResourceKey;

public class RangeDispatchProperties {
    public static final Key BUNDLE_FULLNESS = Key.of("minecraft:bundle/fullness");
    public static final Key COMPASS = Key.of("minecraft:compass");
    public static final Key COOLDOWN = Key.of("minecraft:cooldown");
    public static final Key COUNT = Key.of("minecraft:count");
    public static final Key CROSSBOW_PULL = Key.of("minecraft:crossbow/pull");
    public static final Key CUSTOM_MODEL_DATA = Key.of("minecraft:custom_model_data");
    public static final Key DAMAGE = Key.of("minecraft:damage");
    public static final Key TIME = Key.of("minecraft:time");
    public static final Key USE_CYCLE = Key.of("minecraft:use_cycle");
    public static final Key USE_DURATION = Key.of("minecraft:use_duration");

    public static void registerFactory(Key key, RangeDispatchPropertyFactory factory) {
        Holder.Reference<RangeDispatchPropertyFactory> holder = ((WritableRegistry)BuiltInRegistries.RANGE_DISPATCH_PROPERTY_FACTORY).registerForHolder(new ResourceKey(Registries.RANGE_DISPATCH_PROPERTY_FACTORY.location(), key));
        holder.bindValue(factory);
    }

    public static void registerReader(Key key, RangeDispatchPropertyReader reader) {
        Holder.Reference<RangeDispatchPropertyReader> holder = ((WritableRegistry)BuiltInRegistries.RANGE_DISPATCH_PROPERTY_READER).registerForHolder(new ResourceKey(Registries.RANGE_DISPATCH_PROPERTY_READER.location(), key));
        holder.bindValue(reader);
    }

    public static RangeDispatchProperty fromMap(Map<String, Object> map) {
        String type = ResourceConfigUtils.requireNonEmptyStringOrThrow(map.get("property"), "warning.config.item.model.range_dispatch.missing_property");
        Key key = Key.withDefaultNamespace(type, "minecraft");
        RangeDispatchPropertyFactory factory = BuiltInRegistries.RANGE_DISPATCH_PROPERTY_FACTORY.getValue(key);
        if (factory == null) {
            throw new LocalizedResourceConfigException("warning.config.item.model.range_dispatch.invalid_property", type);
        }
        return factory.create(map);
    }

    public static RangeDispatchProperty fromJson(JsonObject json) {
        String type = json.get("property").getAsString();
        Key key = Key.withDefaultNamespace(type, "minecraft");
        RangeDispatchPropertyReader reader = BuiltInRegistries.RANGE_DISPATCH_PROPERTY_READER.getValue(key);
        if (reader == null) {
            throw new IllegalArgumentException("Invalid range dispatch property type: " + String.valueOf(key));
        }
        return reader.read(json);
    }

    static {
        RangeDispatchProperties.registerFactory(BUNDLE_FULLNESS, SimpleRangeDispatchProperty.FACTORY);
        RangeDispatchProperties.registerReader(BUNDLE_FULLNESS, SimpleRangeDispatchProperty.READER);
        RangeDispatchProperties.registerFactory(COOLDOWN, SimpleRangeDispatchProperty.FACTORY);
        RangeDispatchProperties.registerReader(COOLDOWN, SimpleRangeDispatchProperty.READER);
        RangeDispatchProperties.registerFactory(CROSSBOW_PULL, CrossBowPullingRangeDispatchProperty.FACTORY);
        RangeDispatchProperties.registerReader(CROSSBOW_PULL, CrossBowPullingRangeDispatchProperty.READER);
        RangeDispatchProperties.registerFactory(COMPASS, CompassRangeDispatchProperty.FACTORY);
        RangeDispatchProperties.registerReader(COMPASS, CompassRangeDispatchProperty.READER);
        RangeDispatchProperties.registerFactory(COUNT, NormalizeRangeDispatchProperty.FACTORY);
        RangeDispatchProperties.registerReader(COUNT, NormalizeRangeDispatchProperty.READER);
        RangeDispatchProperties.registerFactory(DAMAGE, DamageRangeDispatchProperty.FACTORY);
        RangeDispatchProperties.registerReader(DAMAGE, DamageRangeDispatchProperty.READER);
        RangeDispatchProperties.registerFactory(CUSTOM_MODEL_DATA, CustomModelDataRangeDispatchProperty.FACTORY);
        RangeDispatchProperties.registerReader(CUSTOM_MODEL_DATA, CustomModelDataRangeDispatchProperty.READER);
        RangeDispatchProperties.registerFactory(TIME, TimeRangeDispatchProperty.FACTORY);
        RangeDispatchProperties.registerReader(TIME, TimeRangeDispatchProperty.READER);
        RangeDispatchProperties.registerFactory(USE_CYCLE, UseCycleRangeDispatchProperty.FACTORY);
        RangeDispatchProperties.registerReader(USE_CYCLE, UseCycleRangeDispatchProperty.READER);
        RangeDispatchProperties.registerFactory(USE_DURATION, UseDurationRangeDispatchProperty.FACTORY);
        RangeDispatchProperties.registerReader(USE_DURATION, UseDurationRangeDispatchProperty.READER);
    }
}

