/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.pack.model.select;

import com.google.gson.JsonObject;
import java.util.Map;
import net.momirealms.craftengine.core.pack.model.select.BlockStateSelectProperty;
import net.momirealms.craftengine.core.pack.model.select.ChargeTypeSelectProperty;
import net.momirealms.craftengine.core.pack.model.select.ComponentSelectProperty;
import net.momirealms.craftengine.core.pack.model.select.CustomModelDataSelectProperty;
import net.momirealms.craftengine.core.pack.model.select.LocalTimeSelectProperty;
import net.momirealms.craftengine.core.pack.model.select.MainHandSelectProperty;
import net.momirealms.craftengine.core.pack.model.select.SelectProperty;
import net.momirealms.craftengine.core.pack.model.select.SelectPropertyFactory;
import net.momirealms.craftengine.core.pack.model.select.SelectPropertyReader;
import net.momirealms.craftengine.core.pack.model.select.SimpleSelectProperty;
import net.momirealms.craftengine.core.pack.model.select.TrimMaterialSelectProperty;
import net.momirealms.craftengine.core.plugin.locale.LocalizedResourceConfigException;
import net.momirealms.craftengine.core.registry.BuiltInRegistries;
import net.momirealms.craftengine.core.registry.Holder;
import net.momirealms.craftengine.core.registry.Registries;
import net.momirealms.craftengine.core.registry.WritableRegistry;
import net.momirealms.craftengine.core.util.Key;
import net.momirealms.craftengine.core.util.ResourceConfigUtils;
import net.momirealms.craftengine.core.util.ResourceKey;

public class SelectProperties {
    public static final Key BLOCK_STATE = Key.of("minecraft:block_state");
    public static final Key CHARGE_TYPE = Key.of("minecraft:charge_type");
    public static final Key CONTEXT_DIMENSION = Key.of("minecraft:context_dimension");
    public static final Key CONTEXT_ENTITY_TYPE = Key.of("minecraft:context_entity_type");
    public static final Key CUSTOM_MODEL_DATA = Key.of("minecraft:custom_model_data");
    public static final Key DISPLAY_CONTEXT = Key.of("minecraft:display_context");
    public static final Key LOCAL_TIME = Key.of("minecraft:local_time");
    public static final Key MAIN_HAND = Key.of("minecraft:main_hand");
    public static final Key TRIM_MATERIAL = Key.of("minecraft:trim_material");
    public static final Key COMPONENT = Key.of("minecraft:component");

    public static void registerFactory(Key key, SelectPropertyFactory factory) {
        Holder.Reference<SelectPropertyFactory> holder = ((WritableRegistry)BuiltInRegistries.SELECT_PROPERTY_FACTORY).registerForHolder(new ResourceKey(Registries.SELECT_PROPERTY_FACTORY.location(), key));
        holder.bindValue(factory);
    }

    public static void registerReader(Key key, SelectPropertyReader reader) {
        Holder.Reference<SelectPropertyReader> holder = ((WritableRegistry)BuiltInRegistries.SELECT_PROPERTY_READER).registerForHolder(new ResourceKey(Registries.SELECT_PROPERTY_READER.location(), key));
        holder.bindValue(reader);
    }

    public static SelectProperty fromMap(Map<String, Object> map) {
        String type = ResourceConfigUtils.requireNonEmptyStringOrThrow(map.get("property"), "warning.config.item.model.select.missing_property");
        Key key = Key.withDefaultNamespace(type, "minecraft");
        SelectPropertyFactory factory = BuiltInRegistries.SELECT_PROPERTY_FACTORY.getValue(key);
        if (factory == null) {
            throw new LocalizedResourceConfigException("warning.config.item.model.select.invalid_property", type);
        }
        return factory.create(map);
    }

    public static SelectProperty fromJson(JsonObject json) {
        String type = json.get("property").getAsString();
        Key key = Key.withDefaultNamespace(type, "minecraft");
        SelectPropertyReader reader = BuiltInRegistries.SELECT_PROPERTY_READER.getValue(key);
        if (reader == null) {
            throw new IllegalArgumentException("Invalid select property type: " + String.valueOf(key));
        }
        return reader.read(json);
    }

    static {
        SelectProperties.registerFactory(CHARGE_TYPE, ChargeTypeSelectProperty.FACTORY);
        SelectProperties.registerReader(CHARGE_TYPE, ChargeTypeSelectProperty.READER);
        SelectProperties.registerFactory(CONTEXT_DIMENSION, SimpleSelectProperty.FACTORY);
        SelectProperties.registerReader(CONTEXT_DIMENSION, SimpleSelectProperty.READER);
        SelectProperties.registerFactory(CONTEXT_ENTITY_TYPE, SimpleSelectProperty.FACTORY);
        SelectProperties.registerReader(CONTEXT_ENTITY_TYPE, SimpleSelectProperty.READER);
        SelectProperties.registerFactory(DISPLAY_CONTEXT, SimpleSelectProperty.FACTORY);
        SelectProperties.registerReader(DISPLAY_CONTEXT, SimpleSelectProperty.READER);
        SelectProperties.registerFactory(MAIN_HAND, MainHandSelectProperty.FACTORY);
        SelectProperties.registerReader(MAIN_HAND, MainHandSelectProperty.READER);
        SelectProperties.registerFactory(TRIM_MATERIAL, TrimMaterialSelectProperty.FACTORY);
        SelectProperties.registerReader(TRIM_MATERIAL, TrimMaterialSelectProperty.READER);
        SelectProperties.registerFactory(BLOCK_STATE, BlockStateSelectProperty.FACTORY);
        SelectProperties.registerReader(BLOCK_STATE, BlockStateSelectProperty.READER);
        SelectProperties.registerFactory(CUSTOM_MODEL_DATA, CustomModelDataSelectProperty.FACTORY);
        SelectProperties.registerReader(CUSTOM_MODEL_DATA, CustomModelDataSelectProperty.READER);
        SelectProperties.registerFactory(LOCAL_TIME, LocalTimeSelectProperty.FACTORY);
        SelectProperties.registerReader(LOCAL_TIME, LocalTimeSelectProperty.READER);
        SelectProperties.registerFactory(COMPONENT, ComponentSelectProperty.FACTORY);
        SelectProperties.registerReader(COMPONENT, ComponentSelectProperty.READER);
    }
}

