/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.pack.model.special;

import com.google.gson.JsonObject;
import java.util.Map;
import net.momirealms.craftengine.core.pack.model.special.BannerSpecialModel;
import net.momirealms.craftengine.core.pack.model.special.BedSpecialModel;
import net.momirealms.craftengine.core.pack.model.special.ChestSpecialModel;
import net.momirealms.craftengine.core.pack.model.special.HeadSpecialModel;
import net.momirealms.craftengine.core.pack.model.special.PlayerHeadSpecialModel;
import net.momirealms.craftengine.core.pack.model.special.ShulkerBoxSpecialModel;
import net.momirealms.craftengine.core.pack.model.special.SignSpecialModel;
import net.momirealms.craftengine.core.pack.model.special.SimpleSpecialModel;
import net.momirealms.craftengine.core.pack.model.special.SpecialModel;
import net.momirealms.craftengine.core.pack.model.special.SpecialModelFactory;
import net.momirealms.craftengine.core.pack.model.special.SpecialModelReader;
import net.momirealms.craftengine.core.plugin.locale.LocalizedResourceConfigException;
import net.momirealms.craftengine.core.registry.BuiltInRegistries;
import net.momirealms.craftengine.core.registry.Holder;
import net.momirealms.craftengine.core.registry.Registries;
import net.momirealms.craftengine.core.registry.WritableRegistry;
import net.momirealms.craftengine.core.util.Key;
import net.momirealms.craftengine.core.util.ResourceConfigUtils;
import net.momirealms.craftengine.core.util.ResourceKey;

public class SpecialModels {
    public static final Key BANNER = Key.of("minecraft:banner");
    public static final Key BED = Key.of("minecraft:bed");
    public static final Key CONDUIT = Key.of("minecraft:conduit");
    public static final Key CHEST = Key.of("minecraft:chest");
    public static final Key DECORATED_POT = Key.of("minecraft:decorated_pot");
    public static final Key HANGING_SIGN = Key.of("minecraft:hanging_sign");
    public static final Key HEAD = Key.of("minecraft:head");
    public static final Key SHIELD = Key.of("minecraft:shield");
    public static final Key SHULKER_BOX = Key.of("minecraft:shulker_box");
    public static final Key STANDING_SIGN = Key.of("minecraft:standing_sign");
    public static final Key TRIDENT = Key.of("minecraft:trident");
    public static final Key PLAYER_HEAD = Key.of("minecraft:player_head");

    public static void registerFactory(Key key, SpecialModelFactory factory) {
        Holder.Reference<SpecialModelFactory> holder = ((WritableRegistry)BuiltInRegistries.SPECIAL_MODEL_FACTORY).registerForHolder(new ResourceKey(Registries.SPECIAL_MODEL_FACTORY.location(), key));
        holder.bindValue(factory);
    }

    public static void registerReader(Key key, SpecialModelReader factory) {
        Holder.Reference<SpecialModelReader> holder = ((WritableRegistry)BuiltInRegistries.SPECIAL_MODEL_READER).registerForHolder(new ResourceKey(Registries.SPECIAL_MODEL_READER.location(), key));
        holder.bindValue(factory);
    }

    public static SpecialModel fromMap(Map<String, Object> map) {
        String type = ResourceConfigUtils.requireNonEmptyStringOrThrow(map.get("type"), "warning.config.item.model.special.missing_type");
        Key key = Key.withDefaultNamespace(type, "minecraft");
        SpecialModelFactory factory = BuiltInRegistries.SPECIAL_MODEL_FACTORY.getValue(key);
        if (factory == null) {
            throw new LocalizedResourceConfigException("warning.config.item.model.special.invalid_type", type);
        }
        return factory.create(map);
    }

    public static SpecialModel fromJson(JsonObject json) {
        String type = json.get("type").getAsString();
        Key key = Key.withDefaultNamespace(type, "minecraft");
        SpecialModelReader reader = BuiltInRegistries.SPECIAL_MODEL_READER.getValue(key);
        if (reader == null) {
            throw new IllegalArgumentException("Invalid special model type: " + String.valueOf(key));
        }
        return reader.read(json);
    }

    static {
        SpecialModels.registerFactory(TRIDENT, SimpleSpecialModel.FACTORY);
        SpecialModels.registerReader(TRIDENT, SimpleSpecialModel.READER);
        SpecialModels.registerFactory(DECORATED_POT, SimpleSpecialModel.FACTORY);
        SpecialModels.registerReader(DECORATED_POT, SimpleSpecialModel.READER);
        SpecialModels.registerFactory(CONDUIT, SimpleSpecialModel.FACTORY);
        SpecialModels.registerReader(CONDUIT, SimpleSpecialModel.READER);
        SpecialModels.registerFactory(SHIELD, SimpleSpecialModel.FACTORY);
        SpecialModels.registerReader(SHIELD, SimpleSpecialModel.READER);
        SpecialModels.registerFactory(HANGING_SIGN, SignSpecialModel.FACTORY);
        SpecialModels.registerReader(HANGING_SIGN, SignSpecialModel.READER);
        SpecialModels.registerFactory(STANDING_SIGN, SignSpecialModel.FACTORY);
        SpecialModels.registerReader(STANDING_SIGN, SignSpecialModel.READER);
        SpecialModels.registerFactory(PLAYER_HEAD, PlayerHeadSpecialModel.FACTORY);
        SpecialModels.registerReader(PLAYER_HEAD, PlayerHeadSpecialModel.READER);
        SpecialModels.registerFactory(CHEST, ChestSpecialModel.FACTORY);
        SpecialModels.registerReader(CHEST, ChestSpecialModel.READER);
        SpecialModels.registerFactory(BANNER, BannerSpecialModel.FACTORY);
        SpecialModels.registerReader(BANNER, BannerSpecialModel.READER);
        SpecialModels.registerFactory(BED, BedSpecialModel.FACTORY);
        SpecialModels.registerReader(BED, BedSpecialModel.READER);
        SpecialModels.registerFactory(HEAD, HeadSpecialModel.FACTORY);
        SpecialModels.registerReader(HEAD, HeadSpecialModel.READER);
        SpecialModels.registerFactory(SHULKER_BOX, ShulkerBoxSpecialModel.FACTORY);
        SpecialModels.registerReader(SHULKER_BOX, ShulkerBoxSpecialModel.READER);
    }
}

