/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.plugin.config.template;

import java.util.Map;
import net.momirealms.craftengine.core.plugin.config.template.ExpressionTemplateArgument;
import net.momirealms.craftengine.core.plugin.config.template.ListTemplateArgument;
import net.momirealms.craftengine.core.plugin.config.template.MapTemplateArgument;
import net.momirealms.craftengine.core.plugin.config.template.NullTemplateArgument;
import net.momirealms.craftengine.core.plugin.config.template.PlainStringTemplateArgument;
import net.momirealms.craftengine.core.plugin.config.template.SelfIncreaseIntTemplateArgument;
import net.momirealms.craftengine.core.plugin.config.template.TemplateArgument;
import net.momirealms.craftengine.core.plugin.config.template.TemplateArgumentFactory;
import net.momirealms.craftengine.core.registry.BuiltInRegistries;
import net.momirealms.craftengine.core.registry.Holder;
import net.momirealms.craftengine.core.registry.Registries;
import net.momirealms.craftengine.core.registry.WritableRegistry;
import net.momirealms.craftengine.core.util.Key;
import net.momirealms.craftengine.core.util.ResourceKey;

public class TemplateArguments {
    public static final Key PLAIN = Key.of("craftengine:plain");
    public static final Key SELF_INCREASE_INT = Key.of("craftengine:self_increase_int");
    public static final Key MAP = Key.of("craftengine:map");
    public static final Key LIST = Key.of("craftengine:list");
    public static final Key NULL = Key.of("craftengine:null");
    public static final Key EXPRESSION = Key.of("craftengine:expression");
    public static final Key OBJECT = Key.of("craftengine:object");

    public static void register(Key key, TemplateArgumentFactory factory) {
        Holder.Reference<TemplateArgumentFactory> holder = ((WritableRegistry)BuiltInRegistries.TEMPLATE_ARGUMENT_FACTORY).registerForHolder(new ResourceKey(Registries.TEMPLATE_ARGUMENT_FACTORY.location(), key));
        holder.bindValue(factory);
    }

    public static TemplateArgument fromMap(Map<String, Object> map) {
        String type = (String)map.get("type");
        if (type == null) {
            return new MapTemplateArgument(map);
        }
        Key key = Key.withDefaultNamespace(type, "craftengine");
        TemplateArgumentFactory factory = BuiltInRegistries.TEMPLATE_ARGUMENT_FACTORY.getValue(key);
        if (factory == null) {
            throw new IllegalArgumentException("Unknown argument type: " + type);
        }
        return factory.create(map);
    }

    static {
        TemplateArguments.register(PLAIN, PlainStringTemplateArgument.FACTORY);
        TemplateArguments.register(SELF_INCREASE_INT, SelfIncreaseIntTemplateArgument.FACTORY);
        TemplateArguments.register(MAP, MapTemplateArgument.FACTORY);
        TemplateArguments.register(LIST, ListTemplateArgument.FACTORY);
        TemplateArguments.register(NULL, NullTemplateArgument.FACTORY);
        TemplateArguments.register(EXPRESSION, ExpressionTemplateArgument.FACTORY);
    }
}

