/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.plugin.config.template;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.momirealms.craftengine.core.plugin.Manageable;
import net.momirealms.craftengine.core.plugin.config.ConfigParser;
import net.momirealms.craftengine.core.plugin.config.template.TemplateArgument;
import net.momirealms.craftengine.core.plugin.locale.LocalizedResourceConfigException;
import net.momirealms.craftengine.core.util.Key;
import net.momirealms.craftengine.core.util.SNBTReader;

public interface TemplateManager
extends Manageable {
    public ConfigParser parser();

    public Object applyTemplates(Key var1, Object var2);

    public static ArgumentString preParse(String input) {
        if (input == null || input.isEmpty()) {
            return Literal.literal("");
        }
        ArrayList<ArgumentString> arguments = new ArrayList<ArgumentString>();
        StringBuilder currentLiteral = new StringBuilder();
        int n = input.length();
        int i = 0;
        while (i < n) {
            char c = input.charAt(i);
            if (c == '$' && i + 1 < n && input.charAt(i + 1) == '{') {
                if (!currentLiteral.isEmpty()) {
                    arguments.add(Literal.literal(currentLiteral.toString()));
                    currentLiteral.setLength(0);
                }
                int contentStartIndex = i + 2;
                StringBuilder keyBuilder = new StringBuilder();
                int depth = 1;
                int j = contentStartIndex;
                boolean foundMatch = false;
                while (j < n) {
                    char innerChar = input.charAt(j);
                    if (innerChar == '\\') {
                        if (j + 1 < n && (input.charAt(j + 1) == '{' || input.charAt(j + 1) == '}')) {
                            keyBuilder.append(input.charAt(j + 1));
                            j += 2;
                            continue;
                        }
                        keyBuilder.append(innerChar);
                        ++j;
                        continue;
                    }
                    if (innerChar == '{') {
                        ++depth;
                        keyBuilder.append(innerChar);
                        ++j;
                        continue;
                    }
                    if (innerChar == '}') {
                        if (--depth == 0) {
                            arguments.add(Placeholder.placeholder(keyBuilder.toString()));
                            i = j + 1;
                            foundMatch = true;
                            break;
                        }
                        keyBuilder.append(innerChar);
                        ++j;
                        continue;
                    }
                    keyBuilder.append(innerChar);
                    ++j;
                }
                if (foundMatch) continue;
                currentLiteral.append(c);
                ++i;
                continue;
            }
            if (c == '\\' && i + 1 < n && input.charAt(i + 1) == '$') {
                currentLiteral.append('$');
                i += 2;
                continue;
            }
            currentLiteral.append(c);
            ++i;
        }
        if (!currentLiteral.isEmpty()) {
            arguments.add(Literal.literal(currentLiteral.toString()));
        }
        return switch (arguments.size()) {
            case 0 -> Literal.literal("");
            case 1 -> (ArgumentString)arguments.getFirst();
            case 2 -> new Complex2(input, (ArgumentString)arguments.get(0), (ArgumentString)arguments.get(1));
            default -> new Complex(input, arguments);
        };
    }

    public static final class Literal
    implements ArgumentString {
        private final String value;

        public Literal(String value) {
            this.value = value;
        }

        public static Literal literal(String value) {
            return new Literal(value);
        }

        @Override
        public String rawValue() {
            return this.value;
        }

        @Override
        public Object get(Map<String, TemplateArgument> arguments) {
            return this.value;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Literal)) {
                return false;
            }
            Literal literal = (Literal)o;
            return this.value.equals(literal.value);
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        public String toString() {
            return "Literal(" + this.value + ")";
        }
    }

    public static final class Placeholder
    implements ArgumentString {
        private final String placeholder;
        private final String rawText;
        private final Object defaultValue;

        public Placeholder(String placeholderContent) {
            this.rawText = "${" + placeholderContent + "}";
            int separatorIndex = placeholderContent.indexOf(":-");
            if (separatorIndex == -1) {
                this.placeholder = placeholderContent;
                this.defaultValue = null;
            } else {
                this.placeholder = placeholderContent.substring(0, separatorIndex);
                String defaultValueString = placeholderContent.substring(separatorIndex + 2);
                try {
                    this.defaultValue = new SNBTReader(defaultValueString).deserializeAsJava();
                }
                catch (LocalizedResourceConfigException e) {
                    e.appendTailArgument(this.placeholder);
                    throw e;
                }
            }
        }

        public static Placeholder placeholder(String placeholder) {
            return new Placeholder(placeholder);
        }

        @Override
        public Object get(Map<String, TemplateArgument> arguments) {
            TemplateArgument replacement = arguments.get(this.placeholder);
            if (replacement != null) {
                return replacement.get(arguments);
            }
            return this.defaultValue;
        }

        @Override
        public String rawValue() {
            return this.rawText;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Placeholder)) {
                return false;
            }
            Placeholder that = (Placeholder)o;
            return this.placeholder.equals(that.placeholder);
        }

        public int hashCode() {
            return this.placeholder.hashCode();
        }

        public String toString() {
            return "Placeholder(" + this.placeholder + ")";
        }
    }

    public static interface ArgumentString {
        public String rawValue();

        public Object get(Map<String, TemplateArgument> var1);
    }

    public static final class Complex2
    implements ArgumentString {
        private final String rawText;
        private final ArgumentString arg1;
        private final ArgumentString arg2;

        public Complex2(String rawText, ArgumentString arg1, ArgumentString arg2) {
            this.arg1 = arg1;
            this.arg2 = arg2;
            this.rawText = rawText;
        }

        @Override
        public Object get(Map<String, TemplateArgument> arguments) {
            Object arg1 = this.arg1.get(arguments);
            Object arg2 = this.arg2.get(arguments);
            if (arg1 == null && arg2 == null) {
                return null;
            }
            if (arg1 == null) {
                return String.valueOf(arg2);
            }
            if (arg2 == null) {
                return String.valueOf(arg1);
            }
            return String.valueOf(arg1) + String.valueOf(arg2);
        }

        @Override
        public String rawValue() {
            return this.rawText;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Complex)) {
                return false;
            }
            Complex that = (Complex)o;
            return this.rawText.equals(that.rawText);
        }

        public int hashCode() {
            return this.rawText.hashCode();
        }

        public String toString() {
            return "Complex2(" + this.rawText + ")";
        }
    }

    public static final class Complex
    implements ArgumentString {
        private final List<ArgumentString> parts;
        private final String rawText;

        public Complex(String rawText, List<ArgumentString> parts) {
            this.parts = parts;
            this.rawText = rawText;
        }

        @Override
        public Object get(Map<String, TemplateArgument> arguments) {
            StringBuilder result = new StringBuilder();
            boolean hasValue = false;
            for (ArgumentString part : this.parts) {
                Object arg = part.get(arguments);
                if (arg == null) continue;
                result.append(arg);
                hasValue = true;
            }
            if (!hasValue) {
                return null;
            }
            return result.toString();
        }

        @Override
        public String rawValue() {
            return this.rawText;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Complex)) {
                return false;
            }
            Complex that = (Complex)o;
            return this.rawText.equals(that.rawText);
        }

        public int hashCode() {
            return this.rawText.hashCode();
        }

        public String toString() {
            return "Complex(" + this.rawText + ")";
        }
    }
}

