/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.plugin.context;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ContextKey<T> {
    public static <T> ContextKey<T> direct(@NotNull String node) {
        return new Direct(node);
    }

    public static <T> ContextKey<T> chain(@NotNull String node) {
        String[] parts = node.split("\\.");
        Chain current = null;
        for (String part : parts) {
            current = new Chain(part, current);
        }
        return current;
    }

    @Nullable
    default public <A> ContextKey<A> parent() {
        return null;
    }

    @NotNull
    public String node();

    public record Direct<T>(String node) implements ContextKey<T>
    {
        @Override
        public boolean equals(Object object) {
            if (!(object instanceof ContextKey)) {
                return false;
            }
            ContextKey another = (ContextKey)object;
            return this.node.equals(another.node());
        }

        @Override
        public int hashCode() {
            return this.node.hashCode();
        }
    }

    public static class Chain<T>
    implements ContextKey<T> {
        private final String node;
        private final ContextKey<?> parent;

        protected Chain(@NotNull String node, @Nullable ContextKey<?> parent) {
            this.node = node;
            this.parent = parent;
        }

        @Override
        @NotNull
        public String node() {
            return this.node;
        }

        @Override
        public <A> ContextKey<A> parent() {
            return this.parent;
        }

        public boolean equals(Object object) {
            if (!(object instanceof ContextKey)) {
                return false;
            }
            ContextKey another = (ContextKey)object;
            return this.node.equals(another.node());
        }

        public int hashCode() {
            return this.node.hashCode();
        }
    }
}

