/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.plugin.context.number;

import java.util.Map;
import net.momirealms.craftengine.core.plugin.context.Context;
import net.momirealms.craftengine.core.plugin.context.number.NumberProvider;
import net.momirealms.craftengine.core.plugin.context.number.NumberProviderFactory;
import net.momirealms.craftengine.core.plugin.context.number.NumberProviders;
import net.momirealms.craftengine.core.util.AdventureHelper;
import net.momirealms.craftengine.core.util.Key;
import net.momirealms.craftengine.core.util.ResourceConfigUtils;
import net.momirealms.craftengine.libraries.adventure.text.Component;
import net.momirealms.craftengine.libraries.evalex.EvaluationException;
import net.momirealms.craftengine.libraries.evalex.Expression;
import net.momirealms.craftengine.libraries.evalex.parser.ParseException;

public class ExpressionNumberProvider
implements NumberProvider {
    public static final FactoryImpl FACTORY = new FactoryImpl();
    private final String expr;

    public ExpressionNumberProvider(String expr) {
        this.expr = expr;
    }

    @Override
    public float getFloat(Context context) {
        Component resultComponent = AdventureHelper.customMiniMessage().deserialize(this.expr, context.tagResolvers());
        String resultString = AdventureHelper.plainTextContent(resultComponent);
        Expression expression = new Expression(resultString);
        try {
            return expression.evaluate().getNumberValue().floatValue();
        }
        catch (EvaluationException | ParseException e) {
            throw new RuntimeException("Invalid expression: " + this.expr + " -> " + resultString + " -> Cannot parse", e);
        }
    }

    @Override
    public double getDouble(Context context) {
        Component resultComponent = AdventureHelper.customMiniMessage().deserialize(this.expr, context.tagResolvers());
        String resultString = AdventureHelper.plainTextContent(resultComponent);
        Expression expression = new Expression(resultString);
        try {
            return expression.evaluate().getNumberValue().doubleValue();
        }
        catch (EvaluationException | ParseException e) {
            throw new RuntimeException("Invalid expression: " + this.expr + " -> " + resultString + " -> Cannot parse", e);
        }
    }

    @Override
    public Key type() {
        return NumberProviders.EXPRESSION;
    }

    public String expression() {
        return this.expr;
    }

    public static class FactoryImpl
    implements NumberProviderFactory {
        @Override
        public NumberProvider create(Map<String, Object> arguments) {
            String value = ResourceConfigUtils.requireNonEmptyStringOrThrow(arguments.get("expression"), "warning.config.number.expression.missing_expression");
            return new ExpressionNumberProvider(value);
        }
    }
}

