/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.plugin.dependency;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import net.momirealms.craftengine.core.plugin.dependency.Dependency;
import net.momirealms.craftengine.core.plugin.dependency.DependencyDownloadException;

public enum DependencyRepository {
    MAVEN_CENTRAL("maven", "https://repo1.maven.org/maven2/"){

        @Override
        protected URLConnection openConnection(Dependency dependency) throws IOException {
            URLConnection connection = super.openConnection(dependency);
            connection.setConnectTimeout(5000);
            connection.setReadTimeout(5000);
            return connection;
        }
    }
    ,
    MAVEN_CENTRAL_MIRROR("maven", "https://maven.aliyun.com/repository/public/");

    private final String url;
    private final String id;

    private DependencyRepository(String id, String url) {
        this.url = url;
        this.id = id;
    }

    public String getUrl() {
        return this.url;
    }

    public static List<DependencyRepository> getByID(String id) {
        ArrayList<DependencyRepository> repositories = new ArrayList<DependencyRepository>();
        for (DependencyRepository repository : DependencyRepository.values()) {
            if (!id.equals(repository.id)) continue;
            repositories.add(repository);
        }
        if (id.equals("maven") && Locale.getDefault() == Locale.SIMPLIFIED_CHINESE) {
            Collections.reverse(repositories);
        }
        return repositories;
    }

    protected URLConnection openConnection(Dependency dependency) throws IOException {
        URL dependencyUrl = new URL(this.url + dependency.mavenPath());
        return dependencyUrl.openConnection();
    }

    public byte[] downloadRaw(Dependency dependency) throws DependencyDownloadException {
        byte[] byArray;
        block9: {
            URLConnection connection = this.openConnection(dependency);
            InputStream in = connection.getInputStream();
            try {
                byte[] bytes = in.readAllBytes();
                if (bytes.length == 0) {
                    throw new DependencyDownloadException("Empty stream");
                }
                byArray = bytes;
                if (in == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new DependencyDownloadException(e);
                }
            }
            in.close();
        }
        return byArray;
    }

    public byte[] download(Dependency dependency) throws DependencyDownloadException {
        return this.downloadRaw(dependency);
    }

    public void download(Dependency dependency, Path file) throws DependencyDownloadException {
        try {
            Files.createDirectories(file.getParent(), new FileAttribute[0]);
            Files.write(file, this.download(dependency), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new DependencyDownloadException(e);
        }
    }

    public String id() {
        return this.id;
    }
}

