/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.plugin.locale;

import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import net.momirealms.craftengine.core.plugin.locale.MiniMessageTranslationRegistryImpl;
import net.momirealms.craftengine.libraries.adventure.key.Key;
import net.momirealms.craftengine.libraries.adventure.text.minimessage.MiniMessage;
import net.momirealms.craftengine.libraries.adventure.translation.Translator;
import org.jetbrains.annotations.NotNull;

public interface MiniMessageTranslationRegistry
extends Translator {
    @NotNull
    public static MiniMessageTranslationRegistry create(Key name, MiniMessage miniMessage) {
        return new MiniMessageTranslationRegistryImpl(Objects.requireNonNull(name, "name"), Objects.requireNonNull(miniMessage, "MiniMessage"));
    }

    public void register(@NotNull String var1, @NotNull Locale var2, @NotNull String var3);

    public void unregister(@NotNull String var1);

    public boolean contains(@NotNull String var1);

    public String miniMessageTranslation(@NotNull String var1, @NotNull Locale var2);

    public void defaultLocale(@NotNull Locale var1);

    default public void registerAll(@NotNull Locale locale, @NotNull Map<String, String> bundle) {
        IllegalArgumentException firstError = null;
        int errorCount = 0;
        for (Map.Entry<String, String> entry : bundle.entrySet()) {
            try {
                this.register(entry.getKey(), locale, entry.getValue());
            }
            catch (IllegalArgumentException e) {
                if (firstError == null) {
                    firstError = e;
                }
                ++errorCount;
            }
        }
        if (firstError != null) {
            if (errorCount == 1) {
                throw firstError;
            }
            if (errorCount > 1) {
                throw new IllegalArgumentException(String.format("Invalid or duplicated lang key (and %d more).", errorCount - 1), firstError);
            }
        }
    }
}

