/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.plugin.text.minimessage;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import java.util.Objects;
import net.momirealms.craftengine.core.util.AdventureHelper;
import net.momirealms.craftengine.libraries.adventure.text.Component;
import net.momirealms.craftengine.libraries.adventure.text.minimessage.Context;
import net.momirealms.craftengine.libraries.adventure.text.minimessage.ParsingException;
import net.momirealms.craftengine.libraries.adventure.text.minimessage.tag.Tag;
import net.momirealms.craftengine.libraries.adventure.text.minimessage.tag.resolver.ArgumentQueue;
import net.momirealms.craftengine.libraries.adventure.text.minimessage.tag.resolver.TagResolver;
import net.momirealms.craftengine.libraries.evalex.EvaluationException;
import net.momirealms.craftengine.libraries.evalex.Expression;
import net.momirealms.craftengine.libraries.evalex.parser.ParseException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExpressionTag
implements TagResolver {
    private final net.momirealms.craftengine.core.plugin.context.Context context;

    public ExpressionTag(@NotNull net.momirealms.craftengine.core.plugin.context.Context context) {
        this.context = Objects.requireNonNull(context, "context");
    }

    @Nullable
    public Tag resolve(@NotNull String name, @NotNull ArgumentQueue arguments, @NotNull Context ctx) throws ParsingException {
        if (!this.has(name)) {
            return null;
        }
        String format = arguments.popOr("No format provided").toString();
        String expr = arguments.popOr("No expression provided").toString();
        Component resultComponent = AdventureHelper.customMiniMessage().deserialize(expr, this.context.tagResolvers());
        String resultString = AdventureHelper.plainTextContent(resultComponent);
        Expression expression = new Expression(resultString);
        try {
            BigDecimal numberValue = expression.evaluate().getNumberValue();
            DecimalFormat df = new DecimalFormat(format);
            DecimalFormatSymbols symbols = new DecimalFormatSymbols(Locale.US);
            df.setDecimalFormatSymbols(symbols);
            String formatted = df.format(numberValue);
            return Tag.selfClosingInserting((Component)Component.text((String)formatted));
        }
        catch (IllegalArgumentException e) {
            throw ctx.newException("Invalid number format: " + format, arguments);
        }
        catch (EvaluationException | ParseException e) {
            throw ctx.newException("Invalid expression: " + e.getMessage(), arguments);
        }
    }

    public boolean has(@NotNull String name) {
        return "expr".equals(name);
    }
}

